/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.kpichart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.kpichart.KPIChartDataModel;
import com.sas.graphics.components.kpichart.KPIChartModel;
import com.sas.graphics.components.kpichart.KPIChartSimpleDataModel;
import com.sas.graphics.components.kpichart.KPIChartTableDataModel;
import com.sas.graphics.components.kpichart.RB;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ConstantVariable;
import com.sas.graphics.util.cell.ConstantVariableFactory;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.kpichart.KPIChartMatrix;
import com.sas.graphics.util.cell.kpichart.KPIChartMatrixModel;
import com.sas.rpf.ContextInterface;
import java.awt.Color;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class KPIChart
extends Graph {
    public static final String RB_KEY = "KPIChart.";
    private transient KPIChartModel kpiModel;
    private transient KPIChartDataModel dataModel;
    private final transient KPIChartMatrix matrix;
    private final transient KPIChartMatrixModel matrixModel;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    private final transient Util.AnimationDirectorListener animationListener = new Util.AnimationDirectorListener(){

        @Override
        public void doSetAnimationFrame(AnimationPosition animationPosition) {
            KPIChart.this.setAnimationFrame(animationPosition);
        }
    };
    private static final String ANIMATION_KEY_FRAME = "animationKeyFrameVariable";
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String ACTUAL = "actualVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public KPIChart() {
        this(null, null);
    }

    public KPIChart(KPIChartDataModel kpiDataModel) {
        this(kpiDataModel, null);
    }

    public KPIChart(KPIChartDataModel kpiDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new KPIChartMatrixModel();
        this.matrixModel.setAnimationKeyFrameRole(ANIMATION_KEY_FRAME);
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setActualRole(ACTUAL);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrix = new KPIChartMatrix(this.matrixModel, this.getChannel());
        this.setGraphModel(new KPIChartModel());
        GraphStyle thisStyle = defaultGraphStyle;
        if (thisStyle == null) {
            thisStyle = this.getDefaultGraphStyle();
            thisStyle.getLabelTextStyle().setColor(Color.black);
            thisStyle.getLabelTextStyle().setFont(FontManager.getFont((String)com.sas.graphics.components.RB.getStringResource("fontTahoma.lcl"), (int)1, (int)12));
            thisStyle.getValueTextStyle().setColor(new Color(153, 153, 153));
            thisStyle.getValueTextStyle().setFont(FontManager.getFont((String)com.sas.graphics.components.RB.getStringResource("fontTahoma.lcl"), (int)0, (int)10));
            thisStyle.getBackgroundFillStyle().setSolidFillColor(Color.white);
        }
        this.applyGraphStyle(thisStyle);
        this.dataModelMomento.apply(this.kpiModel);
        if (kpiDataModel != null) {
            this.setDataModel(kpiDataModel);
        }
        this.setGraph(this.matrix);
    }

    private void setAnimationFrame(AnimationPosition animationPosition) {
        this.matrix.setAnimationFrame(animationPosition);
        super.setPaintContext(true, animationPosition);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationListener.setListeningEnabled(enabled);
    }

    public boolean isAnimationEnabled() {
        return this.animationListener.isListeningEnabled();
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean enabled) {
        this.matrix.setAutoRepaintEnabled(enabled);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(KPIChartModel newKPIModel) throws IllegalArgumentException {
        super.setGraphModel(newKPIModel);
        KPIChartModel oldKPIModel = this.kpiModel;
        this.kpiModel = newKPIModel;
        this.matrixModel.setGraphModel(this.kpiModel);
        this.firePropertyChange("graphModel", oldKPIModel, this.kpiModel);
    }

    public KPIChartModel getGraphModel() {
        return this.kpiModel;
    }

    public void setDataModel(KPIChartDataModel newDataModel) {
        KPIChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public KPIChartDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        DataSource dataSource = null;
        this.dataModelMomento.apply(this.kpiModel);
        this.animationListener.setEventSource(null);
        try {
            TableModel tableModel;
            dataSource = KPIChart._newDataSource(this.dataModel, this.kpiModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener());
            if (this.dataModel != null && this.dataModel.getRulesContext() != null) {
                String ruleTargetVariableNameID = RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                String columnName = RPFUtil.containsRuleTargetVariableNameID(dataSource, new String[]{ACTUAL}, ruleTargetVariableNameID);
                this.matrixModel.setRuleTargetIdentifier(columnName);
            }
            this.matrix.setDataSource(dataSource);
            if (this.dataModel instanceof KPIChartTableDataModel && (tableModel = ((KPIChartTableDataModel)this.dataModel).getModel()) instanceof AnimationDirector) {
                this.animationListener.setEventSource((AnimationDirector)((Object)tableModel));
            }
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, KPIChartDataModel dataModel, KPIChartModel kpiChartModel) {
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            switch (kpiChartModel.getMissingPolicy()) {
                default: {
                    break;
                }
                case 10202: {
                    removeIfAnyMissing = new Object[]{ANIMATION_KEY_FRAME, COLUMN, ROW};
                }
                case 10201: 
            }
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(ACTUAL, 0) instanceof FreqVariableDefinition)) {
                removeIfAllMissing = new Object[]{ACTUAL};
            }
            if (removeIfAnyMissing != null || removeIfAllMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(KPIChartDataModel dataModel, KPIChartModel kpiModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (dataModel == null) {
            if (kpiModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof KPIChartSimpleDataModel) {
                dataSource = KPIChart._newDataSource((KPIChartSimpleDataModel)dataModel, kpiModel, locale, formatLocale);
            } else if (dataModel instanceof KPIChartTableDataModel) {
                dataSource = KPIChart._newDataSource((KPIChartTableDataModel)dataModel, kpiModel, locale, formatLocale, listSelectionListener);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(KPIChartSimpleDataModel simpleDataModel, KPIChartModel kpiModel, Locale locale, Locale formatLocale) {
        if (Double.isNaN(simpleDataModel.getActualValue()) || Double.isInfinite(simpleDataModel.getActualValue())) {
            if (kpiModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            DataSource dataSource = new DataSource(new ConstantVariableFactory(formatLocale, simpleDataModel.getSortStrategy()), true, true);
            boolean missingDataColumnMessageEnabled = !kpiModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            ConstantVariable actualConstantVariable = new ConstantVariable(new Double(simpleDataModel.getActualValue()), simpleDataModel.getFormat(), null, simpleDataModel.getActualLabel(), new Double(simpleDataModel.getTargetValue()), simpleDataModel.getTargetLabel());
            Util.setVariableDefinition(dataSource, ACTUAL, "actualRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(actualConstantVariable, 5), missingDataColumnMessageEnabled);
            dataSource = KPIChart._applyDataSourceWhereProcessing(dataSource, simpleDataModel, kpiModel);
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(KPIChartTableDataModel tableDataModel, KPIChartModel kpiModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (kpiModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (kpiModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            boolean missingDataColumnMessageEnabled;
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, tableDataModel.getSortStrategy()), true, true);
            boolean bl = missingDataColumnMessageEnabled = !kpiModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            if (tableModel instanceof AnimationDirector) {
                AnimationDirector atm = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, ANIMATION_KEY_FRAME, "animationKeyFrameRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(atm.getKeyFrameVariable()), missingDataColumnMessageEnabled);
            }
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ACTUAL, "actualRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getActualVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(ACTUAL) == null) {
                int index = Util.seekNumberColumn(tableModel);
                if (index < 0) {
                    throw new Util.ComponentsMessageException("RequiredActualDataNotFound.txt", locale);
                }
                Util.setVariableDefinition(dataSource, ACTUAL, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 1), missingDataColumnMessageEnabled);
            }
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("selected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = KPIChart._applyDataSourceWhereProcessing(dataSource, tableDataModel, kpiModel);
            return dataSource;
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.kpiModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    public ChartImageMapInfo getImageMapInfo() {
        ChartImageMapInfo2 chartImageMapInfo = null;
        ChartImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (chartImageMapInfo == null) {
                    chartImageMapInfo = new ChartImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                chartImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return chartImageMapInfo;
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.kpiModel.getColumnAxisModel(), this.kpiModel.getRowAxisModel());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.kpiModel.getActualLabelTextStyle());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.kpiModel.getActualValueTextStyle());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.kpiModel.getRangeValueTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        Util.Conveyer.applyGraphStyle(graphStyle, this.kpiModel.getColumnAxisModel(), this.kpiModel.getRowAxisModel());
        TextStyle labelTextStyle = new TextStyle();
        labelTextStyle.apply(graphStyle.getLabelTextStyle());
        TextStyle valueTextStyle = new TextStyle();
        valueTextStyle.apply(graphStyle.getValueTextStyle());
        TextStyle actualLabelTextStyle = new TextStyle();
        actualLabelTextStyle.apply(labelTextStyle);
        int[] styleNums = GraphStyle.STYLE.getConstants();
        int currentStyleNum = graphStyle.getName();
        boolean predefinedStyle = false;
        for (int i = 0; i < styleNums.length; ++i) {
            if (currentStyleNum != styleNums[i]) continue;
            predefinedStyle = true;
            break;
        }
        if (predefinedStyle && !graphStyle.isModified()) {
            actualLabelTextStyle.setVisible(false);
            labelTextStyle.setFont(labelTextStyle.getFont().deriveFont(1, 12.0f));
            valueTextStyle.setFont(valueTextStyle.getFont().deriveFont(0, 10.0f));
        }
        this.kpiModel.setActualLabelTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(actualLabelTextStyle, this.kpiModel.getActualLabelTextStyle()));
        this.kpiModel.setActualValueTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(labelTextStyle, this.kpiModel.getActualValueTextStyle()));
        this.kpiModel.setRangeValueTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(valueTextStyle, this.kpiModel.getRangeValueTextStyle()));
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof KPIChartTableDataModel) {
            KPIChartTableDataModel tm = (KPIChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private int missingPolicy;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(KPIChartModel kpiModel) {
            this.apply(kpiModel);
        }

        public void apply(KPIChartModel kpiModel) {
            this.customOptions = kpiModel.getCustomOptions() & dataOptions;
            this.missingPolicy = kpiModel.getMissingPolicy();
        }

        public boolean isApplyDataModel(KPIChartModel kpiModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != kpiModel.getMissingPolicy();
            }
            return this.customOptions != (kpiModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && super.equals(arg);
        }
    }
}

