/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.ganttchart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.TableAxisModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseLength;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;

@SASScope(value="ALL")
public class GanttChartModel
extends GraphModel {
    private static final String ANNO_TEXTSTYLE = "annotationLabelTextStyle";
    private int orientation = 0;
    private ReferenceLineModel timeNowRefLineModel = null;
    private CompoundTimeAxisModel dateAxisModel = new CompoundTimeAxisModel();
    private TableAxisModel tableAxisModel = new TableAxisModel();
    private AxisWallModel axisWallModel = new AxisWallModel();
    private LegendModel legendModel = new LegendModel();
    private boolean actualOverlaid = false;
    private int dividerLocation = -1;
    private boolean probeEnabled = true;
    private boolean showActual = true;
    private boolean showCustom1 = true;
    private boolean showCustom2 = true;
    private boolean showGantt = true;
    private boolean showResource = true;
    private boolean showBaseline = true;
    private boolean showConnectingLines = true;
    private double viewStart = Double.NaN;
    private boolean timeNow = false;
    private boolean showSlackTime = true;
    private String custom1Label = new String("Custom Schedule 1");
    private String custom2Label = new String("Custom Schedule 2");
    private TextStyle annotationLabelTextStyle = new TextStyle();
    private BaseLength annoSymbolSize = new BaseLength(0.0, "px");

    public void apply(GanttChartModel theOtherModel) {
        if (theOtherModel == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherModel);
        this.orientation = theOtherModel.orientation;
        this.actualOverlaid = theOtherModel.actualOverlaid;
        this.dividerLocation = theOtherModel.dividerLocation;
        this.probeEnabled = theOtherModel.probeEnabled;
        this.showActual = theOtherModel.showActual;
        this.showCustom1 = theOtherModel.showCustom1;
        this.showCustom2 = theOtherModel.showCustom2;
        this.showGantt = theOtherModel.showGantt;
        this.showBaseline = theOtherModel.showBaseline;
        this.showResource = theOtherModel.showResource;
        this.showConnectingLines = theOtherModel.showConnectingLines;
        this.viewStart = theOtherModel.viewStart;
        this.showSlackTime = theOtherModel.showSlackTime;
        this.custom1Label = theOtherModel.custom1Label;
        this.custom2Label = theOtherModel.custom2Label;
        this.dateAxisModel.apply(theOtherModel.dateAxisModel);
        this.axisWallModel.apply(theOtherModel.axisWallModel);
        this.legendModel.apply(theOtherModel.legendModel);
        this.tableAxisModel.apply(theOtherModel.tableAxisModel);
        if (this.timeNowRefLineModel != null) {
            this.timeNowRefLineModel.apply(theOtherModel.timeNowRefLineModel);
        } else if (theOtherModel.timeNowRefLineModel != null) {
            this.timeNowRefLineModel = new ReferenceLineModel();
            this.timeNowRefLineModel.apply(theOtherModel.timeNowRefLineModel);
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public GanttChartModel() {
        this.setContainedModel("dateAxisModel", this.dateAxisModel);
        this.setContainedModel("tableAxisModel", this.tableAxisModel);
        this.setContainedModel("axisWallModel", this.axisWallModel);
        this.setContainedModel("legendModel", this.legendModel);
        this.setContainedModel("timeNowRefLineModel", this.timeNowRefLineModel);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GanttChartModel)) {
            return false;
        }
        GanttChartModel arg = (GanttChartModel)obj;
        return Util.Evaluate.isEqual(this.orientation, arg.orientation) && Util.Evaluate.isEqual(this.actualOverlaid, arg.actualOverlaid) && Util.Evaluate.isEqual(this.dividerLocation, arg.dividerLocation) && Util.Evaluate.isEqual(this.probeEnabled, arg.probeEnabled) && Util.Evaluate.isEqual(this.showActual, arg.showActual) && Util.Evaluate.isEqual(this.showCustom1, arg.showCustom1) && Util.Evaluate.isEqual(this.showCustom2, arg.showCustom2) && Util.Evaluate.isEqual(this.showGantt, arg.showGantt) && Util.Evaluate.isEqual(this.showBaseline, arg.showBaseline) && Util.Evaluate.isEqual(this.custom1Label, arg.custom1Label) && Util.Evaluate.isEqual(this.custom2Label, arg.custom2Label) && Util.Evaluate.isEqual(this.showResource, arg.showResource) && Util.Evaluate.isEqual(this.showSlackTime, arg.showSlackTime) && Util.Evaluate.isEqual(this.showConnectingLines, arg.showConnectingLines) && Util.Evaluate.isEqual(this.dateAxisModel, arg.dateAxisModel) && Util.Evaluate.isEqual(this.tableAxisModel, arg.tableAxisModel) && Util.Evaluate.isEqual(this.axisWallModel, arg.axisWallModel) && Util.Evaluate.isEqual(this.timeNowRefLineModel, arg.timeNowRefLineModel) && Util.Evaluate.isEqual(this.legendModel, arg.legendModel) && Util.Evaluate.isEqual(this.viewStart, arg.viewStart) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void setDateAxisModel(CompoundTimeAxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException();
        }
        CompoundTimeAxisModel oldValue = this.dateAxisModel;
        this.dateAxisModel = newAxisModel;
        this.firePropertyChange("dateAxisModel", oldValue, newAxisModel);
    }

    public CompoundTimeAxisModel getDateAxisModel() {
        return this.dateAxisModel;
    }

    public void setTableAxisModel(TableAxisModel newTableAxisModel) throws IllegalArgumentException {
        if (newTableAxisModel == null) {
            throw new IllegalArgumentException();
        }
        TableAxisModel oldValue = this.tableAxisModel;
        this.tableAxisModel = newTableAxisModel;
        this.firePropertyChange("tableAxisModel", oldValue, newTableAxisModel);
    }

    public TableAxisModel getTableAxisModel() {
        return this.tableAxisModel;
    }

    public void setAxisWallModel(AxisWallModel newAxisWallModel) throws IllegalArgumentException {
        if (newAxisWallModel == null) {
            throw new IllegalArgumentException();
        }
        AxisWallModel oldValue = this.axisWallModel;
        this.axisWallModel = newAxisWallModel;
        this.firePropertyChange("axisWallModel", oldValue, newAxisWallModel);
    }

    public AxisWallModel getAxisWallModel() {
        return this.axisWallModel;
    }

    public void setCustomSchedule1Label(String newCustom1Label) {
        String oldCustom1Label = this.custom1Label;
        this.custom1Label = newCustom1Label;
        this.firePropertyChange("custom1Label", oldCustom1Label, newCustom1Label);
    }

    public String getCustomSchedule1Label() {
        return this.custom1Label;
    }

    public void setCustomSchedule2Label(String newCustom2Label) {
        String oldCustom2Label = this.custom2Label;
        this.custom2Label = newCustom2Label;
        this.firePropertyChange("custom2Label", oldCustom2Label, newCustom2Label);
    }

    public String getCustomSchedule2Label() {
        return this.custom2Label;
    }

    public void setAnnotationLabelTextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.annotationLabelTextStyle;
        this.annotationLabelTextStyle = newTextStyle;
        this.firePropertyChange(ANNO_TEXTSTYLE, oldValue, this.annotationLabelTextStyle);
    }

    public TextStyle getAnnotationLabelTextStyle() {
        return this.annotationLabelTextStyle;
    }

    public void setAnnotationSymbolSize(BaseLength newSize) throws IllegalArgumentException {
        if (newSize == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseLength oldSize = this.annoSymbolSize;
        this.annoSymbolSize = newSize;
        this.firePropertyChange("annoSymbolSize", oldSize, newSize);
    }

    public BaseLength getAnnotationSymbolSize() {
        return this.annoSymbolSize;
    }

    public void setLegendModel(LegendModel newLegendModel) throws IllegalArgumentException {
        if (newLegendModel == null) {
            throw new IllegalArgumentException();
        }
        LegendModel oldValue = this.legendModel;
        this.legendModel = newLegendModel;
        this.firePropertyChange("legendModel", oldValue, newLegendModel);
    }

    public LegendModel getLegendModel() {
        return this.legendModel;
    }

    public void setActualBarOverlaid(boolean newOverlaid) {
        boolean oldOverlaid = this.actualOverlaid;
        this.actualOverlaid = newOverlaid;
        this.firePropertyChange("ActualBarOverlaid", oldOverlaid, newOverlaid);
    }

    public boolean isActualBarOverlaid() {
        return this.actualOverlaid;
    }

    public void setActualBarEnabled(boolean newBoolean) {
        boolean oldShow = this.showActual;
        this.showActual = newBoolean;
        this.firePropertyChange("ActualBarEnabled", oldShow, newBoolean);
    }

    public boolean isActualBarEnabled() {
        return this.showActual;
    }

    public void setCustom1BarEnabled(boolean newBoolean) {
        boolean oldShow = this.showCustom1;
        this.showCustom1 = newBoolean;
        this.firePropertyChange("CustomBar1Enabled", oldShow, newBoolean);
    }

    public boolean isCustomBar1Enabled() {
        return this.showCustom1;
    }

    public void setCustom2BarEnabled(boolean newBoolean) {
        boolean oldShow = this.showCustom2;
        this.showCustom2 = newBoolean;
        this.firePropertyChange("CustomBar2Enabled", oldShow, newBoolean);
    }

    public boolean isCustomBar2Enabled() {
        return this.showCustom2;
    }

    public void setGanttBarEnabled(boolean newBoolean) {
        boolean oldShow = this.showGantt;
        this.showGantt = newBoolean;
        this.firePropertyChange("GanttBarEnabled", oldShow, newBoolean);
    }

    public boolean isGanttBarEnabled() {
        return this.showGantt;
    }

    public void setSlackTimeEnabled(boolean newBoolean) {
        boolean oldShow = this.showSlackTime;
        this.showSlackTime = newBoolean;
        this.firePropertyChange("GanttBarEnabled", oldShow, newBoolean);
    }

    public boolean isSlackTimeEnabled() {
        return this.showSlackTime;
    }

    public void setBaselineBarEnabled(boolean newBoolean) {
        boolean oldShow = this.showBaseline;
        this.showBaseline = newBoolean;
        this.firePropertyChange("BaselineBarEnabled", oldShow, newBoolean);
    }

    public boolean isBaselineBarEnabled() {
        return this.showBaseline;
    }

    public void setResourceBarEnabled(boolean newBoolean) {
        boolean oldShow = this.showResource;
        this.showResource = newBoolean;
        this.firePropertyChange("ResourceBarEnabled", oldShow, newBoolean);
    }

    public boolean isResourceBarEnabled() {
        return this.showResource;
    }

    public void setTimeNowReferenceLineModel(ReferenceLineModel newModel) {
        ReferenceLineModel oldModel = this.timeNowRefLineModel;
        if (this.timeNowRefLineModel != null) {
            this.setContainedModel("timeNowRefLineModel", null);
        }
        this.timeNowRefLineModel = newModel;
        if (this.timeNowRefLineModel != null) {
            this.setContainedModel("timeNowRefLineModel", this.timeNowRefLineModel);
        }
        this.firePropertyChange("timeNowRefLineModel", oldModel, newModel);
    }

    public ReferenceLineModel getTimeNowReferenceLineModel() {
        ReferenceLineModel copyOftimeNowRefLineModel = this.timeNowRefLineModel;
        return copyOftimeNowRefLineModel;
    }

    public void setViewStart(double newViewStart) {
        double oldViewStart = this.viewStart;
        this.viewStart = newViewStart;
        this.firePropertyChange("viewStart", oldViewStart, newViewStart);
    }

    public double getViewStart() {
        return this.viewStart;
    }

    public void setTimeNowEnabled(boolean newTimeNow) {
        boolean oldTimeNow = this.timeNow;
        this.timeNow = newTimeNow;
        this.firePropertyChange("timeNow", oldTimeNow, newTimeNow);
    }

    public boolean isTimeNowEnabled() {
        return this.timeNow;
    }

    public double getInformatValue(String informatValue, String informatName) throws IllegalStateException {
        if (informatValue == null) {
            throw new IllegalStateException();
        }
        SASFormat informat = SASFormat.getInstance((String)informatName);
        if (informat != null) {
            try {
                return ((SASDateTimeFormat)informat).informat(informatValue);
            }
            catch (UnsupportedOperationException e) {
                String message = Message.format((String)RB.getStringResource("Graph.", "inFormatNotSupported.fmt.txt"), (Object)informatName.trim());
                throw new IllegalStateException(message);
            }
            catch (IllegalArgumentException e) {
                return Double.NaN;
            }
        }
        String message = Message.format((String)RB.getStringResource("inFormatNotSupported.fmt.txt"), (Object)informatName.trim());
        throw new IllegalStateException(message);
    }
}

