/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.barlinechart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.barlinechart.BarLineChartDataModel;
import com.sas.graphics.components.util.Util;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class BarLineChartTableDataModel
extends BarLineChartDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private boolean statisticEnabled = true;
    private ClassificationVariable columnVariable;
    private ClassificationVariable rowVariable;
    private ClassificationVariable categoryVariable;
    private ClassificationVariable subgroupVariable;
    private AnalysisVariable barResponseVariable;
    private AnalysisVariable barResponse2Variable;
    private AnalysisVariable lineResponseVariable;
    private AnalysisVariable lineResponse2Variable;
    private Variable categorySortVariable;
    private Variable styleByVariable;
    private Variable outsideBarLabelVariable;
    private Variable insideBarLabelVariable;
    private Variable outsideMarkerLabelVariable;
    private Variable[] auxiliaryVariables = null;
    private Variable[] dataTipVariables = null;

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void apply(BarLineChartTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(BarLineChartTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.statisticEnabled = theOtherModel.statisticEnabled;
        this.columnVariable = theOtherModel.columnVariable;
        this.rowVariable = theOtherModel.rowVariable;
        this.categoryVariable = theOtherModel.categoryVariable;
        this.categorySortVariable = theOtherModel.categorySortVariable;
        this.styleByVariable = theOtherModel.styleByVariable;
        this.subgroupVariable = theOtherModel.subgroupVariable;
        this.barResponseVariable = theOtherModel.barResponseVariable;
        this.barResponse2Variable = theOtherModel.barResponse2Variable;
        this.lineResponseVariable = theOtherModel.lineResponseVariable;
        this.lineResponse2Variable = theOtherModel.lineResponse2Variable;
        this.outsideBarLabelVariable = theOtherModel.outsideBarLabelVariable;
        this.insideBarLabelVariable = theOtherModel.insideBarLabelVariable;
        this.outsideMarkerLabelVariable = theOtherModel.outsideMarkerLabelVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public BarLineChartTableDataModel() {
    }

    public BarLineChartTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, this.model);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setStatisticEnabled(boolean newStatisticEnabled) {
        boolean oldValue = this.statisticEnabled;
        this.statisticEnabled = newStatisticEnabled;
        this.firePropertyChange("statisticEnabled", oldValue, newStatisticEnabled);
    }

    public boolean isStatisticEnabled() {
        return this.statisticEnabled;
    }

    public void setColumnVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.columnVariable;
        this.columnVariable = newVariable;
        this.firePropertyChange("columnVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setRowVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.rowVariable;
        this.rowVariable = newVariable;
        this.firePropertyChange("rowVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getRowVariable() {
        return this.rowVariable;
    }

    public void setCategoryVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.categoryVariable;
        this.categoryVariable = newVariable;
        this.firePropertyChange("categoryVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getCategoryVariable() {
        return this.categoryVariable;
    }

    public void setCategorySortVariable(Variable newVariable) {
        Variable oldVariable = this.categorySortVariable;
        this.categorySortVariable = newVariable;
        this.firePropertyChange("categorySortVariable", oldVariable, newVariable);
    }

    public Variable getCategorySortVariable() {
        return this.categorySortVariable;
    }

    public void setStyleByVariable(Variable newVariable) {
        Variable oldVariable = this.styleByVariable;
        this.styleByVariable = newVariable;
        this.firePropertyChange("styleByVariable", oldVariable, newVariable);
    }

    public Variable getStyleByVariable() {
        return this.styleByVariable;
    }

    public void setSubgroupVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.subgroupVariable;
        this.subgroupVariable = newVariable;
        this.firePropertyChange("subgroupVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getSubgroupVariable() {
        return this.subgroupVariable;
    }

    public void setBarResponseVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.barResponseVariable;
        this.barResponseVariable = newVariable;
        this.firePropertyChange("barResponseVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getBarResponseVariable() {
        return this.barResponseVariable;
    }

    public void setBarResponse2Variable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.barResponse2Variable;
        this.barResponse2Variable = newVariable;
        this.firePropertyChange("barResponse2Variable", oldVariable, newVariable);
    }

    public AnalysisVariable getBarResponse2Variable() {
        return this.barResponse2Variable;
    }

    public void setLineResponseVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.lineResponseVariable;
        this.lineResponseVariable = newVariable;
        this.firePropertyChange("lineResponseVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getLineResponseVariable() {
        return this.lineResponseVariable;
    }

    public void setLineResponse2Variable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.lineResponse2Variable;
        this.lineResponse2Variable = newVariable;
        this.firePropertyChange("lineResponse2Variable", oldVariable, newVariable);
    }

    public AnalysisVariable getLineResponse2Variable() {
        return this.lineResponse2Variable;
    }

    public void setOutsideBarLabelVariable(Variable newVariable) {
        Variable oldVariable = this.outsideBarLabelVariable;
        this.outsideBarLabelVariable = newVariable;
        this.firePropertyChange("outsideBarLabelVariable", oldVariable, newVariable);
    }

    public Variable getOutsideBarLabelVariable() {
        return this.outsideBarLabelVariable;
    }

    public void setInsideBarLabelVariable(Variable newVariable) {
        Variable oldVariable = this.insideBarLabelVariable;
        this.insideBarLabelVariable = newVariable;
        this.firePropertyChange("insideBarLabelVariable", oldVariable, newVariable);
    }

    public Variable getInsideBarLabelVariable() {
        return this.insideBarLabelVariable;
    }

    public void setOutsideMarkerLabelVariable(Variable newVariable) {
        Variable oldVariable = this.outsideMarkerLabelVariable;
        this.outsideMarkerLabelVariable = newVariable;
        this.firePropertyChange("outsideMarkerLabelVariable", oldVariable, newVariable);
    }

    public Variable getOutsideMarkerLabelVariable() {
        return this.outsideMarkerLabelVariable;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        BarLineChartTableDataModel arg = (BarLineChartTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.statisticEnabled, arg.statisticEnabled) && Util.Evaluate.isEqual(this.columnVariable, arg.columnVariable) && Util.Evaluate.isEqual(this.rowVariable, arg.rowVariable) && Util.Evaluate.isEqual(this.categoryVariable, arg.categoryVariable) && Util.Evaluate.isEqual(this.categorySortVariable, arg.categorySortVariable) && Util.Evaluate.isEqual(this.styleByVariable, arg.styleByVariable) && Util.Evaluate.isEqual(this.subgroupVariable, arg.subgroupVariable) && Util.Evaluate.isEqual(this.barResponseVariable, arg.barResponseVariable) && Util.Evaluate.isEqual(this.barResponse2Variable, arg.barResponse2Variable) && Util.Evaluate.isEqual(this.lineResponseVariable, arg.lineResponseVariable) && Util.Evaluate.isEqual(this.lineResponse2Variable, arg.lineResponse2Variable) && Util.Evaluate.isEqual(this.outsideBarLabelVariable, arg.outsideBarLabelVariable) && Util.Evaluate.isEqual(this.insideBarLabelVariable, arg.insideBarLabelVariable) && Util.Evaluate.isEqual(this.outsideMarkerLabelVariable, arg.outsideMarkerLabelVariable) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

