/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.barchart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.barchart.BarChartDataModel;
import com.sas.graphics.components.barchart.BarChartModel;
import com.sas.graphics.components.barchart.BarChartOLAPDataModel;
import com.sas.graphics.components.barchart.BarChartTableDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.OLAPVariableFactory;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.barlinechart.BarLineChartMatrix;
import com.sas.graphics.util.cell.barlinechart.BarLineChartMatrixModel;
import com.sas.rpf.ContextInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class BarChart
extends Graph {
    public static final String RB_KEY = "BarChart.";
    private transient BarChartModel barChartModel;
    private transient BarChartDataModel dataModel;
    private final transient BarLineChartMatrix matrix;
    private final transient BarLineChartMatrixModel matrixModel;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    protected MouseListener scrollBarListener;
    private final transient Util.AnimationDirectorListener animationListener = new Util.AnimationDirectorListener(){

        @Override
        public void doSetAnimationFrame(AnimationPosition animationPosition) {
            BarChart.this.setAnimationFrame(animationPosition);
        }
    };
    private static final String ANIMATION_KEY_FRAME = "animationKeyFrameVariable";
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String CATEGORY = "categoryVariable";
    private static final String SUBGROUP = "subgroupVariable";
    private static final String RESPONSE = "responseVariable";
    private static final String RESPONSE2 = "response2Variable";
    private static final String CATEGORY_SORT = "categorySortVariable";
    private static final String STYLE_BY = "styleByVariable";
    private static final String OUTSIDE_BAR_LABEL = "outsideBarLabelVariable";
    private static final String INSIDE_BAR_LABEL = "insideBarLabelVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String BAR_SELECTION = "barSelectionVariable";
    private static final String BAR2_SELECTION = "bar2SelectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public BarChart() {
        this(null, null);
    }

    public BarChart(BarChartDataModel barChartDataModel) {
        this(barChartDataModel, null);
    }

    public BarChart(BarChartDataModel barChartDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new BarLineChartMatrixModel();
        this.matrixModel.setAnimationKeyFrameRole(ANIMATION_KEY_FRAME);
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setCategoryRole(CATEGORY);
        this.matrixModel.setCategorySortRole(CATEGORY_SORT);
        this.matrixModel.setStyleByRole(STYLE_BY);
        this.matrixModel.setSubgroupRole(SUBGROUP);
        this.matrixModel.setBarRole(RESPONSE);
        this.matrixModel.setBar2Role(RESPONSE2);
        this.matrixModel.setOutsideBarLabelRole(OUTSIDE_BAR_LABEL);
        this.matrixModel.setInsideBarLabelRole(INSIDE_BAR_LABEL);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrixModel.setBarSelectionRole(BAR_SELECTION);
        this.matrixModel.setBar2SelectionRole(BAR2_SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrix = new BarLineChartMatrix(this.matrixModel, this.getChannel());
        this.setGraphModel(new BarChartModel());
        this.applyGraphStyle(defaultGraphStyle != null ? defaultGraphStyle : this.getDefaultGraphStyle());
        this.dataModelMomento.apply(this.barChartModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimeChartTableData(), Util.getLocale(this), 10475), true, true);
                dataSource.setVariableDefinition(CATEGORY, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("Category"), 2));
                dataSource.setVariableDefinition(RESPONSE, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Response"), 1));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (barChartDataModel != null) {
            this.setDataModel(barChartDataModel);
        }
        this.setGraph(this.matrix);
    }

    private void setAnimationFrame(AnimationPosition animationPosition) {
        this.matrix.setAnimationFrame(animationPosition);
        super.setPaintContext(true, animationPosition);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationListener.setListeningEnabled(enabled);
    }

    public boolean isAnimationEnabled() {
        return this.animationListener.isListeningEnabled();
    }

    @Override
    public void setDisplayPolicy(int newDisplayPolicy) throws IllegalArgumentException {
        super.setDisplayPolicy(newDisplayPolicy);
        if (newDisplayPolicy == 10002) {
            this.scrollBarInit();
        }
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(BarChartModel newBarChartModel) throws IllegalArgumentException {
        super.setGraphModel(newBarChartModel);
        BarChartModel oldBarChartModel = this.barChartModel;
        this.barChartModel = newBarChartModel;
        this.matrixModel.setGraphModel(this.barChartModel);
        this.matrixModel.setBarLineChartModel(this.barChartModel.getBarLineChartModel());
        this.firePropertyChange("graphModel", oldBarChartModel, this.barChartModel);
    }

    public BarChartModel getGraphModel() {
        return this.barChartModel;
    }

    public void setDataModel(BarChartDataModel newDataModel) {
        BarChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public BarChartDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        this.dataModelMomento.apply(this.barChartModel);
        this.animationListener.setEventSource(null);
        try {
            TableModel tableModel;
            DataSource dataSource = BarChart._newDataSource(this.dataModel, this.barChartModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel));
            if (this.dataModel != null && this.dataModel.getRulesContext() != null) {
                String ruleTargetVariableNameID = RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                String columnName = RPFUtil.containsRuleTargetVariableNameID(dataSource, new String[]{RESPONSE, RESPONSE2}, ruleTargetVariableNameID);
                this.matrixModel.setRuleTargetIdentifier(columnName);
            }
            this.matrix.setDataSource(dataSource);
            if (this.dataModel instanceof BarChartTableDataModel && (tableModel = ((BarChartTableDataModel)this.dataModel).getModel()) instanceof AnimationDirector) {
                this.animationListener.setEventSource((AnimationDirector)((Object)tableModel));
            }
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, BarChartDataModel dataModel, BarChartModel barChartModel) {
        if (dataSource != null && dataSource.isOLAPData()) {
            return dataSource;
        }
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            switch (barChartModel.getMissingPolicy()) {
                default: {
                    removeIfAnyMissing = new Object[]{CATEGORY};
                    break;
                }
                case 10202: {
                    removeIfAnyMissing = new Object[]{ANIMATION_KEY_FRAME, COLUMN, ROW, CATEGORY, SUBGROUP};
                }
                case 10201: 
            }
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(RESPONSE, 0) instanceof FreqVariableDefinition) && !barChartModel.isMissingResponseEnabled()) {
                removeIfAllMissing = new Object[]{RESPONSE, RESPONSE2};
            }
            if (removeIfAnyMissing != null || removeIfAllMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(BarChartDataModel dataModel, BarChartModel barChartModel, Locale locale, Locale formatLocale) {
        if (dataModel == null) {
            if (barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof BarChartTableDataModel) {
                dataSource = BarChart._newDataSource((BarChartTableDataModel)dataModel, barChartModel, locale, formatLocale);
            } else if (dataModel instanceof BarChartOLAPDataModel) {
                dataSource = BarChart._newDataSource((BarChartOLAPDataModel)dataModel, barChartModel, locale, formatLocale);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(BarChartTableDataModel tableDataModel, BarChartModel barChartModel, Locale locale, Locale formatLocale) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            Integer statistic;
            Integer sort;
            Variable catSortVariable;
            AnimationDirector animationDirector;
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, tableDataModel.getSortStrategy()), true, tableDataModel.isStatisticEnabled());
            boolean missingDataColumnMessageEnabled = !barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            ClassificationVariable column = tableDataModel.getColumnVariable();
            ClassificationVariable row = tableDataModel.getRowVariable();
            if (tableModel instanceof AnimationDirector) {
                animationDirector = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, ANIMATION_KEY_FRAME, "animationKeyFrameRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(animationDirector.getKeyFrameVariable()), missingDataColumnMessageEnabled);
            }
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(column, 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(row, 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCategoryVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSubgroupVariable(), 10), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getResponseVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, RESPONSE2, "response2Role.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getResponse2Variable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(CATEGORY) == null && tableModel instanceof AnimationDirector) {
                animationDirector = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(animationDirector.getIdentificationVariable(), 2), missingDataColumnMessageEnabled);
            }
            AnalysisVariable[] rva = new AnalysisVariable[]{tableDataModel.getResponseVariable(), tableDataModel.getResponse2Variable()};
            AnalysisVariable olv = null;
            switch (barChartModel.getOutsideBarLabelContent()) {
                case 10200: {
                    Util.setVariableDefinition(dataSource, OUTSIDE_BAR_LABEL, "outsideBarLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getOutsideBarLabelVariable(), 4), missingDataColumnMessageEnabled);
                    break;
                }
                case 10614: {
                    olv = Util.newAnalysisVaraible(rva, 10506);
                    break;
                }
                case 10615: {
                    olv = Util.newAnalysisVaraible(rva, 10501);
                    break;
                }
                case 10608: {
                    olv = Util.newAnalysisVaraible(rva, 10507);
                }
            }
            if (olv != null) {
                Util.setVariableDefinition(dataSource, OUTSIDE_BAR_LABEL, null, null, VariableDefinition.Factory.newVariableDefinition(olv, 0), missingDataColumnMessageEnabled);
            }
            AnalysisVariable ilv = null;
            switch (barChartModel.getInsideBarLabelContent()) {
                case 10200: {
                    Util.setVariableDefinition(dataSource, INSIDE_BAR_LABEL, "insideBarLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getInsideBarLabelVariable(), 4), missingDataColumnMessageEnabled);
                    break;
                }
                case 10614: {
                    ilv = Util.newAnalysisVaraible(rva, 10506);
                    break;
                }
                case 10615: {
                    ilv = Util.newAnalysisVaraible(rva, 10501);
                    break;
                }
                case 10608: {
                    ilv = Util.newAnalysisVaraible(rva, 10507);
                }
            }
            if (ilv != null) {
                Util.setVariableDefinition(dataSource, INSIDE_BAR_LABEL, null, null, VariableDefinition.Factory.newVariableDefinition(ilv, 2), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(CATEGORY) == null) {
                int index = -1;
                index = Util.seekStringColumn(tableModel);
                if (index < 0) {
                    index = Util.seekDateColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNumberColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNonNullColumn(tableModel);
                }
                if (index < 0) {
                    index = 0;
                }
                Util.setVariableDefinition(dataSource, CATEGORY, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 2), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(RESPONSE) == null && dataSource.getVariableDefinition(RESPONSE2) == null) {
                if (!tableDataModel.isStatisticEnabled()) {
                    throw new Util.ComponentsMessageException("RequiredResponseDataNotFound.txt", locale);
                }
                Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, new FreqVariableDefinition(), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(ANIMATION_KEY_FRAME) == null && (catSortVariable = tableDataModel.getCategorySortVariable()) != null) {
                Integer n = catSortVariable instanceof ClassificationVariable ? new Integer(((ClassificationVariable)catSortVariable).getSort()) : (sort = tableDataModel.getCategoryVariable() != null ? new Integer(tableDataModel.getCategoryVariable().getSort()) : new Integer(10401));
                statistic = catSortVariable instanceof AnalysisVariable ? new Integer(((AnalysisVariable)catSortVariable).getStatistic()) : (catSortVariable instanceof ClassificationVariable ? null : new Integer(10506));
                AnalysisVariableDefinition catSortVarDef = catSortVariable.getColumnName() != null ? new AnalysisVariableDefinition(catSortVariable.getColumnName(), catSortVariable.getFormat(), catSortVariable.getInformat(), catSortVariable.getLabel(), sort, statistic, null, null, null, null, null, null, null, 0) : new AnalysisVariableDefinition(new Integer(catSortVariable.getColumnIndex()), catSortVariable.getFormat(), catSortVariable.getInformat(), catSortVariable.getLabel(), sort, statistic, null, null, null, null, null, null, null, 0);
                Util.setVariableDefinition(dataSource, CATEGORY_SORT, "categorySortRole.txt", locale, catSortVarDef, missingDataColumnMessageEnabled);
            }
            if (tableDataModel.getSubgroupVariable() != null) {
                Util.setLegendVariable(dataSource, STYLE_BY, SUBGROUP);
            } else {
                Variable styleByVariable = tableDataModel.getStyleByVariable();
                if (styleByVariable != null) {
                    sort = new Integer(10401);
                    Integer n = statistic = styleByVariable instanceof AnalysisVariable ? new Integer(((AnalysisVariable)styleByVariable).getStatistic()) : new Integer(10500);
                    AnalysisVariableDefinition styleByVarDef = styleByVariable.getColumnName() != null ? new AnalysisVariableDefinition(styleByVariable.getColumnName(), styleByVariable.getFormat(), styleByVariable.getInformat(), styleByVariable.getLabel(), sort, statistic, styleByVariable.getCategorizationModel(), styleByVariable.getSegmentedRangeStyle(), null, null, null, null, null, null, null, styleByVariable instanceof ClassificationVariable ? 2 : 0) : new AnalysisVariableDefinition(new Integer(styleByVariable.getColumnIndex()), styleByVariable.getFormat(), styleByVariable.getInformat(), styleByVariable.getLabel(), sort, statistic, styleByVariable.getCategorizationModel(), styleByVariable.getSegmentedRangeStyle(), null, null, null, null, null, null, null, styleByVariable instanceof ClassificationVariable ? 2 : 0);
                    Util.setVariableDefinition(dataSource, STYLE_BY, "styleByRole.txt", locale, styleByVarDef, missingDataColumnMessageEnabled);
                }
            }
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("selected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = BarChart._applyDataSourceWhereProcessing(dataSource, tableDataModel, barChartModel);
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(BarChartOLAPDataModel olapDataModel, BarChartModel barChartModel, Locale locale, Locale formatLocale) {
        OLAPDataSetInterface olapDataSetInterface = olapDataModel.getModel();
        try {
            if (olapDataSetInterface == null) {
                if (barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("nullModel.txt", locale);
                }
            } else if (olapDataSetInterface.getCellCount() == 0L) {
                if (barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                }
            } else {
                if (System.getProperty("com.sas.graph.tuple.limit") != null && olapDataSetInterface.getCellCount() > (long)new Integer(System.getProperty("com.sas.graph.tuple.limit")).intValue()) {
                    throw new Util.ComponentsMessageException(com.sas.graphics.util.cell.RB.getStringResource("Matrix.InsufficientDisplaySpace.ex.txt", locale));
                }
                com.sas.graphics.util.gtk.OLAPVariableFactory gtkOLAPFactory = (com.sas.graphics.util.gtk.OLAPVariableFactory)GraphOLAPDataSet.getGraphInfo(olapDataSetInterface);
                ResultSetMetadataInterface resultSetMetadataInterface = gtkOLAPFactory.getResultSetMetadata();
                if (resultSetMetadataInterface != null) {
                    int ii;
                    int i;
                    int measure2Count;
                    DataSource dataSource = new DataSource(new OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    boolean missingDataColumnMessageEnabled = !barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
                    String categoryHierarchyName = null;
                    String subgroupHierarchyName = null;
                    List columnHierarchyNames = gtkOLAPFactory.getHeirarchyNames(0);
                    List rowHierarchyNames = gtkOLAPFactory.getHeirarchyNames(1);
                    List measureNames = gtkOLAPFactory.getMeasureNames();
                    List measure2Names = null;
                    List styleByNames = null;
                    if (olapDataModel.getResponseVariable() != null || olapDataModel.getResponse2Variable() != null) {
                        List names = measureNames;
                        measureNames = Util.newValidatedList(olapDataModel.getResponseVariable(), names, gtkOLAPFactory, "responseRole.txt", locale);
                        measure2Names = Util.newValidatedList(olapDataModel.getResponse2Variable(), names, gtkOLAPFactory, "response2Role.txt", locale);
                    }
                    int measureCount = measureNames != null ? measureNames.size() : 0;
                    int n = measure2Count = measure2Names != null ? measure2Names.size() : 0;
                    if (olapDataModel.isSubgroupEnabled() && measureCount + measure2Count == 1) {
                        if (columnHierarchyNames.size() > 0) {
                            subgroupHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                        } else if (rowHierarchyNames.size() > 0) {
                            subgroupHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                        }
                    }
                    if (subgroupHierarchyName == null && olapDataModel.getStyleByVariable() != null) {
                        styleByNames = Util.newValidatedList(olapDataModel.getStyleByVariable(), gtkOLAPFactory.getMeasureNames(), gtkOLAPFactory, "styleByRole.txt", locale);
                    }
                    if (columnHierarchyNames.size() > 0) {
                        categoryHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                    } else if (rowHierarchyNames.size() > 0) {
                        categoryHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                    }
                    if (categoryHierarchyName == null && subgroupHierarchyName != null) {
                        categoryHierarchyName = subgroupHierarchyName;
                        subgroupHierarchyName = null;
                    }
                    if (categoryHierarchyName == null) {
                        throw new Util.ComponentsMessageException("RequiredCategoryDataNotFound.txt", locale);
                    }
                    ClassificationVariableDefinition category = new ClassificationVariableDefinition(categoryHierarchyName, null, null, 0);
                    Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, category, missingDataColumnMessageEnabled);
                    if (subgroupHierarchyName != null) {
                        ClassificationVariableDefinition subgroup = new ClassificationVariableDefinition(subgroupHierarchyName, null, null, 0);
                        Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, subgroup, missingDataColumnMessageEnabled);
                        Util.setLegendVariable(dataSource, STYLE_BY, SUBGROUP);
                    } else if (styleByNames != null) {
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, STYLE_BY, styleByNames, "styleByRole.txt", locale, missingDataColumnMessageEnabled);
                    }
                    if (columnHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition columns = null;
                        for (i = columnHierarchyNames.size() - 1; i >= 0; --i) {
                            columns = new ClassificationVariableDefinition((String)columnHierarchyNames.get(i), null, columns, 0);
                        }
                        Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, columns, missingDataColumnMessageEnabled);
                    }
                    if (rowHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition rows = null;
                        for (i = rowHierarchyNames.size() - 1; i >= 0; --i) {
                            rows = new ClassificationVariableDefinition((String)rowHierarchyNames.get(i), null, rows, 0);
                        }
                        Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, rows, missingDataColumnMessageEnabled);
                    }
                    if (measureCount + measure2Count > 0) {
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, RESPONSE, measureNames, "responseRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, RESPONSE2, measure2Names, "response2Role.txt", locale, missingDataColumnMessageEnabled);
                        if (olapDataModel.getSelectionModel() != null) {
                            ListSelectionModel selectionModel = olapDataModel.getSelectionModel();
                            dataSource.setSelectionModel(selectionModel, false);
                            Util.setOLAPSelections(dataSource, selectionModel, BAR_SELECTION, measureNames, missingDataColumnMessageEnabled);
                            Util.setOLAPSelections(dataSource, selectionModel, BAR2_SELECTION, measure2Names, missingDataColumnMessageEnabled);
                        }
                    }
                    List allMeasureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getDataTipVariable() != null) {
                        Variable[] dataTipVariable = olapDataModel.getDataTipVariable();
                        for (ii = 0; ii < dataTipVariable.length; ++ii) {
                            List dataTipNames = Util.newValidatedList(dataTipVariable[ii], allMeasureNames, gtkOLAPFactory, "dataTipRoles.txt", locale);
                            if (dataTipNames == null || dataTipNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, DATA_TIP + ii, dataTipNames, "dataTipRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (olapDataModel.getAuxiliaryVariable() != null) {
                        Variable[] auxiliaryVariable = olapDataModel.getAuxiliaryVariable();
                        for (ii = 0; ii < auxiliaryVariable.length; ++ii) {
                            List auxiliaryNames = Util.newValidatedList(auxiliaryVariable[ii], allMeasureNames, gtkOLAPFactory, "auxiliaryRoles.txt", locale);
                            if (auxiliaryNames == null || auxiliaryNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, AUXILIARY + ii, auxiliaryNames, "auxiliaryRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    dataSource = BarChart._applyDataSourceWhereProcessing(dataSource, olapDataModel, barChartModel);
                    return dataSource;
                }
            }
        }
        catch (OLAPException e) {
            if (barChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLPA_EXCEPTION_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("olapExceptionEncounteredZeroDataValues.txt", locale);
            }
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.barChartModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    public ChartImageMapInfo getImageMapInfo() {
        ChartImageMapInfo2 chartImageMapInfo = null;
        ChartImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (chartImageMapInfo == null) {
                    chartImageMapInfo = new ChartImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                chartImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return chartImageMapInfo;
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.barChartModel.getColumnAxisModel(), this.barChartModel.getRowAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barChartModel.getLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.barChartModel.getCategoryAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barChartModel.getResponseAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barChartModel.getResponse2AxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barChartModel.getAxisWallModel());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.barChartModel.getInsideBarLabelTextStyle());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.barChartModel.getOutsideBarLabelTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        AxisModel categoryAxisModel = this.barChartModel.getCategoryAxisModel();
        AxisModel responseAxisModel = this.barChartModel.getResponseAxisModel();
        AxisModel response2AxisModel = this.barChartModel.getResponse2AxisModel();
        AxisWallModel axisWallModel = this.barChartModel.getAxisWallModel();
        LegendModel legendModel = this.barChartModel.getLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, categoryAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, responseAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, response2AxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, axisWallModel);
        Util.Conveyer.applyGraphStyle(graphStyle, legendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, this.barChartModel.getColumnAxisModel(), this.barChartModel.getRowAxisModel());
        StrokeLineStyle baseLineStyle = this.barChartModel.getResponseAxisBaselineModel().getLineStyle();
        if (baseLineStyle != null) {
            baseLineStyle.apply(graphStyle.getAxisLineStyle());
        }
        if ((baseLineStyle = this.barChartModel.getResponse2AxisBaselineModel().getLineStyle()) != null) {
            baseLineStyle.apply(graphStyle.getAxisLineStyle());
        }
        Util.Conveyer.applyTextStyle(graphStyle.getDataLabelTextStyle(), this.barChartModel.getOutsideBarLabelTextStyle());
        Util.Conveyer.applyTextStyle(graphStyle.getDataLabelTextStyle(), this.barChartModel.getInsideBarLabelTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof BarChartTableDataModel) {
            BarChartTableDataModel tm = (BarChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        } else if (this.dataModel instanceof BarChartOLAPDataModel) {
            BarChartOLAPDataModel om = (BarChartOLAPDataModel)this.dataModel;
            model = om.getModel();
            selectionModel = om.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private void scrollBarInit() {
        this.removeMouseListener(this.scrollBarListener);
        this.scrollBarListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (BarChart.this.matrix.getColumnScrollBar() != null) {
                    BarChart.this.matrix.getColumnScrollBar().setVisible(true);
                }
                if (BarChart.this.matrix.getRowScrollBar() != null) {
                    BarChart.this.matrix.getRowScrollBar().setVisible(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Point pt = evt.getPoint();
                Rectangle b = BarChart.this.getBounds();
                if (pt.x >= b.width || pt.x < 0 || pt.y >= b.height || pt.y < 0) {
                    if (!BarChart.this.matrix.isZoomedColumnScrollBar() && BarChart.this.matrix.getColumnScrollBar() != null) {
                        BarChart.this.matrix.getColumnScrollBar().setVisible(false);
                    }
                    if (!BarChart.this.matrix.isZoomedRowScrollBar() && BarChart.this.matrix.getRowScrollBar() != null) {
                        BarChart.this.matrix.getRowScrollBar().setVisible(false);
                    }
                }
            }
        };
        this.addMouseListener(this.scrollBarListener);
    }

    @SASScope
    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private int missingPolicy;
        private boolean missingResponseEnabled;
        private int uniformPolicy;
        private int outsideBarLabelContent;
        private int insideBarLabelContent;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(BarChartModel barChartModel) {
            this.apply(barChartModel);
        }

        public void apply(BarChartModel barChartModel) {
            this.customOptions = barChartModel.getCustomOptions() & dataOptions;
            this.missingResponseEnabled = barChartModel.isMissingResponseEnabled();
            this.uniformPolicy = barChartModel.getUniformPolicy();
            this.missingPolicy = barChartModel.getMissingPolicy();
            this.outsideBarLabelContent = barChartModel.getOutsideBarLabelContent();
            this.insideBarLabelContent = barChartModel.getInsideBarLabelContent();
        }

        public boolean isApplyDataModel(BarChartModel barChartModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != barChartModel.getMissingPolicy() || this.uniformPolicy != barChartModel.getUniformPolicy() || this.missingResponseEnabled != barChartModel.isMissingResponseEnabled() || this.outsideBarLabelContent != barChartModel.getOutsideBarLabelContent() || this.insideBarLabelContent != barChartModel.getInsideBarLabelContent();
            }
            return this.customOptions != (barChartModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.missingResponseEnabled, arg.missingResponseEnabled) && Util.Evaluate.isEqual(this.uniformPolicy, arg.uniformPolicy) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && Util.Evaluate.isEqual(this.outsideBarLabelContent, arg.outsideBarLabelContent) && Util.Evaluate.isEqual(this.insideBarLabelContent, arg.insideBarLabelContent) && super.equals(arg);
        }
    }
}

