/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.areabarchart;

import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.areabarchart.AreaBarChartDataModel;
import com.sas.graphics.components.areabarchart.AreaBarChartModel;
import com.sas.graphics.components.areabarchart.AreaBarChartTableDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.areabarchart.AreaBarChartMatrix;
import com.sas.graphics.util.cell.areabarchart.AreaBarChartMatrixModel;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.table.TableModel;

public class AreaBarChart
extends Graph {
    protected transient AreaBarChartModel areaBarChartModel;
    protected transient AreaBarChartDataModel dataModel;
    protected transient AreaBarChartMatrix matrix;
    protected transient AreaBarChartMatrixModel matrixModel = new AreaBarChartMatrixModel();
    protected static final String COLUMN = "columnVariable";
    protected static final String ROW = "rowVariable";
    protected static final String CATEGORY = "categoryVariable";
    protected static final String SUBGROUP = "subgroupVariable";
    protected static final String HEIGHT = "heightVariable";
    protected static final String WIDTH = "widthVariable";
    protected static final String INSIDE_BAR_LABEL = "insideBarLabelVariable";
    protected static final String OUTSIDE_BAR_LABEL = "outsideBarLabelVariable";
    protected static final String DATA_TIP = "datatipVariable";
    protected static final String AUXILIARY = "auxiliaryVariable";

    public AreaBarChart() {
        this(null, null);
    }

    public AreaBarChart(AreaBarChartDataModel areabarChartDataModel) {
        this(areabarChartDataModel, null);
    }

    public AreaBarChart(AreaBarChartDataModel dm, GraphStyle gs) {
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setCategoryRole(CATEGORY);
        this.matrixModel.setSubgroupRole(SUBGROUP);
        this.matrixModel.setHeightRole(HEIGHT);
        this.matrixModel.setWidthRole(WIDTH);
        this.matrixModel.setInsideBarLabelRole(INSIDE_BAR_LABEL);
        this.matrixModel.setOutsideBarLabelRole(OUTSIDE_BAR_LABEL);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrix = new AreaBarChartMatrix(this.getChannel());
        this.matrix.setModel(this.matrixModel);
        this.setGraphModel(new AreaBarChartModel());
        if (gs == null) {
            gs = this.getDefaultGraphStyle();
        }
        this.applyGraphStyle(gs);
        if (this.designTime) {
            DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimeChartTableData(), Util.getLocale(this), 10475), true, true);
            dataSource.setVariableDefinition(CATEGORY, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("Category")));
            dataSource.setVariableDefinition(HEIGHT, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Response")));
            dataSource.setVariableDefinition(WIDTH, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Response")));
            this.matrix.setDataSource(dataSource);
        }
        if (dm != null) {
            this.setDataModel(dm);
        }
        this.setGraph(this.matrix);
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void validateTree() {
        try {
            super.validateTree();
        }
        catch (IllegalStateException x) {
            this.matrix.setSize(new Dimension(0, 0));
        }
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public void setGraphModel(AreaBarChartModel newAreabarChartModel) throws IllegalArgumentException {
        AreaBarChartModel oldAreabarChartModel = this.areaBarChartModel;
        this.areaBarChartModel = newAreabarChartModel;
        super.setGraphModel(this.areaBarChartModel);
        this.matrixModel.setAreabarChartModel(this.areaBarChartModel);
        this.firePropertyChange("graphModel", oldAreabarChartModel, this.areaBarChartModel);
    }

    public AreaBarChartModel getGraphModel() {
        return this.areaBarChartModel;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        this._setupLabelVariables();
        this.matrix.reconstruct();
    }

    public void setDataModel(AreaBarChartDataModel newDataModel) {
        AreaBarChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public AreaBarChartDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        if (!(this.dataModel instanceof AreaBarChartTableDataModel)) {
            this.matrix.setDataSource(null);
            return;
        }
        AreaBarChartTableDataModel tableDataModel = (AreaBarChartTableDataModel)this.dataModel;
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null || tableModel.getColumnCount() <= 0) {
            this.matrix.setDataSource(null);
            return;
        }
        Locale locale = Util.getLocale(this);
        Locale formatLocale = Util.getFormatLocale(this, this.dataModel);
        boolean missingDataColumnMessageEnabled = !this.areaBarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
        DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, this.dataModel.getSortStrategy()), true, true);
        Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable(), 2), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable(), 2), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCategoryVariable(), 2), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSubgroupVariable(), 2), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, HEIGHT, "heightRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getHeightVariable(), 1), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, WIDTH, "widthRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getWidthVariable(), 1), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
        int firstStringCol = -1;
        int firstNumberCol = -1;
        if (dataSource.getVariableDefinition(CATEGORY) == null) {
            int categoryCol = firstStringCol = this.findColumn(tableModel, String.class, firstStringCol + 1);
            if (categoryCol < 0) {
                categoryCol = firstNumberCol = this.findColumn(tableModel, Number.class, firstNumberCol + 1);
            }
            if (categoryCol >= 0) {
                dataSource.setVariableDefinition(CATEGORY, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(categoryCol), 2));
            }
        }
        if (dataSource.getVariableDefinition(WIDTH) == null) {
            int widthCol = firstNumberCol = this.findColumn(tableModel, Number.class, firstNumberCol + 1);
            FreqVariableDefinition widthVarDef = widthCol >= 0 ? VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(widthCol)) : new FreqVariableDefinition();
            dataSource.setVariableDefinition(WIDTH, widthVarDef);
        }
        if (dataSource.getVariableDefinition(HEIGHT) == null) {
            int heightCol = firstNumberCol = this.findColumn(tableModel, Number.class, firstNumberCol + 1);
            FreqVariableDefinition heightVarDef = heightCol >= 0 ? VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(heightCol)) : new FreqVariableDefinition();
            dataSource.setVariableDefinition(HEIGHT, heightVarDef);
        }
        this.matrix.setDataSource(dataSource);
        this._setupLabelVariables();
    }

    private void _setupLabelVariables() {
        DataSource ds = this.matrix.getDataSource();
        if (ds == null) {
            return;
        }
        if (!(this.dataModel instanceof AreaBarChartTableDataModel)) {
            return;
        }
        AreaBarChartTableDataModel tableDataModel = (AreaBarChartTableDataModel)this.dataModel;
        Variable insideLabelVar = null;
        Variable outsideLabelVar = null;
        for (int v = 1; v <= 2; ++v) {
            Variable var;
            int content = v == 1 ? this.areaBarChartModel.getInsideBarLabelContent() : this.areaBarChartModel.getOutsideBarLabelContent();
            switch (content) {
                default: {
                    var = null;
                    break;
                }
                case 10616: {
                    var = tableDataModel.getWidthVariable();
                    break;
                }
                case 10617: {
                    var = Util.newAnalysisVaraible(tableDataModel.getWidthVariable(), null, 10507);
                    break;
                }
                case 10618: {
                    var = tableDataModel.getHeightVariable();
                    break;
                }
                case 10619: {
                    var = Util.newAnalysisVaraible(tableDataModel.getHeightVariable(), null, 10507);
                    break;
                }
                case 10602: {
                    var = tableDataModel.getCategoryVariable();
                }
            }
            if (v == 1) {
                insideLabelVar = var;
                continue;
            }
            outsideLabelVar = var;
        }
        Locale locale = Util.getLocale(this);
        boolean missingDataColumnMessageEnabled = !this.areaBarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
        Util.setVariableDefinition(ds, INSIDE_BAR_LABEL, "insideBarLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(insideLabelVar), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ds, OUTSIDE_BAR_LABEL, "outsideBarLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(outsideLabelVar), missingDataColumnMessageEnabled);
    }

    protected int findColumn(TableModel model, Class type, int minCol) {
        int maxCol = model.getColumnCount();
        for (int col = minCol; col < maxCol; ++col) {
            if (!type.isAssignableFrom(model.getColumnClass(col))) continue;
            return col;
        }
        return -1;
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        AxisModel widthAxisModel = this.areaBarChartModel.getWidthAxisModel();
        AxisModel heightAxisModel = this.areaBarChartModel.getHeightAxisModel();
        AxisWallModel axisWallModel = this.areaBarChartModel.getAxisWallModel();
        LegendModel legendModel = this.areaBarChartModel.getLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, widthAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, heightAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, axisWallModel);
        Util.Conveyer.applyGraphStyle(graphStyle, legendModel);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
        this.invalidate();
        this.validate();
        this.validate();
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        Object selectionModel = null;
        if (this.dataModel instanceof AreaBarChartTableDataModel) {
            AreaBarChartTableDataModel tm = (AreaBarChartTableDataModel)this.dataModel;
            model = tm.getModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }
}

