/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.animation;

import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.text.Message;

public class AnimationPosition {
    public static final AnimationPosition NEXT_KEY_FRAME = new AnimationPosition(null);
    public static final AnimationPosition PREVIOUS_KEY_FRAME = new AnimationPosition(null);
    public static final AnimationPosition NEXT_FRAME = new AnimationPosition(null);
    public static final AnimationPosition PREVIOUS_FRAME = new AnimationPosition(null);
    private final Object keyFrame1;
    private final Object keyFrame2;
    private final double interpolationPercent;

    public AnimationPosition(Object keyFrame) {
        this.keyFrame1 = this.keyFrame2 = keyFrame;
        this.interpolationPercent = 0.0;
    }

    public AnimationPosition(Object keyFrame1, Object keyFrame2, double interpolationPercent) throws IllegalArgumentException {
        if (keyFrame1 == null || keyFrame2 == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        if (interpolationPercent < 0.0 || interpolationPercent > 1.0 || Double.isNaN(interpolationPercent)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(0.0), (Object)new Double(1.0)));
        }
        this.keyFrame1 = keyFrame1;
        this.keyFrame2 = keyFrame2;
        this.interpolationPercent = Math.min(1.0, Math.max(interpolationPercent, 0.0));
    }

    public double getInterpolationPercent() {
        return this.interpolationPercent;
    }

    public Object getKeyFrame1() {
        return this.keyFrame1;
    }

    public Object getKeyFrame2() {
        return this.keyFrame2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AnimationPosition arg = (AnimationPosition)obj;
        return Util.Evaluate.isEqual(this.keyFrame1, arg.keyFrame1) && Util.Evaluate.isEqual(this.keyFrame2, arg.keyFrame2) && Util.Evaluate.isEqual(this.interpolationPercent, arg.interpolationPercent);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

