/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

@SASScope(value="ALL")
public class VariableList
extends Variable {
    private VariableList next;

    public VariableList(String columnName, String format, String informat, String label, VariableList next) {
        super(columnName, format, informat, label);
        this.next = next;
    }

    public VariableList(int columnIndex, String format, String informat, String label, VariableList next) {
        super(columnIndex, format, informat, label);
        this.next = next;
    }

    public VariableList(String[] columnNames) {
        super(columnNames != null && columnNames.length > 0 ? columnNames[0] : null);
        if (columnNames != null && columnNames.length > 1) {
            VariableList nextVar = null;
            for (int ii = columnNames.length - 1; ii > 0; --ii) {
                nextVar = new VariableList(columnNames[ii], null, null, null, nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    private VariableList(Variable variable, VariableList next) {
        super(variable);
        this.next = next;
    }

    public VariableList(Variable[] variableArray) {
        super(variableArray != null && variableArray.length > 0 ? variableArray[0] : null);
        if (variableArray != null && variableArray.length > 1) {
            VariableList nextVar = null;
            for (int ii = variableArray.length - 1; ii > 0; --ii) {
                nextVar = new VariableList(variableArray[ii], nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    public VariableList getNext() {
        return this.next;
    }

    public Variable[] asArray() {
        VariableList curr;
        int ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            ++ii;
        }
        Variable[] array = new Variable[ii];
        ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            array[ii++] = new Variable(curr);
        }
        return array;
    }

    public ArrayList asArrayList() {
        VariableList curr = this;
        ArrayList<VariableList> list = new ArrayList<VariableList>();
        do {
            list.add(curr);
        } while ((curr = curr.getNext()) != null);
        return list;
    }

    public Iterator iterator() {
        return new VariableListIterator(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        VariableList arg = (VariableList)obj;
        return Util.Evaluate.isEqual(this.next, arg.next) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @SASScope
    private static class VariableListIterator
    implements Iterator {
        VariableList curr = null;
        VariableList next;

        public VariableListIterator(VariableList ptr) {
            this.next = ptr;
        }

        public Object next() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = this.curr.getNext();
            return this.curr;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
        }
    }
}

