/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class Variable
extends ModelBase {
    private final String columnName;
    private final int columnIndex;
    private final String format;
    private final String informat;
    private final String label;
    private final CategorizationModel categorizationModel;
    private final SegmentedRangeStyle segmentedRangeStyle;

    public Variable(String columnName) {
        this(columnName, null, null, null, null, null);
    }

    public Variable(String columnName, String format) {
        this(columnName, format, null, null, null, null);
    }

    public Variable(String columnName, String format, String informat, String label) {
        this(columnName, format, informat, label, null, null);
    }

    public Variable(String columnName, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        this.columnName = columnName;
        this.columnIndex = -1;
        this.format = format;
        this.informat = informat;
        this.label = label;
        this.categorizationModel = Util.Copier.copyOf(categorizationModel);
        this.segmentedRangeStyle = this.categorizationModel != null ? Util.Copier.copyOf(segmentedRangeStyle) : null;
    }

    public Variable(int columnIndex) {
        this(columnIndex, null, null, null);
    }

    public Variable(int columnIndex, String format, String informat, String label) {
        this(columnIndex, format, informat, label, null, null);
    }

    public Variable(int columnIndex, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        this.columnName = null;
        this.columnIndex = columnIndex;
        this.format = format;
        this.informat = informat;
        this.label = label;
        this.categorizationModel = Util.Copier.copyOf(categorizationModel);
        this.segmentedRangeStyle = this.categorizationModel != null ? Util.Copier.copyOf(segmentedRangeStyle) : null;
    }

    public Variable(Variable v) {
        if (v == null) {
            this.columnName = null;
            this.columnIndex = -1;
            this.format = null;
            this.informat = null;
            this.label = null;
            this.categorizationModel = null;
            this.segmentedRangeStyle = null;
        } else {
            this.columnName = v.getColumnName();
            this.columnIndex = v.getColumnIndex();
            this.format = v.getFormat();
            this.informat = v.getInformat();
            this.label = v.getLabel();
            this.categorizationModel = v.getCategorizationModel();
            this.segmentedRangeStyle = v.getSegmentedRangeStyle();
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFormat() {
        return this.format;
    }

    public String getInformat() {
        return this.informat;
    }

    public CategorizationModel getCategorizationModel() {
        return Util.Copier.copyOf(this.categorizationModel);
    }

    public SegmentedRangeStyle getSegmentedRangeStyle() {
        return Util.Copier.copyOf(this.segmentedRangeStyle);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Variable arg = (Variable)obj;
        return Util.Evaluate.isEqual(this.columnName, arg.columnName) && Util.Evaluate.isEqual(this.columnIndex, arg.columnIndex) && Util.Evaluate.isEqual(this.format, arg.format) && Util.Evaluate.isEqual(this.informat, arg.informat) && Util.Evaluate.isEqual(this.label, arg.label) && Util.Evaluate.isEqual(this.categorizationModel, arg.categorizationModel) && Util.Evaluate.isEqual(this.segmentedRangeStyle, arg.segmentedRangeStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

