/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TimeLength;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class TimePeriodModel
extends ModelBase {
    public static final String RB_KEY = "TimePeriodModel.";
    private LineStyle frameLineStyle = new LineStyle();
    private TextStyle textStyle = new TextStyle();
    private TimeLength timeLength = null;
    private String format;
    private boolean visible = true;

    public TimePeriodModel() {
        this.textStyle.setJustification(2);
        this.setContainedModel("textStyle", this.textStyle);
        this.setContainedModel("frameLineStyle", this.frameLineStyle);
    }

    public void apply(TimePeriodModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.format = theOtherObject.format;
        this.timeLength = theOtherObject.timeLength;
        this.visible = theOtherObject.visible;
        this.frameLineStyle.apply(theOtherObject.frameLineStyle);
        this.textStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.textStyle, this.textStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setTimeLength(TimeLength newLength) {
        TimeLength oldLength = this.timeLength;
        this.timeLength = newLength;
        this.firePropertyChange("timeLength", oldLength, newLength);
    }

    public TimeLength getTimeLength() {
        return this.timeLength;
    }

    public void setTextStyle(TextStyle valueTextStyle) throws IllegalArgumentException {
        if (this.textStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.textStyle;
        this.textStyle = valueTextStyle;
        this.firePropertyChange("textStyle", oldValue, valueTextStyle);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setFormat(String aFormat) {
        String oldFormat = this.format;
        this.format = aFormat;
        this.firePropertyChange("format", oldFormat, this.format);
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TimePeriodModel arg = (TimePeriodModel)obj;
        return Util.Evaluate.isEqual(this.timeLength, arg.timeLength) && Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.format, arg.format) && Util.Evaluate.isEqual(this.textStyle, arg.textStyle) && Util.Evaluate.isEqual(this.frameLineStyle, arg.frameLineStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

