/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseDistance;
import com.sas.measures.BaseLength;
import java.awt.Color;

@SASScope(value="ALL")
public class TickStyle
extends ModelBase {
    public static final String RB_KEY = "TickStyle.";
    private static final BaseLength DEFAULT_LENGTH = new BaseLength(3.0, "px");
    private int placement = 50002;
    private BaseLength length = DEFAULT_LENGTH;
    private LineStyle lineStyle = new LineStyle();
    private static final int _PLACEMENT_ = 50000;
    public static final int PLACEMENT_INSIDE = 50000;
    public static final int PLACEMENT_ACROSS = 50001;
    public static final int PLACEMENT_OUTSIDE = 50002;
    public static final ConstantCollection PLACEMENT = new ConstantCollection("TickStyle.", new ConstantCollection.Element[]{new ConstantCollection.Element(50000, "PLACEMENT_INSIDE", "Inside"), new ConstantCollection.Element(50001, "PLACEMENT_ACROSS", "Across"), new ConstantCollection.Element(50002, "PLACEMENT_OUTSIDE", "Outside")});

    public TickStyle() {
        this(null);
    }

    public TickStyle(Color newColor) {
        if (newColor != null) {
            this.lineStyle = new LineStyle(newColor);
        }
        this.setContainedModel("lineStyle", this.lineStyle);
    }

    public void apply(TickStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.placement = theOtherObject.placement;
        this.length = theOtherObject.length;
        this.lineStyle.apply(theOtherObject.lineStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setPlacement(int newPlacement) throws IllegalArgumentException {
        PLACEMENT.validate(newPlacement);
        int oldPlacement = this.placement;
        this.placement = newPlacement;
        this.firePropertyChange("placement", oldPlacement, newPlacement);
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setBaseLength(BaseLength newBaseLength) {
        if (newBaseLength != null) {
            BaseLength oldBaseLength = this.length;
            this.length = newBaseLength;
            this.firePropertyChange("length", oldBaseLength, newBaseLength);
        }
    }

    public BaseLength getBaseLength() {
        return this.length;
    }

    public void setLineStyle(LineStyle newLineStyle) throws IllegalArgumentException {
        if (newLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldValue = this.lineStyle;
        this.lineStyle = newLineStyle;
        this.firePropertyChange("lineStyle", oldValue, newLineStyle);
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TickStyle arg = (TickStyle)obj;
        return Util.Evaluate.isEqual(this.placement, arg.placement) && Util.Evaluate.isEqual((BaseDistance)this.length, (BaseDistance)arg.length) && Util.Evaluate.isEqual(this.lineStyle, arg.lineStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

