/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;

@SASScope(value="ALL")
public class TextStyle
extends ModelBase {
    private boolean visible = true;
    private Font font = FontManager.getFont((String)RB.getStringResource("fontTimesRoman.lcl"), (int)0, (int)12);
    private Color color = SystemColor.textText;
    private int justification = 10200;
    private Color rowSelectionTextColor = SystemColor.textText;
    private Font rowSelectionFont = FontManager.getDefaultFont();
    private ShadowStyle shadowStyle = new ShadowStyle();

    public void apply(TextStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.visible = theOtherObject.visible;
        this.font = theOtherObject.font;
        this.rowSelectionFont = theOtherObject.rowSelectionFont;
        this.justification = theOtherObject.justification;
        this.color = theOtherObject.color;
        this.shadowStyle.apply(theOtherObject.shadowStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public TextStyle() {
        this.setContainedModel("shadowStyle", this.shadowStyle);
    }

    public TextStyle(Font newFont, Color newColor, int newJustification, boolean newVisible) {
        if (newFont != null) {
            this.font = newFont;
        }
        if (newColor != null) {
            this.color = newColor;
        }
        if (newFont != null) {
            this.rowSelectionFont = newFont;
        }
        if (newColor != null) {
            this.rowSelectionTextColor = newColor;
        }
        switch (newJustification) {
            case 0: 
            case 2: 
            case 4: 
            case 10200: {
                this.justification = newJustification;
            }
        }
        this.visible = newVisible;
        this.setContainedModel("shadowStyle", this.shadowStyle);
    }

    public void setFont(Font newFont) throws IllegalArgumentException {
        if (newFont == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Font oldFont = this.font;
        this.font = newFont;
        this.firePropertyChange("font", oldFont, newFont);
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.color;
        this.color = newColor;
        this.firePropertyChange("color", oldColor, newColor);
    }

    public Color getColor() {
        return this.color;
    }

    public void setJustification(int newJustification) throws IllegalArgumentException {
        switch (newJustification) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 0: 
            case 2: 
            case 4: 
            case 10200: 
        }
        int oldJustification = this.justification;
        this.justification = newJustification;
        this.firePropertyChange("justification", oldJustification, newJustification);
    }

    public int getJustification() {
        return this.justification;
    }

    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        this.firePropertyChange("visible", oldVisible, newVisible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setShadowStyle(ShadowStyle newShadow) throws IllegalArgumentException {
        if (newShadow == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ShadowStyle oldValue = this.shadowStyle;
        this.shadowStyle = newShadow;
        this.firePropertyChange("shadowStyle", oldValue, newShadow);
    }

    public ShadowStyle getShadowStyle() {
        return this.shadowStyle;
    }

    public Font getRowSelectionFontStlye() {
        return this.rowSelectionFont;
    }

    public void setRowSelectionFontStyle(Font newRowSelectionFont) throws IllegalArgumentException {
        if (newRowSelectionFont == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Font oldRowSelctionFont = this.rowSelectionFont;
        this.rowSelectionFont = newRowSelectionFont;
        this.firePropertyChange("rowSelectionFont", oldRowSelctionFont, newRowSelectionFont);
    }

    public Color getRowSelectionTextColorStlye() {
        return this.rowSelectionTextColor;
    }

    public void setRowSelectionTextColorStyle(Color newRowSelectionColor) throws IllegalArgumentException {
        if (newRowSelectionColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldRowSelctioncolor = this.rowSelectionTextColor;
        this.rowSelectionTextColor = newRowSelectionColor;
        this.firePropertyChange("rowSelectionTextColor", oldRowSelctioncolor, newRowSelectionColor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TextStyle arg = (TextStyle)obj;
        return Util.Evaluate.isEqual(this.justification, arg.justification) && Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.color, arg.color) && Util.Evaluate.isEqual(this.shadowStyle, arg.shadowStyle) && Util.Evaluate.isEqual(this.font, arg.font) && Util.Evaluate.isEqual(this.rowSelectionTextColor, arg.rowSelectionTextColor) && Util.Evaluate.isEqual(this.rowSelectionFont, arg.rowSelectionFont) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

