/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseDistance;
import com.sas.measures.BaseLength;

@SASScope(value="ALL")
public class TableAxisColumn
extends ModelBase {
    private final Variable variable;
    private BaseLength width = new BaseLength(60.0, "px");
    private boolean visible = true;
    private int sortType = 10400;
    private int sortIndex = 0;

    public TableAxisColumn(Variable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        this.variable = var;
    }

    public TableAxisColumn(Variable var, int sort) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        this.variable = var;
        this.sortType = TableAxisColumn._validateSort(sort);
    }

    public TableAxisColumn(Variable var, int sort, int index) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        if (index < 0) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInvalid.ex.txt"));
        }
        this.variable = var;
        this.sortType = TableAxisColumn._validateSort(sort);
        this.sortIndex = index;
    }

    public TableAxisColumn(Variable var, int sort, int index, BaseLength wid) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        if (index < 0) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInvalid.ex.txt"));
        }
        this.variable = var;
        this.width = wid;
        this.sortType = TableAxisColumn._validateSort(sort);
        this.sortIndex = index;
    }

    public TableAxisColumn(Variable var, int sort, int index, BaseLength wid, boolean vis) {
        if (var == null || wid == null) {
            throw new IllegalArgumentException();
        }
        if (index < 0) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInvalid.ex.txt"));
        }
        this.variable = var;
        this.width = wid;
        this.visible = vis;
        this.sortType = TableAxisColumn._validateSort(sort);
        this.sortIndex = index;
    }

    public void apply(TableAxisColumn theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.width = theOtherObject.width;
        this.visible = theOtherObject.visible;
        this.sortType = TableAxisColumn._validateSort(theOtherObject.sortType);
        this.sortIndex = theOtherObject.sortIndex;
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TableAxisColumn arg = (TableAxisColumn)obj;
        return Util.Evaluate.isEqual(this.variable, arg.variable) && Util.Evaluate.isEqual((BaseDistance)this.width, (BaseDistance)arg.width) && Util.Evaluate.isEqual(this.visible, arg.visible) && super.equals(arg);
    }

    private static int _validateSort(int sort) {
        switch (sort) {
            default: {
                sort = 10400;
            }
            case 10400: 
            case 10401: 
            case 10402: 
            case 10403: 
            case 10404: 
            case 10405: 
            case 10406: 
        }
        return sort;
    }

    public void setWidth(BaseLength newWidth) throws IllegalArgumentException {
        if (newWidth == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseLength oldWidth = this.width;
        this.width = newWidth;
        this.firePropertyChange("width", oldWidth, newWidth);
    }

    public BaseLength getWidth() {
        return this.width;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        this.firePropertyChange("visible", oldVisible, newVisible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setSort(int newSort) {
        int oldSort = this.sortType;
        this.sortType = TableAxisColumn._validateSort(newSort);
        this.firePropertyChange("sortType", oldSort, newSort);
    }

    public int getSort() {
        return this.sortType;
    }

    public void setSortIndex(int newSortIndex) {
        if (newSortIndex < 0) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInvalid.ex.txt"));
        }
        int oldSortIndex = this.sortIndex;
        this.sortIndex = newSortIndex;
        this.firePropertyChange("sortIndex", oldSortIndex, newSortIndex);
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

