/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.util.Util;

@SASScope
public class SummarizedVariable
extends AnalysisVariable {
    private final String freqColumnName;
    private final int freqColumnIndex;

    private static int _validateStatistic(int statistic) {
        switch (statistic) {
            case 10501: 
            case 10502: 
            case 10503: 
            case 10504: 
            case 10505: 
            case 10506: 
            case 10507: 
            case 10508: 
            case 10509: {
                return statistic;
            }
        }
        return 10506;
    }

    private static AnalysisVariable _validateVariable(AnalysisVariable sumVariable) {
        if (sumVariable != null) {
            if (sumVariable.getStatistic() == SummarizedVariable._validateStatistic(sumVariable.getStatistic())) {
                return sumVariable;
            }
            if (sumVariable.getColumnIndex() >= 0) {
                return new AnalysisVariable(sumVariable.getColumnIndex(), sumVariable.getFormat(), sumVariable.getInformat(), sumVariable.getLabel(), 10506, sumVariable.getHighColumnIndex(), sumVariable.getHighLabel(), sumVariable.getLowColumnIndex(), sumVariable.getLowLabel());
            }
            return new AnalysisVariable(sumVariable.getColumnName(), sumVariable.getFormat(), sumVariable.getInformat(), sumVariable.getLabel(), 10506, sumVariable.getHighColumnName(), sumVariable.getHighLabel(), sumVariable.getLowColumnName(), sumVariable.getLowLabel());
        }
        return null;
    }

    public SummarizedVariable(AnalysisVariable sumVariable, Variable freqVariable) {
        super(SummarizedVariable._validateVariable(sumVariable));
        if (freqVariable != null) {
            this.freqColumnName = freqVariable.getColumnName();
            this.freqColumnIndex = freqVariable.getColumnIndex();
        } else {
            this.freqColumnName = null;
            this.freqColumnIndex = -1;
        }
    }

    public SummarizedVariable(String columnName, String freqColumnName, String format, String informat, String label, int statistic) {
        super(columnName, format, informat, label, SummarizedVariable._validateStatistic(statistic));
        this.freqColumnName = freqColumnName;
        this.freqColumnIndex = -1;
    }

    public SummarizedVariable(int columnIndex, int freqColumnIndex, String format, String informat, String label, int statistic) {
        super(columnIndex, format, informat, label, SummarizedVariable._validateStatistic(statistic));
        this.freqColumnName = null;
        this.freqColumnIndex = freqColumnIndex;
    }

    public SummarizedVariable(String columnName, String freqColumnName, String format, String informat, String label, int statistic, String highColumnName, String highLabel, String lowColumnName, String lowLabel) {
        super(columnName, format, informat, label, SummarizedVariable._validateStatistic(statistic), highColumnName, highLabel, lowColumnName, lowLabel);
        this.freqColumnName = freqColumnName;
        this.freqColumnIndex = -1;
    }

    public SummarizedVariable(int columnIndex, int freqColumnIndex, String format, String informat, String label, int statistic, int highColumnIndex, String highLabel, int lowColumnIndex, String lowLabel) {
        super(columnIndex, format, informat, label, SummarizedVariable._validateStatistic(statistic), highColumnIndex, highLabel, lowColumnIndex, lowLabel);
        this.freqColumnName = null;
        this.freqColumnIndex = freqColumnIndex;
    }

    public SummarizedVariable(SummarizedVariable av) {
        super(av);
        this.freqColumnName = av.freqColumnName;
        this.freqColumnIndex = av.freqColumnIndex;
    }

    public String getFreqColumnName() {
        return this.freqColumnName;
    }

    public int getFreqColumnIndex() {
        return this.freqColumnIndex;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SummarizedVariable arg = (SummarizedVariable)obj;
        return Util.Evaluate.isEqual(this.freqColumnIndex, arg.freqColumnIndex) && Util.Evaluate.isEqual(this.freqColumnName, arg.freqColumnName) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

