/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

@SASScope
public class SegmentedRangeStyle
extends ModelBase {
    DataElementStyles dataElementStyles;
    private int paletteType = 10200;

    public static SegmentedRangeStyle newSegmentedRangeStyle(Color[] colors) {
        if (colors == null || colors.length < 1) {
            return null;
        }
        for (int ii = 0; ii < colors.length; ++ii) {
            if (colors[ii] != null) continue;
            return null;
        }
        DataElementStyles styles = new DataElementStyles();
        MarkerStyle[] oldMarkerStyles = styles.getMarkerStyles();
        FillStyle[] fillStyles = new FillStyle[colors.length];
        MarkerStyle[] markerStyles = new MarkerStyle[colors.length];
        StrokeLineStyle[] lineStyles = new StrokeLineStyle[colors.length];
        for (int ii = 0; ii < colors.length; ++ii) {
            fillStyles[ii] = new FillStyle(colors[ii]);
            lineStyles[ii] = new StrokeLineStyle(colors[ii]);
            markerStyles[ii] = new MarkerStyle(oldMarkerStyles[ii % oldMarkerStyles.length].getSymbol(), colors[ii]);
        }
        styles.setFillStyles(fillStyles);
        styles.setLineStyles(lineStyles);
        styles.setMarkerStyles(markerStyles);
        styles.setDiscreteFillColors(colors);
        SegmentedRangeStyle segmentedRangeStyle = new SegmentedRangeStyle();
        segmentedRangeStyle.setPaletteType(12100);
        segmentedRangeStyle.setDataElementStyles(styles);
        return segmentedRangeStyle;
    }

    public static SegmentedRangeStyle newSegmentedRangeStyle(Color startColor, Color neutralColor, Color endColor) {
        if (startColor == null || neutralColor == null || endColor == null) {
            return null;
        }
        DataElementStyles styles = new DataElementStyles();
        styles.setContinuousContrastThreeColorStartColor(startColor);
        styles.setContinuousContrastThreeColorNeutralColor(neutralColor);
        styles.setContinuousContrastThreeColorEndColor(endColor);
        styles.setContinuousFillThreeColorStartColor(startColor);
        styles.setContinuousFillThreeColorNeutralColor(neutralColor);
        styles.setContinuousFillThreeColorEndColor(endColor);
        SegmentedRangeStyle segmentedRangeStyle = new SegmentedRangeStyle();
        segmentedRangeStyle.setPaletteType(12102);
        segmentedRangeStyle.setDataElementStyles(styles);
        return segmentedRangeStyle;
    }

    public static SegmentedRangeStyle newSegmentedRangeStyle(Color startColor, Color endColor) {
        if (startColor == null || endColor == null) {
            return null;
        }
        DataElementStyles styles = new DataElementStyles();
        styles.setContinuousContrastTwoColorStartColor(startColor);
        styles.setContinuousContrastTwoColorEndColor(endColor);
        styles.setContinuousFillTwoColorStartColor(startColor);
        styles.setContinuousFillTwoColorEndColor(endColor);
        SegmentedRangeStyle segmentedRangeStyle = new SegmentedRangeStyle();
        segmentedRangeStyle.setPaletteType(12101);
        segmentedRangeStyle.setDataElementStyles(styles);
        return segmentedRangeStyle;
    }

    public SegmentedRangeStyle() {
    }

    public SegmentedRangeStyle(int paletteType) {
        GraphConstants.PALETTE.validate(paletteType);
        this.paletteType = paletteType;
    }

    public void setDataElementStyles(DataElementStyles dataElementStyles) {
        DataElementStyles oldDataElementStyles = this.dataElementStyles;
        this.dataElementStyles = dataElementStyles;
        this.firePropertyChange("dataElementStyles", oldDataElementStyles, this.dataElementStyles);
    }

    public DataElementStyles getDataElementStyles() {
        return this.dataElementStyles;
    }

    public void setPaletteType(int paletteType) {
        GraphConstants.PALETTE.validate(paletteType);
        int oldPaletteType = this.paletteType;
        this.paletteType = paletteType;
        this.firePropertyChange("paletteType", oldPaletteType, this.paletteType);
    }

    public int getPaletteType() {
        return this.paletteType;
    }

    public void apply(SegmentedRangeStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.paletteType = theOtherObject.paletteType;
        this.disablePropertyChange();
        if (theOtherObject.dataElementStyles == null) {
            this.dataElementStyles = null;
        } else {
            if (this.dataElementStyles == null) {
                this.dataElementStyles = new DataElementStyles();
            }
            this.dataElementStyles.apply(theOtherObject.dataElementStyles);
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SegmentedRangeStyle arg = (SegmentedRangeStyle)obj;
        return Util.Evaluate.isEqual(this.paletteType, arg.paletteType) && Util.Evaluate.isEqual(this.dataElementStyles, arg.dataElementStyles) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

