/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.text.Message;

@SASScope
public class SegmentedRangeModel
extends ModelBase {
    private boolean boundaryInHigherSegment = true;
    private double[] segmentedRange;

    public static SegmentedRangeModel newSegmentedRangeModel(double[] segmentedRange) throws IllegalArgumentException {
        SegmentedRangeModel segmentedRangeModel = new SegmentedRangeModel();
        segmentedRangeModel.setSegmentedRange(segmentedRange);
        return segmentedRangeModel;
    }

    public static SegmentedRangeModel newSegmentedRangeModel(double[] segmentedRange, boolean boundaryInHigherSegment) throws IllegalArgumentException {
        SegmentedRangeModel segmentedRangeModel = new SegmentedRangeModel();
        segmentedRangeModel.setSegmentedRange(segmentedRange);
        segmentedRangeModel.setBoundaryInHigherSegment(boundaryInHigherSegment);
        return segmentedRangeModel;
    }

    public static SegmentedRangeModel newSegmentedRangeModel(double from, double to, double by) throws IllegalArgumentException {
        if (Double.isNaN(from) || Double.isInfinite(from)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (Double.isNaN(to) || Double.isInfinite(to)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (Double.isNaN(by) || Double.isInfinite(by)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (from >= to) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidRangeSpec.ex.fmt.txt"), (Object)"to", (Object)"from"));
        }
        if (to - from < by) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidBySpec.ex.fmt.txt"), (Object)"by", (Object)"to", (Object)"from"));
        }
        int ii = 0;
        int size = (int)((to - from) / by) + 1;
        double[] segmentedRange = new double[size];
        double boudary = from;
        while (boudary <= to) {
            segmentedRange[ii] = boudary;
            boudary += by;
            ++ii;
        }
        return SegmentedRangeModel.newSegmentedRangeModel(segmentedRange);
    }

    public void setBoundaryInHigherSegment(boolean boundaryInHigherSegment) {
        boolean oldBoundaryInHigherSegment = this.boundaryInHigherSegment;
        this.boundaryInHigherSegment = boundaryInHigherSegment;
        this.firePropertyChange("boundaryInHigherSegment", oldBoundaryInHigherSegment, this.boundaryInHigherSegment);
    }

    public boolean isBoundaryInHigherSegment() {
        return this.boundaryInHigherSegment;
    }

    public void setSegmentedRange(double[] segmentedRange) throws IllegalArgumentException {
        Util.Validator.validateSegmentedRange(segmentedRange);
        double[] oldSegmentedRange = this.segmentedRange;
        this.segmentedRange = Util.Copier.copyOf(segmentedRange);
        this.firePropertyChange("segmentedRange", oldSegmentedRange, this.segmentedRange);
    }

    public double[] getSegmentedRange() {
        return Util.Copier.copyOf(this.segmentedRange);
    }

    public void apply(SegmentedRangeModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.boundaryInHigherSegment = theOtherObject.boundaryInHigherSegment;
        this.segmentedRange = theOtherObject.getSegmentedRange();
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SegmentedRangeModel arg = (SegmentedRangeModel)obj;
        return Util.Evaluate.isEqual(this.boundaryInHigherSegment, arg.boundaryInHigherSegment) && Util.Evaluate.isEqual(this.segmentedRange, arg.segmentedRange) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

