/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

@SASScope(value="ALL")
public class ReferenceBandModel
extends ModelBase {
    private String label = null;
    private TextStyle textStyle = null;
    private FillStyle fillStyle = new FillStyle();
    private ReferenceLineModel beginReferenceLineModel = ReferenceBandModel.newReferenceLineModel(Double.NaN);
    private ReferenceLineModel endReferenceLineModel = ReferenceBandModel.newReferenceLineModel(Double.NaN);
    private boolean visible = true;

    public ReferenceBandModel() {
        this.setContainedModel("fillStyle", this.fillStyle);
        this.setContainedModel("endReferenceLineModel", this.endReferenceLineModel);
        this.setContainedModel("beginReferenceLineModel", this.beginReferenceLineModel);
    }

    public ReferenceBandModel(FillStyle newFillStyle) {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.fillStyle = newFillStyle;
    }

    public ReferenceBandModel(FillStyle newFillStyle, ReferenceLineModel newBegin, ReferenceLineModel newEnd) {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.fillStyle = newFillStyle;
        this.setBeginReferenceLineModel(newBegin);
        this.setEndReferenceLineModel(newEnd);
    }

    public ReferenceBandModel(String label, Color color, Object newBegin, Object newEnd) {
        if (newEnd == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newBegin == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.label = label;
        this.fillStyle = new FillStyle(color);
        if (newBegin instanceof ReferenceLineModel && newEnd instanceof ReferenceLineModel) {
            this.setEndReferenceLineModel((ReferenceLineModel)newEnd);
            this.setBeginReferenceLineModel((ReferenceLineModel)newBegin);
        } else {
            this.setEndReferenceLineModel(ReferenceBandModel.newReferenceLineModel(newEnd));
            this.setBeginReferenceLineModel(ReferenceBandModel.newReferenceLineModel(newBegin));
        }
    }

    public ReferenceBandModel(String label, Color color, double newBegin, double newEnd) {
        if (Double.isNaN(newBegin) || Double.isInfinite(newBegin)) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (Double.isNaN(newEnd) || Double.isInfinite(newEnd)) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.label = label;
        this.fillStyle = new FillStyle(color);
        this.setBeginReferenceLineModel(ReferenceBandModel.newReferenceLineModel(newBegin));
        this.setEndReferenceLineModel(ReferenceBandModel.newReferenceLineModel(newEnd));
    }

    private static ReferenceLineModel newReferenceLineModel(double d) {
        ReferenceLineModel rlm = new ReferenceLineModel(d);
        rlm.setInFront(false);
        rlm.setVisible(false);
        return rlm;
    }

    private static ReferenceLineModel newReferenceLineModel(Object o) {
        ReferenceLineModel rlm = new ReferenceLineModel(o);
        rlm.setInFront(false);
        rlm.setVisible(false);
        return rlm;
    }

    public void apply(ReferenceBandModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.label = theOtherObject.label;
        if (theOtherObject.textStyle == null) {
            this.setTextStyle(null);
        } else {
            if (this.textStyle != null) {
                this.setTextStyle(new AdvancedTextStyle());
            }
            this.textStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.textStyle, this.textStyle);
        }
        this.fillStyle.apply(theOtherObject.fillStyle);
        if (theOtherObject.beginReferenceLineModel == null) {
            this.beginReferenceLineModel = null;
        } else {
            if (this.beginReferenceLineModel == null) {
                this.setBeginReferenceLineModel(new ReferenceLineModel());
            }
            this.beginReferenceLineModel.apply(theOtherObject.beginReferenceLineModel);
        }
        if (theOtherObject.endReferenceLineModel == null) {
            this.endReferenceLineModel = null;
        } else {
            if (this.endReferenceLineModel == null) {
                this.setEndReferenceLineModel(new ReferenceLineModel());
            }
            this.endReferenceLineModel.apply(theOtherObject.endReferenceLineModel);
        }
        this.visible = theOtherObject.visible;
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setTextStyle(TextStyle newTextStyle) {
        TextStyle oldValue = this.textStyle;
        this.textStyle = newTextStyle;
        this.firePropertyChange("textStyle", oldValue, newTextStyle);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setLabel(String newLabel) {
        String oldValue = this.label;
        this.label = newLabel;
        this.firePropertyChange("label", oldValue, newLabel);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
    }

    public void setFillStyle(FillStyle newFillStyle) {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.fillStyle;
        this.fillStyle = newFillStyle;
        this.firePropertyChange("fillStyle", oldValue, newFillStyle);
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setBeginReferenceLineModel(ReferenceLineModel newBegin) {
        ReferenceLineModel oldValue = this.beginReferenceLineModel;
        this.beginReferenceLineModel = newBegin;
        this.firePropertyChange("beginReferenceLineModel", oldValue, this.beginReferenceLineModel);
    }

    public ReferenceLineModel getBeginReferenceLineModel() {
        return this.beginReferenceLineModel;
    }

    public void setEndReferenceLineModel(ReferenceLineModel newEnd) {
        ReferenceLineModel oldValue = this.endReferenceLineModel;
        this.endReferenceLineModel = newEnd;
        this.firePropertyChange("endReferenceLineModel", oldValue, this.endReferenceLineModel);
    }

    public ReferenceLineModel getEndReferenceLineModel() {
        return this.endReferenceLineModel;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ReferenceBandModel arg = (ReferenceBandModel)obj;
        return Util.Evaluate.isEqual(this.fillStyle, arg.fillStyle) && Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.beginReferenceLineModel, arg.beginReferenceLineModel) && Util.Evaluate.isEqual(this.endReferenceLineModel, arg.endReferenceLineModel) && Util.Evaluate.isEqual(this.label, arg.label) && Util.Evaluate.isEqual(this.textStyle, arg.textStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

