/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.PlotVariable;
import com.sas.graphics.components.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

@SASScope(value="ALL")
public class PlotVariableList
extends PlotVariable {
    private PlotVariableList next;

    public PlotVariableList(String columnName, String format, String informat, String label, PlotVariableList next) {
        super(columnName, format, informat, label);
        this.next = next;
    }

    public PlotVariableList(int columnIndex, String format, String informat, String label, PlotVariableList next) {
        super(columnIndex, format, informat, label);
        this.next = next;
    }

    public PlotVariableList(String[] columnNames) {
        super(columnNames != null && columnNames.length > 0 ? columnNames[0] : null);
        if (columnNames != null && columnNames.length > 1) {
            PlotVariableList nextVar = null;
            for (int ii = columnNames.length - 1; ii > 0; --ii) {
                nextVar = new PlotVariableList(columnNames[ii], null, null, null, nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    private PlotVariableList(PlotVariable variable, PlotVariableList nextVar) {
        super(variable);
        this.next = nextVar;
    }

    public PlotVariableList(PlotVariable[] variableArray) {
        super(variableArray != null && variableArray.length > 0 ? variableArray[0] : null);
        if (variableArray != null && variableArray.length > 1) {
            PlotVariableList nextVar = null;
            for (int ii = variableArray.length - 1; ii > 0; --ii) {
                nextVar = new PlotVariableList(variableArray[ii], nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    public PlotVariableList getNext() {
        return this.next;
    }

    public PlotVariable[] asArray() {
        PlotVariableList curr;
        int ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            ++ii;
        }
        PlotVariable[] array = new PlotVariable[ii];
        ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            array[ii++] = new PlotVariable(curr);
        }
        return array;
    }

    public ArrayList asArrayList() {
        PlotVariableList curr = this;
        ArrayList<PlotVariableList> list = new ArrayList<PlotVariableList>();
        do {
            list.add(curr);
        } while ((curr = curr.getNext()) != null);
        return list;
    }

    public Iterator iterator() {
        return new VariableListIterator(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PlotVariableList arg = (PlotVariableList)obj;
        return Util.Evaluate.isEqual(this.next, arg.next) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @SASScope
    private static class VariableListIterator
    implements Iterator {
        PlotVariableList prev = null;
        PlotVariableList curr = null;
        PlotVariableList next;

        public VariableListIterator(PlotVariableList ptr) {
            this.next = ptr;
        }

        public Object next() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.curr;
            this.curr = this.next;
            this.next = this.curr.getNext();
            return this.curr;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
        }
    }
}

