/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class NoteModel
extends ModelBase {
    private String text = null;
    private TextStyle textStyle = new AdvancedTextStyle();

    public void apply(NoteModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.text = theOtherObject.text;
        this.textStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.textStyle, this.textStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public NoteModel() {
        this(null, null);
    }

    public NoteModel(String newText) {
        this(newText, null);
    }

    public NoteModel(String newText, TextStyle newTextStyle) {
        this.text = newText;
        if (newTextStyle != null) {
            this.textStyle = newTextStyle;
        }
        this.setContainedModel("textStyle", this.textStyle);
    }

    public void setText(String newText) {
        String oldText = this.text;
        this.text = newText;
        this.firePropertyChange("text", oldText, newText);
    }

    public String getText() {
        return this.text;
    }

    public void setTextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.textStyle;
        this.textStyle = newTextStyle;
        this.firePropertyChange("textStyle", oldValue, newTextStyle);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        NoteModel arg = (NoteModel)obj;
        return Util.Evaluate.isEqual(this.text, arg.text) && Util.Evaluate.isEqual(this.textStyle, arg.textStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

