/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ContentsModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.util.Util;
import java.awt.SystemColor;
import java.util.LinkedHashMap;

@SASScope(value="ALL")
public class LegendModel
extends ContentsModel {
    private int labelPlacement = 10200;
    private int placement = 10200;
    private boolean drillIconVisible = false;
    private FillStyle backgroundFillStyle = new FillStyle(SystemColor.window);
    private ShadowStyle shadowStyle = new ShadowStyle();
    private LineStyle frameLineStyle = new LineStyle(SystemColor.windowBorder, null, 10201);
    private String[] values = null;
    private double minimum = Double.NaN;
    private double maximum = Double.NaN;
    private double baseline = 0.0;
    private boolean symmetricEnabled = false;
    private boolean isMilestoneMarkerPresent = false;
    private boolean isTargetMarkerPresent = false;
    private int milestoneMarkerIndex = -1;
    private int targetMarkerIndex = -1;
    private LinkedHashMap legendValuesIndexMap = new LinkedHashMap();
    private boolean isFirstTime = true;
    private int actualCOLOR_BYLegendSize = 0;
    private boolean isFirstTimeStringVectorCOLOR_BY = true;
    private boolean isFirstTimeColorVectorCOLOR_BY = true;

    public void apply(LegendModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherObject);
        this.labelPlacement = theOtherObject.labelPlacement;
        this.drillIconVisible = theOtherObject.drillIconVisible;
        this.placement = theOtherObject.placement;
        String[] stringArray = this.values = theOtherObject.values == null ? null : new String[theOtherObject.values.length];
        if (this.values != null) {
            System.arraycopy(theOtherObject.values, 0, this.values, 0, this.values.length);
        }
        this.minimum = theOtherObject.minimum;
        this.maximum = theOtherObject.maximum;
        this.baseline = theOtherObject.baseline;
        this.symmetricEnabled = theOtherObject.symmetricEnabled;
        this.backgroundFillStyle.apply(theOtherObject.backgroundFillStyle);
        this.shadowStyle.apply(theOtherObject.shadowStyle);
        this.frameLineStyle.apply(theOtherObject.frameLineStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public LegendModel() {
        this.setContainedModel("backgroundFillStyle", this.backgroundFillStyle);
        this.setContainedModel("shadowStyle", this.shadowStyle);
        this.setContainedModel("frameLineStyle", this.frameLineStyle);
    }

    public void setLabelPlacement(int newPlacement) throws IllegalArgumentException {
        switch (newPlacement) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 11301: 
            case 11302: 
            case 11303: 
            case 11304: 
            case 11305: 
            case 11311: 
            case 11312: 
            case 11313: 
            case 11314: 
            case 11315: 
            case 11316: 
            case 11317: 
            case 11318: 
            case 11319: 
        }
        int oldVal = this.labelPlacement;
        this.labelPlacement = newPlacement;
        this.firePropertyChange("LabelPlacement", oldVal, newPlacement);
    }

    public int getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setShadowStyle(ShadowStyle newShadow) throws IllegalArgumentException {
        if (newShadow == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ShadowStyle oldValue = this.shadowStyle;
        this.shadowStyle = newShadow;
        this.firePropertyChange("shadowStyle", oldValue, newShadow);
    }

    public ShadowStyle getShadowStyle() {
        return this.shadowStyle;
    }

    public void setCategories(String[] newValues) throws IllegalArgumentException {
        String[] oldValues = this.values;
        if (newValues != null) {
            int newValuesSize = newValues.length;
            if (newValuesSize < 1) {
                throw new IllegalArgumentException();
            }
            for (int ii = 0; ii < newValuesSize; ++ii) {
                if (newValues[ii] == null) {
                    throw new IllegalArgumentException();
                }
                for (int jj = 0; jj < ii; ++jj) {
                    if (!newValues[jj].equalsIgnoreCase(newValues[ii])) continue;
                    throw new IllegalArgumentException();
                }
            }
        }
        String[] stringArray = this.values = newValues == null ? null : new String[newValues.length];
        if (this.values != null) {
            System.arraycopy(newValues, 0, this.values, 0, this.values.length);
        }
        this.firePropertyChange("values", oldValues, this.values);
    }

    public void setLegendValues(String[] newValues) throws IllegalArgumentException {
        if (newValues != null) {
            int newValuesSize = newValues.length;
            if (newValuesSize < 1) {
                throw new IllegalArgumentException();
            }
            for (int ii = 0; ii < newValuesSize; ++ii) {
                if (newValues[ii] == null) {
                    throw new IllegalArgumentException();
                }
                for (int jj = 0; jj < ii; ++jj) {
                    if (!newValues[jj].equalsIgnoreCase(newValues[ii])) continue;
                    throw new IllegalArgumentException();
                }
            }
        }
        String[] stringArray = this.values = newValues == null ? null : new String[newValues.length];
        if (this.values != null) {
            System.arraycopy(newValues, 0, this.values, 0, this.values.length);
        }
    }

    public String[] getCategories() {
        return this.values;
    }

    public void setMilestoneMarkerFlag(boolean b) {
        this.isMilestoneMarkerPresent = b;
    }

    public void setTargetMarkerFlag(boolean b) {
        this.isTargetMarkerPresent = b;
    }

    public boolean getMilestoneMarkerFlag() {
        return this.isMilestoneMarkerPresent;
    }

    public boolean getTargetMarkerFlag() {
        return this.isTargetMarkerPresent;
    }

    public void setMilestoneMarkerIndex(int i) {
        this.milestoneMarkerIndex = i;
    }

    public void setTargetMarkerIndex(int i) {
        this.targetMarkerIndex = i;
    }

    public int getMilestoneMarkerIndex() {
        return this.milestoneMarkerIndex;
    }

    public int getTargetMarkerIndex() {
        return this.targetMarkerIndex;
    }

    public LinkedHashMap getLegendValuesIndexMap() {
        return this.legendValuesIndexMap;
    }

    public void setLegendValuesIndexMap(LinkedHashMap hm) {
        this.legendValuesIndexMap = hm;
    }

    public void addEntryToLegendValuesIndexMap(String keyStr, String valueStr) {
        if (keyStr != null && valueStr != null) {
            this.legendValuesIndexMap.put(keyStr, valueStr);
        }
    }

    public String getValueFromLegendValuesIndexMap(String keyStr) {
        if (keyStr != null) {
            String valueStr = (String)this.legendValuesIndexMap.get(keyStr);
            return valueStr;
        }
        return null;
    }

    public void setIsFirstTime(int i) {
        this.isFirstTime = i != 0;
    }

    public boolean getIsFirstTime() {
        return this.isFirstTime;
    }

    public int getActualCOLOR_BYLegendSize() {
        return this.actualCOLOR_BYLegendSize;
    }

    public void setActualCOLOR_BYLegendSize(int i) {
        this.actualCOLOR_BYLegendSize = i;
    }

    public boolean getFirstTimeStringVectorCOLOR_BY() {
        return this.isFirstTimeStringVectorCOLOR_BY;
    }

    public void setFirstTimeStringVectorCOLOR_BY(int i) {
        this.isFirstTimeStringVectorCOLOR_BY = i != 0;
    }

    public boolean getFirstTimeColorVectorCOLOR_BY() {
        return this.isFirstTimeColorVectorCOLOR_BY;
    }

    public void setFirstTimeColorVectorCOLOR_BY(int i) {
        this.isFirstTimeColorVectorCOLOR_BY = i != 0;
    }

    public void setBackgroundFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.backgroundFillStyle;
        this.backgroundFillStyle = newFillStyle;
        this.firePropertyChange("backgroundFillStyle", oldValue, newFillStyle);
    }

    public FillStyle getBackgroundFillStyle() {
        return this.backgroundFillStyle;
    }

    public void setPlacement(int newPlacement) {
        switch (newPlacement) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10200: 
        }
        int oldPlacement = this.placement;
        this.placement = newPlacement;
        this.firePropertyChange("placement", oldPlacement, newPlacement);
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setFrameLineStyle(LineStyle newFrameLineStyle) throws IllegalArgumentException {
        if (newFrameLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldFrameLineStyle = this.frameLineStyle;
        this.frameLineStyle = newFrameLineStyle;
        this.firePropertyChange("frameLineStyle", oldFrameLineStyle, newFrameLineStyle);
    }

    public LineStyle getFrameLineStyle() {
        return this.frameLineStyle;
    }

    public void setDrillIconVisible(boolean newVis) {
        boolean oldVis = this.drillIconVisible;
        this.drillIconVisible = newVis;
        this.firePropertyChange("drillIconVisible", oldVis, newVis);
    }

    public boolean isDrillIconVisible() {
        return this.drillIconVisible;
    }

    public void setMinimum(double minValue) {
        if (minValue == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (minValue == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldValue = this.minimum;
        this.minimum = minValue;
        this.firePropertyChange("minimum", oldValue, this.minimum);
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(double maxValue) {
        if (maxValue == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (maxValue == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldValue = this.maximum;
        this.maximum = maxValue;
        this.firePropertyChange("maximum", oldValue, this.maximum);
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setBaseline(double baselineValue) {
        if (baselineValue == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (baselineValue == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldValue = this.baseline;
        this.baseline = baselineValue;
        this.firePropertyChange("baseline", oldValue, this.baseline);
    }

    public double getBaseline() {
        return this.baseline;
    }

    public void setSymmetricEnabled(boolean symmetry) {
        boolean oldValue = this.symmetricEnabled;
        this.symmetricEnabled = symmetry;
        this.firePropertyChange("symmetricEnabled", oldValue, this.symmetricEnabled);
    }

    public boolean isSymmetricEnabled() {
        return this.symmetricEnabled;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LegendModel arg = (LegendModel)obj;
        return Util.Evaluate.isEqual(this.labelPlacement, arg.labelPlacement) && Util.Evaluate.isEqual(this.placement, arg.placement) && Util.Evaluate.isEqual(this.symmetricEnabled, arg.symmetricEnabled) && Util.Evaluate.isEqual(this.drillIconVisible, arg.drillIconVisible) && Util.Evaluate.isEqual(this.backgroundFillStyle, arg.backgroundFillStyle) && Util.Evaluate.isEqual(this.shadowStyle, arg.shadowStyle) && Util.Evaluate.isEqual(this.frameLineStyle, arg.frameLineStyle) && Util.Evaluate.isEqual(this.values, arg.values) && Util.Evaluate.isEqual(this.minimum, arg.minimum) && Util.Evaluate.isEqual(this.maximum, arg.maximum) && Util.Evaluate.isEqual(this.baseline, arg.baseline) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

