/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.TreeIconModel;
import com.sas.graphics.components.util.Util;
import java.util.HashMap;
import java.util.Set;

@SASScope(value="ALL")
public class HierarchyModel
extends ModelBase {
    private boolean showHierarchy = true;
    private HashMap valueTreeIconModel = null;
    private TreeIconModel treeIconModel = null;

    public void apply(HierarchyModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.showHierarchy = theOtherObject.showHierarchy;
        this.valueTreeIconModel = theOtherObject.valueTreeIconModel;
        this.treeIconModel = theOtherObject.treeIconModel;
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setEnabled(boolean newBoolean) {
        boolean oldHier = this.showHierarchy;
        this.showHierarchy = newBoolean;
        this.firePropertyChange("HierarchyEnabled", oldHier, newBoolean);
    }

    public boolean isEnabled() {
        return this.showHierarchy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        HierarchyModel arg = (HierarchyModel)obj;
        return Util.Evaluate.isEqual(this.showHierarchy, arg.showHierarchy) && Util.Evaluate.isEqual(this.valueTreeIconModel, arg.valueTreeIconModel) && Util.Evaluate.isEqual(this.treeIconModel, arg.treeIconModel) && super.equals(arg);
    }

    public void setTreeIconModel(TreeIconModel newTreeIconModel) {
        TreeIconModel old = this.treeIconModel;
        this.treeIconModel = newTreeIconModel;
        this.firePropertyChange("treeIconModel", old, newTreeIconModel);
    }

    public TreeIconModel getTreeIconModel() {
        return this.treeIconModel;
    }

    public void putTreeIconModel(Object key, TreeIconModel treeIconModel) {
        if (key instanceof String) {
            String taskName = (String)key;
            if (this.valueTreeIconModel == null) {
                this.valueTreeIconModel = new HashMap();
            }
            TreeIconModel old = (TreeIconModel)this.valueTreeIconModel.get(key);
            this.valueTreeIconModel.put(key, treeIconModel);
            this.firePropertyChange("valueTreeIconModel." + taskName, old, treeIconModel);
        }
    }

    public TreeIconModel getTreeIconModel(Object key) {
        TreeIconModel tim = null;
        if (this.valueTreeIconModel != null) {
            tim = (TreeIconModel)this.valueTreeIconModel.get(key);
        }
        return tim;
    }

    public void removeTreeIconModel(Object key) {
        if (key instanceof String && this.valueTreeIconModel != null && this.valueTreeIconModel.containsKey(key)) {
            String taskName = (String)key;
            Object oldIcon = this.valueTreeIconModel.get(key);
            this.valueTreeIconModel.remove(key);
            this.firePropertyChange("valueTreeIconModel." + taskName, oldIcon, null);
        }
    }

    public void clearTreeIconModel() {
        if (this.valueTreeIconModel != null && !this.valueTreeIconModel.isEmpty()) {
            this.valueTreeIconModel.clear();
            this.firePropertyChange("clearTreeIconModel", null, this.valueTreeIconModel);
        }
    }

    public Set keySetTreeIconModel() {
        if (this.valueTreeIconModel != null) {
            return this.valueTreeIconModel.keySet();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

