/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.DataElementColors;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TickStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.ShadowStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.Markers;
import com.sas.visuals.GraphResources;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Hashtable;
import javax.swing.ImageIcon;

@SASScope(value="ALL")
public class GraphStyle
extends ModelBase {
    public static final String RB_KEY = "GraphStyle.";
    private static final int _STYLE_ = 100000;
    public static final int STYLE_ANALYSIS = 100000;
    public static final int STYLE_ASTRONOMY = 100001;
    public static final int STYLE_BANKER = 100002;
    public static final int STYLE_BLOCKPRINT = 100003;
    public static final int STYLE_CONVENTION = 100004;
    public static final int STYLE_CURVE = 100005;
    public static final int STYLE_EDUCATION = 100006;
    public static final int STYLE_ELECTRONICS = 100007;
    public static final int STYLE_GEARS = 100008;
    public static final int STYLE_MAGNIFY = 100009;
    public static final int STYLE_MONEY = 100010;
    public static final int STYLE_MONOCHROME = 100011;
    public static final int STYLE_RSVP = 100012;
    public static final int STYLE_SCIENCE = 100013;
    public static final int STYLE_SKETCH = 100014;
    public static final int STYLE_STATISTICAL = 100015;
    public static final int STYLE_TORN = 100016;
    public static final int STYLE_WATERCOLOR = 100017;
    public static final int STYLE_OLAP = 100018;
    public static final int STYLE_GANTTCHART = 100019;
    public static final ConstantCollection STYLE = new ConstantCollection("GraphStyle.", new ConstantCollection.Element[]{new ConstantCollection.Element(100000, "STYLE_ANALYSIS", "Analysis"), new ConstantCollection.Element(100001, "STYLE_ASTRONOMY", "Astronomy"), new ConstantCollection.Element(100002, "STYLE_BANKER", "Banker"), new ConstantCollection.Element(100003, "STYLE_BLOCKPRINT", "Blockprint"), new ConstantCollection.Element(100004, "STYLE_CONVENTION", "Convention"), new ConstantCollection.Element(100005, "STYLE_CURVE", "Curve"), new ConstantCollection.Element(100006, "STYLE_EDUCATION", "Education"), new ConstantCollection.Element(100007, "STYLE_ELECTRONICS", "Electronics"), new ConstantCollection.Element(100019, "STYLE_GANTTCHART", "GanttChart"), new ConstantCollection.Element(100008, "STYLE_GEARS", "Gears"), new ConstantCollection.Element(100009, "STYLE_MAGNIFY", "Magnify"), new ConstantCollection.Element(100010, "STYLE_MONEY", "Money"), new ConstantCollection.Element(100011, "STYLE_MONOCHROME", "Monochrome"), new ConstantCollection.Element(100018, "STYLE_OLAP", "OLAP"), new ConstantCollection.Element(100012, "STYLE_RSVP", "RSVP"), new ConstantCollection.Element(100013, "STYLE_SCIENCE", "Science"), new ConstantCollection.Element(100014, "STYLE_SKETCH", "Sketch"), new ConstantCollection.Element(100015, "STYLE_STATISTICAL", "Statistical"), new ConstantCollection.Element(100016, "STYLE_TORN", "Torn"), new ConstantCollection.Element(100017, "STYLE_WATERCOLOR", "Watercolor")});
    private static final String[] DATA_CONTEXT_NAMES = new String[]{"GraphDataStyle1", "GraphDataStyle2", "GraphDataStyle3", "GraphDataStyle4", "GraphDataStyle5", "GraphDataStyle6", "GraphDataStyle7", "GraphDataStyle8", "GraphDataStyle9", "GraphDataStyle10", "GraphDataStyle11", "GraphDataStyle12"};
    private final int name;
    private boolean modified = false;
    private int appliedColorSchemeName;
    private TextStyle title1TextStyle = new TextStyle();
    private TextStyle title2TextStyle = new TextStyle();
    private TextStyle title3TextStyle = new TextStyle();
    private TextStyle title4TextStyle = new TextStyle();
    private TextStyle footnote1TextStyle = new TextStyle();
    private TextStyle footnote2TextStyle = new TextStyle();
    private final DataElementStyles dataElementStyles = new DataElementStyles();
    private FillStyle weekendBandFillStyle = new FillStyle();
    private FillStyle backgroundFillStyle = new FillStyle();
    private FillStyle wallFillStyle = new FillStyle();
    private FillStyle floorFillStyle = new FillStyle();
    private FillStyle legendBackgroundFillStyle = new FillStyle();
    private ShadowStyle legendShadowStyle = new ShadowStyle();
    private TextStyle labelTextStyle = new TextStyle();
    private TextStyle valueTextStyle = new TextStyle();
    private TextStyle dataLabelTextStyle = new TextStyle();
    private TextStyle dataTipTextStyle = new TextStyle();
    private Color dataTipBackgroundColor = SystemColor.window;
    private StrokeLineStyle axisLineStyle = new StrokeLineStyle();
    private StrokeLineStyle gridLineStyle = new StrokeLineStyle(30001, new Color(80, 80, 80), null);
    private TickStyle majorTickStyle = new TickStyle();
    private TickStyle minorTickStyle = new TickStyle();
    private LineStyle frameLineStyle = new LineStyle();
    private Color rowAxisLabelCellBackgroundColor = null;
    private Color rowAxisValueCellBackgroundColor = null;
    private Color columnAxisLabelCellBackgroundColor = null;
    private Color columnAxisValueCellBackgroundColor = null;
    private LineStyle columnRowAxisLabelCellFrameLineStyle = null;
    private LineStyle columnRowAxisValueCellFrameLineStyle = null;
    private int columnRowAxisValueShadingPolicy = 10200;
    private Color selectionColor = SystemColor.textHighlight;
    private Color selectionAccentColor = SystemColor.textHighlightText;
    private static Hashtable imageIconCache = null;

    public GraphStyle() {
        this(100004);
    }

    public GraphStyle(int newGraphStyleName) {
        switch (newGraphStyleName) {
            default: {
                this.name = this._buildConventionStyle();
                break;
            }
            case 100000: {
                this.name = this._buildAnalysisStyle();
                break;
            }
            case 100001: {
                this.name = this._buildAstronomyStyle();
                break;
            }
            case 100002: {
                this.name = this._buildBankerStyle();
                break;
            }
            case 100003: {
                this.name = this._buildBlockprintStyle();
                break;
            }
            case 100005: {
                this.name = this._buildCurveStyle();
                break;
            }
            case 100006: {
                this.name = this._buildEducationStyle();
                break;
            }
            case 100007: {
                this.name = this._buildElectronicsStyle();
                break;
            }
            case 100008: {
                this.name = this._buildGearsStyle();
                break;
            }
            case 100009: {
                this.name = this._buildMagnifyStyle();
                break;
            }
            case 100010: {
                this.name = this._buildMoneyStyle();
                break;
            }
            case 100012: {
                this.name = this._buildRSVPStyle();
                break;
            }
            case 100013: {
                this.name = this._buildScienceStyle();
                break;
            }
            case 100014: {
                this.name = this._buildSketchStyle();
                break;
            }
            case 100015: {
                this.name = this._buildStatisticalStyle();
                break;
            }
            case 100016: {
                this.name = this._buildTornStyle();
                break;
            }
            case 100017: {
                this.name = this._buildWatercolorStyle();
                break;
            }
            case 100011: {
                this.name = this._buildMonochromeStyle();
                break;
            }
            case 100018: {
                this.name = this._buildOLAPStyle();
                break;
            }
            case 100019: {
                this.name = this._buildGanttChartStyle();
            }
        }
        this.setContainedModel("title1TextStyle", this.title1TextStyle);
        this.setContainedModel("title2TextStyle", this.title2TextStyle);
        this.setContainedModel("title3TextStyle", this.title3TextStyle);
        this.setContainedModel("title4TextStyle", this.title4TextStyle);
        this.setContainedModel("footnote1TextStyle", this.footnote1TextStyle);
        this.setContainedModel("footnote2TextStyle", this.footnote2TextStyle);
        this.setContainedModel("dataElementStyles", this.dataElementStyles);
        this.setContainedModel("backgroundFillStyle", this.backgroundFillStyle);
        this.setContainedModel("wallFillStyle", this.wallFillStyle);
        this.setContainedModel("floorFillStyle", this.floorFillStyle);
        this.setContainedModel("legendBackgroundFillStyle", this.legendBackgroundFillStyle);
        this.setContainedModel("legendShadowStyle", this.legendShadowStyle);
        this.setContainedModel("labelTextStyle", this.labelTextStyle);
        this.setContainedModel("valueTextStyle", this.valueTextStyle);
        this.setContainedModel("dataLabelTextStyle", this.dataLabelTextStyle);
        this.setContainedModel("dataTipTextStyle", this.dataTipTextStyle);
        this.setContainedModel("axisLineStyle", this.axisLineStyle);
        this.setContainedModel("gridLineStyle", this.gridLineStyle);
        this.setContainedModel("majorTickStyle", this.majorTickStyle);
        this.setContainedModel("minorTickStyle", this.minorTickStyle);
        this.setContainedModel("frameLineStyle", this.frameLineStyle);
        this.setContainedModel("weekendBandFillStyle", this.weekendBandFillStyle);
        this.modified = false;
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldProperty, Object newProperty) {
        this.modified = true;
        super.firePropertyChange(propertyName, oldProperty, newProperty);
    }

    public String toString() {
        return STYLE.toName(this.name);
    }

    @Override
    protected void firePropertyChange(String propertyName, ModelBase oldProperty, ModelBase newProperty) {
        super.firePropertyChange(propertyName, oldProperty, newProperty);
    }

    public int getName() {
        return this.name;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setTitle1TextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.title1TextStyle;
        this.title1TextStyle = newTextStyle;
        this.firePropertyChange("title1TextStyle", oldValue, newTextStyle);
    }

    public TextStyle getTitle1TextStyle() {
        return this.title1TextStyle;
    }

    public void setTitle2TextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.title2TextStyle;
        this.title2TextStyle = newTextStyle;
        this.firePropertyChange("title2TextStyle", oldValue, newTextStyle);
    }

    public TextStyle getTitle2TextStyle() {
        return this.title2TextStyle;
    }

    public void setTitle3TextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.title3TextStyle;
        this.title3TextStyle = newTextStyle;
        this.firePropertyChange("title3TextStyle", oldValue, newTextStyle);
    }

    public TextStyle getTitle3TextStyle() {
        return this.title3TextStyle;
    }

    public void setTitle4TextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.title4TextStyle;
        this.title4TextStyle = newTextStyle;
        this.firePropertyChange("title4TextStyle", oldValue, newTextStyle);
    }

    public TextStyle getTitle4TextStyle() {
        return this.title4TextStyle;
    }

    public void setFootnote1TextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.footnote1TextStyle;
        this.footnote1TextStyle = newTextStyle;
        this.firePropertyChange("footnote1TextStyle", oldValue, newTextStyle);
    }

    public TextStyle getFootnote1TextStyle() {
        return this.footnote1TextStyle;
    }

    public void setFootnote2TextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.footnote2TextStyle;
        this.footnote2TextStyle = newTextStyle;
        this.firePropertyChange("footnote2TextStyle", oldValue, newTextStyle);
    }

    public TextStyle getFootnote2TextStyle() {
        return this.footnote2TextStyle;
    }

    public void setBackgroundFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.backgroundFillStyle;
        this.backgroundFillStyle = newFillStyle;
        this.firePropertyChange("backgroundFillStyle", oldValue, newFillStyle);
    }

    public FillStyle getBackgroundFillStyle() {
        return this.backgroundFillStyle;
    }

    public void setWallFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.wallFillStyle;
        this.wallFillStyle = newFillStyle;
        this.firePropertyChange("wallFillStyle", oldValue, newFillStyle);
    }

    public FillStyle getWallFillStyle() {
        return this.wallFillStyle;
    }

    public void setWeekendBandFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.weekendBandFillStyle;
        this.weekendBandFillStyle = newFillStyle;
        this.firePropertyChange("weekendBandFillStyle", oldValue, newFillStyle);
    }

    public FillStyle getWeekendBandFillStyle() {
        return this.weekendBandFillStyle;
    }

    public void setFloorFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.floorFillStyle;
        this.floorFillStyle = newFillStyle;
        this.firePropertyChange("floorFillStyle", oldValue, newFillStyle);
    }

    public FillStyle getFloorFillStyle() {
        return this.floorFillStyle;
    }

    public void setLegendBackgroundFillStyle(FillStyle newFillStyle) {
        FillStyle oldValue = this.legendBackgroundFillStyle;
        this.legendBackgroundFillStyle = newFillStyle;
        this.firePropertyChange("legendBackgroundFillStyle", oldValue, newFillStyle);
    }

    public FillStyle getLegendBackgroundFillStyle() {
        return this.legendBackgroundFillStyle;
    }

    public void setLegendShadowStyle(ShadowStyle newShadowStyle) {
        ShadowStyle oldValue = this.legendShadowStyle;
        this.legendShadowStyle = newShadowStyle;
        this.firePropertyChange("legendShadowStyle", oldValue, this.legendShadowStyle);
    }

    public ShadowStyle getLegendShadowStyle() {
        return this.legendShadowStyle;
    }

    public void setLabelTextStyle(TextStyle newTextStyle) {
        TextStyle oldValue = this.labelTextStyle;
        this.labelTextStyle = newTextStyle;
        this.firePropertyChange("labelTextStyle", oldValue, newTextStyle);
    }

    public TextStyle getLabelTextStyle() {
        return this.labelTextStyle;
    }

    public void setValueTextStyle(TextStyle newTextStyle) {
        TextStyle oldValue = this.valueTextStyle;
        this.valueTextStyle = newTextStyle;
        this.firePropertyChange("valueTextStyle", oldValue, newTextStyle);
    }

    public TextStyle getValueTextStyle() {
        return this.valueTextStyle;
    }

    public void setDataLabelTextStyle(TextStyle newTextStyle) {
        TextStyle oldValue = this.dataLabelTextStyle;
        this.dataLabelTextStyle = newTextStyle;
        this.firePropertyChange("dataLabelTextStyle", oldValue, newTextStyle);
    }

    public TextStyle getDataLabelTextStyle() {
        return this.dataLabelTextStyle;
    }

    public void setDataTipTextStyle(TextStyle newTextStyle) {
        TextStyle oldValue = this.dataTipTextStyle;
        this.dataTipTextStyle = newTextStyle;
        this.firePropertyChange("dataTipTextStyle", oldValue, newTextStyle);
    }

    public TextStyle getDataTipTextStyle() {
        return this.dataTipTextStyle;
    }

    public void setDataTipBackgroundColor(Color newColor) {
        Color oldValue = this.dataTipBackgroundColor;
        this.dataTipBackgroundColor = newColor;
        this.firePropertyChange("dataTipBackgroundColor", oldValue, this.dataTipBackgroundColor);
    }

    public Color getDataTipBackgroundColor() {
        return this.dataTipBackgroundColor;
    }

    @SASScope
    public void setRowAxisLabelCellBackgroundColor(Color newColor) {
        Color oldColor = this.rowAxisLabelCellBackgroundColor;
        this.rowAxisLabelCellBackgroundColor = newColor;
        this.firePropertyChange("rowAxisLabelCellBackgroundColor", oldColor, this.rowAxisLabelCellBackgroundColor);
    }

    @SASScope
    public Color getRowAxisLabelCellBackgroundColor() {
        return this.rowAxisLabelCellBackgroundColor;
    }

    @SASScope
    public void setColumnAxisLabelCellBackgroundColor(Color newColor) {
        Color oldColor = this.columnAxisLabelCellBackgroundColor;
        this.columnAxisLabelCellBackgroundColor = newColor;
        this.firePropertyChange("columnAxisLabelCellBackgroundColor", oldColor, this.columnAxisLabelCellBackgroundColor);
    }

    @SASScope
    public Color getColumnAxisLabelCellBackgroundColor() {
        return this.columnAxisLabelCellBackgroundColor;
    }

    public void setRowAxisValueCellBackgroundColor(Color newColor) {
        Color oldColor = this.rowAxisValueCellBackgroundColor;
        this.rowAxisValueCellBackgroundColor = newColor;
        this.firePropertyChange("rowAxisValueCellBackgroundColor", oldColor, this.rowAxisValueCellBackgroundColor);
    }

    public Color getRowAxisValueCellBackgroundColor() {
        return this.rowAxisValueCellBackgroundColor;
    }

    public void setColumnAxisValueCellBackgroundColor(Color newColor) {
        Color oldColor = this.columnAxisValueCellBackgroundColor;
        this.columnAxisValueCellBackgroundColor = newColor;
        this.firePropertyChange("columnAxisValueCellBackgroundColor", oldColor, this.columnAxisValueCellBackgroundColor);
    }

    public Color getColumnAxisValueCellBackgroundColor() {
        return this.columnAxisValueCellBackgroundColor;
    }

    @SASScope
    public void setColumnRowAxisLabelCellFrameLineStyle(LineStyle newFrameLineStyle) {
        LineStyle oldFrameLineStyle = this.columnRowAxisLabelCellFrameLineStyle;
        this.columnRowAxisLabelCellFrameLineStyle = newFrameLineStyle;
        this.firePropertyChange("columnRowAxisLabelCellFrameLineStyle", oldFrameLineStyle, this.columnRowAxisLabelCellFrameLineStyle);
    }

    @SASScope
    public LineStyle getColumnRowAxisLabelCellFrameLineStyle() {
        return this.columnRowAxisLabelCellFrameLineStyle;
    }

    @SASScope
    public void setColumnRowAxisValueCellFrameLineStyle(LineStyle newFrameLineStyle) {
        LineStyle oldFrameLineStyle = this.columnRowAxisValueCellFrameLineStyle;
        this.columnRowAxisValueCellFrameLineStyle = newFrameLineStyle;
        this.firePropertyChange("columnRowAxisValueCellFrameLineStyle", oldFrameLineStyle, this.columnRowAxisValueCellFrameLineStyle);
    }

    @SASScope
    public LineStyle getColumnRowAxisValueCellFrameLineStyle() {
        return this.columnRowAxisValueCellFrameLineStyle;
    }

    public void setAxisLineStyle(StrokeLineStyle newLineStyle) {
        StrokeLineStyle oldValue = this.axisLineStyle;
        this.axisLineStyle = newLineStyle;
        this.firePropertyChange("axisLineStyle", oldValue, newLineStyle);
    }

    public StrokeLineStyle getAxisLineStyle() {
        return this.axisLineStyle;
    }

    public void setGridLineStyle(StrokeLineStyle newLineStyle) {
        StrokeLineStyle oldValue = this.gridLineStyle;
        this.gridLineStyle = newLineStyle;
        this.firePropertyChange("gridLineStyle", oldValue, newLineStyle);
    }

    public StrokeLineStyle getGridLineStyle() {
        return this.gridLineStyle;
    }

    public void setMajorTickStyle(TickStyle newTickStyle) {
        TickStyle oldValue = this.majorTickStyle;
        this.majorTickStyle = newTickStyle;
        this.firePropertyChange("majorTickStyle", oldValue, newTickStyle);
    }

    public TickStyle getMajorTickStyle() {
        return this.majorTickStyle;
    }

    public void setMinorTickStyle(TickStyle newTickStyle) {
        TickStyle oldValue = this.minorTickStyle;
        this.minorTickStyle = newTickStyle;
        this.firePropertyChange("minorTickStyle", oldValue, newTickStyle);
    }

    public TickStyle getMinorTickStyle() {
        return this.minorTickStyle;
    }

    public DataElementStyles getDataElementStyles() {
        return this.dataElementStyles;
    }

    public void setSelectionColor(Color newSelectionColor) throws IllegalArgumentException {
        Color oldValue = this.selectionColor;
        this.selectionColor = newSelectionColor;
        this.firePropertyChange("selectionColor", oldValue, this.selectionColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionAccentColor(Color neweSelectionAccentColor) throws IllegalArgumentException {
        Color oldValue = this.selectionAccentColor;
        this.selectionAccentColor = neweSelectionAccentColor;
        this.firePropertyChange("selectionAccentColor", oldValue, this.selectionAccentColor);
    }

    public Color getSelectionAccentColor() {
        return this.selectionAccentColor;
    }

    public void setFrameLineStyle(LineStyle newFrameLineStyle) {
        LineStyle oldFrameLineStyle = this.frameLineStyle;
        this.frameLineStyle = newFrameLineStyle;
        this.firePropertyChange("frameLineStyle", oldFrameLineStyle, newFrameLineStyle);
    }

    public LineStyle getFrameLineStyle() {
        return this.frameLineStyle;
    }

    public void setRowAxisBackgroundColor(Color newColor) {
        this.setRowAxisValueCellBackgroundColor(newColor);
    }

    public Color getRowAxisBackgroundColor() {
        return this.getRowAxisValueCellBackgroundColor();
    }

    public void setColumnAxisBackgroundColor(Color newColor) {
        this.setColumnAxisValueCellBackgroundColor(newColor);
    }

    public Color getColumnAxisBackgroundColor() {
        return this.getColumnAxisValueCellBackgroundColor();
    }

    public void setColumnRowAxisValueShadingPolicy(int newShadingPolicy) {
        GraphConstants.TRI.validate(newShadingPolicy);
        int oldShadingPolicy = this.columnRowAxisValueShadingPolicy;
        this.columnRowAxisValueShadingPolicy = newShadingPolicy;
        this.firePropertyChange("columnRowAxisValueShadingPolicy", oldShadingPolicy, this.columnRowAxisValueShadingPolicy);
    }

    public int getColumnRowAxisValueShadingPolicy() {
        return this.columnRowAxisValueShadingPolicy;
    }

    public void applyTextShadowStyle(ShadowStyle newShadowStyle) {
        if (newShadowStyle != null) {
            this.title1TextStyle.getShadowStyle().apply(newShadowStyle);
            this.title2TextStyle.getShadowStyle().apply(newShadowStyle);
            this.title3TextStyle.getShadowStyle().apply(newShadowStyle);
            this.title4TextStyle.getShadowStyle().apply(newShadowStyle);
            this.footnote1TextStyle.getShadowStyle().apply(newShadowStyle);
            this.footnote2TextStyle.getShadowStyle().apply(newShadowStyle);
            if (this.labelTextStyle != null) {
                this.labelTextStyle.getShadowStyle().apply(newShadowStyle);
            }
            if (this.valueTextStyle != null) {
                this.valueTextStyle.getShadowStyle().apply(newShadowStyle);
            }
            if (this.dataLabelTextStyle != null) {
                this.dataLabelTextStyle.getShadowStyle().apply(newShadowStyle);
            }
            this.firePropertyChange("", null, this);
        }
    }

    public ShadowStyle asTextShadowStyle() {
        ShadowStyle ss = this.title1TextStyle.getShadowStyle();
        if (Util.Evaluate.isEqual(ss, this.title2TextStyle.getShadowStyle()) && Util.Evaluate.isEqual(ss, this.title3TextStyle.getShadowStyle()) && Util.Evaluate.isEqual(ss, this.title4TextStyle.getShadowStyle()) && Util.Evaluate.isEqual(ss, this.footnote1TextStyle.getShadowStyle()) && Util.Evaluate.isEqual(ss, this.footnote2TextStyle.getShadowStyle()) && (this.labelTextStyle == null || Util.Evaluate.isEqual(ss, this.labelTextStyle.getShadowStyle())) && (this.valueTextStyle == null || Util.Evaluate.isEqual(ss, this.valueTextStyle.getShadowStyle())) && (this.dataLabelTextStyle == null || Util.Evaluate.isEqual(ss, this.dataLabelTextStyle.getShadowStyle()))) {
            return ss;
        }
        return null;
    }

    private int _buildConventionStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Convention"), 101012);
        return 100004;
    }

    private int _buildAnalysisStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Analysis"), 101017);
        return 100000;
    }

    private int _buildAstronomyStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Astronomy"), 101005);
        return 100001;
    }

    private int _buildBankerStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Banker"), 101001);
        return 100002;
    }

    private int _buildBlockprintStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Blockprint"), 101013);
        return 100003;
    }

    private int _buildCurveStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Curve"), 101014);
        return 100005;
    }

    private int _buildEducationStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Education"), 101010);
        return 100006;
    }

    private int _buildElectronicsStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Electronics"), 101000);
        return 100007;
    }

    private int _buildGearsStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Gears"), 101011);
        return 100008;
    }

    private int _buildMagnifyStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Magnify"), 101003);
        return 100009;
    }

    private int _buildMoneyStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Money"), 101005);
        return 100010;
    }

    private int _buildRSVPStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"RSVP"), 101002);
        return 100012;
    }

    private int _buildScienceStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Science"), 101008);
        return 100013;
    }

    private int _buildSketchStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Sketch"), 101007);
        return 100014;
    }

    private int _buildStatisticalStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Statistical"), 101016);
        return 100015;
    }

    private int _buildTornStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Torn"), 101009);
        return 100016;
    }

    private int _buildWatercolorStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Watercolor"), 101007);
        return 100017;
    }

    private int _buildMonochromeStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Journal"), 101004);
        return 100011;
    }

    private int _buildGanttChartStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"Gantt"), 101015);
        int size = this.dataElementStyles.getMarkerStyles().length;
        for (int ii = 0; ii < size; ++ii) {
            this.dataElementStyles.getMarkerStyles()[ii].setSymbol(Markers.SET_OR_FILLED[ii % Markers.SET_OR_FILLED.length]);
        }
        return 100019;
    }

    private int _buildOLAPStyle() {
        this._applyCommonGraphStyleObject(PredefinedStyles.getPredefinedStyle((String)"EGDefault"), 101011);
        return 100018;
    }

    private static ImageIcon _newImageIcon(String fileName) {
        ImageIcon imageIcon = null;
        try {
            if (imageIconCache != null) {
                imageIcon = (ImageIcon)imageIconCache.get(fileName);
            }
            if (imageIcon == null) {
                imageIcon = new ImageIcon(GraphResources.getImage((String)fileName), fileName);
                if (imageIconCache == null) {
                    imageIconCache = new Hashtable();
                }
                imageIconCache.put(fileName, imageIcon);
            }
        }
        catch (Exception e) {
            System.err.println(RB.getStringResource("imageLoadFailed.ex.txt"));
        }
        return imageIcon;
    }

    public void applyColorScheme(ColorScheme cs) {
        this._applyColorScheme(cs);
        this.firePropertyChange("", null, this);
    }

    private void _applyColorScheme(ColorScheme cs) {
        LineStyle fls;
        Color cbc;
        this.disablePropertyChange();
        this.appliedColorSchemeName = cs.getName();
        if (cs.getSelectionColor() != null) {
            this.selectionColor = cs.getSelectionColor();
        }
        if (cs.getSelectionAccentColor() != null) {
            this.selectionAccentColor = cs.getSelectionAccentColor();
        }
        if (cs.getFrameColor() != null && this.frameLineStyle != null) {
            this.frameLineStyle.setColor(cs.getFrameColor());
        }
        if (cs.getBackgroundColor() != null) {
            this.backgroundFillStyle.setSolidFillColor(cs.getBackgroundColor());
        }
        if (cs.getWallColor() != null && this.wallFillStyle != null) {
            this.wallFillStyle.setSolidFillColor(cs.getWallColor());
        }
        if (cs.getFloorColor() != null) {
            this.floorFillStyle.setSolidFillColor(cs.getFloorColor());
        }
        if (cs.getLegendBackgroundColor() != null && this.legendBackgroundFillStyle != null) {
            this.legendBackgroundFillStyle.setSolidFillColor(cs.getLegendBackgroundColor());
        }
        if (cs.getShadowColor() != null && this.legendShadowStyle != null) {
            this.legendShadowStyle.setColor(cs.getShadowColor());
        }
        if (cs.getAxisLineColor() != null && this.axisLineStyle != null) {
            this.axisLineStyle.setColor(cs.getAxisLineColor());
        }
        if (cs.getGridLineColor() != null && this.gridLineStyle != null) {
            this.gridLineStyle.setColor(cs.getGridLineColor());
        }
        if (cs.getMajorTickColor() != null && this.majorTickStyle != null) {
            this.majorTickStyle.getLineStyle().setColor(cs.getMajorTickColor());
        }
        if (cs.getMinorTickColor() != null && this.minorTickStyle != null) {
            this.minorTickStyle.getLineStyle().setColor(cs.getMinorTickColor());
        }
        if (this.labelTextStyle != null) {
            if (cs.getShadowColor() != null) {
                this.labelTextStyle.getShadowStyle().setColor(cs.getShadowColor());
            }
            if (cs.getLabelColor() != null) {
                this.labelTextStyle.setColor(cs.getLabelColor());
            }
        }
        if (this.valueTextStyle != null) {
            if (cs.getShadowColor() != null) {
                this.valueTextStyle.getShadowStyle().setColor(cs.getShadowColor());
            }
            if (cs.getValueColor() != null) {
                this.valueTextStyle.setColor(cs.getValueColor());
            }
        }
        if (this.dataLabelTextStyle != null) {
            if (cs.getShadowColor() != null) {
                this.dataLabelTextStyle.getShadowStyle().setColor(cs.getShadowColor());
            }
            if (cs.getDataLabelColor() != null) {
                this.dataLabelTextStyle.setColor(cs.getDataLabelColor());
            }
        }
        if (this.dataTipTextStyle != null && cs.getDataTipColor() != null) {
            this.dataTipTextStyle.setColor(cs.getDataTipColor());
        }
        if (cs.getTitleFootnoteColor() != null) {
            this.title1TextStyle.setColor(cs.getTitleFootnoteColor());
            this.title2TextStyle.setColor(cs.getTitleFootnoteColor());
            this.title3TextStyle.setColor(cs.getTitleFootnoteColor());
            this.title4TextStyle.setColor(cs.getTitleFootnoteColor());
            this.footnote1TextStyle.setColor(cs.getTitleFootnoteColor());
            this.footnote2TextStyle.setColor(cs.getTitleFootnoteColor());
        }
        if (cs.getShadowColor() != null) {
            this.title1TextStyle.getShadowStyle().setColor(cs.getShadowColor());
            this.title2TextStyle.getShadowStyle().setColor(cs.getShadowColor());
            this.title3TextStyle.getShadowStyle().setColor(cs.getShadowColor());
            this.title4TextStyle.getShadowStyle().setColor(cs.getShadowColor());
            this.footnote1TextStyle.getShadowStyle().setColor(cs.getShadowColor());
            this.footnote2TextStyle.getShadowStyle().setColor(cs.getShadowColor());
        }
        Color lbc = cs.getLegendBackgroundColor();
        if (this.rowAxisLabelCellBackgroundColor != null) {
            cbc = cs.getRowAxisLabelCellBackgroundColor();
            if (cbc != null) {
                this.rowAxisLabelCellBackgroundColor = cbc;
            } else if (lbc != null) {
                this.rowAxisLabelCellBackgroundColor = lbc;
            }
        } else if (cs.getRowAxisLabelCellBackgroundColor() != null) {
            this.rowAxisLabelCellBackgroundColor = cs.getRowAxisLabelCellBackgroundColor();
        }
        if (this.rowAxisValueCellBackgroundColor != null) {
            cbc = cs.getRowAxisValueCellBackgroundColor();
            if (cbc != null) {
                this.rowAxisValueCellBackgroundColor = cbc;
            } else if (lbc != null) {
                this.rowAxisValueCellBackgroundColor = lbc;
            }
        } else if (cs.getRowAxisValueCellBackgroundColor() != null) {
            this.rowAxisValueCellBackgroundColor = cs.getRowAxisValueCellBackgroundColor();
        }
        if (this.columnAxisLabelCellBackgroundColor != null) {
            cbc = cs.getColumnAxisLabelCellBackgroundColor();
            if (cbc != null) {
                this.columnAxisLabelCellBackgroundColor = cbc;
            } else if (lbc != null) {
                this.columnAxisLabelCellBackgroundColor = lbc;
            }
        } else if (cs.getColumnAxisLabelCellBackgroundColor() != null) {
            this.columnAxisLabelCellBackgroundColor = cs.getColumnAxisLabelCellBackgroundColor();
        }
        if (this.columnAxisValueCellBackgroundColor != null) {
            cbc = cs.getColumnAxisValueCellBackgroundColor();
            if (cbc != null) {
                this.columnAxisValueCellBackgroundColor = cbc;
            } else if (lbc != null) {
                this.columnAxisValueCellBackgroundColor = lbc;
            }
        } else if (cs.getColumnAxisValueCellBackgroundColor() != null) {
            this.columnAxisValueCellBackgroundColor = cs.getColumnAxisValueCellBackgroundColor();
        }
        if (cs.getColumnRowAxisLabelCellFrameColor() != null) {
            fls = this.columnRowAxisLabelCellFrameLineStyle;
            if (fls == null) {
                fls = new LineStyle();
            }
            fls.setColor(cs.getColumnRowAxisLabelCellFrameColor());
            this.setColumnRowAxisLabelCellFrameLineStyle(fls);
        }
        if (cs.getColumnRowAxisValueCellFrameColor() != null) {
            fls = this.columnRowAxisValueCellFrameLineStyle;
            if (fls == null) {
                fls = new LineStyle();
            }
            fls.setColor(cs.getColumnRowAxisValueCellFrameColor());
            this.setColumnRowAxisValueCellFrameLineStyle(fls);
        }
        if (cs.getWeekendBandColor() != null && this.getWeekendBandFillStyle() != null) {
            this.getWeekendBandFillStyle().setSolidFillColor(cs.getWeekendBandColor());
        }
        this.dataElementStyles.applyDataElementColors(cs.getDataElementColors());
        this.enablePropertyChange();
    }

    private void _applyCommonGraphStyleObject(Style style, int colorSchemeName) {
        int ii;
        this.disablePropertyChange();
        style.setFallbackEnabled(true);
        GraphStyle._applyStrokeLineStyleElement(this.axisLineStyle, style.getLineStyleElement("AxisLines"));
        GraphStyle._applyLineStyleElement(this.frameLineStyle, style.getLineStyleElement("BorderLines"));
        ShadowStyleElement shadow = style.getShadowStyleElement("DropShadow");
        GraphStyle._applyTextStyleElement(this.title1TextStyle, style.getTextStyleElement("TitleText"), shadow);
        GraphStyle._applyTextStyleElement(this.title2TextStyle, style.getTextStyleElement("TitleText"), shadow);
        GraphStyle._applyTextStyleElement(this.title3TextStyle, style.getTextStyleElement("TitleText"), shadow);
        GraphStyle._applyTextStyleElement(this.title4TextStyle, style.getTextStyleElement("TitleText"), shadow);
        GraphStyle._applyTextStyleElement(this.labelTextStyle, style.getTextStyleElement("LabelText"), shadow);
        GraphStyle._applyTextStyleElement(this.valueTextStyle, style.getTextStyleElement("ValueText"), shadow);
        GraphStyle._applyTextStyleElement(this.footnote1TextStyle, style.getTextStyleElement("FootnoteText"), shadow);
        GraphStyle._applyTextStyleElement(this.footnote2TextStyle, style.getTextStyleElement("FootnoteText"), shadow);
        GraphStyle._applyTextStyleElement(this.dataLabelTextStyle, style.getTextStyleElement("DataText"), shadow);
        FillStyle[] fills = this.dataElementStyles.getFillStyles();
        if (fills.length != DATA_CONTEXT_NAMES.length) {
            fills = GraphStyle._newFillStyleArray(DATA_CONTEXT_NAMES.length);
        }
        block11: for (ii = 0; ii < DATA_CONTEXT_NAMES.length; ++ii) {
            GraphStyle._applyFillStyleElement(fills[ii], style.getFillStyleElement(DATA_CONTEXT_NAMES[ii]));
            switch (ii) {
                case 0: {
                    this.dataElementStyles.getNormalFillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 1: {
                    this.dataElementStyles.getSlackFillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 2: {
                    this.dataElementStyles.getCriticalFillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 3: {
                    this.dataElementStyles.getActualFillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 4: {
                    this.dataElementStyles.getResourceFillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 5: {
                    this.dataElementStyles.getBaselineFillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 6: {
                    this.dataElementStyles.getCustomSchedule1FillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 7: {
                    this.dataElementStyles.getCustomSchedule2FillStyle().apply(fills[ii]);
                    continue block11;
                }
                case 8: {
                    this.dataElementStyles.getBreakTimeFillStyle().apply(fills[ii]);
                }
            }
        }
        this.dataElementStyles.setFillStyles(fills);
        StrokeLineStyle[] lines = this.dataElementStyles.getLineStyles();
        if (lines.length != DATA_CONTEXT_NAMES.length) {
            lines = GraphStyle._newStrokeLineStyleArray(DATA_CONTEXT_NAMES.length);
        }
        for (ii = 0; ii < DATA_CONTEXT_NAMES.length; ++ii) {
            GraphStyle._applyStrokeLineStyleElement(lines[ii], style.getLineStyleElement(DATA_CONTEXT_NAMES[ii]));
        }
        this.dataElementStyles.setLineStyles(lines);
        MarkerStyle[] markers = this.dataElementStyles.getMarkerStyles();
        if (markers.length != DATA_CONTEXT_NAMES.length) {
            markers = GraphStyle._newMarkerStyleArray(DATA_CONTEXT_NAMES.length);
        }
        for (ii = 0; ii < DATA_CONTEXT_NAMES.length; ++ii) {
            GraphStyle._applyMarkerStyleElement(markers[ii], style.getMarkerStyleElement(DATA_CONTEXT_NAMES[ii]));
        }
        this.dataElementStyles.setMarkerStyles(markers);
        GraphStyle._applyStrokeLineStyleElement(this.gridLineStyle, style.getLineStyleElement("GridLines"));
        GraphStyle._applyFillStyleElement(this.floorFillStyle, style.getFillStyleElement("FloorFill"));
        GraphStyle._applyFillStyleElement(this.wallFillStyle, style.getFillStyleElement("WallFill"));
        GraphStyle._applyFillStyleElement(this.legendBackgroundFillStyle, style.getFillStyleElement("LegendFill"));
        this.legendShadowStyle.setVisible(false);
        this.appliedColorSchemeName = colorSchemeName;
        this._applyCommonGraphStyleColors(style);
        GraphStyle._applyFillStyleElement(this.backgroundFillStyle, style.getFillStyleElement("Backfill"));
        this.enablePropertyChange();
    }

    private static FillStyle[] _newFillStyleArray(int len) {
        FillStyle[] a = null;
        if (len > 0) {
            a = new FillStyle[len];
            for (int ii = 0; ii < a.length; ++ii) {
                a[ii] = new FillStyle();
            }
        }
        return a;
    }

    private static StrokeLineStyle[] _newStrokeLineStyleArray(int len) {
        StrokeLineStyle[] a = null;
        if (len > 0) {
            a = new StrokeLineStyle[len];
            for (int ii = 0; ii < a.length; ++ii) {
                a[ii] = new StrokeLineStyle();
            }
        }
        return a;
    }

    private static MarkerStyle[] _newMarkerStyleArray(int len) {
        MarkerStyle[] a = null;
        if (len > 0) {
            a = new MarkerStyle[len];
            for (int ii = 0; ii < a.length; ++ii) {
                a[ii] = new MarkerStyle();
            }
        }
        return a;
    }

    private void _applyCommonGraphStyleColors(Style style) {
        FillStyleElement fse = null;
        LineStyleElement lse = null;
        LineStyleElement frameLSE = null;
        ShadowStyleElement shadow = null;
        RampStyleElement rse = null;
        MarkerStyleElement mse = null;
        fse = style.getFillStyleElement("Selection");
        if (fse != null) {
            this.selectionColor = fse.applyElementTransparency(fse.getFillColor());
        }
        if ((fse = style.getFillStyleElement("GraphWeekend")) != null) {
            this.weekendBandFillStyle.setSolidFillColor(fse.getFillColor());
        }
        if ((lse = style.getLineStyleElement("Selection")) != null) {
            this.selectionAccentColor = lse.applyElementTransparency(lse.getLineColor());
        }
        if ((shadow = style.getShadowStyleElement("DropShadow")) != null && this.legendShadowStyle != null) {
            this.legendShadowStyle.setColor(shadow.applyElementTransparency(shadow.getShadowColor()));
        }
        if ((lse = style.getLineStyleElement("AxisLines")) != null) {
            if (this.majorTickStyle != null) {
                this.majorTickStyle.getLineStyle().setColor(lse.applyElementTransparency(lse.getLineColor()));
            }
            if (this.minorTickStyle != null) {
                this.minorTickStyle.getLineStyle().setColor(lse.applyElementTransparency(lse.getLineColor()));
            }
        }
        fse = style.getFillStyleElement("GraphRowColumnAxisCellFill");
        Color lbc = fse.getFillColor();
        fse.applyElementTransparency(lbc);
        this.rowAxisLabelCellBackgroundColor = lbc;
        this.rowAxisValueCellBackgroundColor = lbc;
        this.columnAxisLabelCellBackgroundColor = lbc;
        this.columnAxisValueCellBackgroundColor = lbc;
        frameLSE = style.getLineStyleElement("BorderLines");
        LineStyle ls = null;
        if (frameLSE != null) {
            ls = this.getColumnRowAxisLabelCellFrameLineStyle();
            if (ls == null) {
                ls = new LineStyle();
            }
            ls.setColor(lse.applyElementTransparency(frameLSE.getLineColor()));
            this.columnRowAxisLabelCellFrameLineStyle = ls;
            ls = this.getColumnRowAxisValueCellFrameLineStyle();
            if (ls == null) {
                ls = new LineStyle();
            }
            ls.setColor(lse.applyElementTransparency(frameLSE.getLineColor()));
            this.columnRowAxisValueCellFrameLineStyle = ls;
        }
        rse = style.getRampStyleElement("TwoColorRamp");
        this.dataElementStyles.setContinuousFillTwoColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        this.dataElementStyles.setContinuousFillTwoColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        rse = style.getRampStyleElement("ThreeColorRamp");
        this.dataElementStyles.setContinuousFillThreeColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        this.dataElementStyles.setContinuousFillThreeColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        this.dataElementStyles.setContinuousFillThreeColorNeutralColor(rse.applyElementTransparency(rse.getNeutralColor()));
        rse = style.getRampStyleElement("TwoColorAltRamp");
        this.dataElementStyles.setContinuousContrastTwoColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        this.dataElementStyles.setContinuousContrastTwoColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        rse = style.getRampStyleElement("ThreeColorAltRamp");
        this.dataElementStyles.setContinuousContrastThreeColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        this.dataElementStyles.setContinuousContrastThreeColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        this.dataElementStyles.setContinuousContrastThreeColorNeutralColor(rse.applyElementTransparency(rse.getNeutralColor()));
        ColorPosition[] continuousColorSpectrum = new ColorPosition[]{new ColorPosition(this.dataElementStyles.getContinuousFillThreeColorStartColor(), 0.0), new ColorPosition(this.dataElementStyles.getContinuousFillThreeColorNeutralColor(), 0.5), new ColorPosition(this.dataElementStyles.getContinuousFillThreeColorEndColor(), 1.0)};
        this.dataElementStyles.setContinuousColorSpectrum(continuousColorSpectrum);
        FillStyle[] errorFillStyles = this.dataElementStyles.getErrorFillStyles();
        fse = style.getFillStyleElement("Error");
        for (int j = 0; j < errorFillStyles.length; ++j) {
            errorFillStyles[j].setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        }
        MarkerStyle[] errorMarkerStyles = this.dataElementStyles.getErrorMarkerStyles();
        mse = style.getMarkerStyleElement("Error");
        for (int j = 0; j < errorMarkerStyles.length; ++j) {
            errorMarkerStyles[j].setColor(fse.applyElementTransparency(mse.getMarkerColor()));
        }
        StrokeLineStyle[] errorLineStyles = this.dataElementStyles.getErrorLineStyles();
        lse = style.getLineStyleElement("Error");
        for (int j = 0; j < errorLineStyles.length; ++j) {
            errorLineStyles[j].setColor(fse.applyElementTransparency(lse.getLineColor()));
        }
        this.dataElementStyles.setDiscreteFillColors(style.getDataFillColors());
        lse = style.getLineStyleElement("Outlines");
        this.dataElementStyles.getOutlineLineStyle().setColor(lse.applyElementTransparency(lse.getLineColor()));
        lse = style.getLineStyleElement("ConnectLine");
        this.dataElementStyles.getConnectingLineStyle().setColor(lse.getLineColor());
        fse = style.getFillStyleElement("GraphDataStyleOther");
        this.dataElementStyles.getOtherFillStyle().setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        fse = style.getFillStyleElement("Missing");
        this.dataElementStyles.getMissingFillStyle().setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        fse = style.getFillStyleElement("OutOfRange");
        this.dataElementStyles.getOutOfRangeFillStyle().setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        fse = style.getFillStyleElement("UpperThreshold");
        this.dataElementStyles.getUpperThresholdFillStyle().setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        fse = style.getFillStyleElement("LowerThreshold");
        this.dataElementStyles.getLowerThresholdFillStyle().setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        fse = style.getFillStyleElement("GraphDataStyleInitial");
        this.dataElementStyles.getInitialFillStyle().setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        fse = style.getFillStyleElement("GraphDataStyleFinal");
        this.dataElementStyles.getFinalFillStyle().setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        mse = style.getMarkerStyleElement("GraphMilestone");
        this.dataElementStyles.getMilestoneMarkerStyle().setColor(mse.applyElementTransparency(mse.getMarkerColor()));
    }

    private static String _getImageFileName(String fillFile) {
        if (fillFile != null) {
            if (fillFile.equalsIgnoreCase("Astro.jpg")) {
                return "res/astronomy.jpg";
            }
            if (fillFile.equalsIgnoreCase("Bank64g.gif")) {
                return "res/Tile_Banker_64x64_GS.gif";
            }
            if (fillFile.equalsIgnoreCase("BlkPrint.gif")) {
                return "res/Tile_Blockprint.gif";
            }
            if (fillFile.equalsIgnoreCase("Curve.jpg")) {
                return "res/curve.jpg";
            }
            if (fillFile.equalsIgnoreCase("Educate.gif")) {
                return "res/education.gif";
            }
            if (fillFile.equalsIgnoreCase("Electron.gif")) {
                return "res/Tile_Electronics.gif";
            }
            if (fillFile.equalsIgnoreCase("Gears.gif")) {
                return "res/gears.gif";
            }
            if (fillFile.equalsIgnoreCase("Magnify.gif")) {
                return "res/magnify.gif";
            }
            if (fillFile.equalsIgnoreCase("MoneyLg.gif")) {
                return "res/Tile_Money.gif";
            }
            if (fillFile.equalsIgnoreCase("RSVP.jpg")) {
                return "res/rsvp.jpg";
            }
            if (fillFile.equalsIgnoreCase("Science.gif")) {
                return "res/science.gif";
            }
            if (fillFile.equalsIgnoreCase("Sketch.jpg")) {
                return "res/Tile_Sketch_64x64_GS.jpg";
            }
            if (fillFile.equalsIgnoreCase("Torn.gif")) {
                return "res/torn.gif";
            }
            if (fillFile.equalsIgnoreCase("Waterclr.jpg")) {
                return "res/Tile_Watercolor.jpg";
            }
        }
        return null;
    }

    private static int _getImageFitStyle(int fit) {
        switch (fit) {
            default: {
                return 20200;
            }
            case 1: {
                return 20201;
            }
            case 2: {
                return 20203;
            }
            case 4: {
                return 20204;
            }
            case 5: {
                return 20207;
            }
            case 8: {
                return 20205;
            }
            case 9: {
                return 20206;
            }
            case 10: {
                return 20208;
            }
            case 11: {
                return 20209;
            }
            case 3: 
        }
        return 20200;
    }

    private static void _applyFillStyleElement(FillStyle fs, FillStyleElement fse) {
        int type = fse.getFillType();
        fs.setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
        switch (type) {
            default: {
                fs.setFillType(20000);
                fs.setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
                break;
            }
            case 1: {
                fs.setFillType(20001);
                fs.setGradientFillBeginColor(fse.getFillGradientStartColor());
                fs.setGradientFillEndColor(fse.getFillGradientEndColor());
                if (fse.getFillGradientType() == 0) {
                    fs.setGradientFill(20100);
                    break;
                }
                fs.setGradientFill(20101);
                break;
            }
            case 2: {
                String imageFileName = fse.getFillFile();
                fs.setImageFill(GraphStyle._getImageFitStyle(fse.getFillImageFitStyle()));
                fs.setImageFillColor(fse.applyElementTransparency(fse.getFillColor()));
                ImageIcon imageIcon = null;
                if (imageFileName != null) {
                    imageIcon = GraphStyle._newImageIcon(GraphStyle._getImageFileName(fse.getFillFile()));
                }
                if (imageIcon != null) {
                    fs.setFillType(20002);
                    fs.setImageFill(GraphStyle._getImageFitStyle(fse.getFillImageFitStyle()));
                    fs.setImageIcon(imageIcon);
                    break;
                }
                fs.setFillType(20000);
                fs.setSolidFillColor(fse.applyElementTransparency(fse.getFillColor()));
                break;
            }
            case 3: {
                String imageFileName = fse.getFillFile();
                fs.setImageFill(GraphStyle._getImageFitStyle(fse.getFillImageFitStyle()));
                fs.setImageFillColor(fse.applyElementTransparency(fse.getFillColor()));
                ImageIcon imageIcon = null;
                if (imageFileName != null) {
                    imageIcon = GraphStyle._newImageIcon(GraphStyle._getImageFileName(fse.getFillFile()));
                }
                if (imageIcon != null) {
                    fs.setFillType(20003);
                    fs.setSolidBlendColor(fse.applyElementTransparency(fse.getFillColor()));
                    fs.setImageFill(GraphStyle._getImageFitStyle(fse.getFillImageFitStyle()));
                    fs.setImageIcon(imageIcon);
                    break;
                }
                fs.setFillType(20000);
                break;
            }
            case 4: {
                fs.setFillType(20004);
                fs.setSolidBlendColor(fse.applyElementTransparency(fse.getFillColor()));
            }
        }
    }

    private static void _applyMarkerStyleElement(MarkerStyle ms, MarkerStyleElement mse) {
        ms.setColor(mse.applyElementTransparency(mse.getMarkerColor()));
        ms.setSize(mse.getMarkerSize().asBaseLength());
        ms.setSymbol(mse.getMarkerSymbol());
    }

    private static void _applyStrokeLineStyleElement(StrokeLineStyle ls, LineStyleElement lse) {
        int[] bipLineStyleConstants;
        int lineStyle = lse.getLineStyle();
        lineStyle = lineStyle > (bipLineStyleConstants = StrokeLineStyle.SASGRAPH_LINE.getConstants()).length ? 30001 : bipLineStyleConstants[lineStyle - 1];
        ls.setSASGraphLineStyle(lineStyle);
        ls.setColor(lse.applyElementTransparency(lse.getLineColor()));
        ls.setThickness(lse.getLineThickness().asBaseLength());
    }

    private static void _applyLineStyleElement(LineStyle ls, LineStyleElement lse) {
        ls.setColor(lse.applyElementTransparency(lse.getLineColor()));
        ls.setThickness(lse.getLineThickness().asBaseLength());
    }

    private static void _applyTextStyleElement(TextStyle ts, TextStyleElement tse, ShadowStyleElement shadow) {
        ts.setFont(tse.getAdjustedFont());
        ts.setColor(tse.applyElementTransparency(tse.getTextColor()));
        ts.getShadowStyle().setVisible(tse.isTextDropShadowEnabled());
        ts.getShadowStyle().setColor(shadow.applyElementTransparency(shadow.getShadowColor()));
    }

    public int getAppliedColorSchemeName() {
        return this.appliedColorSchemeName;
    }

    public ColorScheme asColorScheme() {
        int jj;
        ColorScheme cs = new ColorScheme(this.appliedColorSchemeName);
        cs.setBackgroundColor(this.backgroundFillStyle.getSolidFillColor());
        cs.setFloorColor(this.floorFillStyle.getSolidFillColor());
        cs.setWallColor(this.wallFillStyle != null ? this.wallFillStyle.getSolidFillColor() : null);
        cs.setLegendBackgroundColor(this.legendBackgroundFillStyle != null ? this.legendBackgroundFillStyle.getSolidFillColor() : null);
        cs.setAxisLineColor(this.axisLineStyle != null ? this.axisLineStyle.getColor() : null);
        cs.setMajorTickColor(this.majorTickStyle != null ? this.majorTickStyle.getLineStyle().getColor() : null);
        cs.setMinorTickColor(this.minorTickStyle != null ? this.minorTickStyle.getLineStyle().getColor() : null);
        cs.setGridLineColor(this.gridLineStyle != null ? this.gridLineStyle.getColor() : null);
        cs.setLabelColor(this.labelTextStyle != null ? this.labelTextStyle.getColor() : null);
        cs.setValueColor(this.valueTextStyle != null ? this.valueTextStyle.getColor() : null);
        cs.setDataLabelColor(this.dataLabelTextStyle != null ? this.dataLabelTextStyle.getColor() : null);
        cs.setFrameColor(this.frameLineStyle != null ? this.frameLineStyle.getColor() : null);
        cs.setSelectionColor(this.selectionColor);
        cs.setSelectionAccentColor(this.selectionAccentColor);
        cs.setRowAxisLabelCellBackgroundColor(this.rowAxisLabelCellBackgroundColor);
        cs.setRowAxisValueCellBackgroundColor(this.rowAxisValueCellBackgroundColor);
        cs.setColumnAxisLabelCellBackgroundColor(this.columnAxisLabelCellBackgroundColor);
        cs.setColumnAxisValueCellBackgroundColor(this.columnAxisValueCellBackgroundColor);
        if (this.columnRowAxisLabelCellFrameLineStyle != null) {
            cs.setColumnRowAxisLabelCellFrameColor(this.columnRowAxisLabelCellFrameLineStyle.getColor());
        }
        if (this.columnRowAxisValueCellFrameLineStyle != null) {
            cs.setColumnRowAxisValueCellFrameColor(this.columnRowAxisValueCellFrameLineStyle.getColor());
        }
        Color titleFootnoteColor = null;
        Color color = this.title1TextStyle.getColor();
        if (Util.Evaluate.isEqual(color, this.title2TextStyle.getColor()) && Util.Evaluate.isEqual(color, this.title3TextStyle.getColor()) && Util.Evaluate.isEqual(color, this.title4TextStyle.getColor()) && Util.Evaluate.isEqual(color, this.footnote1TextStyle.getColor()) && Util.Evaluate.isEqual(color, this.footnote2TextStyle.getColor())) {
            titleFootnoteColor = color;
        }
        cs.setTitleFootnoteColor(titleFootnoteColor);
        Color shadowColor = null;
        if (this.labelTextStyle != null && this.valueTextStyle != null && this.dataLabelTextStyle != null && this.legendShadowStyle != null && Util.Evaluate.isEqual(color = this.title1TextStyle.getShadowStyle().getColor(), this.title2TextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.title3TextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.title4TextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.footnote1TextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.footnote2TextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.labelTextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.valueTextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.dataLabelTextStyle.getShadowStyle().getColor()) && Util.Evaluate.isEqual(color, this.legendShadowStyle.getColor())) {
            shadowColor = color;
        }
        cs.setShadowColor(shadowColor);
        DataElementColors dataElementColors = cs.getDataElementColors();
        dataElementColors.setOutlineColor(this.dataElementStyles.getOutlineLineStyle().getColor());
        dataElementColors.setContinuousFillTwoColorStartColor(this.dataElementStyles.getContinuousFillTwoColorStartColor());
        dataElementColors.setContinuousFillTwoColorEndColor(this.dataElementStyles.getContinuousFillTwoColorEndColor());
        dataElementColors.setContinuousContrastTwoColorStartColor(this.dataElementStyles.getContinuousContrastTwoColorStartColor());
        dataElementColors.setContinuousContrastTwoColorEndColor(this.dataElementStyles.getContinuousContrastTwoColorEndColor());
        dataElementColors.setContinuousFillThreeColorStartColor(this.dataElementStyles.getContinuousFillThreeColorStartColor());
        dataElementColors.setContinuousFillThreeColorEndColor(this.dataElementStyles.getContinuousFillThreeColorEndColor());
        dataElementColors.setContinuousFillThreeColorNeutralColor(this.dataElementStyles.getContinuousFillThreeColorNeutralColor());
        dataElementColors.setContinuousContrastThreeColorStartColor(this.dataElementStyles.getContinuousContrastThreeColorStartColor());
        dataElementColors.setContinuousContrastThreeColorEndColor(this.dataElementStyles.getContinuousContrastThreeColorEndColor());
        dataElementColors.setContinuousContrastThreeColorNeutralColor(this.dataElementStyles.getContinuousContrastThreeColorNeutralColor());
        FillStyle[] fillStyle = this.dataElementStyles.getFillStyles();
        Color[] fillColors = new Color[fillStyle.length];
        for (jj = 0; jj < fillColors.length; ++jj) {
            fillColors[jj] = fillStyle[jj].getSolidFillColor();
        }
        cs.getDataElementColors().setDiscreteFillColors(fillColors);
        MarkerStyle[] markerStyle = this.dataElementStyles.getMarkerStyles();
        Color[] contrastColors = new Color[markerStyle.length];
        for (jj = 0; jj < contrastColors.length; ++jj) {
            contrastColors[jj] = markerStyle[jj].getColor();
        }
        cs.getDataElementColors().setDiscreteContrastColors(contrastColors);
        return cs;
    }
}

