/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.util.ArrayList;
import java.util.Locale;

@SASScope(value="ALL")
public class GraphOLAPDataSet
implements OLAPDataSetInterface,
ContentsChangedListener,
ContentsChangedSource {
    private OLAPVariableFactory factory;
    private OLAPDataSetInterface olapDelegate;
    private ArrayList listenerList = new ArrayList();

    public void setDelegateModel(OLAPDataSetInterface olapDataSet) {
        ContentsChangedSource source;
        if (this.olapDelegate instanceof ContentsChangedSource) {
            source = (ContentsChangedSource)this.olapDelegate;
            source.removeContentsChangedListener((ContentsChangedListener)this);
        }
        this.olapDelegate = olapDataSet;
        this.factory = null;
        if (olapDataSet instanceof ContentsChangedSource) {
            source = (ContentsChangedSource)olapDataSet;
            source.addContentsChangedListener((ContentsChangedListener)this);
        }
        this.fireContentsChanged();
    }

    public OLAPDataSetInterface getDelegateModel() {
        return this.olapDelegate;
    }

    public static Object getGraphInfo(OLAPDataSetInterface olap) throws OLAPException {
        if (olap instanceof GraphOLAPDataSet) {
            return ((GraphOLAPDataSet)olap).getGraphInfo();
        }
        return new OLAPVariableFactory((ResultSetInterface)olap);
    }

    public Object getGraphInfo() throws OLAPException {
        if (this.factory == null && this.olapDelegate != null) {
            this.factory = new OLAPVariableFactory((ResultSetInterface)this.olapDelegate);
        }
        return this.factory;
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        this.listenerList.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        this.listenerList.remove(listener);
    }

    public void removeAllContentsChangedListeners() {
        this.listenerList.clear();
    }

    private void fireContentsChanged() {
        ContentsChangedEvent e = new ContentsChangedEvent((Object)this);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ContentsChangedListener listener = (ContentsChangedListener)this.listenerList.get(i);
            listener.contentsChanged(e);
        }
    }

    public void contentsChanged(ContentsChangedEvent e) {
        this.factory = null;
        this.fireContentsChanged();
    }

    public void close() throws OLAPException {
        this.olapDelegate.close();
    }

    public void setCells(long startCell, long endCell, Object[] cellValues) throws OLAPException {
        this.olapDelegate.setCells(startCell, endCell, cellValues);
    }

    public void setPerformanceTuning(PerformanceTuning performanceTuning) throws OLAPException {
        this.olapDelegate.setPerformanceTuning(performanceTuning);
    }

    public Object[] getCells(long startCell, long endCell) throws OLAPException {
        return this.olapDelegate.getCells(startCell, endCell);
    }

    public long getCellCount() throws OLAPException {
        return this.olapDelegate.getCellCount();
    }

    public String[] getFormattedCells(long startCell, long endCell) throws OLAPException {
        return this.olapDelegate.getFormattedCells(startCell, endCell);
    }

    public void setQueryStatement(String queryStatement) throws OLAPException {
        this.olapDelegate.setQueryStatement(queryStatement);
    }

    public void executeQuery() throws OLAPException {
        this.olapDelegate.executeQuery();
    }

    public boolean isReadOnly() throws OLAPException {
        return this.olapDelegate.isReadOnly();
    }

    public Object getConnection() throws OLAPException {
        return this.olapDelegate.getConnection();
    }

    public void setConnection(Object con) throws OLAPException {
        this.olapDelegate.setConnection(con);
    }

    public void setReadOnly(boolean readOnly) throws OLAPException {
        this.olapDelegate.setReadOnly(readOnly);
    }

    public void setContextType(int contextType) throws OLAPException {
        this.olapDelegate.setContextType(contextType);
    }

    public void setFormattedCells(long startCell, long endCell, String[] cellValues) throws OLAPException {
        this.olapDelegate.setFormattedCells(startCell, endCell, cellValues);
    }

    public void executeQuery(String queryStatement) throws OLAPException {
        this.olapDelegate.executeQuery(queryStatement);
    }

    public String getCubeName() throws OLAPException {
        return this.olapDelegate.getCubeName();
    }

    public int getContextType() throws OLAPException {
        return this.olapDelegate.getContextType();
    }

    public ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        return this.olapDelegate.getResultSetMetadata();
    }

    public MetadataInterface getDatabaseMetadata() throws OLAPException {
        return this.olapDelegate.getDatabaseMetadata();
    }

    public Locale getLocale() throws OLAPException {
        return this.olapDelegate.getLocale();
    }

    public PerformanceTuning getPerformanceTuning() throws OLAPException {
        return this.olapDelegate.getPerformanceTuning();
    }

    public void setLocale(Locale locale) throws OLAPException {
        this.olapDelegate.setLocale(locale);
    }

    public String getQueryStatement() throws OLAPException {
        return this.olapDelegate.getQueryStatement();
    }
}

