/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.BrushModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.DataTipModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import java.awt.SystemColor;
import javax.swing.ImageIcon;

@SASScope(value="ALL")
public class GraphModel
extends ModelBase {
    private boolean antialiasedText = true;
    private boolean antialiasedGraphics = true;
    private DataElementStyles dataElementStyles = new DataElementStyles();
    private FillStyle backgroundFillStyle = new FillStyle(SystemColor.window);
    private LineStyle frameLineStyle = new LineStyle(SystemColor.windowBorder, null, 10200);
    private DataTipModel dataTipModel = new DataTipModel();
    private BrushModel brushModel = new BrushModel();
    private ImageIcon logo = null;
    private int logoJustification = 4;
    private long customOptions = 0L;

    public void apply(GraphModel theOtherModel) {
        if (theOtherModel == null) {
            return;
        }
        this.disablePropertyChange();
        this.antialiasedText = theOtherModel.antialiasedText;
        this.antialiasedGraphics = theOtherModel.antialiasedGraphics;
        this.logo = theOtherModel.logo;
        this.logoJustification = theOtherModel.logoJustification;
        this.customOptions = theOtherModel.customOptions;
        this.dataElementStyles.apply(theOtherModel.dataElementStyles);
        this.backgroundFillStyle.apply(theOtherModel.backgroundFillStyle);
        this.frameLineStyle.apply(theOtherModel.frameLineStyle);
        this.dataTipModel.apply(theOtherModel.dataTipModel);
        this.brushModel.apply(theOtherModel.brushModel);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public GraphModel() {
        this.setContainedModel("dataElementStyles", this.dataElementStyles);
        this.setContainedModel("backgroundFillStyle", this.backgroundFillStyle);
        this.setContainedModel("frameLineStyle", this.frameLineStyle);
        this.setContainedModel("dataTipModel", this.dataTipModel);
        this.setContainedModel("brushModel", this.brushModel);
    }

    public void setAntialiasedText(boolean newAntialiasedText) {
        boolean oldAntialiasedText = this.antialiasedText;
        this.antialiasedText = newAntialiasedText;
        this.firePropertyChange("antialiasedText", oldAntialiasedText, newAntialiasedText);
    }

    public boolean isAntialiasedText() {
        return this.antialiasedText;
    }

    public void setAntialiasedGraphics(boolean newAntialiasedGraphics) {
        boolean oldAntialiasedGraphics = this.antialiasedGraphics;
        this.antialiasedGraphics = newAntialiasedGraphics;
        this.firePropertyChange("antialiasedGraphics", oldAntialiasedGraphics, newAntialiasedGraphics);
    }

    public boolean isAntialiasedGraphics() {
        return this.antialiasedGraphics;
    }

    public void setFrameLineStyle(LineStyle newFrameLineStyle) throws IllegalArgumentException {
        if (newFrameLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldFrameLineStyle = this.frameLineStyle;
        this.frameLineStyle = newFrameLineStyle;
        this.firePropertyChange("frameLineStyle", oldFrameLineStyle, newFrameLineStyle);
    }

    public LineStyle getFrameLineStyle() {
        return this.frameLineStyle;
    }

    public void setDataTipModel(DataTipModel newDataTipModel) throws IllegalArgumentException {
        if (newDataTipModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        DataTipModel oldDataTipModel = this.dataTipModel;
        this.dataTipModel = newDataTipModel;
        this.firePropertyChange("dataTipModel", oldDataTipModel, newDataTipModel);
    }

    public DataTipModel getDataTipModel() {
        return this.dataTipModel;
    }

    public void setDataElementStyles(DataElementStyles newStyles) throws IllegalArgumentException {
        if (newStyles == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        DataElementStyles oldValue = this.dataElementStyles;
        this.dataElementStyles = newStyles;
        this.firePropertyChange("dataElementStyles", oldValue, newStyles);
    }

    public DataElementStyles getDataElementStyles() {
        return this.dataElementStyles;
    }

    public void setBackgroundFillStyle(FillStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.backgroundFillStyle;
        this.backgroundFillStyle = newStyle;
        this.firePropertyChange("backgroundFillStyle", oldValue, newStyle);
    }

    public FillStyle getBackgroundFillStyle() {
        return this.backgroundFillStyle;
    }

    public void setBrushModel(BrushModel newBrushModel) throws IllegalArgumentException {
        if (newBrushModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BrushModel oldValue = this.brushModel;
        this.brushModel = newBrushModel;
        this.firePropertyChange("brushModel", oldValue, this.brushModel);
    }

    public BrushModel getBrushModel() {
        return this.brushModel;
    }

    public void setLogo(ImageIcon newLogo) {
        ImageIcon oldValue = this.logo;
        this.logo = newLogo;
        this.firePropertyChange("logo", oldValue, this.logo);
    }

    public ImageIcon getLogo() {
        return this.logo;
    }

    public void setLogoJustification(int newJustification) throws IllegalArgumentException {
        switch (newJustification) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
        }
        int oldValue = this.logoJustification;
        this.logoJustification = newJustification;
        this.firePropertyChange("logoJustification", oldValue, this.logoJustification);
    }

    public int getLogoJustification() {
        return this.logoJustification;
    }

    @SASScope
    public void setCustomOptions(long newCustomOptions) {
        long oldValue = this.customOptions;
        this.customOptions = newCustomOptions;
        this.firePropertyChange("customOptions", oldValue, this.customOptions);
    }

    @SASScope
    public long getCustomOptions() {
        return this.customOptions;
    }

    @SASScope
    public boolean isCustomOptionEnabled(long option) {
        return (this.customOptions & option) == option;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        GraphModel arg = (GraphModel)obj;
        return Util.Evaluate.isEqual(this.antialiasedText, arg.antialiasedText) && Util.Evaluate.isEqual(this.antialiasedGraphics, arg.antialiasedGraphics) && Util.Evaluate.isEqual(this.logoJustification, arg.logoJustification) && Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.dataElementStyles, arg.dataElementStyles) && Util.Evaluate.isEqual(this.backgroundFillStyle, arg.backgroundFillStyle) && Util.Evaluate.isEqual(this.frameLineStyle, arg.frameLineStyle) && Util.Evaluate.isEqual(this.dataTipModel, arg.dataTipModel) && Util.Evaluate.isEqual(this.brushModel, arg.brushModel) && Util.Evaluate.isEqual(this.logo, arg.logo) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

