/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ClassificationCellStyle;
import com.sas.graphics.components.ContentsModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

@SASScope(value="ALL")
public class GraphMatrixAxisModel
extends ContentsModel {
    private ClassificationCellStyle valueCellStyle = new ClassificationCellStyle();

    public void apply(GraphMatrixAxisModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherObject);
        this.valueCellStyle.apply(theOtherObject.valueCellStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public GraphMatrixAxisModel() {
        this.setContainedModel("valueCellStyle", this.valueCellStyle);
    }

    public void setValueCellStyle(ClassificationCellStyle newCellStyle) {
        if (newCellStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ClassificationCellStyle oldCellStyle = this.valueCellStyle;
        this.valueCellStyle = newCellStyle;
        this.firePropertyChange("valueCellStyle", oldCellStyle, this.valueCellStyle);
    }

    public ClassificationCellStyle getValueCellStyle() {
        return this.valueCellStyle;
    }

    public void setFrameLineStyle(LineStyle newFrameLineStyle) throws IllegalArgumentException {
        this.valueCellStyle.setFrameLineStyle(newFrameLineStyle);
    }

    public LineStyle getFrameLineStyle() {
        return this.valueCellStyle.getFrameLineStyle();
    }

    public void setBackgroundFillColor(Color newColor) {
        this.valueCellStyle.setBackgroundColors(new Color[]{newColor});
    }

    public Color getBackgroundFillColor() {
        return this.valueCellStyle.getBackgroundColors()[0];
    }

    public void setBackgroundVisibilityPolicy(int newVisibilityPolicy) throws IllegalArgumentException {
        this.valueCellStyle.setBackgroundVisibilityPolicy(newVisibilityPolicy);
    }

    public int getBackgroundVisibilityPolicy() {
        return this.valueCellStyle.getBackgroundVisibilityPolicy();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        GraphMatrixAxisModel arg = (GraphMatrixAxisModel)obj;
        return Util.Evaluate.isEqual(this.valueCellStyle, arg.valueCellStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

