/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.visuals.GraphResources;
import java.awt.Color;
import javax.swing.ImageIcon;

@SASScope(value="ALL")
public class FillStyle
extends ModelBase {
    public static final String RB_KEY = "FillStyle.";
    private static final int _FILL_TYPE_ = 20000;
    private static final int _GRADIENT_FILL_ = 20100;
    private static final int _IMAGE_FILL_ = 20200;
    public static final int FILL_TYPE_SOLID_COLOR = 20000;
    public static final int FILL_TYPE_GRADIENT = 20001;
    public static final int FILL_TYPE_IMAGE = 20002;
    public static final int FILL_TYPE_IMAGE_COLOR_BLEND = 20003;
    public static final int FILL_TYPE_IMAGE_GRADIENT_BLEND = 20004;
    public static final ConstantCollection FILL_TYPE = new ConstantCollection("FillStyle.", new ConstantCollection.Element[]{new ConstantCollection.Element(20000, "FILL_TYPE_SOLID_COLOR", "SolidColor"), new ConstantCollection.Element(20001, "FILL_TYPE_GRADIENT", "Gradient"), new ConstantCollection.Element(20002, "FILL_TYPE_IMAGE", "Image"), new ConstantCollection.Element(20003, "FILL_TYPE_IMAGE_COLOR_BLEND", "ImageColorBlend"), new ConstantCollection.Element(20004, "FILL_TYPE_IMAGE_GRADIENT_BLEND", "ImageGradientBlend")});
    public static final int GRADIENT_FILL_LEFT_TO_RIGHT = 20100;
    public static final int GRADIENT_FILL_BOTTOM_TO_TOP = 20101;
    public static final int GRADIENT_FILL_FRONT_TO_BACK = 20102;
    public static final int GRADIENT_FILL_DIAGONAL_UP = 20103;
    public static final int GRADIENT_FILL_DIAGONAL_DOWN = 20104;
    public static final ConstantCollection GRADIENT_FILL = new ConstantCollection("FillStyle.", new ConstantCollection.Element[]{new ConstantCollection.Element(20100, "GRADIENT_FILL_LEFT_TO_RIGHT", "LeftToRight"), new ConstantCollection.Element(20101, "GRADIENT_FILL_BOTTOM_TO_TOP", "BottomToTop"), new ConstantCollection.Element(20102, "GRADIENT_FILL_FRONT_TO_BACK", "FrontToBack"), new ConstantCollection.Element(20103, "GRADIENT_FILL_DIAGONAL_UP", "DiagonalUp"), new ConstantCollection.Element(20104, "GRADIENT_FILL_DIAGONAL_DOWN", "DiagonalDown")});
    public static final int IMAGE_FILL_STRETCH = 20200;
    public static final int IMAGE_FILL_TILE = 20201;
    public static final int IMAGE_FILL_POINT = 20202;
    public static final int IMAGE_FILL_CENTER = 20203;
    public static final int IMAGE_FILL_TOP = 20204;
    public static final int IMAGE_FILL_TOP_LEFT = 20205;
    public static final int IMAGE_FILL_TOP_RIGHT = 20206;
    public static final int IMAGE_FILL_BOTTOM = 20207;
    public static final int IMAGE_FILL_BOTTOM_LEFT = 20208;
    public static final int IMAGE_FILL_BOTTOM_RIGHT = 20209;
    public static final ConstantCollection IMAGE_FILL = new ConstantCollection("FillStyle.", new ConstantCollection.Element[]{new ConstantCollection.Element(20200, "IMAGE_FILL_STRETCH", "Stretch"), new ConstantCollection.Element(20201, "IMAGE_FILL_TILE", "Tile"), new ConstantCollection.Element(20202, "IMAGE_FILL_POINT", "Point"), new ConstantCollection.Element(20203, "IMAGE_FILL_CENTER", "Center"), new ConstantCollection.Element(20204, "IMAGE_FILL_TOP", "Top"), new ConstantCollection.Element(20205, "IMAGE_FILL_TOP_LEFT", "TopLeft"), new ConstantCollection.Element(20206, "IMAGE_FILL_TOP_RIGHT", "TopRight"), new ConstantCollection.Element(20207, "IMAGE_FILL_BOTTOM", "Bottom"), new ConstantCollection.Element(20208, "IMAGE_FILL_BOTTOM_LEFT", "BottomLeft"), new ConstantCollection.Element(20209, "IMAGE_FILL_BOTTOM_RIGHT", "BottomRight")});
    private int fillType = 20000;
    private boolean visible = true;
    private Color solidFillColor = Color.white;
    private int imageFill = 20203;
    private ImageIcon imageIcon = null;
    private Color imageFillColor = Color.white;
    private Color solidBlendColor = Color.white;
    private Color gradientBlendBeginColor = Color.white;
    private Color gradientBlendEndColor = Color.white;
    private int x = 0;
    private int y = 0;
    private int gradientFill = 20100;
    private Color gradientFillBeginColor = Color.white;
    private Color gradientFillEndColor = Color.gray;

    public FillStyle() {
    }

    public FillStyle(Color solidColor) {
        if (solidColor != null) {
            this.solidFillColor = solidColor;
        }
    }

    public FillStyle(Color beginColor, Color endColor, int gradientFill) {
        this.fillType = 20001;
        if (beginColor != null) {
            this.gradientFillBeginColor = beginColor;
        }
        if (endColor != null) {
            this.gradientFillEndColor = endColor;
        }
        if (GRADIENT_FILL.isValid(gradientFill)) {
            this.gradientFill = gradientFill;
        }
    }

    public FillStyle(ImageIcon imageIcon, Color imageFillColor, int imageFill) {
        this.fillType = 20002;
        if (imageFillColor != null) {
            this.imageFillColor = imageFillColor;
        }
        if (IMAGE_FILL.isValid(imageFill)) {
            this.imageFill = imageFill;
        }
        this.imageIcon = imageIcon;
    }

    public void apply(FillStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.fillType = theOtherObject.fillType;
        this.visible = theOtherObject.visible;
        this.solidFillColor = theOtherObject.solidFillColor;
        this.imageFill = theOtherObject.imageFill;
        this.imageIcon = theOtherObject.imageIcon;
        this.imageFillColor = theOtherObject.imageFillColor;
        this.x = theOtherObject.x;
        this.y = theOtherObject.y;
        this.gradientFill = theOtherObject.gradientFill;
        this.gradientFillBeginColor = theOtherObject.gradientFillBeginColor;
        this.gradientFillEndColor = theOtherObject.gradientFillEndColor;
        this.solidBlendColor = theOtherObject.solidBlendColor;
        this.gradientBlendBeginColor = theOtherObject.gradientBlendBeginColor;
        this.gradientBlendEndColor = theOtherObject.gradientBlendEndColor;
        this.firePropertyChange("", null, this);
    }

    public void setFillType(int newFillType) throws IllegalArgumentException {
        FILL_TYPE.validate(newFillType);
        int oldFillType = this.fillType;
        this.fillType = newFillType;
        this.firePropertyChange("fillType", oldFillType, newFillType);
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        this.firePropertyChange("visible", oldVisible, newVisible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setSolidFillColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.solidFillColor;
        this.solidFillColor = newColor;
        this.firePropertyChange("solidFillColor", oldColor, newColor);
    }

    public Color getSolidFillColor() {
        return this.solidFillColor;
    }

    public void setGradientFill(int newGradientFill) throws IllegalArgumentException {
        GRADIENT_FILL.validate(newGradientFill);
        int oldGradientFill = this.gradientFill;
        this.gradientFill = newGradientFill;
        this.firePropertyChange("gradientFill", oldGradientFill, newGradientFill);
    }

    public int getGradientFill() {
        return this.gradientFill;
    }

    public void setGradientFillBeginColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.gradientFillBeginColor;
        this.gradientFillBeginColor = newColor;
        this.firePropertyChange("gradientFillBeginColor", oldColor, newColor);
    }

    public Color getGradientFillBeginColor() {
        return this.gradientFillBeginColor;
    }

    public void setGradientFillEndColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.gradientFillEndColor;
        this.gradientFillEndColor = newColor;
        this.firePropertyChange("gradientFillEndColor", oldColor, newColor);
    }

    public Color getGradientFillEndColor() {
        return this.gradientFillEndColor;
    }

    public void setImageFill(int newImageFill) throws IllegalArgumentException {
        IMAGE_FILL.validate(newImageFill);
        int oldImageFill = this.imageFill;
        this.imageFill = newImageFill;
        this.firePropertyChange("imageFill", oldImageFill, newImageFill);
    }

    public int getImageFill() {
        return this.imageFill;
    }

    public void setImageFillColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.imageFillColor;
        this.imageFillColor = newColor;
        this.firePropertyChange("imageFillColor", oldColor, newColor);
    }

    public Color getImageFillColor() {
        return this.imageFillColor;
    }

    public void setSolidBlendColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.solidBlendColor;
        this.solidBlendColor = newColor;
        this.firePropertyChange("solidBlendColor", oldColor, newColor);
    }

    public Color getSolidBlendColor() {
        return this.solidBlendColor;
    }

    public void setGradientBlendBeginColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.gradientBlendBeginColor;
        this.gradientBlendBeginColor = newColor;
        this.firePropertyChange("imageGradientBlendBeginColor", oldColor, newColor);
    }

    public Color getGradientBlendBeginColor() {
        return this.gradientBlendBeginColor;
    }

    public void setGradientBlendEndColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.gradientBlendEndColor;
        this.gradientBlendEndColor = newColor;
        this.firePropertyChange("imageGradientBlendEndColor", oldColor, newColor);
    }

    public Color getGradientBlendEndColor() {
        return this.gradientBlendEndColor;
    }

    public void setImageIcon(ImageIcon newImageIcon) {
        ImageIcon oldImageIcon = this.imageIcon;
        this.imageIcon = newImageIcon;
        this.firePropertyChange("image", oldImageIcon, newImageIcon);
    }

    public ImageIcon getImageIcon() {
        if (this.imageIcon != null && this.imageIcon.getImage() == null && this.imageIcon.getDescription() != null) {
            try {
                this.imageIcon.setImage(GraphResources.getImage((String)this.imageIcon.getDescription()));
            }
            catch (Exception e) {
                ImageIcon imageIcon2 = new ImageIcon(this.imageIcon.getDescription());
                if (imageIcon2.getImageLoadStatus() == 8) {
                    this.imageIcon.setImage(imageIcon2.getImage());
                }
                this.imageIcon.setImage(GraphResources.getImage((String)"res/Invalid.gif"));
            }
        }
        return this.imageIcon;
    }

    public void setX(int newX) {
        int oldX = this.x;
        this.x = newX;
        this.firePropertyChange("x", oldX, newX);
    }

    public int getX() {
        return this.x;
    }

    public void setY(int newY) {
        int oldY = this.y;
        this.y = newY;
        this.firePropertyChange("y", oldY, newY);
    }

    public int getY() {
        return this.y;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        FillStyle arg = (FillStyle)obj;
        return Util.Evaluate.isEqual(this.fillType, arg.fillType) && Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.imageFill, arg.imageFill) && Util.Evaluate.isEqual(this.x, arg.x) && Util.Evaluate.isEqual(this.y, arg.y) && Util.Evaluate.isEqual(this.gradientFill, arg.gradientFill) && Util.Evaluate.isEqual(this.solidFillColor, arg.solidFillColor) && Util.Evaluate.isEqual(this.imageIcon, arg.imageIcon) && Util.Evaluate.isEqual(this.imageFillColor, arg.imageFillColor) && Util.Evaluate.isEqual(this.gradientFillBeginColor, arg.gradientFillBeginColor) && Util.Evaluate.isEqual(this.gradientFillEndColor, arg.gradientFillEndColor) && Util.Evaluate.isEqual(this.solidBlendColor, arg.solidBlendColor) && Util.Evaluate.isEqual(this.gradientBlendBeginColor, arg.gradientBlendBeginColor) && Util.Evaluate.isEqual(this.gradientBlendEndColor, arg.gradientBlendEndColor) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

