/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseDistance;
import java.awt.Color;
import java.awt.SystemColor;

@SASScope(value="ALL")
public class DataTipModel
extends ModelBase {
    private static final BaseDistance DEFAULT_HJUST = new BaseDistance(0.0, "cm");
    private static final BaseDistance DEFAULT_VJUST = new BaseDistance(0.5, "cm");
    private boolean visible = true;
    private TextStyle textStyle = new TextStyle();
    private Color backgroundColor = SystemColor.window;
    private BaseDistance horizontalOffset = DEFAULT_HJUST;
    private BaseDistance verticalOffset = DEFAULT_VJUST;
    private int horizontalJustification = 0;
    private int content = 11400;

    DataTipModel() {
        this.setContainedModel("textStyle", this.textStyle);
    }

    public void apply(DataTipModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.visible = theOtherObject.visible;
        this.backgroundColor = theOtherObject.backgroundColor;
        this.horizontalOffset = theOtherObject.horizontalOffset;
        this.verticalOffset = theOtherObject.verticalOffset;
        this.horizontalJustification = theOtherObject.horizontalJustification;
        this.content = theOtherObject.content;
        this.textStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.textStyle, this.textStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        this.firePropertyChange("visible", oldVisible, newVisible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setTextStyle(TextStyle newTextStyle) throws IllegalArgumentException {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.textStyle;
        this.textStyle = newTextStyle;
        this.firePropertyChange("textStyle", oldValue, newTextStyle);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setBackgroundColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldValue = this.backgroundColor;
        this.backgroundColor = newColor;
        this.firePropertyChange("backgroundColor", oldValue, this.backgroundColor);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setHorizontalJustification(int newJustification) throws IllegalArgumentException {
        switch (newJustification) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 0: 
            case 2: 
            case 4: 
        }
        int oldHorizontalJustification = this.horizontalJustification;
        this.horizontalJustification = newJustification;
        this.firePropertyChange("horizontalJustification", oldHorizontalJustification, this.horizontalJustification);
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public void setHorizontalOffset(BaseDistance newOffset) throws IllegalArgumentException {
        if (newOffset == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseDistance oldHorizontalOffset = this.horizontalOffset;
        this.horizontalOffset = newOffset;
        this.firePropertyChange("horizontalOffset", oldHorizontalOffset, this.horizontalOffset);
    }

    public BaseDistance getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setVerticalOffset(BaseDistance newOffset) throws IllegalArgumentException {
        if (newOffset == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseDistance oldVerticalOffset = this.verticalOffset;
        this.verticalOffset = newOffset;
        this.firePropertyChange("verticalOffset", oldVerticalOffset, this.verticalOffset);
    }

    public BaseDistance getVerticalOffset() {
        return this.verticalOffset;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DataTipModel arg = (DataTipModel)obj;
        return Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.horizontalJustification, arg.horizontalJustification) && Util.Evaluate.isEqual(this.content, arg.content) && Util.Evaluate.isEqual(this.horizontalOffset, arg.horizontalOffset) && Util.Evaluate.isEqual(this.verticalOffset, arg.verticalOffset) && Util.Evaluate.isEqual(this.textStyle, arg.textStyle) && Util.Evaluate.isEqual(this.backgroundColor, arg.backgroundColor) && super.equals(arg);
    }

    public void setContent(int newMode) {
        int oldMode = this.content;
        if (newMode != 11400 && newMode != 11401) {
            throw new IllegalArgumentException();
        }
        this.content = newMode;
        this.firePropertyChange("content", oldMode, this.content);
    }

    public int getContent() {
        return this.content;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

