/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.DataElementColors;
import com.sas.graphics.components.DiscreteStyleMapModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseLength;
import com.sas.text.Message;
import java.awt.Color;

@SASScope(value="ALL")
public class DataElementStyles
extends ModelBase {
    private static final BaseLength ONE_PIXEL = new BaseLength(1.0, "px");
    private static final int[] DEFAULT_MARKERS = new int[]{18, 19, 23, 16, 17, 106, 20, 21, 123, 121, 22, 122, 148, 38};
    private LineStyle outlineLineStyle = new LineStyle();
    private LineStyle connectingLineStyle = new LineStyle();
    private Color targetColor = Color.black;
    private Color continuousFillTwoColorStartColor = Color.green;
    private Color continuousFillTwoColorEndColor = Color.red;
    private Color continuousFillThreeColorStartColor = Color.blue;
    private Color continuousFillThreeColorEndColor = Color.orange;
    private Color continuousFillThreeColorNeutralColor = Color.white;
    private Color continuousContrastTwoColorStartColor = Color.blue;
    private Color continuousContrastTwoColorEndColor = Color.orange;
    private Color continuousContrastThreeColorStartColor = Color.red;
    private Color continuousContrastThreeColorEndColor = Color.green;
    private Color continuousContrastThreeColorNeutralColor = Color.white;
    private Color[] discreteFillColors;
    private ColorPosition[] continuousColorSpectrum = new ColorPosition[]{new ColorPosition(this.continuousFillThreeColorStartColor, 0.0), new ColorPosition(this.continuousFillThreeColorNeutralColor, 0.5), new ColorPosition(this.continuousFillThreeColorEndColor, 1.0)};
    private FillStyle[] dataFillStyles = null;
    private StrokeLineStyle[] dataLineStyles = null;
    private MarkerStyle[] dataMarkerStyles = null;
    private FillStyle[] errorFillStyles = null;
    private StrokeLineStyle[] errorLineStyles = null;
    private MarkerStyle[] errorMarkerStyles = null;
    private FillStyle otherFillStyle = new FillStyle();
    private FillStyle outOfRangeFillStyle = new FillStyle();
    private FillStyle overFlowFillStyle = new FillStyle();
    private FillStyle underFlowFillStyle = new FillStyle();
    private FillStyle missingFillStyle = new FillStyle();
    private FillStyle upperThresholdFillStyle = new FillStyle();
    private FillStyle lowerThresholdFillStyle = new FillStyle();
    private FillStyle initialFillStyle = new FillStyle();
    private FillStyle finalFillStyle = new FillStyle();
    private FillStyle normalFillStyle = new FillStyle(new Color(175, 193, 122));
    private FillStyle slackFillStyle = new FillStyle(new Color(242, 229, 157));
    private FillStyle criticalFillStyle = new FillStyle(new Color(218, 123, 123));
    private FillStyle resourceFillStyle = new FillStyle(new Color(171, 145, 169));
    private FillStyle custom1FillStyle = new FillStyle(new Color(255, 255, 119));
    private FillStyle custom2FillStyle = new FillStyle(new Color(192, 192, 192));
    private FillStyle actualFillStyle = new FillStyle(new Color(156, 167, 199));
    private FillStyle baselineFillStyle = new FillStyle(new Color(195, 210, 213));
    private FillStyle breakTimeFillStyle = new FillStyle(new Color(195, 210, 213));
    private DiscreteStyleMapModel discreteStyleMapModel = new DiscreteStyleMapModel();
    private MarkerStyle milestoneMarkerStyle = new MarkerStyle(118);
    private MarkerStyle targetMarkerStyle = new MarkerStyle(112);
    private static final int[] lineIDs = new int[]{30001};

    public void apply(DataElementStyles theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.outlineLineStyle.apply(theOtherObject.outlineLineStyle);
        this.connectingLineStyle.apply(theOtherObject.connectingLineStyle);
        this.targetColor = theOtherObject.targetColor;
        this.continuousFillTwoColorStartColor = theOtherObject.continuousFillTwoColorStartColor;
        this.continuousFillTwoColorEndColor = theOtherObject.continuousFillTwoColorEndColor;
        this.continuousFillThreeColorStartColor = theOtherObject.continuousFillThreeColorStartColor;
        this.continuousFillThreeColorEndColor = theOtherObject.continuousFillThreeColorEndColor;
        this.continuousFillThreeColorNeutralColor = theOtherObject.continuousFillThreeColorNeutralColor;
        this.continuousContrastTwoColorStartColor = theOtherObject.continuousContrastTwoColorStartColor;
        this.continuousContrastTwoColorEndColor = theOtherObject.continuousContrastTwoColorEndColor;
        this.continuousContrastThreeColorStartColor = theOtherObject.continuousContrastThreeColorStartColor;
        this.continuousContrastThreeColorEndColor = theOtherObject.continuousContrastThreeColorEndColor;
        this.continuousContrastThreeColorNeutralColor = theOtherObject.continuousContrastThreeColorNeutralColor;
        this.dataFillStyles = this.apply("dataFillStyle", theOtherObject.dataFillStyles, this.dataFillStyles);
        this.dataLineStyles = this.apply("dataLineStyle", theOtherObject.dataLineStyles, this.dataLineStyles);
        this.dataMarkerStyles = this.apply("dataMarkerStyle", theOtherObject.dataMarkerStyles, this.dataMarkerStyles);
        this.errorFillStyles = this.apply("errorFillStyle", theOtherObject.errorFillStyles, this.errorFillStyles);
        this.errorLineStyles = this.apply("errorLineStyle", theOtherObject.errorLineStyles, this.errorLineStyles);
        this.errorMarkerStyles = this.apply("errorMarkerStyle", theOtherObject.errorMarkerStyles, this.errorMarkerStyles);
        if (this.discreteFillColors.length != theOtherObject.discreteFillColors.length) {
            this.discreteFillColors = new Color[theOtherObject.discreteFillColors.length];
        }
        System.arraycopy(theOtherObject.discreteFillColors, 0, this.discreteFillColors, 0, this.discreteFillColors.length);
        if (this.continuousColorSpectrum.length != theOtherObject.continuousColorSpectrum.length) {
            this.continuousColorSpectrum = new ColorPosition[theOtherObject.continuousColorSpectrum.length];
        }
        System.arraycopy(theOtherObject.continuousColorSpectrum, 0, this.continuousColorSpectrum, 0, this.continuousColorSpectrum.length);
        this.otherFillStyle.apply(theOtherObject.otherFillStyle);
        this.outOfRangeFillStyle.apply(theOtherObject.outOfRangeFillStyle);
        this.overFlowFillStyle.apply(theOtherObject.overFlowFillStyle);
        this.underFlowFillStyle.apply(theOtherObject.underFlowFillStyle);
        this.missingFillStyle.apply(theOtherObject.missingFillStyle);
        this.discreteStyleMapModel.apply(theOtherObject.discreteStyleMapModel);
        this.upperThresholdFillStyle.apply(theOtherObject.upperThresholdFillStyle);
        this.lowerThresholdFillStyle.apply(theOtherObject.lowerThresholdFillStyle);
        this.initialFillStyle.apply(theOtherObject.initialFillStyle);
        this.finalFillStyle.apply(theOtherObject.finalFillStyle);
        this.normalFillStyle.apply(theOtherObject.normalFillStyle);
        this.slackFillStyle.apply(theOtherObject.slackFillStyle);
        this.criticalFillStyle.apply(theOtherObject.criticalFillStyle);
        this.resourceFillStyle.apply(theOtherObject.resourceFillStyle);
        this.custom1FillStyle.apply(theOtherObject.custom1FillStyle);
        this.custom2FillStyle.apply(theOtherObject.custom2FillStyle);
        this.actualFillStyle.apply(theOtherObject.actualFillStyle);
        this.baselineFillStyle.apply(theOtherObject.baselineFillStyle);
        this.breakTimeFillStyle.apply(theOtherObject.breakTimeFillStyle);
        this.milestoneMarkerStyle.apply(theOtherObject.milestoneMarkerStyle);
        this.targetMarkerStyle.apply(theOtherObject.targetMarkerStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void applyDataElementColors(DataElementColors colors) {
        Color errorColor;
        if (colors == null) {
            return;
        }
        this.disablePropertyChange();
        if (colors.getTargetColor() != null) {
            this.targetColor = colors.getTargetColor();
        }
        if (colors.getContinuousFillTwoColorStartColor() != null && colors.getContinuousFillTwoColorEndColor() != null) {
            this.continuousFillTwoColorStartColor = colors.getContinuousFillTwoColorStartColor();
            this.continuousFillTwoColorEndColor = colors.getContinuousFillTwoColorEndColor();
        }
        if (colors.getContinuousFillThreeColorStartColor() != null && colors.getContinuousFillThreeColorNeutralColor() != null && colors.getContinuousFillThreeColorEndColor() != null) {
            this.continuousFillThreeColorStartColor = colors.getContinuousFillThreeColorStartColor();
            this.continuousFillThreeColorEndColor = colors.getContinuousFillThreeColorEndColor();
            this.continuousFillThreeColorNeutralColor = colors.getContinuousFillThreeColorNeutralColor();
        }
        if (colors.getContinuousContrastTwoColorStartColor() != null && colors.getContinuousContrastTwoColorEndColor() != null) {
            this.continuousContrastTwoColorStartColor = colors.getContinuousContrastTwoColorStartColor();
            this.continuousContrastTwoColorEndColor = colors.getContinuousContrastTwoColorEndColor();
        }
        if (colors.getContinuousContrastThreeColorStartColor() != null && colors.getContinuousContrastThreeColorNeutralColor() != null && colors.getContinuousContrastThreeColorEndColor() != null) {
            this.continuousContrastThreeColorStartColor = colors.getContinuousContrastThreeColorStartColor();
            this.continuousContrastThreeColorEndColor = colors.getContinuousContrastThreeColorEndColor();
            this.continuousContrastThreeColorNeutralColor = colors.getContinuousContrastThreeColorNeutralColor();
        }
        Color[] fillColors = colors.getDiscreteFillColors();
        Color[] contrastColors = colors.getDiscreteContrastColors();
        if (this.discreteFillColors.length != fillColors.length) {
            this.discreteFillColors = new Color[fillColors.length];
        }
        System.arraycopy(fillColors, 0, this.discreteFillColors, 0, this.discreteFillColors.length);
        if (fillColors != null && fillColors.length > 0) {
            for (int ii = 0; ii < this.dataFillStyles.length; ++ii) {
                this.dataFillStyles[ii].setSolidFillColor(Util.newCycledColor(fillColors, ii));
                this.dataFillStyles[ii].setSolidBlendColor(this.dataFillStyles[ii].getSolidFillColor());
                this.dataFillStyles[ii].setGradientFillBeginColor(this.dataFillStyles[ii].getSolidFillColor());
                this.dataFillStyles[ii].setGradientFillEndColor(Color.white);
                this.dataFillStyles[ii].setGradientBlendBeginColor(this.dataFillStyles[ii].getGradientFillBeginColor());
                this.dataFillStyles[ii].setGradientBlendEndColor(this.dataFillStyles[ii].getGradientFillEndColor());
            }
        }
        if (this.continuousColorSpectrum.length != colors.getContinuousColorSpectrum().length) {
            this.continuousColorSpectrum = new ColorPosition[colors.getContinuousColorSpectrum().length];
        }
        System.arraycopy(colors.getContinuousColorSpectrum(), 0, this.continuousColorSpectrum, 0, this.continuousColorSpectrum.length);
        if (contrastColors != null && contrastColors.length > 0) {
            int j;
            for (j = 0; j < this.dataMarkerStyles.length; ++j) {
                this.dataMarkerStyles[j].setColor(contrastColors[j % contrastColors.length]);
            }
            for (j = 0; j < this.dataLineStyles.length; ++j) {
                this.dataLineStyles[j].setColor(contrastColors[j % contrastColors.length]);
            }
        }
        if ((errorColor = colors.getErrorColor()) != null) {
            int j;
            for (j = 0; j < this.errorFillStyles.length; ++j) {
                this.errorFillStyles[j].setSolidFillColor(errorColor);
            }
            for (j = 0; j < this.errorMarkerStyles.length; ++j) {
                this.errorMarkerStyles[j].setColor(errorColor);
            }
            for (j = 0; j < this.errorLineStyles.length; ++j) {
                this.errorLineStyles[j].setColor(errorColor);
            }
        }
        if (colors.getOutlineColor() != null) {
            this.outlineLineStyle.setColor(colors.getOutlineColor());
        }
        if (colors.getConnectingLineColor() != null) {
            this.connectingLineStyle.setColor(colors.getConnectingLineColor());
        }
        if (colors.getOtherColor() != null) {
            this.otherFillStyle.setSolidFillColor(colors.getOtherColor());
        }
        if (colors.getMissingColor() != null) {
            this.missingFillStyle.setSolidFillColor(colors.getMissingColor());
        }
        if (colors.getOutOfRangeColor() != null) {
            this.outOfRangeFillStyle.setSolidFillColor(colors.getOutOfRangeColor());
        }
        if (colors.getOverFlowColor() != null) {
            this.overFlowFillStyle.setSolidFillColor(colors.getOverFlowColor());
        }
        if (colors.getUnderFlowColor() != null) {
            this.underFlowFillStyle.setSolidFillColor(colors.getUnderFlowColor());
        }
        if (colors.getThresholdColor() != null) {
            this.upperThresholdFillStyle.setSolidFillColor(colors.getThresholdColor());
            this.lowerThresholdFillStyle.setSolidFillColor(colors.getThresholdColor());
        }
        if (colors.getInitialColor() != null) {
            this.initialFillStyle.setSolidFillColor(colors.getInitialColor());
        }
        if (colors.getFinalColor() != null) {
            this.finalFillStyle.setSolidFillColor(colors.getFinalColor());
        }
        if (colors.getNormalColor() != null) {
            this.normalFillStyle.setSolidFillColor(colors.getNormalColor());
        }
        if (colors.getSlackColor() != null) {
            this.slackFillStyle.setSolidFillColor(colors.getSlackColor());
        }
        if (colors.getCriticalColor() != null) {
            this.criticalFillStyle.setSolidFillColor(colors.getCriticalColor());
        }
        if (colors.getActualColor() != null) {
            this.actualFillStyle.setSolidFillColor(colors.getActualColor());
        }
        if (colors.getResourceColor() != null) {
            this.resourceFillStyle.setSolidFillColor(colors.getResourceColor());
        }
        if (colors.getCustomSchedule1Color() != null) {
            this.custom1FillStyle.setSolidFillColor(colors.getCustomSchedule1Color());
        }
        if (colors.getCustom2Color() != null) {
            this.custom2FillStyle.setSolidFillColor(colors.getCustom2Color());
        }
        if (colors.getBaselineColor() != null) {
            this.baselineFillStyle.setSolidFillColor(colors.getBaselineColor());
        }
        if (colors.getBreakTimeColor() != null) {
            this.breakTimeFillStyle.setSolidFillColor(colors.getBreakTimeColor());
        }
        if (colors.getMilestoneColor() != null) {
            this.milestoneMarkerStyle.setColor(colors.getMilestoneColor());
        }
        if (colors.getTargetColor() != null) {
            this.targetMarkerStyle.setColor(colors.getTargetColor());
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    private Color _newColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public void applyFillStylesAlpha(int alpha) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Integer(1).toString(), (Object)new Integer(255).toString());
            throw new IllegalArgumentException(message);
        }
        this.disablePropertyChange();
        if (this.dataFillStyles != null && this.dataFillStyles.length > 0) {
            for (int j = 0; j < this.dataFillStyles.length; ++j) {
                this.dataFillStyles[j].setSolidFillColor(this._newColor(this.dataFillStyles[j].getSolidFillColor(), alpha));
            }
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void applyMarkerStylesAlpha(int alpha) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Integer(1).toString(), (Object)new Integer(255).toString());
            throw new IllegalArgumentException(message);
        }
        this.disablePropertyChange();
        if (this.dataMarkerStyles != null) {
            for (int j = 0; j < this.dataMarkerStyles.length; ++j) {
                this.dataMarkerStyles[j].setColor(this._newColor(this.dataMarkerStyles[j].getColor(), alpha));
            }
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void applyLineStylesAlpha(int alpha) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Integer(1).toString(), (Object)new Integer(255).toString());
            throw new IllegalArgumentException(message);
        }
        this.disablePropertyChange();
        if (this.dataLineStyles != null) {
            for (int j = 0; j < this.dataLineStyles.length; ++j) {
                this.dataLineStyles[j].setColor(this._newColor(this.dataLineStyles[j].getColor(), alpha));
            }
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void applyDiscreteFillColorsAlpha(int alpha) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Integer(1).toString(), (Object)new Integer(255).toString());
            throw new IllegalArgumentException(message);
        }
        if (this.discreteFillColors != null) {
            for (int ii = 0; ii < this.discreteFillColors.length; ++ii) {
                this.discreteFillColors[ii] = this._newColor(this.discreteFillColors[ii], alpha);
            }
        }
        this.firePropertyChange("", null, this);
    }

    public DataElementStyles() {
        int ii;
        this.setContainedModel("outlineLineStyle", this.outlineLineStyle);
        this.setContainedModel("connectingLineStyle", this.connectingLineStyle);
        ColorScheme colors = new ColorScheme(101012);
        DataElementColors dataColors = colors.getDataElementColors();
        Color[] fillColor = dataColors.getDiscreteFillColors();
        this.dataFillStyles = new FillStyle[fillColor.length];
        for (ii = 0; ii < this.dataFillStyles.length; ++ii) {
            this.dataFillStyles[ii] = new FillStyle(Util.newCycledColor(fillColor, ii));
            this.setContainedModel("dataFillStyle" + ii, this.dataFillStyles[ii]);
        }
        this.dataLineStyles = new StrokeLineStyle[fillColor.length];
        for (ii = 0; ii < this.dataLineStyles.length; ++ii) {
            this.dataLineStyles[ii] = new StrokeLineStyle(lineIDs[ii % lineIDs.length], Util.newCycledColor(fillColor, ii), ONE_PIXEL);
            this.setContainedModel("dataLineStyle" + ii, this.dataLineStyles[ii]);
        }
        this.dataMarkerStyles = new MarkerStyle[DEFAULT_MARKERS.length];
        for (ii = 0; ii < this.dataMarkerStyles.length; ++ii) {
            this.dataMarkerStyles[ii] = new MarkerStyle(DEFAULT_MARKERS[ii % DEFAULT_MARKERS.length], Util.newCycledColor(fillColor, ii));
            this.setContainedModel("dataMarkerStyle" + ii, this.dataMarkerStyles[ii]);
        }
        this.discreteFillColors = new Color[fillColor.length];
        System.arraycopy(fillColor, 0, this.discreteFillColors, 0, this.discreteFillColors.length);
        this.errorFillStyles = new FillStyle[1];
        for (ii = 0; ii < this.errorFillStyles.length; ++ii) {
            this.errorFillStyles[ii] = new FillStyle();
            this.errorFillStyles[ii].setSolidFillColor(dataColors.getErrorColor());
            this.setContainedModel("errorFillStyles" + ii, this.errorFillStyles[ii]);
        }
        this.errorLineStyles = new StrokeLineStyle[1];
        for (ii = 0; ii < this.errorLineStyles.length; ++ii) {
            this.errorLineStyles[ii] = new StrokeLineStyle(dataColors.getErrorColor());
            this.setContainedModel("errorLineStyles" + ii, this.errorLineStyles[ii]);
        }
        this.errorMarkerStyles = new MarkerStyle[4];
        for (ii = 0; ii < this.errorMarkerStyles.length; ++ii) {
            this.errorMarkerStyles[ii] = ii < 2 ? new MarkerStyle(33, dataColors.getErrorColor()) : new MarkerStyle(34, dataColors.getErrorColor());
            this.setContainedModel("errorMarkerStyles" + ii, this.errorMarkerStyles[ii]);
        }
        if (dataColors.getOutlineColor() != null) {
            this.outlineLineStyle.setColor(dataColors.getOutlineColor());
        }
        this.setContainedModel("outlineLineStyle", this.outlineLineStyle);
        if (dataColors.getConnectingLineColor() != null) {
            this.connectingLineStyle.setColor(dataColors.getConnectingLineColor());
        }
        this.setContainedModel("connectingLineStyle", this.connectingLineStyle);
        if (dataColors.getOtherColor() != null) {
            this.otherFillStyle.setSolidFillColor(dataColors.getOtherColor());
        }
        if (dataColors.getMissingColor() != null) {
            this.missingFillStyle.setSolidFillColor(dataColors.getMissingColor());
        }
        if (dataColors.getOutOfRangeColor() != null) {
            this.outOfRangeFillStyle.setSolidFillColor(dataColors.getOutOfRangeColor());
        }
        if (dataColors.getOverFlowColor() != null) {
            this.overFlowFillStyle.setSolidFillColor(dataColors.getOverFlowColor());
        }
        if (dataColors.getUnderFlowColor() != null) {
            this.underFlowFillStyle.setSolidFillColor(dataColors.getUnderFlowColor());
        }
        if (dataColors.getThresholdColor() != null) {
            this.upperThresholdFillStyle.setSolidFillColor(dataColors.getThresholdColor());
            this.lowerThresholdFillStyle.setSolidFillColor(dataColors.getThresholdColor());
        }
        if (dataColors.getInitialColor() != null) {
            this.initialFillStyle.setSolidFillColor(dataColors.getInitialColor());
        }
        if (dataColors.getFinalColor() != null) {
            this.finalFillStyle.setSolidFillColor(dataColors.getFinalColor());
        }
        this.milestoneMarkerStyle.setSize(new BaseLength(0.0, "px"));
        if (dataColors.getMilestoneColor() != null) {
            this.milestoneMarkerStyle.setColor(dataColors.getMilestoneColor());
        }
        if (dataColors.getTargetColor() != null) {
            this.targetMarkerStyle.setColor(dataColors.getTargetColor());
        }
        if (dataColors.getNormalColor() != null) {
            this.normalFillStyle.setSolidFillColor(dataColors.getNormalColor());
        }
        if (dataColors.getSlackColor() != null) {
            this.slackFillStyle.setSolidFillColor(dataColors.getSlackColor());
        }
        if (dataColors.getCriticalColor() != null) {
            this.criticalFillStyle.setSolidFillColor(dataColors.getCriticalColor());
        }
        if (dataColors.getActualColor() != null) {
            this.actualFillStyle.setSolidFillColor(dataColors.getActualColor());
        }
        if (dataColors.getResourceColor() != null) {
            this.resourceFillStyle.setSolidFillColor(dataColors.getResourceColor());
        }
        if (dataColors.getCustomSchedule1Color() != null) {
            this.custom1FillStyle.setSolidFillColor(dataColors.getCustomSchedule1Color());
        }
        if (dataColors.getCustom2Color() != null) {
            this.custom2FillStyle.setSolidFillColor(dataColors.getCustom2Color());
        }
        if (dataColors.getBaselineColor() != null) {
            this.baselineFillStyle.setSolidFillColor(dataColors.getBaselineColor());
        }
        if (dataColors.getBreakTimeColor() != null) {
            this.breakTimeFillStyle.setSolidFillColor(dataColors.getBreakTimeColor());
        }
        this.setContainedModel("otherFillStyle", this.otherFillStyle);
        this.setContainedModel("outOfRangeFillStyle", this.outOfRangeFillStyle);
        this.setContainedModel("overFlowFillStyle", this.overFlowFillStyle);
        this.setContainedModel("underFlowFillStyle", this.underFlowFillStyle);
        this.setContainedModel("upperThresholdFillStyle", this.upperThresholdFillStyle);
        this.setContainedModel("lowerThresholdFillStyle", this.lowerThresholdFillStyle);
        this.setContainedModel("milestoneMarkerStyle", this.milestoneMarkerStyle);
        this.setContainedModel("initialFillStyle", this.initialFillStyle);
        this.setContainedModel("finalFillStyle", this.finalFillStyle);
        this.setContainedModel("missingFillStyle", this.missingFillStyle);
        this.setContainedModel("discreteStyleMapModel", this.discreteStyleMapModel);
        this.setContainedModel("normalFillStyle", this.normalFillStyle);
        this.setContainedModel("slackFillStyle", this.slackFillStyle);
        this.setContainedModel("criticalFillStyle", this.criticalFillStyle);
        this.setContainedModel("actualFillStyle", this.actualFillStyle);
        this.setContainedModel("baselineFillStyle", this.baselineFillStyle);
        this.setContainedModel("breakTimeFillStyle", this.breakTimeFillStyle);
        this.setContainedModel("resourceFillStyle", this.resourceFillStyle);
        this.setContainedModel("custom1FillStyle", this.custom1FillStyle);
        this.setContainedModel("custom2FillStyle", this.custom2FillStyle);
        this.setContainedModel("targetMarkerStyle", this.targetMarkerStyle);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DataElementStyles arg = (DataElementStyles)obj;
        return Util.Evaluate.isEqual(this.outlineLineStyle, arg.outlineLineStyle) && Util.Evaluate.isEqual(this.connectingLineStyle, arg.connectingLineStyle) && Util.Evaluate.isEqual(this.targetColor, arg.targetColor) && Util.Evaluate.isEqual(this.continuousFillTwoColorStartColor, arg.continuousFillTwoColorStartColor) && Util.Evaluate.isEqual(this.continuousFillTwoColorEndColor, arg.continuousFillTwoColorEndColor) && Util.Evaluate.isEqual(this.continuousFillThreeColorStartColor, arg.continuousFillThreeColorStartColor) && Util.Evaluate.isEqual(this.continuousFillThreeColorEndColor, arg.continuousFillThreeColorEndColor) && Util.Evaluate.isEqual(this.continuousFillThreeColorNeutralColor, arg.continuousFillThreeColorNeutralColor) && Util.Evaluate.isEqual(this.continuousContrastTwoColorStartColor, arg.continuousContrastTwoColorStartColor) && Util.Evaluate.isEqual(this.continuousContrastTwoColorEndColor, arg.continuousContrastTwoColorEndColor) && Util.Evaluate.isEqual(this.continuousContrastThreeColorStartColor, arg.continuousContrastThreeColorStartColor) && Util.Evaluate.isEqual(this.continuousContrastThreeColorEndColor, arg.continuousContrastThreeColorEndColor) && Util.Evaluate.isEqual(this.continuousContrastThreeColorNeutralColor, arg.continuousContrastThreeColorNeutralColor) && Util.Evaluate.isEqual(this.dataFillStyles, arg.dataFillStyles) && Util.Evaluate.isEqual(this.dataLineStyles, arg.dataLineStyles) && Util.Evaluate.isEqual(this.dataMarkerStyles, arg.dataMarkerStyles) && Util.Evaluate.isEqual(this.discreteFillColors, arg.discreteFillColors) && Util.Evaluate.isEqual(this.continuousColorSpectrum, arg.continuousColorSpectrum) && Util.Evaluate.isEqual(this.errorFillStyles, arg.errorFillStyles) && Util.Evaluate.isEqual(this.errorLineStyles, arg.errorLineStyles) && Util.Evaluate.isEqual(this.errorMarkerStyles, arg.errorMarkerStyles) && Util.Evaluate.isEqual(this.otherFillStyle, arg.otherFillStyle) && Util.Evaluate.isEqual(this.missingFillStyle, arg.missingFillStyle) && Util.Evaluate.isEqual(this.outOfRangeFillStyle, arg.outOfRangeFillStyle) && Util.Evaluate.isEqual(this.overFlowFillStyle, arg.overFlowFillStyle) && Util.Evaluate.isEqual(this.underFlowFillStyle, arg.underFlowFillStyle) && Util.Evaluate.isEqual(this.upperThresholdFillStyle, arg.upperThresholdFillStyle) && Util.Evaluate.isEqual(this.lowerThresholdFillStyle, arg.lowerThresholdFillStyle) && Util.Evaluate.isEqual(this.milestoneMarkerStyle, arg.milestoneMarkerStyle) && Util.Evaluate.isEqual(this.initialFillStyle, arg.initialFillStyle) && Util.Evaluate.isEqual(this.finalFillStyle, arg.finalFillStyle) && Util.Evaluate.isEqual(this.discreteStyleMapModel, arg.discreteStyleMapModel) && Util.Evaluate.isEqual(this.normalFillStyle, arg.normalFillStyle) && Util.Evaluate.isEqual(this.slackFillStyle, arg.slackFillStyle) && Util.Evaluate.isEqual(this.criticalFillStyle, arg.criticalFillStyle) && Util.Evaluate.isEqual(this.actualFillStyle, arg.actualFillStyle) && Util.Evaluate.isEqual(this.resourceFillStyle, arg.resourceFillStyle) && Util.Evaluate.isEqual(this.custom1FillStyle, arg.custom1FillStyle) && Util.Evaluate.isEqual(this.custom2FillStyle, arg.custom2FillStyle) && Util.Evaluate.isEqual(this.baselineFillStyle, arg.baselineFillStyle) && Util.Evaluate.isEqual(this.breakTimeFillStyle, arg.breakTimeFillStyle) && super.equals(arg);
    }

    public void setFillStyles(FillStyle[] newFillStyles) throws IllegalArgumentException {
        int ii;
        if (newFillStyles == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newFillStyles.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        for (ii = 0; ii < newFillStyles.length; ++ii) {
            if (newFillStyles[ii] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        for (ii = 0; ii < this.dataFillStyles.length; ++ii) {
            this.setContainedModel("dataFillStyle" + ii, null);
        }
        FillStyle[] oldDataFillStyles = this.dataFillStyles;
        this.dataFillStyles = new FillStyle[newFillStyles.length];
        System.arraycopy(newFillStyles, 0, this.dataFillStyles, 0, this.dataFillStyles.length);
        for (int ii2 = 0; ii2 < this.dataFillStyles.length; ++ii2) {
            this.setContainedModel("dataFillStyle" + ii2, this.dataFillStyles[ii2]);
        }
        this.firePropertyChange("dataFillStyles", oldDataFillStyles, newFillStyles);
    }

    public FillStyle[] getFillStyles() {
        FillStyle[] dataFillStylesCopy = new FillStyle[this.dataFillStyles.length];
        System.arraycopy(this.dataFillStyles, 0, dataFillStylesCopy, 0, dataFillStylesCopy.length);
        return dataFillStylesCopy;
    }

    public void setLineStyles(StrokeLineStyle[] newLineStyles) throws IllegalArgumentException {
        int ii;
        if (newLineStyles == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newLineStyles.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        for (ii = 0; ii < newLineStyles.length; ++ii) {
            if (newLineStyles[ii] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        for (ii = 0; ii < this.dataLineStyles.length; ++ii) {
            if (this.dataLineStyles[ii] == null) continue;
            this.setContainedModel("dataLineStyle" + ii, null);
        }
        StrokeLineStyle[] oldLineStyles = this.dataLineStyles;
        this.dataLineStyles = new StrokeLineStyle[newLineStyles.length];
        System.arraycopy(newLineStyles, 0, this.dataLineStyles, 0, this.dataLineStyles.length);
        for (int ii2 = 0; ii2 < this.dataLineStyles.length; ++ii2) {
            this.setContainedModel("dataLineStyle" + ii2, this.dataLineStyles[ii2]);
        }
        this.firePropertyChange("dataLineStyles", oldLineStyles, newLineStyles);
    }

    public StrokeLineStyle[] getLineStyles() {
        StrokeLineStyle[] dataLineStylesCopy = new StrokeLineStyle[this.dataLineStyles.length];
        System.arraycopy(this.dataLineStyles, 0, dataLineStylesCopy, 0, dataLineStylesCopy.length);
        return dataLineStylesCopy;
    }

    public void setMarkerStyles(MarkerStyle[] newMarkerStyles) throws IllegalArgumentException {
        int ii;
        if (newMarkerStyles == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newMarkerStyles.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        for (ii = 0; ii < newMarkerStyles.length; ++ii) {
            if (newMarkerStyles[ii] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        for (ii = 0; ii < this.dataMarkerStyles.length; ++ii) {
            if (this.dataMarkerStyles[ii] == null) continue;
            this.setContainedModel("dataMarkerStyle" + ii, null);
        }
        MarkerStyle[] oldDataMarkerStyles = this.dataMarkerStyles;
        this.dataMarkerStyles = new MarkerStyle[newMarkerStyles.length];
        System.arraycopy(newMarkerStyles, 0, this.dataMarkerStyles, 0, this.dataMarkerStyles.length);
        for (int ii2 = 0; ii2 < this.dataMarkerStyles.length; ++ii2) {
            this.setContainedModel("dataMarkerStyle" + ii2, this.dataMarkerStyles[ii2]);
        }
        this.firePropertyChange("dataMarkerStyles", oldDataMarkerStyles, newMarkerStyles);
    }

    public MarkerStyle[] getMarkerStyles() {
        MarkerStyle[] dataMarkerStylesCopy = new MarkerStyle[this.dataMarkerStyles.length];
        System.arraycopy(this.dataMarkerStyles, 0, dataMarkerStylesCopy, 0, dataMarkerStylesCopy.length);
        return dataMarkerStylesCopy;
    }

    public void setErrorFillStyles(FillStyle[] newFillStyles) throws IllegalArgumentException {
        int ii;
        if (newFillStyles == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newFillStyles.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        for (ii = 0; ii < newFillStyles.length; ++ii) {
            if (newFillStyles[ii] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        for (ii = 0; ii < this.errorFillStyles.length; ++ii) {
            this.setContainedModel("errorFillStyle" + ii, null);
        }
        FillStyle[] oldFillStyles = this.errorFillStyles;
        this.errorFillStyles = new FillStyle[newFillStyles.length];
        System.arraycopy(newFillStyles, 0, this.errorFillStyles, 0, this.errorFillStyles.length);
        for (int ii2 = 0; ii2 < this.errorFillStyles.length; ++ii2) {
            this.setContainedModel("errorFillStyles" + ii2, this.errorFillStyles[ii2]);
        }
        this.firePropertyChange("errorFillStyles", oldFillStyles, newFillStyles);
    }

    public FillStyle[] getErrorFillStyles() {
        FillStyle[] errorFillStylesCopy = new FillStyle[this.errorFillStyles.length];
        System.arraycopy(this.errorFillStyles, 0, errorFillStylesCopy, 0, errorFillStylesCopy.length);
        return errorFillStylesCopy;
    }

    public void setErrorLineStyles(StrokeLineStyle[] newLineStyles) throws IllegalArgumentException {
        int ii;
        if (newLineStyles == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newLineStyles.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        for (ii = 0; ii < newLineStyles.length; ++ii) {
            if (newLineStyles[ii] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        for (ii = 0; ii < this.errorLineStyles.length; ++ii) {
            if (this.errorLineStyles[ii] == null) continue;
            this.setContainedModel("errorLineStyles" + ii, null);
        }
        StrokeLineStyle[] oldLineStyles = this.errorLineStyles;
        this.errorLineStyles = new StrokeLineStyle[newLineStyles.length];
        System.arraycopy(newLineStyles, 0, this.errorLineStyles, 0, this.errorLineStyles.length);
        for (int ii2 = 0; ii2 < this.errorLineStyles.length; ++ii2) {
            this.setContainedModel("errorLineStyles" + ii2, this.errorLineStyles[ii2]);
        }
        this.firePropertyChange("errorLineStyles", oldLineStyles, newLineStyles);
    }

    public StrokeLineStyle[] getErrorLineStyles() {
        StrokeLineStyle[] errorLineStylesCopy = new StrokeLineStyle[this.errorLineStyles.length];
        System.arraycopy(this.errorLineStyles, 0, errorLineStylesCopy, 0, errorLineStylesCopy.length);
        return errorLineStylesCopy;
    }

    public void setErrorMarkerStyles(MarkerStyle[] newMarkerStyles) throws IllegalArgumentException {
        int ii;
        if (newMarkerStyles == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newMarkerStyles.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        for (ii = 0; ii < newMarkerStyles.length; ++ii) {
            if (newMarkerStyles[ii] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        for (ii = 0; ii < this.errorMarkerStyles.length; ++ii) {
            if (this.errorMarkerStyles[ii] == null) continue;
            this.setContainedModel("errorMarkerStyles" + ii, null);
        }
        MarkerStyle[] oldDataMarkerStyles = this.errorMarkerStyles;
        this.errorMarkerStyles = new MarkerStyle[newMarkerStyles.length];
        System.arraycopy(newMarkerStyles, 0, this.errorMarkerStyles, 0, this.errorMarkerStyles.length);
        for (int ii2 = 0; ii2 < this.errorMarkerStyles.length; ++ii2) {
            this.setContainedModel("errorMarkerStyles" + ii2, this.errorMarkerStyles[ii2]);
        }
        this.firePropertyChange("errorMarkerStyles", oldDataMarkerStyles, newMarkerStyles);
    }

    public MarkerStyle[] getErrorMarkerStyles() {
        MarkerStyle[] errorMarkerStylesCopy = new MarkerStyle[this.errorMarkerStyles.length];
        System.arraycopy(this.errorMarkerStyles, 0, errorMarkerStylesCopy, 0, errorMarkerStylesCopy.length);
        return errorMarkerStylesCopy;
    }

    public LineStyle getOutlineLineStyle() {
        return this.outlineLineStyle;
    }

    public void setOutlineLineStyle(LineStyle newOutlineLineStyle) throws IllegalArgumentException {
        if (newOutlineLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldOutlineLineStyle = this.outlineLineStyle;
        this.outlineLineStyle = newOutlineLineStyle;
        this.firePropertyChange("outlineLineStyle", oldOutlineLineStyle, newOutlineLineStyle);
    }

    public LineStyle getConnectingLineStyle() {
        return this.connectingLineStyle;
    }

    public void setConnectingLineStyle(LineStyle newConnectingLineStyle) throws IllegalArgumentException {
        if (newConnectingLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldConnectingLineStyle = this.connectingLineStyle;
        this.connectingLineStyle = newConnectingLineStyle;
        this.firePropertyChange("connectingLineStyle", oldConnectingLineStyle, newConnectingLineStyle);
    }

    public void setTargetColor(Color newTargetColor) throws IllegalArgumentException {
        if (newTargetColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldValue = this.targetColor;
        this.targetColor = newTargetColor;
        this.firePropertyChange("targetColor", oldValue, this.targetColor);
    }

    public Color getTargetColor() {
        return this.targetColor;
    }

    public void setTargetMarkerStyle(MarkerStyle newMarkerStyle) throws IllegalArgumentException {
        if (newMarkerStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        MarkerStyle oldMarkerStyle = this.targetMarkerStyle;
        this.targetMarkerStyle = newMarkerStyle;
        this.firePropertyChange("targetMarkerStyle", oldMarkerStyle, this.targetMarkerStyle);
    }

    public MarkerStyle getTargetMarkerStyle() {
        return this.targetMarkerStyle;
    }

    public void setContinuousFillTwoColorStartColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousFillTwoColorStartColor;
        this.continuousFillTwoColorStartColor = newColor;
        this.firePropertyChange("continuousFillTwoColorStartColor", oldColor, newColor);
    }

    public Color getContinuousFillTwoColorStartColor() {
        return this.continuousFillTwoColorStartColor;
    }

    public void setContinuousFillTwoColorEndColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousFillTwoColorEndColor;
        this.continuousFillTwoColorEndColor = newColor;
        this.firePropertyChange("continuousFillTwoColorEndColor", oldColor, newColor);
    }

    public Color getContinuousFillTwoColorEndColor() {
        return this.continuousFillTwoColorEndColor;
    }

    public void setContinuousFillThreeColorStartColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousFillThreeColorStartColor;
        this.continuousFillThreeColorStartColor = newColor;
        this.firePropertyChange("continuousFillThreeColorStartColor", oldColor, newColor);
    }

    public Color getContinuousFillThreeColorStartColor() {
        return this.continuousFillThreeColorStartColor;
    }

    public void setContinuousFillThreeColorEndColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousFillThreeColorEndColor;
        this.continuousFillThreeColorEndColor = newColor;
        this.firePropertyChange("continuousFillThreeColorEndColor", oldColor, newColor);
    }

    public Color getContinuousFillThreeColorEndColor() {
        return this.continuousFillThreeColorEndColor;
    }

    public void setContinuousFillThreeColorNeutralColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousFillThreeColorNeutralColor;
        this.continuousFillThreeColorNeutralColor = newColor;
        this.firePropertyChange("continuousFillThreeColorNeutralColor", oldColor, newColor);
    }

    public Color getContinuousFillThreeColorNeutralColor() {
        return this.continuousFillThreeColorNeutralColor;
    }

    public void setContinuousContrastTwoColorStartColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousContrastTwoColorStartColor;
        this.continuousContrastTwoColorStartColor = newColor;
        this.firePropertyChange("continuousContrastTwoColorStartColor", oldColor, newColor);
    }

    public Color getContinuousContrastTwoColorStartColor() {
        return this.continuousContrastTwoColorStartColor;
    }

    public void setContinuousContrastTwoColorEndColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousContrastTwoColorEndColor;
        this.continuousContrastTwoColorEndColor = newColor;
        this.firePropertyChange("continuousContrastTwoColorEndColor", oldColor, newColor);
    }

    public Color getContinuousContrastTwoColorEndColor() {
        return this.continuousContrastTwoColorEndColor;
    }

    public void setContinuousContrastThreeColorStartColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousContrastThreeColorStartColor;
        this.continuousContrastThreeColorStartColor = newColor;
        this.firePropertyChange("continuousContrastThreeColorStartColor", oldColor, newColor);
    }

    public Color getContinuousContrastThreeColorStartColor() {
        return this.continuousContrastThreeColorStartColor;
    }

    public void setContinuousContrastThreeColorEndColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousContrastThreeColorEndColor;
        this.continuousContrastThreeColorEndColor = newColor;
        this.firePropertyChange("continuousContrastThreeColorEndColor", oldColor, newColor);
    }

    public Color getContinuousContrastThreeColorEndColor() {
        return this.continuousContrastThreeColorEndColor;
    }

    public void setContinuousContrastThreeColorNeutralColor(Color newColor) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.continuousContrastThreeColorNeutralColor;
        this.continuousContrastThreeColorNeutralColor = newColor;
        this.firePropertyChange("continuousContrastThreeColorNeutralColor", oldColor, newColor);
    }

    public Color getContinuousContrastThreeColorNeutralColor() {
        return this.continuousContrastThreeColorNeutralColor;
    }

    public void setDiscreteStyleMapModel(DiscreteStyleMapModel newStyleMapModel) {
        if (newStyleMapModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        DiscreteStyleMapModel oldStyleMapModel = this.discreteStyleMapModel;
        this.discreteStyleMapModel = newStyleMapModel;
        this.firePropertyChange("discreteStyleMapModel", oldStyleMapModel, this.discreteStyleMapModel);
    }

    public DiscreteStyleMapModel getDiscreteStyleMapModel() {
        return this.discreteStyleMapModel;
    }

    public void setOtherFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.otherFillStyle;
        this.otherFillStyle = newFillStyle;
        this.firePropertyChange("otherFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getOtherFillStyle() {
        return this.otherFillStyle;
    }

    public void setMissingFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.missingFillStyle;
        this.missingFillStyle = newFillStyle;
        this.firePropertyChange("missingFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getMissingFillStyle() {
        return this.missingFillStyle;
    }

    public void setOutOfRangeFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.outOfRangeFillStyle;
        this.outOfRangeFillStyle = newFillStyle;
        this.firePropertyChange("outOfRangeFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getOutOfRangeFillStyle() {
        return this.outOfRangeFillStyle;
    }

    public void setOverFlowFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.overFlowFillStyle;
        this.overFlowFillStyle = newFillStyle;
        this.firePropertyChange("overFlowFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getOverFlowFillStyle() {
        return this.overFlowFillStyle;
    }

    public void setUnderFlowFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.underFlowFillStyle;
        this.underFlowFillStyle = newFillStyle;
        this.firePropertyChange("underFlowFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getUnderFlowFillStyle() {
        return this.underFlowFillStyle;
    }

    public void setUpperThresholdFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.upperThresholdFillStyle;
        this.upperThresholdFillStyle = newFillStyle;
        this.firePropertyChange("upperThresholdFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getUpperThresholdFillStyle() {
        return this.upperThresholdFillStyle;
    }

    public void setLowerThresholdFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.lowerThresholdFillStyle;
        this.lowerThresholdFillStyle = newFillStyle;
        this.firePropertyChange("lowerThresholdFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getLowerThresholdFillStyle() {
        return this.lowerThresholdFillStyle;
    }

    public void setMilestoneMarkerStyle(MarkerStyle newMarkerStyle) throws IllegalArgumentException {
        if (newMarkerStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        MarkerStyle oldMarkerStyle = this.milestoneMarkerStyle;
        this.milestoneMarkerStyle = newMarkerStyle;
        this.firePropertyChange("milestoneMarkerStyle", oldMarkerStyle, this.milestoneMarkerStyle);
    }

    public MarkerStyle getMilestoneMarkerStyle() {
        return this.milestoneMarkerStyle;
    }

    public void setNormalFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.normalFillStyle;
        this.normalFillStyle = newFillStyle;
        this.firePropertyChange("normalFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getNormalFillStyle() {
        return this.normalFillStyle;
    }

    public void setSlackFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.slackFillStyle;
        this.slackFillStyle = newFillStyle;
        this.firePropertyChange("slackFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getSlackFillStyle() {
        return this.slackFillStyle;
    }

    public void setCriticalFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.criticalFillStyle;
        this.criticalFillStyle = newFillStyle;
        this.firePropertyChange("criticalFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getCriticalFillStyle() {
        return this.criticalFillStyle;
    }

    public void setResourceFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.resourceFillStyle;
        this.resourceFillStyle = newFillStyle;
        this.firePropertyChange("resourceFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getResourceFillStyle() {
        return this.resourceFillStyle;
    }

    public void setCustomSchedule1FillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.custom1FillStyle;
        this.custom1FillStyle = newFillStyle;
        this.firePropertyChange("custom1FillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getCustomSchedule1FillStyle() {
        return this.custom1FillStyle;
    }

    public void setCustomSchedule2FillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.custom2FillStyle;
        this.custom2FillStyle = newFillStyle;
        this.firePropertyChange("custom2FillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getCustomSchedule2FillStyle() {
        return this.custom2FillStyle;
    }

    public void setActualFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.actualFillStyle;
        this.actualFillStyle = newFillStyle;
        this.firePropertyChange("actualFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getActualFillStyle() {
        return this.actualFillStyle;
    }

    public void setBaselineFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.baselineFillStyle;
        this.baselineFillStyle = newFillStyle;
        this.firePropertyChange("baselineFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getBaselineFillStyle() {
        return this.baselineFillStyle;
    }

    public void setBreakTimeFillStyle(FillStyle newBreakTimeFillStyle) {
        if (newBreakTimeFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.breakTimeFillStyle;
        this.breakTimeFillStyle = newBreakTimeFillStyle;
        this.firePropertyChange("breakTimeFillStyle", oldFillStyle, newBreakTimeFillStyle);
    }

    public FillStyle getBreakTimeFillStyle() {
        return this.breakTimeFillStyle;
    }

    public void setInitialFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.initialFillStyle;
        this.initialFillStyle = newFillStyle;
        this.firePropertyChange("initialFillStyle", oldFillStyle, this.initialFillStyle);
    }

    public FillStyle getInitialFillStyle() {
        return this.initialFillStyle;
    }

    public void setFinalFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldFillStyle = this.finalFillStyle;
        this.finalFillStyle = newFillStyle;
        this.firePropertyChange("finalFillStyle", oldFillStyle, this.finalFillStyle);
    }

    public FillStyle getFinalFillStyle() {
        return this.finalFillStyle;
    }

    public void setDiscreteFillColors(Color[] newColors) {
        if (newColors == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (newColors.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        for (int ii = 0; ii < newColors.length; ++ii) {
            if (newColors[ii] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        Color[] oldDiscreteFillColors = this.discreteFillColors;
        this.discreteFillColors = new Color[newColors.length];
        System.arraycopy(newColors, 0, this.discreteFillColors, 0, this.discreteFillColors.length);
        this.firePropertyChange("discreteFillColors", oldDiscreteFillColors, newColors);
    }

    public Color[] getDiscreteFillColors() {
        Color[] discreteFillColorsCopy = new Color[this.discreteFillColors.length];
        System.arraycopy(this.discreteFillColors, 0, discreteFillColorsCopy, 0, discreteFillColorsCopy.length);
        return discreteFillColorsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuousColorSpectrum(ColorPosition[] newColorSpectrum) {
        if (newColorSpectrum == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ColorPosition[] colorPositionArray = this.continuousColorSpectrum;
        synchronized (this.continuousColorSpectrum) {
            if (newColorSpectrum.length < 1) {
                String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(1.0).toString(), (Object)new Double(0.0).toString());
                throw new IllegalArgumentException(message);
            }
            if (newColorSpectrum.length == 1) {
                Color cc = newColorSpectrum[0].getColor();
                newColorSpectrum = new ColorPosition[]{new ColorPosition(cc, 0.0), new ColorPosition(cc, 1.0)};
            }
            if (newColorSpectrum[0] == null || newColorSpectrum[newColorSpectrum.length - 1] == null) {
                throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
            }
            double firstPosition = newColorSpectrum[0].getPosition();
            double lastPosition = newColorSpectrum[newColorSpectrum.length - 1].getPosition();
            if (Double.isNaN(firstPosition) || Double.isNaN(lastPosition)) {
                throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
            }
            boolean sameAsPrevious = false;
            double previousPosition = newColorSpectrum[0].getPosition();
            for (int ii = 1; ii < newColorSpectrum.length; ++ii) {
                if (newColorSpectrum[ii] == null) {
                    throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
                }
                double position = newColorSpectrum[ii].getPosition();
                if (Double.isNaN(position)) {
                    throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
                }
                if (position < previousPosition) {
                    throw new IllegalArgumentException(RB.getStringResource("invalidRangeOrder.ex.txt"));
                }
                if (position == previousPosition) {
                    if (sameAsPrevious) {
                        throw new IllegalArgumentException(RB.getStringResource("invalidReplicatedRangeValue.ex.txt"));
                    }
                    sameAsPrevious = true;
                } else {
                    sameAsPrevious = false;
                }
                previousPosition = position;
            }
            ColorPosition[] oldContinuousColorSpectrum = this.continuousColorSpectrum;
            this.continuousColorSpectrum = new ColorPosition[newColorSpectrum.length];
            System.arraycopy(newColorSpectrum, 0, this.continuousColorSpectrum, 0, this.continuousColorSpectrum.length);
            this.firePropertyChange("continuousColorSpectrum", oldContinuousColorSpectrum, this.continuousColorSpectrum);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ColorPosition[] getContinuousColorSpectrum() {
        ColorPosition[] continuousColorSpectrumCopy = new ColorPosition[this.continuousColorSpectrum.length];
        System.arraycopy(this.continuousColorSpectrum, 0, continuousColorSpectrumCopy, 0, continuousColorSpectrumCopy.length);
        return continuousColorSpectrumCopy;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    private FillStyle[] apply(String id, FillStyle[] from, FillStyle[] to) {
        block7: {
            if (from == null || to == null) break block7;
            if (from.length == to.length) {
                for (int ii = 0; ii < to.length; ++ii) {
                    to[ii].apply(from[ii]);
                }
            } else {
                int ii;
                FillStyle[] old_to = to;
                to = new FillStyle[from.length];
                for (ii = 0; ii < to.length; ++ii) {
                    if (ii < old_to.length) {
                        to[ii] = old_to[ii];
                    } else {
                        to[ii] = new FillStyle();
                        this.setContainedModel(id + ii, to[ii]);
                    }
                    to[ii].apply(from[ii]);
                }
                for (ii = to.length; ii < old_to.length; ++ii) {
                    this.setContainedModel(id + ii, null);
                }
            }
        }
        return to;
    }

    private StrokeLineStyle[] apply(String id, StrokeLineStyle[] from, StrokeLineStyle[] to) {
        block7: {
            if (from == null || to == null) break block7;
            if (from.length == to.length) {
                for (int ii = 0; ii < to.length; ++ii) {
                    to[ii].apply(from[ii]);
                }
            } else {
                int ii;
                StrokeLineStyle[] old_to = to;
                to = new StrokeLineStyle[from.length];
                for (ii = 0; ii < to.length; ++ii) {
                    if (ii < old_to.length) {
                        to[ii] = old_to[ii];
                    } else {
                        to[ii] = new StrokeLineStyle();
                        this.setContainedModel(id + ii, to[ii]);
                    }
                    to[ii].apply(from[ii]);
                }
                for (ii = to.length; ii < old_to.length; ++ii) {
                    this.setContainedModel(id + ii, null);
                }
            }
        }
        return to;
    }

    private MarkerStyle[] apply(String id, MarkerStyle[] from, MarkerStyle[] to) {
        block7: {
            if (from == null || to == null) break block7;
            if (from.length == to.length) {
                for (int ii = 0; ii < to.length; ++ii) {
                    to[ii].apply(from[ii]);
                }
            } else {
                int ii;
                MarkerStyle[] old_to = to;
                to = new MarkerStyle[from.length];
                for (ii = 0; ii < to.length; ++ii) {
                    if (ii < old_to.length) {
                        to[ii] = old_to[ii];
                    } else {
                        to[ii] = new MarkerStyle();
                        this.setContainedModel(id + ii, to[ii]);
                    }
                    to[ii].apply(from[ii]);
                }
                for (ii = to.length; ii < old_to.length; ++ii) {
                    this.setContainedModel(id + ii, null);
                }
            }
        }
        return to;
    }
}

