/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.text.Message;
import java.awt.Color;

@SASScope(value="ALL")
public class DataElementColors
extends ModelBase {
    private static final Color[] DEFAULT_DISCRETE_FILL_COLORS = new Color[]{new Color(97, 115, 169), new Color(141, 166, 66), new Color(152, 52, 28), new Color(253, 200, 97), new Color(138, 164, 201), new Color(111, 117, 0), new Color(184, 127, 50), new Color(214, 198, 110), new Color(94, 82, 139), new Color(103, 153, 32), new Color(200, 87, 60), new Color(127, 89, 52)};
    private static final Color[] DEFAULT_DISCRETE_CONTRAST_COLORS = new Color[]{new Color(228, 26, 28), new Color(55, 126, 184), new Color(255, 127, 0), new Color(166, 86, 40), new Color(77, 175, 74), new Color(152, 78, 163), new Color(127, 127, 127), new Color(185, 150, 0), new Color(0, 127, 0), new Color(225, 0, 191), new Color(80, 80, 204), new Color(255, 102, 127)};
    private Color[] discreteFillColors;
    private Color continuousFillTwoColorStartColor = Color.green;
    private Color continuousFillTwoColorEndColor = Color.red;
    private Color continuousFillThreeColorStartColor = Color.blue;
    private Color continuousFillThreeColorNeutralColor = Color.white;
    private Color continuousFillThreeColorEndColor = Color.orange;
    private ColorPosition[] continuousColorSpectrum = new ColorPosition[]{new ColorPosition(this.continuousFillThreeColorStartColor, 0.0), new ColorPosition(this.continuousFillThreeColorNeutralColor, 0.5), new ColorPosition(this.continuousFillThreeColorEndColor, 1.0)};
    private Color[] discreteContrastColors;
    private Color continuousContrastTwoColorStartColor = Color.blue;
    private Color continuousContrastTwoColorEndColor = Color.orange;
    private Color continuousContrastThreeColorStartColor = Color.red;
    private Color continuousContrastThreeColorNeutralColor = Color.white;
    private Color continuousContrastThreeColorEndColor = Color.green;
    private Color outlineColor = Color.black;
    private Color connectingLineColor = Color.black;
    private Color errorColor = Color.red;
    private Color otherColor = Color.yellow;
    private Color outOfRangeColor = Color.red;
    private Color overFlowColor = Color.red;
    private Color underFlowColor = Color.blue;
    private Color thresholdColor = Color.pink;
    private Color milestoneColor = Color.black;
    private Color initialColor = Color.gray;
    private Color finalColor = Color.gray;
    private Color targetColor = Color.black;
    private Color missingColor = Color.lightGray;
    private Color normalColor = new Color(175, 193, 122);
    private Color slackColor = new Color(242, 229, 157);
    private Color criticalColor = new Color(218, 123, 123);
    private Color actualColor = new Color(156, 167, 199);
    private Color customColor1 = new Color(226, 242, 119);
    private Color customColor2 = new Color(192, 192, 192);
    private Color baselineColor = new Color(195, 210, 213);
    private Color resourceColor = new Color(171, 145, 169);
    private Color breakTimeColor = new Color(102, 102, 102);

    public DataElementColors() {
        this(null, null, null);
    }

    public DataElementColors(Color[] fillColors, Color[] contrastColors, Color outline) {
        this.disablePropertyChange();
        this.discreteFillColors = fillColors != null ? fillColors : this.newColorArray(DEFAULT_DISCRETE_FILL_COLORS);
        this.discreteContrastColors = contrastColors != null ? contrastColors : this.newColorArray(DEFAULT_DISCRETE_CONTRAST_COLORS);
        if (outline != null) {
            this.outlineColor = outline;
        }
        this.enablePropertyChange();
    }

    private Color[] newColorArray(Color[] colors) {
        if (colors == null) {
            return null;
        }
        Color[] newColors = new Color[colors.length];
        System.arraycopy(colors, 0, newColors, 0, colors.length);
        return newColors;
    }

    public void setDiscreteFillColors(Color[] newColors) {
        if (newColors != null) {
            Color[] oldColors = this.discreteFillColors;
            this.discreteFillColors = new Color[newColors.length];
            System.arraycopy(newColors, 0, this.discreteFillColors, 0, this.discreteFillColors.length);
            this.firePropertyChange("discreteFillColors", oldColors, this.discreteFillColors);
        }
    }

    public Color[] getDiscreteFillColors() {
        Color[] discreteFillColorsCopy = new Color[this.discreteFillColors.length];
        System.arraycopy(this.discreteFillColors, 0, discreteFillColorsCopy, 0, discreteFillColorsCopy.length);
        return discreteFillColorsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContinuousColorSpectrum(ColorPosition[] newColorSpectrum) throws IllegalArgumentException {
        if (newColorSpectrum == null) return;
        ColorPosition[] colorPositionArray = this.continuousColorSpectrum;
        synchronized (this.continuousColorSpectrum) {
            if (newColorSpectrum.length < 2) {
                String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(1.0).toString(), (Object)new Double(0.0).toString());
                throw new IllegalArgumentException(message);
            }
            if (newColorSpectrum[0] == null || newColorSpectrum[newColorSpectrum.length - 1] == null) {
                throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
            }
            double firstPosition = newColorSpectrum[0].getPosition();
            double lastPosition = newColorSpectrum[newColorSpectrum.length - 1].getPosition();
            if (Double.isNaN(firstPosition) || Double.isNaN(firstPosition)) {
                throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
            }
            if (firstPosition != 0.0 || lastPosition != 1.0) {
                String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(1.0).toString(), (Object)new Double(0.0).toString());
                throw new IllegalArgumentException(message);
            }
            boolean sameAsPrevious = false;
            double previousPosition = newColorSpectrum[0].getPosition();
            for (int ii = 1; ii < newColorSpectrum.length; ++ii) {
                if (newColorSpectrum[ii] == null) {
                    throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
                }
                double position = newColorSpectrum[ii].getPosition();
                if (Double.isNaN(position)) {
                    throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
                }
                if (position < previousPosition) {
                    throw new IllegalArgumentException(RB.getStringResource("invalidRangeOrder.ex.txt"));
                }
                if (position == previousPosition) {
                    if (sameAsPrevious) {
                        throw new IllegalArgumentException(RB.getStringResource("invalidReplicatedRangeValue.ex.txt"));
                    }
                    sameAsPrevious = true;
                } else {
                    sameAsPrevious = false;
                }
                previousPosition = position;
            }
            ColorPosition[] oldContinuousColorSpectrum = this.continuousColorSpectrum;
            this.continuousColorSpectrum = new ColorPosition[newColorSpectrum.length];
            System.arraycopy(newColorSpectrum, 0, this.continuousColorSpectrum, 0, this.continuousColorSpectrum.length);
            this.firePropertyChange("continuousColorSpectrum", oldContinuousColorSpectrum, this.continuousColorSpectrum);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ColorPosition[] getContinuousColorSpectrum() {
        ColorPosition[] continuousColorSpectrumCopy = new ColorPosition[this.continuousColorSpectrum.length];
        System.arraycopy(this.continuousColorSpectrum, 0, continuousColorSpectrumCopy, 0, continuousColorSpectrumCopy.length);
        return continuousColorSpectrumCopy;
    }

    public void setDiscreteContrastColors(Color[] newColors) {
        if (newColors != null) {
            Color[] oldColors = this.discreteContrastColors;
            this.discreteContrastColors = new Color[newColors.length];
            System.arraycopy(newColors, 0, this.discreteContrastColors, 0, this.discreteContrastColors.length);
            this.firePropertyChange("discreteContrastColors", oldColors, this.discreteContrastColors);
        }
    }

    public Color[] getDiscreteContrastColors() {
        Color[] discreteContrastColorsCopy = new Color[this.discreteContrastColors.length];
        System.arraycopy(this.discreteContrastColors, 0, discreteContrastColorsCopy, 0, discreteContrastColorsCopy.length);
        return discreteContrastColorsCopy;
    }

    public void setErrorColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.errorColor;
            this.errorColor = newColor;
            this.firePropertyChange("errorColor", oldColor, newColor);
        }
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setOtherColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.otherColor;
            this.otherColor = newColor;
            this.firePropertyChange("otherColor", oldColor, newColor);
        }
    }

    public Color getOtherColor() {
        return this.otherColor;
    }

    public void setOutOfRangeColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.outOfRangeColor;
            this.outOfRangeColor = newColor;
            this.firePropertyChange("outOfRangeColor", oldColor, newColor);
        }
    }

    public Color getOutOfRangeColor() {
        return this.outOfRangeColor;
    }

    public void setOverFlowColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.overFlowColor;
            this.overFlowColor = newColor;
            this.firePropertyChange("overFlowColor", oldColor, newColor);
        }
    }

    public Color getOverFlowColor() {
        return this.overFlowColor;
    }

    public void setUnderFlowColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.underFlowColor;
            this.underFlowColor = newColor;
            this.firePropertyChange("underFlowColor", oldColor, newColor);
        }
    }

    public Color getUnderFlowColor() {
        return this.underFlowColor;
    }

    public void setThresholdColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.thresholdColor;
            this.thresholdColor = newColor;
            this.firePropertyChange("thresholdColor", oldColor, newColor);
        }
    }

    public Color getThresholdColor() {
        return this.thresholdColor;
    }

    public void setMilestoneColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.milestoneColor;
            this.milestoneColor = newColor;
            this.firePropertyChange("milestoneColor", oldColor, this.milestoneColor);
        }
    }

    public Color getMilestoneColor() {
        return this.milestoneColor;
    }

    public void setInitialColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.initialColor;
            this.initialColor = newColor;
            this.firePropertyChange("initialColor", oldColor, this.initialColor);
        }
    }

    public Color getInitialColor() {
        return this.initialColor;
    }

    public void setNormalColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.normalColor;
            this.normalColor = newColor;
            this.firePropertyChange("normalColor", oldColor, newColor);
        }
    }

    public Color getNormalColor() {
        return this.normalColor;
    }

    public void setSlackColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.slackColor;
            this.slackColor = newColor;
            this.firePropertyChange("slackColor", oldColor, newColor);
        }
    }

    public Color getSlackColor() {
        return this.slackColor;
    }

    public void setCriticalColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.criticalColor;
            this.criticalColor = newColor;
            this.firePropertyChange("criticalColor", oldColor, newColor);
        }
    }

    public Color getCriticalColor() {
        return this.criticalColor;
    }

    public void setActualColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.actualColor;
            this.actualColor = newColor;
            this.firePropertyChange("actualColor", oldColor, newColor);
        }
    }

    public Color getActualColor() {
        return this.actualColor;
    }

    public void setCustomSchedule1Color(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.customColor1;
            this.customColor1 = newColor;
            this.firePropertyChange("customColor1", oldColor, newColor);
        }
    }

    public Color getCustomSchedule1Color() {
        return this.customColor1;
    }

    public void setCustom2Color(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.customColor2;
            this.customColor2 = newColor;
            this.firePropertyChange("customColor2", oldColor, newColor);
        }
    }

    public Color getCustom2Color() {
        return this.customColor2;
    }

    public void setResourceColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.resourceColor;
            this.resourceColor = newColor;
            this.firePropertyChange("resourceColor", oldColor, newColor);
        }
    }

    public Color getResourceColor() {
        return this.resourceColor;
    }

    public void setBaselineColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.baselineColor;
            this.baselineColor = newColor;
            this.firePropertyChange("baselineColor", oldColor, newColor);
        }
    }

    public Color getBaselineColor() {
        return this.baselineColor;
    }

    public void setFinalColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.finalColor;
            this.finalColor = newColor;
            this.firePropertyChange("finalColor", oldColor, this.finalColor);
        }
    }

    public Color getFinalColor() {
        return this.finalColor;
    }

    public void setTargetColor(Color newTargetColor) {
        if (newTargetColor != null) {
            Color oldValue = this.targetColor;
            this.targetColor = newTargetColor;
            this.firePropertyChange("targetColor", oldValue, this.targetColor);
        }
    }

    public Color getBreakTimeColor() {
        return this.breakTimeColor;
    }

    public void setBreakTimeColor(Color newBreakTimeColor) {
        if (newBreakTimeColor != null) {
            Color oldValue = this.breakTimeColor;
            this.breakTimeColor = newBreakTimeColor;
            this.firePropertyChange("targetColor", oldValue, this.breakTimeColor);
        }
    }

    public Color getTargetColor() {
        return this.targetColor;
    }

    public void setMissingColor(Color newMissingColor) {
        if (newMissingColor != null) {
            Color oldValue = this.missingColor;
            this.missingColor = newMissingColor;
            this.firePropertyChange("missingColor", oldValue, this.missingColor);
        }
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setOutlineColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.outlineColor;
            this.outlineColor = newColor;
            this.firePropertyChange("outlineColor", oldColor, newColor);
        }
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setConnectingLineColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.connectingLineColor;
            this.connectingLineColor = newColor;
            this.firePropertyChange("connectingLineColor", oldColor, newColor);
        }
    }

    public Color getConnectingLineColor() {
        return this.connectingLineColor;
    }

    public void setContinuousFillTwoColorStartColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousFillTwoColorStartColor;
            this.continuousFillTwoColorStartColor = newColor;
            this.firePropertyChange("continuousFillTwoColorStartColor", oldColor, newColor);
        }
    }

    public Color getContinuousFillTwoColorStartColor() {
        return this.continuousFillTwoColorStartColor;
    }

    public void setContinuousFillTwoColorEndColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousFillTwoColorEndColor;
            this.continuousFillTwoColorEndColor = newColor;
            this.firePropertyChange("continuousFillTwoColorEndColor", oldColor, newColor);
        }
    }

    public Color getContinuousFillTwoColorEndColor() {
        return this.continuousFillTwoColorEndColor;
    }

    public void setContinuousFillThreeColorStartColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousFillThreeColorStartColor;
            this.continuousFillThreeColorStartColor = newColor;
            this.firePropertyChange("continuousFillThreeColorStartColor", oldColor, newColor);
        }
    }

    public Color getContinuousFillThreeColorStartColor() {
        return this.continuousFillThreeColorStartColor;
    }

    public void setContinuousFillThreeColorEndColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousFillThreeColorEndColor;
            this.continuousFillThreeColorEndColor = newColor;
            this.firePropertyChange("continuousFillThreeColorEndColor", oldColor, newColor);
        }
    }

    public Color getContinuousFillThreeColorEndColor() {
        return this.continuousFillThreeColorEndColor;
    }

    public void setContinuousFillThreeColorNeutralColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousFillThreeColorNeutralColor;
            this.continuousFillThreeColorNeutralColor = newColor;
            this.firePropertyChange("continuousFillThreeColorNeutralColor", oldColor, newColor);
        }
    }

    public Color getContinuousFillThreeColorNeutralColor() {
        return this.continuousFillThreeColorNeutralColor;
    }

    public void setContinuousContrastTwoColorStartColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousContrastTwoColorStartColor;
            this.continuousContrastTwoColorStartColor = newColor;
            this.firePropertyChange("continuousContrastTwoColorStartColor", oldColor, newColor);
        }
    }

    public Color getContinuousContrastTwoColorStartColor() {
        return this.continuousContrastTwoColorStartColor;
    }

    public void setContinuousContrastTwoColorEndColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousContrastTwoColorEndColor;
            this.continuousContrastTwoColorEndColor = newColor;
            this.firePropertyChange("continuousContrastTwoColorEndColor", oldColor, newColor);
        }
    }

    public Color getContinuousContrastTwoColorEndColor() {
        return this.continuousContrastTwoColorEndColor;
    }

    public void setContinuousContrastThreeColorStartColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousContrastThreeColorStartColor;
            this.continuousContrastThreeColorStartColor = newColor;
            this.firePropertyChange("continuousContrastThreeColorStartColor", oldColor, newColor);
        }
    }

    public Color getContinuousContrastThreeColorStartColor() {
        return this.continuousContrastThreeColorStartColor;
    }

    public void setContinuousContrastThreeColorEndColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousContrastThreeColorEndColor;
            this.continuousContrastThreeColorEndColor = newColor;
            this.firePropertyChange("continuousContrastThreeColorEndColor", oldColor, newColor);
        }
    }

    public Color getContinuousContrastThreeColorEndColor() {
        return this.continuousContrastThreeColorEndColor;
    }

    public void setContinuousContrastThreeColorNeutralColor(Color newColor) {
        if (newColor != null) {
            Color oldColor = this.continuousContrastThreeColorNeutralColor;
            this.continuousContrastThreeColorNeutralColor = newColor;
            this.firePropertyChange("continuousContrastThreeColorNeutralColor", oldColor, newColor);
        }
    }

    public Color getContinuousContrastThreeColorNeutralColor() {
        return this.continuousContrastThreeColorNeutralColor;
    }

    public boolean equals(DataElementColors that) {
        return this.colorsEqual(this.outlineColor, that.outlineColor) && this.colorsEqual(this.continuousFillTwoColorStartColor, that.continuousFillTwoColorStartColor) && this.colorsEqual(this.continuousFillTwoColorEndColor, that.continuousFillTwoColorEndColor) && this.colorsEqual(this.continuousFillThreeColorStartColor, that.continuousFillThreeColorStartColor) && this.colorsEqual(this.continuousFillThreeColorEndColor, that.continuousFillThreeColorEndColor) && this.colorsEqual(this.continuousFillThreeColorNeutralColor, that.continuousFillThreeColorNeutralColor) && this.colorArraysEqual(this.discreteFillColors, that.discreteFillColors) && this.colorsEqual(this.continuousContrastTwoColorStartColor, that.continuousContrastTwoColorStartColor) && this.colorsEqual(this.continuousContrastTwoColorEndColor, that.continuousContrastTwoColorEndColor) && this.colorsEqual(this.continuousContrastThreeColorStartColor, that.continuousContrastThreeColorStartColor) && this.colorsEqual(this.continuousContrastThreeColorEndColor, that.continuousContrastThreeColorEndColor) && this.colorsEqual(this.continuousContrastThreeColorNeutralColor, that.continuousContrastThreeColorNeutralColor) && this.colorArraysEqual(this.discreteContrastColors, that.discreteContrastColors) && this.colorsEqual(this.errorColor, that.errorColor) && this.colorsEqual(this.otherColor, that.otherColor) && this.colorsEqual(this.outOfRangeColor, that.outOfRangeColor) && this.colorsEqual(this.overFlowColor, that.overFlowColor) && this.colorsEqual(this.underFlowColor, that.underFlowColor) && this.colorsEqual(this.thresholdColor, that.thresholdColor) && this.colorsEqual(this.milestoneColor, that.milestoneColor) && this.colorsEqual(this.initialColor, that.initialColor) && this.colorsEqual(this.finalColor, that.finalColor) && this.colorsEqual(this.targetColor, that.targetColor) && this.colorsEqual(this.normalColor, that.normalColor) && this.colorsEqual(this.slackColor, that.slackColor) && this.colorsEqual(this.criticalColor, that.criticalColor) && this.colorsEqual(this.actualColor, that.actualColor) && this.colorsEqual(this.baselineColor, that.baselineColor) && this.colorsEqual(this.resourceColor, that.resourceColor) && this.colorsEqual(this.customColor1, that.customColor1) && this.colorsEqual(this.customColor2, that.customColor2) && this.colorsEqual(this.breakTimeColor, that.breakTimeColor) && this.colorPositionArraysEqual(this.continuousColorSpectrum, that.continuousColorSpectrum);
    }

    private boolean colorArraysEqual(Color[] a1, Color[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null || a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (this.colorsEqual(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean colorsEqual(Color c1, Color c2) {
        return c1 == c2 || c1 != null && c2 != null && c1.equals(c2);
    }

    private boolean colorPositionArraysEqual(ColorPosition[] a1, ColorPosition[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null || a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (this.colorPositionEqual(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean colorPositionEqual(ColorPosition c1, ColorPosition c2) {
        return c1 == c2 || c1 != null && c2 != null && c1.equals(c2);
    }
}

