/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class ContentsModel
extends ModelBase {
    private String label = null;
    private boolean visible = true;
    private TextStyle labelTextStyle = new AdvancedTextStyle();
    private TextStyle valueTextStyle = new AdvancedTextStyle();

    public ContentsModel() {
        if (this.labelTextStyle instanceof AdvancedTextStyle) {
            ((AdvancedTextStyle)this.labelTextStyle).setBaselineAngle(Double.NaN);
        }
        if (this.valueTextStyle instanceof AdvancedTextStyle) {
            ((AdvancedTextStyle)this.valueTextStyle).setBaselineAngle(Double.NaN);
        }
        this.setContainedModel("labelTextStyle", this.labelTextStyle);
        this.setContainedModel("valueTextStyle", this.valueTextStyle);
    }

    public void apply(ContentsModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.label = theOtherObject.label;
        this.visible = theOtherObject.visible;
        this.labelTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.labelTextStyle, this.labelTextStyle);
        this.valueTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.valueTextStyle, this.valueTextStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aLabel) {
        String oldValue = this.label;
        this.label = aLabel;
        this.firePropertyChange("label", oldValue, aLabel);
    }

    public void setLabelTextStyle(TextStyle labelTextStyle) throws IllegalArgumentException {
        if (labelTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.labelTextStyle;
        this.labelTextStyle = labelTextStyle;
        this.firePropertyChange("labelTextStyle", oldValue, labelTextStyle);
    }

    public TextStyle getLabelTextStyle() {
        return this.labelTextStyle;
    }

    public void setValueTextStyle(TextStyle valueTextStyle) throws IllegalArgumentException {
        if (valueTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.valueTextStyle;
        this.valueTextStyle = valueTextStyle;
        this.firePropertyChange("valueTextStyle", oldValue, valueTextStyle);
    }

    public TextStyle getValueTextStyle() {
        return this.valueTextStyle;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ContentsModel arg = (ContentsModel)obj;
        return Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.label, arg.label) && Util.Evaluate.isEqual(this.labelTextStyle, arg.labelTextStyle) && Util.Evaluate.isEqual(this.valueTextStyle, arg.valueTextStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

