/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.RB;
import com.sas.util.RBBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.MissingResourceException;

@SASScope(value="ALL")
public class ConstantCollection {
    private final ElementRB elementRB;
    private final String rbKey;
    private final Element[] elements;

    @SASScope
    public ConstantCollection(String rbKey, Element[] elements) {
        this(null, rbKey, elements);
    }

    public ConstantCollection(Class rbClass, Element[] elements) {
        this(rbClass, null, elements);
    }

    public ConstantCollection(Class rbClass, String rbKey, Element[] elements) {
        this.elementRB = new ElementRB(rbClass);
        this.rbKey = rbKey;
        this.elements = elements;
    }

    private int _getIndex(int styleNum) throws IllegalArgumentException {
        if (this.elements != null) {
            for (int ii = 0; ii < this.elements.length; ++ii) {
                if (styleNum != this.elements[ii].toConstant()) continue;
                return ii;
            }
        }
        throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
    }

    public void validate(int styleNum) throws IllegalArgumentException {
        this._getIndex(styleNum);
    }

    public boolean isValid(int styleNum) {
        try {
            this._getIndex(styleNum);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public int[] getConstants() {
        if (this.elements != null) {
            int[] constants = new int[this.elements.length];
            for (int ii = 0; ii < this.elements.length; ++ii) {
                constants[ii] = this.elements[ii].toConstant();
            }
            return constants;
        }
        return null;
    }

    public String[] getNames() {
        if (this.elements != null) {
            String[] strings = new String[this.elements.length];
            for (int ii = 0; ii < this.elements.length; ++ii) {
                strings[ii] = this.elements[ii].toName();
            }
            return strings;
        }
        return null;
    }

    public String[] getJSPAttributes() {
        if (this.elements != null) {
            String[] strings = new String[this.elements.length];
            for (int ii = 0; ii < this.elements.length; ++ii) {
                strings[ii] = this.elements[ii].toJSPAttribute();
            }
            return strings;
        }
        return null;
    }

    private final String toLocalizedName(Element element) {
        if (element == null) {
            return null;
        }
        try {
            return this.rbKey != null ? this.elementRB.getStringResource(this.rbKey, element.toName() + ".txt").trim() : this.elementRB.getStringResource(element.toName() + ".txt").trim();
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String[] getLocalizedNames() {
        if (this.elements != null) {
            String[] localizedStrings = new String[this.elements.length];
            for (int ii = 0; ii < this.elements.length; ++ii) {
                try {
                    localizedStrings[ii] = this.toLocalizedName(this.elements[ii]);
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return localizedStrings;
        }
        return null;
    }

    public String toName(int styleNum) throws IllegalArgumentException {
        int ii = this._getIndex(styleNum);
        return this.elements[ii].toName();
    }

    public String toJSPAttribute(int styleNum) throws IllegalArgumentException {
        int ii = this._getIndex(styleNum);
        return this.elements[ii].toJSPAttribute();
    }

    public String toLocalizedName(int styleNum) throws IllegalArgumentException {
        int ii = this._getIndex(styleNum);
        return this.toLocalizedName(this.elements[ii]);
    }

    public int valueOfName(String name) throws IllegalArgumentException {
        if (name != null && this.elements != null) {
            name = name.trim();
            for (int ii = 0; ii < this.elements.length; ++ii) {
                if (!name.equalsIgnoreCase(this.elements[ii].toName())) continue;
                return this.elements[ii].toConstant();
            }
        }
        throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
    }

    public int valueOfJSPAttribute(String name) throws IllegalArgumentException {
        if (name != null && this.elements != null) {
            name = name.trim();
            for (int ii = 0; ii < this.elements.length; ++ii) {
                if (!this.elements[ii].isJSPAttribute(name)) continue;
                return this.elements[ii].toConstant();
            }
        }
        throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
    }

    public int valueOfLocalizedName(String name) throws IllegalArgumentException {
        if (name != null) {
            name = name.trim();
            for (int ii = 0; ii < this.elements.length; ++ii) {
                try {
                    if (name.equalsIgnoreCase(this.toLocalizedName(this.elements[ii]))) {
                        return this.elements[ii].toConstant();
                    }
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
    }

    @SASScope
    public static class Element {
        private final int constant;
        private final String name;
        private final String JSPAttribute;
        private final String[] JSPAttributes;

        public Element(int constant, String name, String JSPAttribute) {
            this.constant = constant;
            this.name = name;
            this.JSPAttribute = JSPAttribute;
            this.JSPAttributes = null;
        }

        public Element(int constant, String name, String[] JSPAttributes) {
            this.constant = constant;
            this.name = name;
            this.JSPAttribute = null;
            this.JSPAttributes = JSPAttributes;
        }

        private final int toConstant() {
            return this.constant;
        }

        private final String toName() {
            return this.name;
        }

        private final String toJSPAttribute() {
            if (this.JSPAttribute != null) {
                return this.JSPAttribute;
            }
            if (this.JSPAttributes != null && this.JSPAttributes.length > 0) {
                return this.JSPAttributes[0];
            }
            return null;
        }

        private final boolean isJSPAttribute(String someName) {
            if (someName != null) {
                if (this.JSPAttribute != null) {
                    return someName.equalsIgnoreCase(this.JSPAttribute);
                }
                if (this.JSPAttributes != null && this.JSPAttributes.length > 0) {
                    for (int ii = 0; ii < this.JSPAttributes.length; ++ii) {
                        if (!someName.equalsIgnoreCase(this.JSPAttributes[ii])) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    @SASScope
    private static class ElementRB {
        private Class rbClass;

        public ElementRB(Class rbClass) {
            if (rbClass != null && !RBBase.class.isAssignableFrom(rbClass)) {
                rbClass = null;
            }
            this.rbClass = rbClass;
        }

        private String getStringResourceFromDefaultRB(String key) {
            return RB.getStringResource(key);
        }

        private String getStringResourceFromDefaultRB(String classKey, String subKey) {
            return RB.getStringResource(classKey, subKey);
        }

        public String getStringResource(String key) {
            if (this.rbClass == null) {
                return this.getStringResourceFromDefaultRB(key);
            }
            Method m = null;
            try {
                m = this.rbClass.getMethod("getStringResource", String.class);
            }
            catch (NoSuchMethodException e) {
                return this.getStringResourceFromDefaultRB(key);
            }
            catch (SecurityException e) {
                return this.getStringResourceFromDefaultRB(key);
            }
            if (m == null) {
                return this.getStringResourceFromDefaultRB(key);
            }
            try {
                Object o = m.invoke(null, key);
                return o instanceof String ? (String)o : null;
            }
            catch (IllegalAccessException e) {
                return this.getStringResourceFromDefaultRB(key);
            }
            catch (IllegalArgumentException e) {
                return this.getStringResourceFromDefaultRB(key);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof MissingResourceException) {
                    throw (MissingResourceException)e.getTargetException();
                }
                return this.getStringResourceFromDefaultRB(key);
            }
        }

        public String getStringResource(String classKey, String subKey) {
            if (this.rbClass == null) {
                return this.getStringResourceFromDefaultRB(classKey, subKey);
            }
            Method m = null;
            try {
                m = this.rbClass.getMethod("getStringResource", String.class, String.class);
            }
            catch (NoSuchMethodException e) {
                return this.getStringResourceFromDefaultRB(classKey, subKey);
            }
            catch (SecurityException e) {
                return this.getStringResourceFromDefaultRB(classKey, subKey);
            }
            if (m == null) {
                return this.getStringResourceFromDefaultRB(classKey, subKey);
            }
            try {
                Object o = m.invoke(null, classKey, subKey);
                return o instanceof String ? (String)o : null;
            }
            catch (IllegalAccessException e) {
                return this.getStringResourceFromDefaultRB(classKey, subKey);
            }
            catch (IllegalArgumentException e) {
                return this.getStringResourceFromDefaultRB(classKey, subKey);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof MissingResourceException) {
                    throw (MissingResourceException)e.getTargetException();
                }
                return this.getStringResourceFromDefaultRB(classKey, subKey);
            }
        }
    }
}

