/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class ClassificationVariable
extends Variable {
    private final int sort;

    private static int _validateSort(int sort) {
        switch (sort) {
            default: {
                sort = 10400;
            }
            case 10400: 
            case 10401: 
            case 10402: 
            case 10403: 
            case 10404: 
            case 10405: 
            case 10406: 
        }
        return sort;
    }

    public ClassificationVariable(String columnName) {
        super(columnName);
        this.sort = 10400;
    }

    public ClassificationVariable(String columnName, int sort) {
        super(columnName);
        this.sort = ClassificationVariable._validateSort(sort);
    }

    public ClassificationVariable(String columnName, String format) {
        super(columnName, format);
        this.sort = 10400;
    }

    public ClassificationVariable(String columnName, String format, String informat, String label, int sort) {
        this(columnName, format, informat, label, sort, null, null);
    }

    public ClassificationVariable(String columnName, String format, String informat, String label, int sort, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        super(columnName, format, informat, label, categorizationModel, segmentedRangeStyle);
        this.sort = ClassificationVariable._validateSort(sort);
    }

    public ClassificationVariable(int columnIndex) {
        super(columnIndex);
        this.sort = 10400;
    }

    public ClassificationVariable(int columnIndex, String format, String informat, String label, int sort) {
        this(columnIndex, format, informat, label, sort, null, null);
    }

    public ClassificationVariable(int columnIndex, String format, String informat, String label, int sort, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        super(columnIndex, format, informat, label, categorizationModel, segmentedRangeStyle);
        this.sort = ClassificationVariable._validateSort(sort);
    }

    public ClassificationVariable(ClassificationVariable cv) {
        super(cv);
        this.sort = cv == null ? 10400 : cv.getSort();
    }

    public int getSort() {
        return this.sort;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ClassificationVariable arg = (ClassificationVariable)obj;
        return Util.Evaluate.isEqual(this.sort, arg.sort) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

