/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import java.awt.Color;
import java.awt.SystemColor;

@SASScope(value="ALL")
public class CellStyle
extends ModelBase {
    public static final String RB_KEY = "CellStyle.";
    private LineStyle frameLineStyle = new LineStyle(SystemColor.windowBorder, null, 10200);
    private Color[] backgroundColors = new Color[]{SystemColor.window};
    private Color rowSelbackgroundColor = new Color(234, 234, 234, 127);
    private int backgroundVisibilityPolicy = 10200;

    private static Color[] newColorArray(Color[] colors) {
        if (colors == null || colors.length < 1) {
            return null;
        }
        for (int ii = 0; ii < colors.length; ++ii) {
            if (colors[ii] != null) continue;
            return null;
        }
        Color[] newColors = new Color[colors.length];
        System.arraycopy(colors, 0, newColors, 0, colors.length);
        return newColors;
    }

    public void apply(CellStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.backgroundColors = CellStyle.newColorArray(theOtherObject.backgroundColors);
        this.backgroundVisibilityPolicy = theOtherObject.backgroundVisibilityPolicy;
        this.frameLineStyle.apply(theOtherObject.frameLineStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public CellStyle() {
        this.setContainedModel("frameLineStyle", this.frameLineStyle);
    }

    public CellStyle(Color[] backgroundColors, LineStyle frameLineStyle) {
        backgroundColors = CellStyle.newColorArray(backgroundColors);
        if (backgroundColors != null) {
            this.backgroundColors = CellStyle.newColorArray(backgroundColors);
        }
        if (frameLineStyle != null) {
            this.frameLineStyle = frameLineStyle;
        }
        this.setContainedModel("frameLineStyle", frameLineStyle);
    }

    public CellStyle(Color backgroundColor, LineStyle frameLineStyle) {
        this(new Color[]{backgroundColor}, frameLineStyle);
    }

    public void setBackgroundColors(Color[] newColors) throws IllegalArgumentException {
        if ((newColors = CellStyle.newColorArray(newColors)) == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color[] oldBackgroundColors = this.backgroundColors;
        this.backgroundColors = newColors;
        this.firePropertyChange("backgroundColors", oldBackgroundColors, this.backgroundColors);
    }

    public Color[] getBackgroundColors() {
        return CellStyle.newColorArray(this.backgroundColors);
    }

    public void setRowSelectionBackgroundColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldBackgroundColors = this.rowSelbackgroundColor;
        this.rowSelbackgroundColor = newColor;
        this.firePropertyChange("rowSelbackgroundColor", oldBackgroundColors, this.rowSelbackgroundColor);
    }

    public Color getRowSelectionBackgroundColor() {
        return this.rowSelbackgroundColor;
    }

    public void setBackgroundVisibilityPolicy(int newVisibilityPolicy) throws IllegalArgumentException {
        GraphConstants.TRI.validate(newVisibilityPolicy);
        int oldVisibilityPolicy = this.backgroundVisibilityPolicy;
        this.backgroundVisibilityPolicy = newVisibilityPolicy;
        this.firePropertyChange("backgroundVisibilityPolicy", oldVisibilityPolicy, this.backgroundVisibilityPolicy);
    }

    public int getBackgroundVisibilityPolicy() {
        return this.backgroundVisibilityPolicy;
    }

    public void setFrameLineStyle(LineStyle newLineStyle) throws IllegalArgumentException {
        if (newLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldValue = this.frameLineStyle;
        this.frameLineStyle = newLineStyle;
        this.firePropertyChange("frameLineStyle", oldValue, newLineStyle);
    }

    public LineStyle getFrameLineStyle() {
        return this.frameLineStyle;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        CellStyle arg = (CellStyle)obj;
        return Util.Evaluate.isEqual(this.backgroundVisibilityPolicy, arg.backgroundVisibilityPolicy) && Util.Evaluate.isEqual(this.backgroundColors, arg.backgroundColors) && Util.Evaluate.isEqual(this.frameLineStyle, arg.frameLineStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

