/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.util.Util;
import java.text.MessageFormat;

@SASScope
public class CategorizationModel
extends ModelBase {
    private MessageFormat rangeMessageFormat = CategorizationModel.newDefaultRangeMessageFormat();
    private int categorizationType = 10200;
    private int parameter = 0;
    SegmentedRangeModel segmentedRangeModel = null;

    public static final MessageFormat newDefaultRangeMessageFormat() {
        return new MessageFormat("{4}");
    }

    public static final MessageFormat newBoudaryRangeMessageFormat() {
        return new MessageFormat("{0}");
    }

    public static final CategorizationModel newCategorizationModel(SegmentedRangeModel segmentedRangeModel) throws IllegalArgumentException {
        if (segmentedRangeModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        CategorizationModel categorizationModel = new CategorizationModel();
        categorizationModel.setSegmentedRangeModel(segmentedRangeModel);
        categorizationModel.setCategorizationType(10200);
        return categorizationModel;
    }

    public static final CategorizationModel newCategorizationModel(int categorizationType, int parameter) throws IllegalArgumentException {
        return CategorizationModel.newCategorizationModel(categorizationType, parameter, Double.NaN, Double.NaN);
    }

    public static final CategorizationModel newCategorizationModel(int categorizationType, int parameter, double minimum, double maximum) throws IllegalArgumentException {
        if (!(Double.isNaN(minimum) || Double.isNaN(maximum) || Double.isInfinite(minimum) || Double.isInfinite(maximum) || !(maximum < minimum))) {
            throw new IllegalArgumentException(RB.getStringResource("invalidParameterMaximumLessThanMinimumNotAllowed.ex.txt"));
        }
        CategorizationModel categorizationModel = new CategorizationModel();
        categorizationModel.setCategorizationType(categorizationType);
        categorizationModel.setParameter(parameter);
        return categorizationModel;
    }

    public void setParameter(int parameter) {
        if (parameter < 0) {
            throw new IllegalArgumentException(RB.getStringResource("invalidCategorizationParameter.ex.txt"));
        }
        int oldParameter = this.parameter;
        this.parameter = parameter;
        this.firePropertyChange("parameter", oldParameter, this.parameter);
    }

    public int getParameter() {
        return this.parameter;
    }

    public void setCategorizationType(int categorizationType) {
        GraphConstants.CATEGORIZATION.validate(categorizationType);
        int oldCategorizationType = this.categorizationType;
        this.categorizationType = categorizationType;
        this.firePropertyChange("categorizationType", oldCategorizationType, this.categorizationType);
    }

    public int getCategorizationType() {
        return this.categorizationType;
    }

    public void setSegmentedRangeModel(SegmentedRangeModel segmentedRangeModel) {
        SegmentedRangeModel oldSegmentedRangeModel = this.segmentedRangeModel;
        this.segmentedRangeModel = segmentedRangeModel;
        this.firePropertyChange("segmentedRangeModel", oldSegmentedRangeModel, this.segmentedRangeModel);
    }

    public SegmentedRangeModel getSegmentedRangeModel() {
        return this.segmentedRangeModel;
    }

    public void setRangeMessageFormat(MessageFormat rangeMessageFormat) {
        if (rangeMessageFormat == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        MessageFormat oldRangeMessageFormat = this.rangeMessageFormat;
        this.rangeMessageFormat = Util.Copier.copyOf(rangeMessageFormat);
        this.firePropertyChange("rangeMessageFormat", oldRangeMessageFormat, rangeMessageFormat);
    }

    public MessageFormat getRangeMessageFormat() {
        return Util.Copier.copyOf(this.rangeMessageFormat);
    }

    public void apply(CategorizationModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.categorizationType = theOtherObject.categorizationType;
        this.parameter = theOtherObject.parameter;
        this.rangeMessageFormat = Util.Copier.copyOf(theOtherObject.rangeMessageFormat);
        this.disablePropertyChange();
        SegmentedRangeModel srm = this.getSegmentedRangeModel();
        if (theOtherObject.segmentedRangeModel != null) {
            if (srm == null) {
                srm = new SegmentedRangeModel();
            }
            srm.apply(theOtherObject.segmentedRangeModel);
        } else {
            srm = null;
        }
        this.setSegmentedRangeModel(srm);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        CategorizationModel arg = (CategorizationModel)obj;
        return Util.Evaluate.isEqual(this.categorizationType, arg.categorizationType) && Util.Evaluate.isEqual(this.parameter, arg.parameter) && Util.Evaluate.isEqual(this.segmentedRangeModel, arg.segmentedRangeModel) && Util.Evaluate.isEqual(this.rangeMessageFormat, arg.rangeMessageFormat) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

