/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import java.awt.SystemColor;

@SASScope(value="ALL")
public class AxisWallModel
extends ModelBase {
    private FillStyle wallFillStyle = new FillStyle(SystemColor.window);
    private FillStyle floorFillStyle = new FillStyle(SystemColor.window);

    public void apply(AxisWallModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.wallFillStyle.apply(theOtherObject.wallFillStyle);
        this.floorFillStyle.apply(theOtherObject.floorFillStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public AxisWallModel() {
        this.setContainedModel("wallFillStyle", this.wallFillStyle);
        this.setContainedModel("floorFillStyle", this.floorFillStyle);
    }

    public void setWallFillStyle(FillStyle newWallFillStyle) throws IllegalArgumentException {
        if (newWallFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.wallFillStyle;
        this.wallFillStyle = newWallFillStyle;
        this.firePropertyChange("wallFillStyle", oldValue, newWallFillStyle);
    }

    public FillStyle getWallFillStyle() {
        return this.wallFillStyle;
    }

    public void setFloorFillStyle(FillStyle newFillStyle) throws IllegalArgumentException {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.floorFillStyle;
        this.floorFillStyle = newFillStyle;
        this.firePropertyChange("floorFillStyle", oldValue, newFillStyle);
    }

    public FillStyle getFloorFillStyle() {
        return this.floorFillStyle;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AxisWallModel arg = (AxisWallModel)obj;
        return Util.Evaluate.isEqual(this.wallFillStyle, arg.wallFillStyle) && Util.Evaluate.isEqual(this.floorFillStyle, arg.floorFillStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

