/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ContentsModel;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ReferenceBandModel;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TickStyle;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseDistance;
import com.sas.measures.BaseLength;
import java.text.MessageFormat;

@SASScope(value="ALL")
public class AxisModel
extends ContentsModel {
    private static final int DEFAULT_TICK_COUNT = 5;
    private static final int DEFAULT_MINOR_TICK_COUNT = 4;
    private static final int DEFAULT_TICK_ANCHOR = 0;
    private static final double DEFAULT_TICK_INTERVAL = Double.MAX_VALUE;
    private boolean gridInFront = false;
    private BaseLength endOffset;
    private BaseLength startOffset;
    private String[] categories = null;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private String format;
    private boolean reverseDirection = false;
    private boolean drillIconVisible = false;
    private boolean adjustValueMagnitudeEnabled = false;
    private StrokeLineStyle gridLineStyle = new StrokeLineStyle();
    private StrokeLineStyle axisLineStyle = new StrokeLineStyle();
    private ReferenceLineModel[] referenceLineModels = null;
    private ReferenceBandModel[] referenceBandModels = null;
    private int continuousMajorTickPositionPolicy = 10700;
    private int continuousValuePlacementPolicy = 10200;
    private int continuousMajorTickCount = 5;
    private int continuousMinorTickCount = 4;
    private double continuousMajorTickInterval = Double.MAX_VALUE;
    private double continuousMajorTickAnchor = 0.0;
    private int majorTickTimeInterval = 10820;
    private double[] continuousMajorTickValues = null;
    private int labelPlacementPolicy = 10200;
    private int valueFitPolicy = 10200;
    private TickStyle majorTickStyle = new TickStyle();
    private TickStyle minorTickStyle = new TickStyle();
    private MessageFormat rangeMessageFormat = AxisModel.newDefaultRangeMessageFormat();

    private static final MessageFormat newDefaultRangeMessageFormat() {
        return new MessageFormat("{4}");
    }

    public AxisModel() {
        this.setContainedModel("axisLineStyle", this.axisLineStyle);
        this.setContainedModel("gridLineStyle", this.gridLineStyle);
        this.setContainedModel("majorTickStyle", this.majorTickStyle);
        this.setContainedModel("minorTickStyle", this.minorTickStyle);
    }

    public void apply(AxisModel theOtherObject) {
        int ii;
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherObject);
        this.gridInFront = theOtherObject.gridInFront;
        this.endOffset = theOtherObject.endOffset;
        this.startOffset = theOtherObject.startOffset;
        this.min = theOtherObject.min;
        this.max = theOtherObject.max;
        this.drillIconVisible = theOtherObject.drillIconVisible;
        String[] stringArray = this.categories = theOtherObject.categories == null ? null : new String[theOtherObject.categories.length];
        if (this.categories != null) {
            System.arraycopy(theOtherObject.categories, 0, this.categories, 0, this.categories.length);
        }
        this.reverseDirection = theOtherObject.reverseDirection;
        this.continuousMajorTickPositionPolicy = theOtherObject.continuousMajorTickPositionPolicy;
        this.continuousValuePlacementPolicy = theOtherObject.continuousValuePlacementPolicy;
        this.continuousMajorTickCount = theOtherObject.continuousMajorTickCount;
        this.continuousMinorTickCount = theOtherObject.continuousMinorTickCount;
        this.continuousMajorTickInterval = theOtherObject.continuousMajorTickInterval;
        this.majorTickTimeInterval = theOtherObject.majorTickTimeInterval;
        this.continuousMajorTickAnchor = theOtherObject.continuousMajorTickAnchor;
        this.continuousMajorTickValues = theOtherObject.continuousMajorTickValues;
        this.labelPlacementPolicy = theOtherObject.labelPlacementPolicy;
        this.valueFitPolicy = theOtherObject.valueFitPolicy;
        this.gridLineStyle.apply(theOtherObject.gridLineStyle);
        this.axisLineStyle.apply(theOtherObject.axisLineStyle);
        this.majorTickStyle.apply(theOtherObject.majorTickStyle);
        this.minorTickStyle.apply(theOtherObject.minorTickStyle);
        if (this.referenceLineModels != null) {
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (this.referenceLineModels[ii] == null) continue;
                this.setContainedModel("referenceLineModel" + ii, null);
            }
        }
        ReferenceLineModel[] referenceLineModelArray = this.referenceLineModels = theOtherObject.referenceLineModels == null ? null : new ReferenceLineModel[theOtherObject.referenceLineModels.length];
        if (this.referenceLineModels != null) {
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (theOtherObject.referenceLineModels[ii] == null) continue;
                this.referenceLineModels[ii] = new ReferenceLineModel();
                this.referenceLineModels[ii].apply(theOtherObject.referenceLineModels[ii]);
                this.setContainedModel("referenceLineModel" + ii, this.referenceLineModels[ii]);
            }
        }
        if (this.referenceBandModels != null) {
            for (ii = 0; ii < this.referenceBandModels.length; ++ii) {
                if (this.referenceBandModels[ii] == null) continue;
                this.setContainedModel("referenceBandModel" + ii, null);
            }
        }
        ReferenceBandModel[] referenceBandModelArray = this.referenceBandModels = theOtherObject.referenceBandModels == null ? null : new ReferenceBandModel[theOtherObject.referenceBandModels.length];
        if (this.referenceBandModels != null) {
            for (ii = 0; ii < this.referenceBandModels.length; ++ii) {
                if (theOtherObject.referenceBandModels[ii] == null) continue;
                this.referenceBandModels[ii] = new ReferenceBandModel();
                this.referenceBandModels[ii].apply(theOtherObject.referenceBandModels[ii]);
                this.setContainedModel("referenceBandModel" + ii, this.referenceBandModels[ii]);
            }
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public BaseLength getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(BaseLength endOffset) {
        BaseLength oldValue = this.endOffset;
        this.endOffset = endOffset;
        this.firePropertyChange("endOffset", oldValue, endOffset);
    }

    public StrokeLineStyle getGridLineStyle() {
        return this.gridLineStyle;
    }

    public void setGridLineStyle(StrokeLineStyle newLineStyle) throws IllegalArgumentException {
        if (newLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        StrokeLineStyle oldValue = this.gridLineStyle;
        this.gridLineStyle = newLineStyle;
        this.firePropertyChange("gridLineStyle", oldValue, newLineStyle);
    }

    public boolean isGridInFront() {
        return this.gridInFront;
    }

    public void setGridInFront(boolean inFront) {
        boolean oldValue = this.gridInFront;
        this.gridInFront = inFront;
        this.firePropertyChange("gridInFront", oldValue, inFront);
    }

    public StrokeLineStyle getAxisLineStyle() {
        return this.axisLineStyle;
    }

    public void setAxisLineStyle(StrokeLineStyle axisLineStyle) throws IllegalArgumentException {
        if (axisLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        StrokeLineStyle oldValue = this.axisLineStyle;
        this.axisLineStyle = axisLineStyle;
        this.firePropertyChange("axisLineStyle", oldValue, axisLineStyle);
    }

    public ReferenceLineModel[] getReferenceLineModels() {
        ReferenceLineModel[] copyOfReferenceLineModels;
        ReferenceLineModel[] referenceLineModelArray = copyOfReferenceLineModels = this.referenceLineModels == null ? null : new ReferenceLineModel[this.referenceLineModels.length];
        if (copyOfReferenceLineModels != null) {
            System.arraycopy(this.referenceLineModels, 0, copyOfReferenceLineModels, 0, this.referenceLineModels.length);
        }
        return copyOfReferenceLineModels;
    }

    public void setReferenceLineModels(ReferenceLineModel[] newReferenceLineModels) {
        int ii;
        ReferenceLineModel[] oldReferenceLineModels = this.referenceLineModels;
        if (this.referenceLineModels != null) {
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (this.referenceLineModels[ii] == null) continue;
                this.setContainedModel("referenceLineModel" + ii, null);
            }
        }
        ReferenceLineModel[] referenceLineModelArray = this.referenceLineModels = newReferenceLineModels == null ? null : new ReferenceLineModel[newReferenceLineModels.length];
        if (this.referenceLineModels != null) {
            System.arraycopy(newReferenceLineModels, 0, this.referenceLineModels, 0, this.referenceLineModels.length);
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (newReferenceLineModels[ii] == null) continue;
                this.setContainedModel("referenceLineModel" + ii, this.referenceLineModels[ii]);
            }
        }
        this.firePropertyChange("referenceLineModels", oldReferenceLineModels, newReferenceLineModels);
    }

    public BaseLength getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(BaseLength newStartOffset) {
        BaseLength oldValue = this.startOffset;
        this.startOffset = newStartOffset;
        this.firePropertyChange("startOffset", oldValue, newStartOffset);
    }

    public String[] getCategories() {
        String[] copyOfCategories;
        String[] stringArray = copyOfCategories = this.categories == null ? null : new String[this.categories.length];
        if (copyOfCategories != null) {
            System.arraycopy(this.categories, 0, copyOfCategories, 0, copyOfCategories.length);
        }
        return copyOfCategories;
    }

    public void setCategories(String[] newCategories) {
        String[] oldCategories = this.categories;
        String[] stringArray = this.categories = newCategories == null ? null : new String[newCategories.length];
        if (this.categories != null) {
            System.arraycopy(newCategories, 0, this.categories, 0, this.categories.length);
        }
        this.firePropertyChange("categories", oldCategories, newCategories);
    }

    public int getContinuousMajorTickPositionPolicy() {
        return this.continuousMajorTickPositionPolicy;
    }

    public void setContinuousMajorTickPositionPolicy(int newMajorTickPlacementType) throws IllegalArgumentException {
        GraphConstants.TICK_POSITION.validate(newMajorTickPlacementType);
        int oldMajorTickPlacementType = this.continuousMajorTickPositionPolicy;
        this.continuousMajorTickPositionPolicy = newMajorTickPlacementType;
        this.firePropertyChange("continuousMajorTickPositionPolicy", oldMajorTickPlacementType, newMajorTickPlacementType);
    }

    public void setRangeMessageFormat(MessageFormat rangeMessageFormat) {
        if (rangeMessageFormat == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        MessageFormat oldRangeMessageFormat = this.rangeMessageFormat;
        this.rangeMessageFormat = Util.Copier.copyOf(rangeMessageFormat);
        this.firePropertyChange("rangeMessageFormat", oldRangeMessageFormat, rangeMessageFormat);
    }

    public MessageFormat getRangeMessageFormat() {
        return Util.Copier.copyOf(this.rangeMessageFormat);
    }

    public void setFormat(String aFormat) {
        String oldFormat = this.format;
        this.format = aFormat;
        this.firePropertyChange("format", oldFormat, this.format);
    }

    public String getFormat() {
        return this.format;
    }

    public int getContinuousValuePlacementPolicy() {
        return this.continuousValuePlacementPolicy;
    }

    public void setContinuousValuePlacementPolicy(int newValuePlacementType) throws IllegalArgumentException {
        switch (newValuePlacementType) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 12201: 
            case 12202: 
        }
        int oldValuePlacementType = this.continuousValuePlacementPolicy;
        this.continuousValuePlacementPolicy = newValuePlacementType;
        this.firePropertyChange("continuousValuePlacementPolicy", oldValuePlacementType, newValuePlacementType);
    }

    public int getContinuousMajorTickCount() {
        return this.continuousMajorTickCount;
    }

    public void setContinuousMajorTickCount(int newContinuousMajorTickCount) throws IllegalArgumentException {
        if (newContinuousMajorTickCount < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        int oldContinuousMajorTickCount = this.continuousMajorTickCount;
        this.continuousMajorTickCount = newContinuousMajorTickCount;
        this.firePropertyChange("continuousMajorTickCount", oldContinuousMajorTickCount, newContinuousMajorTickCount);
    }

    public int getContinuousMinorTickCount() {
        return this.continuousMinorTickCount;
    }

    public void setContinuousMinorTickCount(int newContinuousMinorTickCount) throws IllegalArgumentException {
        if (newContinuousMinorTickCount < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        int oldContinuousMinorTickCount = this.continuousMinorTickCount;
        this.continuousMinorTickCount = newContinuousMinorTickCount;
        this.firePropertyChange("continuousMinorTickCount", oldContinuousMinorTickCount, newContinuousMinorTickCount);
    }

    public double getContinuousMajorTickInterval() {
        return this.continuousMajorTickInterval;
    }

    public void setContinuousMajorTickInterval(double newMajorTickInterval) throws IllegalArgumentException {
        if (newMajorTickInterval <= 0.0) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        if (newMajorTickInterval == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        double oldMajorTickInterval = this.continuousMajorTickInterval;
        this.continuousMajorTickInterval = newMajorTickInterval;
        this.firePropertyChange("continuousMajorTickInterval", oldMajorTickInterval, newMajorTickInterval);
    }

    public int getMajorTickTimeInterval() {
        return this.majorTickTimeInterval;
    }

    public void setMajorTickTimeInterval(int newMajorTickTimeInterval) throws IllegalArgumentException {
        switch (newMajorTickTimeInterval) {
            case 10820: 
            case 10830: 
            case 10835: 
            case 10840: 
            case 10855: 
            case 10860: 
            case 10865: 
            case 10875: 
            case 10880: 
            case 10890: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
        }
        double oldMajorTickTimeInterval = this.majorTickTimeInterval;
        this.majorTickTimeInterval = newMajorTickTimeInterval;
        this.firePropertyChange("majorTickTimeInterval", oldMajorTickTimeInterval, (double)newMajorTickTimeInterval);
    }

    public double getContinuousMajorTickAnchor() {
        return this.continuousMajorTickAnchor;
    }

    public void setContinuousMajorTickAnchor(double newMajorTickAnchor) {
        if (newMajorTickAnchor == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (newMajorTickAnchor == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldMajorTickAnchor = this.continuousMajorTickAnchor;
        this.continuousMajorTickAnchor = newMajorTickAnchor;
        this.firePropertyChange("continuousMajorTickAnchor", oldMajorTickAnchor, newMajorTickAnchor);
    }

    public double[] getContinuousMajorTickValues() {
        double[] copyOfContinuousMajorTickValues;
        double[] dArray = copyOfContinuousMajorTickValues = this.continuousMajorTickValues == null ? null : new double[this.continuousMajorTickValues.length];
        if (copyOfContinuousMajorTickValues != null) {
            System.arraycopy(this.continuousMajorTickValues, 0, copyOfContinuousMajorTickValues, 0, this.continuousMajorTickValues.length);
        }
        return copyOfContinuousMajorTickValues;
    }

    public void setContinuousMajorTickValues(double[] newContinuousMajorTickValues) throws IllegalArgumentException {
        if (newContinuousMajorTickValues == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        double[] oldContinuousMajorTickValues = this.continuousMajorTickValues;
        double[] dArray = this.continuousMajorTickValues = newContinuousMajorTickValues == null ? null : new double[newContinuousMajorTickValues.length];
        if (this.continuousMajorTickValues != null) {
            System.arraycopy(newContinuousMajorTickValues, 0, this.continuousMajorTickValues, 0, this.continuousMajorTickValues.length);
        }
        this.firePropertyChange("majorTickValues", oldContinuousMajorTickValues, this.continuousMajorTickValues);
    }

    public void setMajorTickStyle(TickStyle newMajorTickStyle) throws IllegalArgumentException {
        if (newMajorTickStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TickStyle oldValue = this.majorTickStyle;
        this.majorTickStyle = newMajorTickStyle;
        this.firePropertyChange("majorTickStyle", oldValue, newMajorTickStyle);
    }

    public TickStyle getMajorTickStyle() {
        return this.majorTickStyle;
    }

    public void setMinorTickStyle(TickStyle newMinorTickStyle) throws IllegalArgumentException {
        if (newMinorTickStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TickStyle oldValue = this.minorTickStyle;
        this.minorTickStyle = newMinorTickStyle;
        this.firePropertyChange("minorTickStyle", oldValue, newMinorTickStyle);
    }

    public TickStyle getMinorTickStyle() {
        return this.minorTickStyle;
    }

    public int getLabelPlacementPolicy() {
        return this.labelPlacementPolicy;
    }

    public void setLabelPlacementPolicy(int newLabelPlacementPolicy) throws IllegalArgumentException {
        switch (newLabelPlacementPolicy) {
            case 10200: 
            case 11301: 
            case 11302: 
            case 11303: 
            case 11306: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
        }
        double oldLabelPlacementPolicy = this.labelPlacementPolicy;
        this.labelPlacementPolicy = newLabelPlacementPolicy;
        this.firePropertyChange("labelPlacementPolicy", oldLabelPlacementPolicy, (double)newLabelPlacementPolicy);
    }

    public int getValueFitPolicy() {
        return this.valueFitPolicy;
    }

    public void setValueFitPolicy(int newValueFitPolicy) throws IllegalArgumentException {
        GraphConstants.FIT.validate(newValueFitPolicy);
        int oldValueFitPolicy = this.valueFitPolicy;
        this.valueFitPolicy = newValueFitPolicy;
        this.firePropertyChange("valueFitPolicy", oldValueFitPolicy, newValueFitPolicy);
    }

    public double getMinimum() {
        return this.min;
    }

    public void setMinimum(double minValue) {
        if (minValue == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (minValue == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldMin = this.min;
        this.min = minValue;
        this.firePropertyChange("minimum", oldMin, minValue);
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMaximum(double maxValue) {
        if (maxValue == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (maxValue == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldMax = this.max;
        this.max = maxValue;
        this.firePropertyChange("maximum", oldMax, maxValue);
    }

    public boolean isDrillIconVisible() {
        return this.drillIconVisible;
    }

    public void setDrillIconVisible(boolean newVis) {
        boolean oldVis = this.drillIconVisible;
        this.drillIconVisible = newVis;
        this.firePropertyChange("drillIconVisible", oldVis, newVis);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AxisModel arg = (AxisModel)obj;
        return Util.Evaluate.isEqual(this.gridInFront, arg.gridInFront) && Util.Evaluate.isEqual(this.continuousMajorTickPositionPolicy, arg.continuousMajorTickPositionPolicy) && Util.Evaluate.isEqual(this.continuousValuePlacementPolicy, arg.continuousValuePlacementPolicy) && Util.Evaluate.isEqual(this.continuousMajorTickCount, arg.continuousMajorTickCount) && Util.Evaluate.isEqual(this.continuousMinorTickCount, arg.continuousMinorTickCount) && Util.Evaluate.isEqual(this.majorTickTimeInterval, arg.majorTickTimeInterval) && Util.Evaluate.isEqual(this.drillIconVisible, arg.drillIconVisible) && Util.Evaluate.isEqual(this.labelPlacementPolicy, arg.labelPlacementPolicy) && Util.Evaluate.isEqual(this.valueFitPolicy, arg.valueFitPolicy) && Util.Evaluate.isEqual(this.reverseDirection, arg.reverseDirection) && Util.Evaluate.isEqual(this.min, arg.min) && Util.Evaluate.isEqual(this.max, arg.max) && Util.Evaluate.isEqual(this.continuousMajorTickInterval, arg.continuousMajorTickInterval) && Util.Evaluate.isEqual(this.continuousMajorTickAnchor, arg.continuousMajorTickAnchor) && Util.Evaluate.isEqual(this.majorTickStyle, arg.majorTickStyle) && Util.Evaluate.isEqual(this.minorTickStyle, arg.minorTickStyle) && Util.Evaluate.isEqual(this.gridLineStyle, arg.gridLineStyle) && Util.Evaluate.isEqual(this.axisLineStyle, arg.axisLineStyle) && Util.Evaluate.isEqual((BaseDistance)this.startOffset, (BaseDistance)arg.startOffset) && Util.Evaluate.isEqual((BaseDistance)this.endOffset, (BaseDistance)arg.endOffset) && Util.Evaluate.isEqual(this.categories, arg.categories) && Util.Evaluate.isEqual(this.referenceLineModels, arg.referenceLineModels) && Util.Evaluate.isEqual(this.referenceBandModels, arg.referenceBandModels) && Util.Evaluate.isEqual(this.continuousMajorTickValues, arg.continuousMajorTickValues) && Util.Evaluate.isEqual(this.rangeMessageFormat, arg.rangeMessageFormat) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void setReverseDirection(boolean reverse) {
        boolean oldValue = this.reverseDirection;
        this.reverseDirection = reverse;
        this.firePropertyChange("reverseDirection", oldValue, this.reverseDirection);
    }

    public boolean getReverseDirection() {
        return this.reverseDirection;
    }

    public boolean isReverseDirection() {
        return this.reverseDirection;
    }

    public boolean isAdjustValueMagnitudeEnabled() {
        return this.adjustValueMagnitudeEnabled;
    }

    public void setAdjustValueMagnitudeEnabled(boolean adjustValueMagnitudeEnabled) {
        this.adjustValueMagnitudeEnabled = adjustValueMagnitudeEnabled;
    }

    public void setReferenceBandModels(ReferenceBandModel[] newReferenceBandModels) {
        int ii;
        ReferenceBandModel[] oldReferenceBandModels = this.referenceBandModels;
        if (this.referenceBandModels != null) {
            for (ii = 0; ii < this.referenceBandModels.length; ++ii) {
                if (this.referenceBandModels[ii] == null) continue;
                this.setContainedModel("referenceBandModel" + ii, null);
            }
        }
        ReferenceBandModel[] referenceBandModelArray = this.referenceBandModels = newReferenceBandModels == null ? null : new ReferenceBandModel[newReferenceBandModels.length];
        if (this.referenceBandModels != null) {
            System.arraycopy(newReferenceBandModels, 0, this.referenceBandModels, 0, this.referenceBandModels.length);
            for (ii = 0; ii < this.referenceBandModels.length; ++ii) {
                if (newReferenceBandModels[ii] == null) continue;
                this.setContainedModel("referenceBandModel" + ii, this.referenceBandModels[ii]);
            }
        }
        this.firePropertyChange("referenceBandModels", oldReferenceBandModels, newReferenceBandModels);
    }

    public ReferenceBandModel[] getReferenceBandModels() {
        ReferenceBandModel[] copyOfReferenceBandModels;
        ReferenceBandModel[] referenceBandModelArray = copyOfReferenceBandModels = this.referenceBandModels == null ? null : new ReferenceBandModel[this.referenceBandModels.length];
        if (copyOfReferenceBandModels != null) {
            System.arraycopy(this.referenceBandModels, 0, copyOfReferenceBandModels, 0, copyOfReferenceBandModels.length);
        }
        return copyOfReferenceBandModels;
    }
}

