/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

@SASScope(value="ALL")
public class AnalysisVariableList
extends AnalysisVariable {
    private AnalysisVariableList next;

    public AnalysisVariableList(String columnName, String format, String informat, String label, int statistic, AnalysisVariableList next) {
        super(columnName, format, informat, label, statistic);
        this.next = next;
    }

    public AnalysisVariableList(int columnIndex, String format, String informat, String label, int statistic, AnalysisVariableList next) {
        super(columnIndex, format, informat, label, statistic);
        this.next = next;
    }

    public AnalysisVariableList(String[] columnNames) {
        super(columnNames != null && columnNames.length > 0 ? columnNames[0] : null);
        if (columnNames != null && columnNames.length > 1) {
            AnalysisVariableList nextVar = null;
            for (int ii = columnNames.length - 1; ii > 0; --ii) {
                nextVar = new AnalysisVariableList(columnNames[ii], null, null, null, 10506, nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    private AnalysisVariableList(AnalysisVariable variable, AnalysisVariableList nextVar) {
        super(variable);
        this.next = nextVar;
    }

    public AnalysisVariableList(AnalysisVariable[] variableArray) {
        super(variableArray != null && variableArray.length > 0 ? variableArray[0] : null);
        if (variableArray != null && variableArray.length > 1) {
            AnalysisVariableList nextVar = null;
            for (int ii = variableArray.length - 1; ii > 0; --ii) {
                nextVar = new AnalysisVariableList(variableArray[ii], nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    public AnalysisVariableList getNext() {
        return this.next;
    }

    public AnalysisVariable[] asArray() {
        AnalysisVariableList curr;
        int ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            ++ii;
        }
        AnalysisVariable[] array = new AnalysisVariable[ii];
        ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            array[ii++] = new AnalysisVariable(curr);
        }
        return array;
    }

    public ArrayList asArrayList() {
        AnalysisVariableList curr = this;
        ArrayList<AnalysisVariableList> list = new ArrayList<AnalysisVariableList>();
        do {
            list.add(curr);
        } while ((curr = curr.getNext()) != null);
        return list;
    }

    public Iterator iterator() {
        return new VariableListIterator(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AnalysisVariableList arg = (AnalysisVariableList)obj;
        return Util.Evaluate.isEqual(this.next, arg.next) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @SASScope
    private static class VariableListIterator
    implements Iterator {
        AnalysisVariableList prev = null;
        AnalysisVariableList curr = null;
        AnalysisVariableList next;

        public VariableListIterator(AnalysisVariableList ptr) {
            this.next = ptr;
        }

        public Object next() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.curr;
            this.curr = this.next;
            this.next = this.curr.getNext();
            return this.curr;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
        }
    }
}

