/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.RangeVariable;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class AnalysisVariable
extends RangeVariable {
    private final int statistic;

    private static int _validateStatistic(int statistic) {
        return GraphConstants.STATISTIC.isValid(statistic) ? statistic : 10506;
    }

    public AnalysisVariable(String columnName) {
        this(columnName, null, null, null, 10506);
    }

    public AnalysisVariable(String columnName, int statistic) {
        this(columnName, null, null, null, statistic);
    }

    public AnalysisVariable(String columnName, String format) {
        this(columnName, format, null, null, 10506);
    }

    public AnalysisVariable(String columnName, String format, String informat, String label, int statistic) {
        this(columnName, format, informat, label, statistic, (CategorizationModel)null, null, null, null);
    }

    public AnalysisVariable(String columnName, String format, String informat, String label, int statistic, String targetColumnName, String targetLabel) {
        super(columnName, format, informat, label, (CategorizationModel)null, null, targetColumnName, targetLabel);
        this.statistic = AnalysisVariable._validateStatistic(statistic);
    }

    public AnalysisVariable(String columnName, String format, String informat, String label, int statistic, String highColumnName, String highLabel, String lowColumnName, String lowLabel) {
        super(columnName, format, informat, label, null, null, highColumnName, highLabel, lowColumnName, lowLabel);
        this.statistic = AnalysisVariable._validateStatistic(statistic);
    }

    public AnalysisVariable(String columnName, String format, String informat, String label, int statistic, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        this(columnName, format, informat, label, statistic, categorizationModel, segmentedRangeStyle, null, null);
    }

    public AnalysisVariable(String columnName, String format, String informat, String label, int statistic, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, String targetColumnName, String targetLabel) {
        super(columnName, format, informat, label, categorizationModel, segmentedRangeStyle, targetColumnName, targetLabel);
        this.statistic = AnalysisVariable._validateStatistic(statistic);
    }

    public AnalysisVariable(String columnName, String format, String informat, String label, int statistic, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, String highColumnName, String highLabel, String lowColumnName, String lowLabel) {
        super(columnName, format, informat, label, categorizationModel, segmentedRangeStyle, highColumnName, highLabel, lowColumnName, lowLabel);
        this.statistic = AnalysisVariable._validateStatistic(statistic);
    }

    public AnalysisVariable(int columnIndex) {
        this(columnIndex, null, null, null, 10506, null, null, -1, null);
    }

    public AnalysisVariable(int columnIndex, String format, String informat, String label, int statistic) {
        this(columnIndex, format, informat, label, statistic, null, null, -1, null);
    }

    public AnalysisVariable(int columnIndex, String format, String informat, String label, int statistic, int targetColumnIndex, String targetLabel) {
        this(columnIndex, format, informat, label, statistic, null, null, targetColumnIndex, targetLabel);
    }

    public AnalysisVariable(int columnIndex, String format, String informat, String label, int statistic, int highColumnIndex, String highLabel, int lowColumnIndex, String lowLabel) {
        this(columnIndex, format, informat, label, statistic, null, null, highColumnIndex, highLabel, lowColumnIndex, lowLabel);
    }

    public AnalysisVariable(int columnIndex, String format, String informat, String label, int statistic, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        this(columnIndex, format, informat, label, statistic, categorizationModel, segmentedRangeStyle, -1, null);
    }

    public AnalysisVariable(int columnIndex, String format, String informat, String label, int statistic, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, int targetColumnIndex, String targetLabel) {
        super(columnIndex, format, informat, label, categorizationModel, segmentedRangeStyle, targetColumnIndex, targetLabel);
        this.statistic = AnalysisVariable._validateStatistic(statistic);
    }

    public AnalysisVariable(int columnIndex, String format, String informat, String label, int statistic, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, int highColumnIndex, String highLabel, int lowColumnIndex, String lowLabel) {
        super(columnIndex, format, informat, label, categorizationModel, segmentedRangeStyle, highColumnIndex, highLabel, lowColumnIndex, lowLabel);
        this.statistic = AnalysisVariable._validateStatistic(statistic);
    }

    public AnalysisVariable(AnalysisVariable av) {
        super(av);
        this.statistic = av == null ? 10506 : av.getStatistic();
    }

    public int getStatistic() {
        return this.statistic;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AnalysisVariable arg = (AnalysisVariable)obj;
        return Util.Evaluate.isEqual(this.statistic, arg.statistic) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

