/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.meta.SASOMI.ISecurityHelper;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.metadata.AssociationList;
import com.sas.metadata.AuthenticationDomain;
import com.sas.metadata.Identity;
import com.sas.metadata.LogicalServer;
import com.sas.metadata.Login;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectBase;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataResource;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.ServerContext;
import com.sas.metadata.Util;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.Server;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataWorkspace {
    public static final String USERNAME_KEY = "Username";
    public static final String PASSWORD_KEY = "Password";
    public static final String HOST_KEY = "Hostname";
    public static final String PORT_KEY = "Port";
    public static final String SECURITY_PACKAGE_LIST_KEY = "SecurityPackage";
    public static final String SPN_KEY = "SPN";
    public static final int SERVER_STATUS_ERROR = -1;
    public static final int SERVER_STATUS_OK = 0;
    public static final int SERVER_STATUS_PAUSED = 1;
    public static final String WORKSPACECLASSID = "440196D4-90F0-11D0-9F41-00A024BB830C";
    protected MetadataResource bundle = null;
    protected IOMI m_pCMR = null;
    protected ArrayList workspaceArray = new ArrayList();
    protected DocumentBuilder m_docBuilder = null;
    private ConnectionFactoryManager m_cxfManager = null;
    private ConnectionInterface OMRcx = null;
    private Map m_credMap = null;
    private static Level log_level = Level.OFF;
    private static MetadataWorkspace m_singleton = new MetadataWorkspace();
    protected DocumentBuilderFactory dbf = null;
    private static final String shortTemplate = "<Templates><Login Name=\"\" Password=\"\" UserID=\"\"><Domain/></Login><AuthenticationDomain Name=\"\"/><Identity><Logins/></Identity><Person><Logins/></Person><IdentityGroup><Logins/></IdentityGroup></Templates>";
    private static final int flags = 260;

    private MetadataWorkspace() {
        this.bundle = new MetadataResource(MetadataWorkspace.class);
        this.m_cxfManager = new ConnectionFactoryManager();
    }

    public static MetadataWorkspace getWorkspace() {
        return m_singleton;
    }

    public static MetadataWorkspace getNewWorkspace() {
        return new MetadataWorkspace();
    }

    public IOMI getCMRHandle() {
        return this.m_pCMR;
    }

    public void setCMRHandle(IOMI pCMR) {
        this.m_pCMR = pCMR;
    }

    public IWorkspace getIOMHandle(int index) {
        if (index < 0) {
            return (IWorkspace)this.workspaceArray.get(0);
        }
        return (IWorkspace)this.workspaceArray.get(index);
    }

    public IWorkspace getIOMHandle() {
        return (IWorkspace)this.workspaceArray.get(0);
    }

    public void setIOMHandle(IWorkspace work) {
        this.workspaceArray.add(work);
    }

    public void setIOMHandle(IWorkspace work, int index) {
        this.workspaceArray.add(index, work);
    }

    public DocumentBuilder getDocumentBuilder() {
        if (this.dbf == null) {
            this.setupDocumentBuilder();
        }
        DocumentBuilder m_docBuilder = null;
        try {
            m_docBuilder = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return m_docBuilder;
    }

    public void setupDocumentBuilder() {
        if (this.dbf == null) {
            this.dbf = DocumentBuilderFactory.newInstance();
        }
    }

    public IOMI makeOMRConnection(String cmrHost, String cmrPort, String cmrUserName, String cmrPassword, boolean setCMRHandle) throws RemoteException, MdException {
        String[] cmrCredential = new String[]{cmrUserName, cmrPassword};
        IOMI iOMI = this.makeOMRConnection(cmrHost, cmrPort, cmrCredential, null, setCMRHandle);
        return iOMI;
    }

    public IOMI makeOMRConnection(String cmrHost, String cmrPort, String cmrUserName, String cmrPassword) throws RemoteException, MdException {
        return this.makeOMRConnection(cmrHost, cmrPort, cmrUserName, cmrPassword, true);
    }

    public IOMI makeOMRConnectionUsingSecurityPackage(String cmrHost, String cmrPort, String cmrSecurityPackageList, String cmrSPN, boolean setCMRHandle) throws MdException {
        String[] cmrSecurityPackage = new String[]{cmrSecurityPackageList, cmrSPN};
        IOMI iOMI = this.makeOMRConnection(cmrHost, cmrPort, null, cmrSecurityPackage, setCMRHandle);
        return iOMI;
    }

    public Map getCredentialMap() {
        return this.m_credMap;
    }

    public void closeOMRConnection() throws RemoteException {
        if (this.m_pCMR != null) {
            this.m_pCMR._release();
            this.m_pCMR = null;
        }
        if (this.OMRcx != null) {
            this.OMRcx.close();
            this.OMRcx = null;
        }
    }

    public void disconnectOMRConnection(IOMI iOMI) throws MdException {
        this.disconnectConnection((Object)iOMI);
    }

    public IWorkspace makeIOMConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        IWorkspace iWorkspace = this.makeIOMConnection(Host, Port, credential, null);
        return iWorkspace;
    }

    public IWorkspace makeIOMConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        IWorkspace iWorkspace = this.makeIOMConnection(Host, Port, null, securityPackage);
        return iWorkspace;
    }

    private LogicalServer getLogicalServer(ServerContext scx) throws MdException, ConnectionFactoryException {
        AssociationList servers = scx.getUsingComponents();
        for (int i = 0; i < servers.size(); ++i) {
            LogicalServer ls = (LogicalServer)servers.get(i);
            if (!ls.getClassIdentifier().equals(WORKSPACECLASSID)) continue;
            return ls;
        }
        throw new ConnectionFactoryException(this.bundle.messageString("MdIOMConnectionFailed.msg.txt", scx.getName()));
    }

    private Login getLogin(LogicalServer ls, String domainName) throws MdException {
        String sOptions;
        int flags;
        String type;
        String reposid;
        MdObjectStore store = (MdObjectStore)ls.getObjectStore();
        List domains = MetadataUtil.getMetadataObjectsSubset(store, reposid = "A0000001." + ls.getFQID().substring(0, 8), type = "AuthenticationDomain", flags = 8320, sOptions = "<XMLSelect search =\"@name = '" + domainName + "'\" />");
        AuthenticationDomain dom = (AuthenticationDomain)domains.get(0);
        AssociationList logins = dom.getLogins();
        if (logins.size() == 1) {
            return (Login)logins.get(0);
        }
        return null;
    }

    public void closeIOMConnection(IWorkspace workspace) throws RemoteException, MdException {
        this.closeConnection((Object)workspace);
    }

    public void disconnectIOMConnection(IWorkspace workspace) throws MdException {
        this.disconnectConnection((Object)workspace);
    }

    public IServer MakeIServerConnection(IOMI OMRConnection) throws RemoteException, MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                IServer iServer = IServerHelper.narrow((Object)obj);
                if (iServer != null) {
                    return iServer;
                }
                throw new MdException(this.bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt"));
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return null;
    }

    public IServer makeIServerConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        IServer iServer = this.makeIServerConnection(Host, Port, credential, null);
        return iServer;
    }

    public IServer makeIServerConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        IServer iServer = this.makeIServerConnection(Host, Port, null, securityPackage);
        return iServer;
    }

    public void closeIServerConnection(IServer serverConnection) throws RemoteException, MdException {
        this.closeConnection((Object)serverConnection);
    }

    public void disconnectIServerConnection(IServer serverConnection) throws MdException {
        this.disconnectConnection((Object)serverConnection);
    }

    public ISecurity_1_1 MakeISecurityConnection(IOMI OMRConnection) throws RemoteException, MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                ISecurity_1_1 iSecurity = ISecurity_1_1Helper.narrow((Object)obj);
                if (iSecurity != null) {
                    return iSecurity;
                }
                throw new MdException(this.bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + "UNKNOWN");
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return null;
    }

    public ISecurity_1_1 makeISecurityConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        ISecurity_1_1 iSecurity = this.makeISecurityConnection(Host, Port, credential, null);
        return iSecurity;
    }

    public ISecurity_1_1 makeISecurityConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        ISecurity_1_1 iSecurity = this.makeISecurityConnection(Host, Port, null, securityPackage);
        return iSecurity;
    }

    public void closeISecurityConnection(ISecurity secureConnection) throws RemoteException, MdException {
        this.closeConnection((Object)secureConnection);
    }

    public void disconnectISecurityConnection(ISecurity secureConnection) throws MdException {
        this.disconnectConnection((Object)secureConnection);
    }

    public ISecurityAdmin MakeISecurityAdminConnection(IOMI OMRConnection) throws RemoteException, MdException {
        try {
            if (OMRConnection != null) {
                Object obj = OMRConnection._duplicate();
                ISecurityAdmin iSecAdmin = ISecurityAdminHelper.narrow((Object)obj);
                if (iSecAdmin != null) {
                    return iSecAdmin;
                }
                throw new MdException(this.bundle.getString("MdOMRConnectionImpl.UnableToConnectToServer.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.MsgSeperator.msg.txt") + this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt"));
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return null;
    }

    public ISecurityAdmin makeISecurityAdminConnection(String Host, String Port, String Username, String Password) throws RemoteException, MdException {
        String[] credential = new String[]{Username, Password};
        ISecurityAdmin iSecurityAdmin = this.makeISecurityAdminConnection(Host, Port, credential, null);
        return iSecurityAdmin;
    }

    public ISecurityAdmin makeISecurityAdminConnectionUsingSecurityPackage(String Host, String Port, String SecurityPackageList, String SPN) throws RemoteException, MdException {
        String[] securityPackage = new String[]{SecurityPackageList, SPN};
        ISecurityAdmin iSecurityAdmin = this.makeISecurityAdminConnection(Host, Port, null, securityPackage);
        return iSecurityAdmin;
    }

    public void closeISecurityAdminConnection(ISecurityAdmin secAdminConnection) throws RemoteException, MdException {
        this.closeConnection((Object)secAdminConnection);
    }

    public void disconnectISecurityAdminConnection(ISecurityAdmin secAdminConnection) throws MdException {
        this.disconnectConnection((Object)secAdminConnection);
    }

    public static String normalizeSecurityPackageList(String securityPackage, String securityPackageList) {
        return "Negotiate".equals(securityPackage) ? securityPackageList : securityPackage;
    }

    public void dispose() {
        this.bundle = null;
        this.m_docBuilder = null;
        this.dbf = null;
        if (this.m_pCMR != null) {
            this.m_pCMR._release();
        }
        this.m_pCMR = null;
        if (this.workspaceArray != null && this.workspaceArray.size() > 0) {
            this.workspaceArray.clear();
        }
        this.workspaceArray = null;
        if (this.OMRcx != null) {
            this.OMRcx.close();
        }
        this.OMRcx = null;
        m_singleton = null;
    }

    public Properties getCMRProperties() throws MdException {
        MdObjectBase ID = null;
        try {
            BrgOrb orb = (BrgOrb)((ObjectImpl)this.m_pCMR)._orb();
            Properties env = orb.objectToProperties((Object)this.m_pCMR);
            env.remove("logFile");
            String userName = (String)env.remove("userName");
            if (userName == null) {
                Properties properties = env;
                return properties;
            }
            userName.toLowerCase();
            ISecurity iSecurity = ISecurityHelper.narrow((Object)this.m_pCMR);
            StringHolder idHolder = new StringHolder();
            iSecurity.GetIdentity("", idHolder);
            String urn = idHolder.value;
            if (urn.indexOf("UNKNOWN") >= 0) {
                String message = this.bundle.getString("MdOMRConnectionImpl.NoIdentity.msg.txt");
                throw new MdException(message);
            }
            int slashIndex = urn.lastIndexOf(47);
            String type = urn.substring(7, slashIndex);
            String fqid = urn.substring(slashIndex + 1);
            ID = (Identity)MetadataUtil.getMetadataAllDepths(null, type, fqid, null, null, shortTemplate, 260);
            AssociationList logins = ID.getLogins();
            String domain = null;
            if (logins != null) {
                int size = logins.size();
                for (int i = 0; i < size; ++i) {
                    Login login = (Login)logins.get(i);
                    String userID = login.getUserID();
                    if (!userName.equals(userID = userID.toLowerCase())) continue;
                    AuthenticationDomain authDomain = login.getDomain();
                    if (authDomain == null) break;
                    domain = authDomain.getName();
                    break;
                }
            }
            env.put("domain", domain != null ? domain : "");
            Properties properties = env;
            return properties;
        }
        catch (SystemException se) {
            throw new MdException(se);
        }
        catch (GenericError ge) {
            throw new MdException(ge);
        }
        catch (InvalidCredHandle iche) {
            throw new MdException(iche);
        }
        finally {
            if (ID != null) {
                ID.getObjectStore().dispose();
            }
        }
    }

    public static void configLogger(String factoryName) {
        final Logger logger = Logger.getLogger(factoryName);
        PrivilegedAction action = new PrivilegedAction(){

            public java.lang.Object run() {
                logger.setLevel(log_level);
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (SecurityException se) {
            Util.printStackTrace(se);
        }
    }

    public int getServerStatus() throws MdException {
        try {
            IServer serverConn = MetadataWorkspace.getWorkspace().MakeIServerConnection(MetadataWorkspace.getWorkspace().getCMRHandle());
            return this.getServerStatus(serverConn);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    public int getServerStatus(IServer serverConn) throws MdException {
        int iStatus = 0;
        try {
            StringHolder outStatus = new StringHolder();
            serverConn.Status("<State/>", outStatus, "");
            String sStatus = outStatus.value;
            String s1 = "<State>";
            String s2 = "</State>";
            sStatus = sStatus.substring(sStatus.indexOf(s1) + s1.length(), sStatus.indexOf(s2));
            iStatus = Integer.parseInt(sStatus);
        }
        catch (Exception e) {
            iStatus = -1;
        }
        return iStatus;
    }

    public int getVersionCompatibility(IServer serverConn) throws MdException {
        try {
            String returnvalue = this.getServerModelVersion(serverConn);
            double value = Double.parseDouble(returnvalue);
            double jvalue = Double.parseDouble("6.00");
            if (value > jvalue) {
                return 1;
            }
            if (value < jvalue) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    public int getVersionCompatibility() throws MdException {
        try {
            IServer serverConn = MetadataWorkspace.getWorkspace().MakeIServerConnection(MetadataWorkspace.getWorkspace().getCMRHandle());
            return this.getVersionCompatibility(serverConn);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    public String getServerModelVersion() throws MdException, RemoteException {
        if (this.m_pCMR != null) {
            IServer serverConn = this.MakeIServerConnection(this.m_pCMR);
            return this.getServerModelVersion(serverConn);
        }
        return "-1";
    }

    public String getServerModelVersion(IServer serverConn) throws MdException {
        String returnValue = "";
        StringHolder outVersion = new StringHolder();
        try {
            serverConn.Status("<ModelVersion/>", outVersion, "");
            String sStatus = outVersion.value;
            String s1 = "<ModelVersion>";
            String s2 = "</ModelVersion>";
            returnValue = sStatus.substring(sStatus.indexOf(s1) + s1.length(), sStatus.indexOf(s2));
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return returnValue;
    }

    public String getServerVersion(IServer serverConn) throws MdException {
        StringHolder output = new StringHolder();
        String input = new String("<Version/>");
        String returnvalue = "";
        try {
            serverConn.Status(input, output, "");
            Document doc = MetadataUtil.parseXML(output.value);
            NodeList list = doc.getElementsByTagName("Version");
            Node listitem = list.item(0);
            NodeList clist = listitem.getChildNodes();
            Node cvalue = clist.item(0);
            returnvalue = cvalue.getNodeValue();
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return returnvalue;
    }

    public String getCurrentServerVerion() throws MdException, RemoteException {
        if (this.m_pCMR != null) {
            IServer serverConn = this.MakeIServerConnection(this.m_pCMR);
            return this.getServerVersion(serverConn);
        }
        return "-1";
    }

    public int getPlatformVersion() throws MdException {
        try {
            IServer serverConn = MetadataWorkspace.getWorkspace().MakeIServerConnection(MetadataWorkspace.getWorkspace().getCMRHandle());
            return this.getPlatformVersion(serverConn);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    public int getPlatformVersion(IServer serverConn) throws MdException {
        StringHolder output = new StringHolder();
        String input = "<PlatformVersion/>";
        int version = 0;
        try {
            String s;
            serverConn.Status("<PlatformVersion/>", output, "");
            Document doc = MetadataUtil.parseXML(output.value);
            NodeList nodeList = doc.getElementsByTagName("PlatformVersion");
            Node node = nodeList.item(0);
            NodeList childList = node.getChildNodes();
            Node childNode = childList.item(0);
            if (childNode != null && (s = childNode.getNodeValue()) != null && s.length() > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == '.') continue;
                    sb.append(c);
                }
                version = Integer.parseInt(sb.toString());
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return version;
    }

    public Identity getIdentityOfUserConnected(MdStore store, String reposID) throws MdException {
        if (this.m_pCMR == null) {
            return null;
        }
        try {
            String type;
            String options;
            String repositoryID;
            ISecurity iSecurity = ISecurityHelper.narrow((Object)this.m_pCMR);
            StringHolder idHolder = new StringHolder();
            iSecurity.GetIdentity("", idHolder);
            String value = idHolder.value;
            int flags = 392;
            if (value.indexOf("UNKNOWN") >= 0) {
                repositoryID = reposID;
                options = "<XMLSELECT Search=\"@Name='PUBLIC'\"/>";
                flags |= 0x2000;
                type = "IdentityGroup";
            } else {
                int index = value.lastIndexOf(47);
                String strFQID = value.substring(index + 1);
                repositoryID = "A0000001." + value.substring(index + 1, index + 9);
                options = "<XMLSELECT Search=\"@Id='" + strFQID + "'\"/>";
                flags |= 0x10;
                type = "Identity";
            }
            List objects = MetadataUtil.getMetadataObjectsSubset(this.m_pCMR, store, repositoryID, type, flags, options, false);
            return objects.size() > 0 ? (Identity)objects.get(0) : null;
        }
        catch (InvalidCredHandle ice) {
            throw new MdException(ice);
        }
        catch (GenericError ge) {
            throw new MdException(ge);
        }
    }

    public Level getMessageLevel() {
        return log_level;
    }

    public void setMessageLevel(Level inLevel) {
        log_level = inLevel;
    }

    private IOMI makeOMRConnection(String cmrHost, String cmrPort, String[] cmrCredential, String[] cmrSecurityPackage, boolean setCMRHandle) throws MdException {
        Object obj;
        IOMI iomiHandle;
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", cmrHost, cmrPort, cmrCredential, cmrSecurityPackage);
        if (setCMRHandle) {
            this.OMRcx = cx;
        }
        if ((iomiHandle = IOMIHelper.narrow((Object)(obj = cx.getObject()))) != null) {
            if (setCMRHandle) {
                this.m_pCMR = iomiHandle;
            }
            this.m_credMap = new HashMap(4);
            this.m_credMap.put(HOST_KEY, cmrHost);
            this.m_credMap.put(PORT_KEY, cmrPort);
            if (cmrCredential != null) {
                this.m_credMap.put(USERNAME_KEY, cmrCredential[0]);
                this.m_credMap.put(PASSWORD_KEY, cmrCredential[1]);
            } else {
                this.m_credMap.put(SECURITY_PACKAGE_LIST_KEY, cmrSecurityPackage[0]);
                this.m_credMap.put(SPN_KEY, cmrSecurityPackage[1]);
            }
        } else {
            this.m_credMap = new HashMap();
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iomiHandle;
    }

    private IWorkspace makeIOMConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("440196d4-90f0-11d0-9f41-00a024bb830c", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)obj);
        if (iWorkspace == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iWorkspace;
    }

    private IServer makeIServerConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        IServer iServer = IServerHelper.narrow((Object)obj);
        if (iServer == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iServer;
    }

    private ISecurity_1_1 makeISecurityConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        ISecurity_1_1 iSecurity = ISecurity_1_1Helper.narrow((Object)obj);
        if (iSecurity == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iSecurity;
    }

    private ISecurityAdmin makeISecurityAdminConnection(String host, String port, String[] credential, String[] securityPackage) throws MdException {
        ConnectionInterface cx = this.makeConnection("0217e202-b560-11db-ad91-001083ff6836", host, port, credential, securityPackage);
        Object obj = cx.getObject();
        ISecurityAdmin iSecurityAdmin = ISecurityAdminHelper.narrow((Object)obj);
        if (iSecurityAdmin == null) {
            String msg = this.bundle.getString("MdOMRConnectionImpl.NullOrbReturn.msg.txt");
            throw new MdException(msg);
        }
        return iSecurityAdmin;
    }

    private ConnectionInterface makeConnection(String classID, String host, String port, String[] credential, String[] securityPackage) throws MdException {
        int iPort = Integer.parseInt(port);
        BridgeServer server = new BridgeServer(classID, host, iPort);
        if (securityPackage != null) {
            String spn;
            server.setSecurityPackage("Negotiate");
            String securityPackageList = securityPackage[0];
            if (securityPackageList != null) {
                server.setSecurityPackageList(securityPackageList);
            }
            if ((spn = securityPackage[1]) != null) {
                server.setSPN(spn);
            }
        }
        ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
        String factoryName = this.m_cxfManager.getFactoryLoggerName((ConnectionFactoryConfiguration)cxfConfig);
        MetadataWorkspace.configLogger(factoryName);
        ConnectionInterface cx = null;
        try {
            ConnectionFactoryInterface cxf = this.m_cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
            if (securityPackage != null) {
                SecurityPackageCredential cred = SecurityPackageCredential.getInstance();
                cx = cxf.getConnection((Credential)cred);
            } else {
                String userName = credential[0];
                String password = credential[1];
                cx = cxf.getConnection(userName, password);
            }
        }
        catch (ConnectionFactoryException cfe) {
            throw new MdException(cfe);
        }
        return cx;
    }

    private void closeConnection(Object obj) throws MdException {
        try {
            obj._release();
        }
        catch (SystemException se) {
            throw new MdException(se);
        }
    }

    private void disconnectConnection(Object obj) throws MdException {
        try {
            ORB orb = ((ObjectImpl)obj)._orb();
            orb.shutdown(true);
        }
        catch (SystemException se) {
            throw new MdException(se);
        }
    }
}

