/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.Converter;
import com.sas.metadata.MapPool;
import com.sas.metadata.MdEvent;
import com.sas.metadata.MdException;
import com.sas.metadata.MdFactory;
import com.sas.metadata.MdFactoryEvent;
import com.sas.metadata.MdOMIWrapper;
import com.sas.metadata.MdObjectAttribute;
import com.sas.metadata.MdObjectAttributePool;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.ResponsibleParty;
import com.sas.metadata.Root;
import com.sas.metadata.Tree;
import com.sas.metadata.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetadataUtil {
    public static final String FOLDERTYPE_HOME = "Home Folder";
    public static final String FOLDERTYPE_MYFOLDER = "My Folder";
    public static final String FOLDERTYPE_APPDATA = "Application Data";
    public static final int OMI_ALL = 1;
    public static final int OMI_EXPAND = 2;
    public static final int OMI_TEMPLATE = 4;
    public static final int OMI_ALL_SIMPLE = 8;
    public static final int OMI_INCLUDE_SUBTYPES = 16;
    public static final int OMI_DELETE = 32;
    public static final int OMI_CI_DELETE_ALL = 33;
    public static final int OMI_ALL_DESCENDANTS = 64;
    public static final int OMI_XMLSELECT = 128;
    public static final int OMI_GET_METADATA = 256;
    public static final int OMI_MATCH_CASE = 512;
    public static final int OMI_RETURN_LIST = 1024;
    public static final int OMI_SUCCINCT = 2048;
    public static final int OMI_GET_OBJREF = 4096;
    public static final int OMI_DEPENDENCY_USES = 8192;
    public static final int OMI_DEPENDENCY_USEDBY = 16384;
    public static final int OMI_LOCK = 32768;
    public static final int OMI_LOCK_TEMPLATE = 65536;
    public static final int OMI_UNLOCK = 131072;
    public static final int OMI_UNLOCK_FORCE = 262144;
    public static final int OMI_CI_NODELETE = 524288;
    public static final int OMI_NOEXPAND_DUPS = 524288;
    public static final int OMI_PURGE = 0x100000;
    public static final int OMI_REINIT = 0x200000;
    public static final int OMI_TRUNCATE = 0x400000;
    public static final int OMI_CLIENT_ID = 0x800000;
    public static final int OMI_NOFORMAT = 0x4000000;
    public static final int OMI_IGNORE_NOTFOUND = 0x8000000;
    public static final int OMI_TRUSTED_CLIENT = 0x10000000;
    public static final int OMI_GET_ID = 0x20000000;
    public static final int OMI_MULT_REQUEST = 0x40000000;
    public static final String CLSID_SAS_WORKSPACE = "440196d4-90f0-11d0-9f41-00a024bb830c";
    public static final String CLSID_SASSTP_STOREDPROCESSSERVER = "15931e31-667f-11d5-8804-00c04f35ac8c";
    public static final String CLSID_SASOMI_OMI = "0217e202-b560-11db-ad91-001083ff6836";
    public static final String CLSID_SASMDX_SERVER = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
    public static final String CLSID_SASGMS_GMS = "9c186a64-83e4-11d2-b956-00c04f81993c";
    public static final String CLSID_SASMQX_MQX = "8d9ef489-8d1e-11d2-b94f-00c04f8198c0";
    public static final String CLASSID_HTTP = "DAC0D7F0-10DA-11D6-8816-AA0004006D06";
    public static final String CLASSID_FTP = "CBA26437-1577-4FF8-93F6-9B68B4DD8D2E";
    public static final String CLASSID_MESSAGEQUEUE_MS = "MessageQueue.MSMQ";
    public static final String CLASSID_MESSAGEQUEUE_WEBSPHERE = "MessageQueue.Websphere";
    public static final String CLSID_SAS_POOLED_WORKSPACE = "620963ee-32bf-4128-bf5f-4b0df8ff90eb";
    public static final String CLASSID_MESSAGEQUEUE_JMS = "MessageQueue.JMS";
    protected static String m_Namespace = new String("SAS");
    protected static MdFactory m_factory = MdObjectFactory.getInstance();
    protected static MdOMIWrapper omi_wrapper = new MdOMIWrapper();

    public static MdOMIWrapper getOMIUtility() {
        return omi_wrapper;
    }

    public static String getNamespace() {
        return m_Namespace;
    }

    public static void setNamespace(String newNamespace) {
        m_Namespace = new String(newNamespace);
    }

    public static String getReposIdFromMetadataObject(CMetadata meta) {
        return meta == null ? "" : "A0000001." + meta.getRepositoryID();
    }

    public static CMetadata getFoundationRepository() throws MdException {
        String repos_manager_id = "A0000001.A0000001";
        int flags = 2440;
        String options = "<XMLSelect Search=\"@RepositoryType='FOUNDATION'\"/>";
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadataObjects><ReposId>");
        inXML.append("A0000001.A0000001");
        inXML.append("</ReposId><Type><RepositoryBase>");
        inXML.append("</Type><Ns>REPOS</Ns><Flags>");
        inXML.append(flags);
        inXML.append("</Flags><Options>");
        inXML.append(options);
        inXML.append("</Options></GetMetadataObjects>");
        StringHolder outXML = new StringHolder();
        Util.printLoglnClient(inXML.toString());
        try {
            IOMI connectionHandle = MetadataWorkspace.getWorkspace().getCMRHandle();
            connectionHandle.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        Document doc = MetadataUtil.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int length = secondLevelList.getLength();
        for (int k = 0; k < length; ++k) {
            CMetadata metadata;
            Node descNode;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            if (idNode == null) continue;
            String name = null;
            String desc = null;
            String id = idNode.getNodeValue();
            Node nameNode = attributeMap.getNamedItem("Name");
            if (nameNode != null) {
                name = nameNode.getNodeValue();
            }
            if ((descNode = attributeMap.getNamedItem("Desc")) != null) {
                desc = descNode.getNodeValue();
            }
            if ((metadata = MdObjectFactory.createSimpleMetadataObject(name, "Environment", id)) == null) continue;
            metadata.setDesc(desc, 2);
            return metadata;
        }
        return null;
    }

    public static List getRepositories() throws MdException {
        return MetadataUtil.getRepositories(MetadataWorkspace.getWorkspace().getCMRHandle());
    }

    public static List getRepositories(IOMI connectionHandle) throws MdException {
        Vector<CMetadata> returnValues = new Vector<CMetadata>();
        StringHolder outXML = new StringHolder();
        String inputXML = "<GetRepositories><Repositories/><Flags>0</Flags><Options/></GetRepositories>";
        Util.printLoglnClient(inputXML);
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetRepositories(outXML, 0, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",GetRepositories," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        Document mainDoc = MetadataUtil.parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            int cRepositories = nodeList.getLength();
            for (int index = 0; index < cRepositories; ++index) {
                String strFQID;
                NamedNodeMap childNodeMap = nodeList.item(index).getAttributes();
                String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                try {
                    strFQID = childNodeMap.getNamedItem("Id").getNodeValue();
                }
                catch (Exception e) {
                    strFQID = childNodeMap.getNamedItem("ObjRef").getNodeValue();
                }
                String strDesc = childNodeMap.getNamedItem("Desc").getNodeValue();
                String strType = "Environment";
                MdObjectFactory cfr_ignored_0 = (MdObjectFactory)m_factory;
                CMetadata metadata = MdObjectFactory.createSimpleMetadataObject(strName, strType, strFQID);
                if (metadata == null) continue;
                metadata.setDesc(strDesc, 2);
                returnValues.add(metadata);
            }
        }
        mainDoc = null;
        return returnValues;
    }

    public static String getMetadataSimple(String strType, String strFQID, String attributeName) throws MdException {
        ArrayList<String> attributeList = new ArrayList<String>(1);
        attributeList.add(attributeName);
        List attrs = MetadataUtil.getMetadataSimple(strType, strFQID, attributeList);
        return attrs.size() > 0 ? (String)attrs.get(0) : "";
    }

    public static List getMetadataSimple(String strType, String strFQID, List attributes) throws MdException {
        int iLength = attributes.size();
        Vector<String> outData = new Vector<String>(iLength);
        String inXML = MetadataUtil.createGetXMLString(strType, strFQID, attributes, null);
        Document doc = MetadataUtil.getMetadata(inXML, 0);
        Node firstNode = doc.getFirstChild();
        NamedNodeMap childNodeMap = firstNode.getAttributes();
        for (int i = 0; i < iLength; ++i) {
            String value = (String)attributes.get(i);
            outData.add(i, childNodeMap.getNamedItem(value).getNodeValue());
        }
        firstNode = null;
        childNodeMap = null;
        doc = null;
        return outData;
    }

    public static CMetadata getMetadataAllDepths(CMetadata object, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions) throws MdException {
        return MetadataUtil.getMetadataAllDepths(object, inSimpleAttr, inComplexObject, strTemplate, iOptions, false);
    }

    public static CMetadata getMetadataAllDepths(CMetadata object, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataAllDepths(object, inSimpleAttr, inComplexObject, strTemplate, iOptions, doNotOverrideAssocs);
        }
        if (object == null || object.getFQID().indexOf(36) > -1 || !object.getObjectStore().isGoToServerForMetadata()) {
            Util.printOutputln(MdObjectFactory.getBundle().getString("MetadataUtil.getMetadataAllDepthsNotToServer.txt"));
            return object;
        }
        String inXML = MetadataUtil.createGetXMLString(object.getCMetadataType(), object.getFQID(), inSimpleAttr, inComplexObject);
        Document doc = MetadataUtil.getMetadata(inXML, strTemplate, iOptions);
        if ((object = MetadataUtil.createObjectInStore(object.getObjectStore(), object.getName(), object.getCMetadataType(), object.getFQID())) == null) {
            return object;
        }
        Node firstNode = doc.getFirstChild();
        CMetadata returnObject = MetadataUtil.populateObject(object, firstNode.getAttributes(), firstNode.getChildNodes(), doNotOverrideAssocs);
        firstNode = null;
        doc = null;
        if (returnObject.getObjectStore().getStoreType() == 0) {
            returnObject.resetObject();
        }
        return returnObject;
    }

    public static CMetadata getMetadataAllDepths(MdStore inStore, String strType, String strFQID, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions) throws MdException {
        return MetadataUtil.getMetadataAllDepths(inStore, strType, strFQID, inSimpleAttr, inComplexObject, strTemplate, iOptions, false);
    }

    public static CMetadata getMetadataAllDepths(MdStore inStore, String strType, String strFQID, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs) throws MdException {
        return MetadataUtil.getMetadataAllDepths(inStore, strType, strFQID, inSimpleAttr, inComplexObject, strTemplate, iOptions, doNotOverrideAssocs, true);
    }

    public static CMetadata getMetadataAllDepths(MdStore inStore, String strType, String strFQID, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException {
        return MetadataUtil.getMetadataAllDepths(MetadataWorkspace.getWorkspace().getCMRHandle(), inStore, strType, strFQID, inSimpleAttr, inComplexObject, strTemplate, iOptions, doNotOverrideAssocs, doNotOverrideAttrs);
    }

    public static CMetadata getMetadataAllDepths(IOMI connectionHandle, MdStore inStore, String strType, String strFQID, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataAllDepths(connectionHandle, inStore, strType, strFQID, inSimpleAttr, inComplexObject, strTemplate, iOptions, doNotOverrideAssocs, doNotOverrideAttrs);
        }
        String inXML = MetadataUtil.createGetXMLString(strType, strFQID, inSimpleAttr, inComplexObject);
        Document doc = MetadataUtil.getMetadata(connectionHandle, inXML, strTemplate, iOptions);
        Node firstNode = doc.getFirstChild();
        if (strType == null) {
            throw new MdException("Cannot create object with null type");
        }
        CMetadata metaObject = MetadataUtil.createObjectInStore(inStore, "", strType, strFQID);
        if (metaObject == null) {
            return null;
        }
        if (metaObject.getFQID().indexOf(36) > -1 || !metaObject.getObjectStore().isGoToServerForMetadata()) {
            Util.printOutputln(MdObjectFactory.getBundle().getString("MetadataUtil.getMetadataAllDepthsNotToServer.txt"));
            return metaObject;
        }
        CMetadata temp = MetadataUtil.populateObject(metaObject, firstNode.getAttributes(), firstNode.getChildNodes(), doNotOverrideAssocs, doNotOverrideAttrs, 2);
        firstNode = null;
        doc = null;
        if (temp.getObjectStore().getStoreType() == 0) {
            temp.resetObject();
        }
        return temp;
    }

    public static void populateStoreFromString(MdStore inStore, Document doc, int state, boolean useReposForNewObjects) throws MdException {
        Node firstNode = doc.getFirstChild();
        ArrayList<CMetadata> createdObjects = new ArrayList<CMetadata>(10);
        NodeList myNodeList = firstNode.getChildNodes();
        int length = myNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            CMetadata metaObject;
            String strId = "";
            String strName = "";
            NamedNodeMap nodeMap = myNodeList.item(i).getAttributes();
            if (nodeMap == null || nodeMap.getLength() == 0) continue;
            String strType = myNodeList.item(i).getNodeName();
            Node idNode = nodeMap.getNamedItem("Id");
            boolean populate = true;
            if (idNode == null) {
                idNode = nodeMap.getNamedItem("ObjRef");
                populate = false;
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            strId = idNode.getNodeValue();
            Node nameNode = nodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = MetadataUtil.createObjectInStore(inStore, strName, strType, strId)) == null) continue;
            createdObjects.add(metaObject);
            MetadataUtil.populateObjectsLocal(metaObject, myNodeList.item(i).getAttributes(), myNodeList.item(i).getChildNodes(), false, state, populate, createdObjects);
        }
        if (useReposForNewObjects) {
            for (CMetadata listObject : createdObjects) {
                if (!listObject.isNewObject()) continue;
                String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                MdObjectFactory cfr_ignored_0 = (MdObjectFactory)m_factory;
                MdObjectFactory.changeHashKey(listObject.getId(), newId);
            }
        }
        myNodeList = null;
        firstNode = null;
    }

    public static void populateStoreFromString(MdStore inStore, String inXML, int state, boolean useReposForNewObjects) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            omi_wrapper.populateStoreFromString(inStore, inXML, state, useReposForNewObjects);
            return;
        }
        Document doc = MetadataUtil.parseXML(inXML);
        ArrayList<CMetadata> createdObjects = new ArrayList<CMetadata>(10);
        Node firstNode = doc.getFirstChild();
        NodeList myNodeList = firstNode.getChildNodes();
        int length = myNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            CMetadata metaObject;
            String strId = "";
            String strName = "";
            NamedNodeMap nodeMap = myNodeList.item(i).getAttributes();
            String strType = myNodeList.item(i).getNodeName();
            if (nodeMap == null || nodeMap.getLength() == 0 || strType.indexOf("#") > -1) continue;
            Node idNode = nodeMap.getNamedItem("Id");
            boolean populate = true;
            if (idNode == null) {
                idNode = nodeMap.getNamedItem("ObjRef");
                populate = false;
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            strId = idNode.getNodeValue();
            Node nameNode = nodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = MetadataUtil.createObjectInStore(inStore, strName, strType, strId)) == null) continue;
            createdObjects.add(metaObject);
            MetadataUtil.populateObjectsLocal(metaObject, myNodeList.item(i).getAttributes(), myNodeList.item(i).getChildNodes(), false, state, populate, createdObjects);
        }
        if (useReposForNewObjects) {
            for (CMetadata listObject : createdObjects) {
                if (!listObject.isNewObject()) continue;
                String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                MdObjectFactory cfr_ignored_0 = (MdObjectFactory)m_factory;
                MdObjectFactory.changeHashKey(listObject.getId(), newId);
            }
        }
        myNodeList = null;
        firstNode = null;
        doc = null;
    }

    public static void populateStoreFromInputStream(MdStore inStore, InputStream stream, int state, boolean useReposForNewObjects) throws MdException {
        omi_wrapper.populateStoreFromInputStream(inStore, stream, state, useReposForNewObjects);
    }

    public static CMetadata populateObject(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList) throws MdException {
        return MetadataUtil.populateObject(metaObject, simpleNodeMap, complexNodeList, false);
    }

    public static CMetadata populateObject(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssocs) throws MdException {
        return MetadataUtil.populateObject(metaObject, simpleNodeMap, complexNodeList, doNotOverrideAssocs, true, 2);
    }

    public static CMetadata populateObject(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs, int state) throws MdException {
        metaObject = MetadataUtil.doSimple(metaObject, simpleNodeMap, state, doNotOverrideAttrs);
        ArrayList outComplexNames = new ArrayList();
        List[] outComplexObjects = new ArrayList[10];
        outComplexObjects = MetadataUtil.createObjectAssociations(metaObject, complexNodeList, outComplexNames, outComplexObjects, doNotOverrideAssocs);
        if ((metaObject.getState() & 4) > 0) {
            metaObject.resetState(4);
        }
        int assoc_state = 1;
        if (state == 1) {
            assoc_state = 4;
        }
        MetadataUtil.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssocs, assoc_state);
        for (int i = 0; i < outComplexObjects.length; ++i) {
            outComplexObjects[i].clear();
            outComplexObjects[i] = null;
        }
        outComplexObjects = null;
        outComplexNames.clear();
        outComplexNames = null;
        return metaObject;
    }

    public static CMetadata populateObjectsLocal(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssocs, int state, boolean setAttrs, List createdObjects) throws MdException {
        if (setAttrs) {
            metaObject = MetadataUtil.doSimple(metaObject, simpleNodeMap, state, doNotOverrideAssocs);
        }
        ArrayList outComplexNames = new ArrayList();
        List[] outComplexObjects = new ArrayList[10];
        outComplexObjects = MetadataUtil.createObjectAssociationsLocal(metaObject, complexNodeList, outComplexNames, outComplexObjects, doNotOverrideAssocs, state, createdObjects);
        int assoc_state = 1;
        if (state == 1) {
            assoc_state = 4;
        }
        MetadataUtil.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssocs, assoc_state);
        for (int i = 0; i < outComplexObjects.length; ++i) {
            outComplexObjects[i].clear();
            outComplexObjects[i] = null;
        }
        outComplexObjects = null;
        outComplexNames.clear();
        outComplexNames = null;
        return metaObject;
    }

    public static List populateObjects(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssns, List objects) throws MdException {
        return MetadataUtil.populateObjects(metaObject, simpleNodeMap, complexNodeList, doNotOverrideAssns, true, objects);
    }

    public static List populateObjects(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList complexNodeList, boolean doNotOverrideAssns, boolean doNotOverrideAttrs, List objects) throws MdException {
        int i;
        metaObject = MetadataUtil.doSimple(metaObject, simpleNodeMap, 2, doNotOverrideAttrs);
        ArrayList outComplexNames = new ArrayList();
        List[] outComplexObjects = new ArrayList[10];
        outComplexObjects = MetadataUtil.createObjectAssociations(metaObject, complexNodeList, outComplexNames, outComplexObjects, doNotOverrideAssns, objects);
        if ((metaObject.getState() & 4) > 0) {
            metaObject.resetState(4);
        }
        MetadataUtil.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssns);
        if (!objects.contains(metaObject)) {
            objects.add(metaObject);
        }
        for (i = 0; i < outComplexObjects.length; ++i) {
            List listobject = outComplexObjects[i];
            for (int j = 0; j < listobject.size(); ++j) {
                if (objects.contains(listobject.get(j))) continue;
                objects.add(listobject.get(j));
            }
        }
        for (i = 0; i < outComplexObjects.length; ++i) {
            outComplexObjects[i].clear();
            outComplexObjects[i] = null;
        }
        outComplexObjects = null;
        outComplexNames.clear();
        outComplexNames = null;
        return objects;
    }

    public static CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap) throws MdException {
        return MetadataUtil.doSimple(thisObject, thisNodeMap, 2);
    }

    public static CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap, int state) throws MdException {
        return MetadataUtil.doSimple(thisObject, thisNodeMap, state, true);
    }

    public static CMetadata doSimple(CMetadata thisObject, NamedNodeMap thisNodeMap, int state, boolean doNotOverrideValues) throws MdException {
        int iLengthinSimpleAttr = thisNodeMap.getLength();
        if (thisObject == null) {
            return thisObject;
        }
        Map<String, Integer> attrStates = thisObject.getAttrsStates();
        MapPool.instance();
        HashMap setAttrs = MapPool.getMap();
        for (int i = 0; i < iLengthinSimpleAttr; ++i) {
            try {
                String attrName = thisNodeMap.item(i).getNodeName();
                if (attrName == null) continue;
                Integer attrState = attrStates.get(attrName);
                if (doNotOverrideValues && attrState != null && attrState == 1) continue;
                MdObjectAttribute attribute = MdObjectAttributePool.instance().getMdObjectAttribute();
                attribute.setAttributeName(attrName);
                attribute.setAttributeState(state);
                attribute.setAttributeValue(thisNodeMap.item(i).getNodeValue());
                setAttrs.put(attrName, attribute);
                continue;
            }
            catch (Exception e) {
                throw new MdException(e);
            }
        }
        thisObject.setAttrs(setAttrs);
        MdObjectAttributePool.instance().returnMapOfMdObjectAttributes(setAttrs);
        MapPool.instance();
        MapPool.returnMap(setAttrs);
        setAttrs = null;
        MapPool.instance();
        MapPool.returnMap(attrStates);
        attrStates = null;
        return thisObject;
    }

    private static List[] createObjectAssociations(CMetadata thisObject, NodeList thisNodeList, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssocs) throws MdException {
        String id = null;
        int numChildLists = thisNodeList.getLength();
        outComplexObjects = new ArrayList[numChildLists];
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[k] = new ArrayList(length);
            outComplexNames.add(k, thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                CMetadata complexObject;
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                String strType = myChildNodeList.item(i).getNodeName();
                boolean populateObject = true;
                Node idNode = childNodeMap2.getNamedItem("Id");
                if (idNode == null) {
                    idNode = childNodeMap2.getNamedItem("ObjRef");
                    populateObject = false;
                }
                if (idNode == null) {
                    throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
                }
                id = idNode.getNodeValue();
                Node nameNode = childNodeMap2.getNamedItem("Name");
                String strName = "";
                if (nameNode != null) {
                    strName = nameNode.getNodeValue();
                }
                if (thisObject == null || (complexObject = MdObjectFactory.createComplexMetadataObject(thisObject.getObjectStore(), thisObject.getObjectStore().getOwningStore(), strName, strType, id, null)) == null) continue;
                if (populateObject) {
                    complexObject = MetadataUtil.populateObject(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), doNotOverrideAssocs);
                }
                outComplexObjects[k].add(complexObject);
            }
        }
        return outComplexObjects;
    }

    private static List[] createObjectAssociationsLocal(CMetadata thisObject, NodeList thisNodeList, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssocs, int state, List createdObjects) throws MdException {
        String id = null;
        int numChildLists = thisNodeList.getLength();
        outComplexObjects = new ArrayList[numChildLists];
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[k] = new ArrayList(length);
            outComplexNames.add(k, thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                CMetadata complexObject;
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                if (childNodeMap2 == null || childNodeMap2.getLength() == 0) continue;
                String strType = myChildNodeList.item(i).getNodeName();
                boolean populate = true;
                Node idNode = childNodeMap2.getNamedItem("Id");
                if (idNode == null) {
                    idNode = childNodeMap2.getNamedItem("ObjRef");
                    populate = false;
                }
                if (idNode == null) {
                    throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
                }
                id = idNode.getNodeValue();
                Node nameNode = childNodeMap2.getNamedItem("Name");
                String strName = "";
                if (nameNode != null) {
                    strName = nameNode.getNodeValue();
                }
                if (thisObject == null || (complexObject = MdObjectFactory.createComplexMetadataObject(thisObject.getObjectStore(), null, strName, strType, id, null)) == null) continue;
                createdObjects.add(complexObject);
                if (populate) {
                    MetadataUtil.populateObjectsLocal(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), doNotOverrideAssocs, state, true, createdObjects);
                }
                outComplexObjects[k].add(complexObject);
            }
        }
        return outComplexObjects;
    }

    private static List[] createObjectAssociations(CMetadata thisObject, NodeList thisNodeList, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssocs, List objects) throws MdException {
        String id = null;
        int numChildLists = thisNodeList.getLength();
        outComplexObjects = new ArrayList[numChildLists];
        for (int k = 0; k < numChildLists; ++k) {
            NodeList myChildNodeList = thisNodeList.item(k).getChildNodes();
            int length = myChildNodeList.getLength();
            outComplexObjects[k] = new ArrayList(length);
            outComplexNames.add(k, thisNodeList.item(k).getNodeName());
            for (int i = 0; i < length; ++i) {
                CMetadata complexObject;
                NamedNodeMap childNodeMap2 = myChildNodeList.item(i).getAttributes();
                String strType = myChildNodeList.item(i).getNodeName();
                Node idNode = childNodeMap2.getNamedItem("Id");
                boolean populateObject = true;
                if (idNode == null) {
                    idNode = childNodeMap2.getNamedItem("ObjRef");
                    populateObject = false;
                }
                if (idNode == null) {
                    throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
                }
                id = idNode.getNodeValue();
                Node nameNode = childNodeMap2.getNamedItem("Name");
                String strName = "";
                if (nameNode != null) {
                    strName = nameNode.getNodeValue();
                }
                if (thisObject == null || (complexObject = MdObjectFactory.createComplexMetadataObject(thisObject.getObjectStore(), thisObject.getObjectStore().getOwningStore(), strName, strType, id, null)) == null) continue;
                if (populateObject) {
                    MetadataUtil.populateObjects(complexObject, childNodeMap2, myChildNodeList.item(i).getChildNodes(), doNotOverrideAssocs, objects);
                }
                outComplexObjects[k].add(complexObject);
            }
        }
        return outComplexObjects;
    }

    public static void setObjectAssociations(CMetadata metaObject, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssns) throws MdException {
        MetadataUtil.setObjectAssociations(metaObject, outComplexNames, outComplexObjects, doNotOverrideAssns, 1);
    }

    public static void setObjectAssociations(CMetadata metaObject, List outComplexNames, List[] outComplexObjects, boolean doNotOverrideAssns, int state) throws MdException {
        int length = outComplexNames.size();
        if (metaObject == null) {
            return;
        }
        Map<String, AssociationList> assns = metaObject.getPopulatedAssocs();
        for (int i = 0; i < length; ++i) {
            String AssocName = (String)outComplexNames.get(i);
            if (AssocName.charAt(0) == '#') continue;
            AssociationList assn = assns.get(AssocName);
            if (doNotOverrideAssns && assn != null) continue;
            assn = null;
            AssociationList complexAssoc = new AssociationList(AssocName, outComplexObjects[i]);
            complexAssoc.setState(state);
            metaObject.setMdObjectAssociation(complexAssoc);
        }
        MapPool.instance();
        MapPool.returnMap(assns);
        assns = null;
    }

    private static CMetadata createObjectInStore(MdStore store, String name, String type, String id) {
        if (store == null || store.getStoreType() == 0) {
            return MdObjectFactory.createComplexMetadataObjectServerStoreOnly(name, type, id);
        }
        if (store.getStoreType() == 1) {
            return MdObjectFactory.createComplexMetadataObject((MdObjectStore)store, null, name, type, id, null);
        }
        return null;
    }

    public static String getUserHomeFolderName(String userName, String folderName) {
        String displayName;
        block2: {
            displayName = null;
            try {
                displayName = MetadataUtil.getUserHomeFolderAttribute("DisplayName", userName, folderName, false);
            }
            catch (MdException e) {
                int startIndex;
                String msg = e.getLocalizedMessage();
                String userFolder = "user folder";
                int index = msg.indexOf("user folder");
                if (index <= -1 || (startIndex = msg.indexOf(39, index)) <= index) break block2;
                int endIndex = msg.indexOf(39, startIndex + 1);
                displayName = msg.substring(startIndex + 1, endIndex);
            }
        }
        return displayName == null ? folderName : displayName;
    }

    public static Tree getUserHomeFolder(MdObjectStore store, String userName, String folderName, String template, int flags) throws MdException {
        return MetadataUtil.getUserHomeFolder(store, userName, folderName, template, flags, false);
    }

    public static Tree getUserHomeFolder(MdObjectStore store, String userName, String folderName, String template, int flags, boolean createIfNecessary) throws MdException {
        String folderID;
        block6: {
            folderID = null;
            try {
                folderID = MetadataUtil.getUserHomeFolderAttribute("Id", userName, folderName, false);
            }
            catch (MdException e) {
                if (createIfNecessary) break block6;
                throw e;
            }
        }
        if (folderID == null && createIfNecessary) {
            folderID = MetadataUtil.getUserHomeFolderAttribute("Id", userName, folderName, true);
        }
        if (folderID != null) {
            if (flags == 0 && (template == null || template.length() == 0)) {
                flags |= 4;
                template = "<Templates><Tree Name=\"\" PublicType=\"\" UsageVersion=\"\"/></Templates>";
            }
            Tree tree = (Tree)MetadataUtil.getMetadataAllDepths(store, "Tree", folderID, null, null, template, flags);
            if (createIfNecessary) {
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put(folderID, "Tree");
                MdObjectFactory.fireMdObjectsCreated(new MdFactoryEvent(m_factory, map));
                MdObjectFactory.fireMdObjectsModified(new MdFactoryEvent(m_factory, new HashMap(map)));
            }
            return tree;
        }
        return null;
    }

    private static String getUserHomeFolderAttribute(String attributeName, String userName, String folderName, boolean create) throws MdException {
        IOMI connectionHandle = MetadataWorkspace.getWorkspace().getCMRHandle();
        StringBuffer sb = new StringBuffer();
        if (create) {
            sb.append("<AddUserFolders>");
            sb.append("<Tree PersonName=\"");
            sb.append(userName);
            sb.append("\" FolderName=\"");
            sb.append(folderName);
            sb.append("\"/></AddUserFolders>");
        } else {
            sb.append("<GetUserFolders>");
            sb.append("<Tree PersonName=\"");
            sb.append(userName);
            sb.append("\" FolderName=\"");
            sb.append(folderName);
            sb.append("\"/></GetUserFolders>");
        }
        String inputXML = sb.toString();
        Util.printLoglnClient(inputXML);
        StringHolder outputXML = new StringHolder();
        try {
            connectionHandle.DoRequest(inputXML, outputXML);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String output = outputXML.value;
        Util.printLoglnServer(output);
        String search = attributeName + "=\"";
        int attrLength = search.length();
        int index = output.indexOf(search);
        return index > -1 ? output.substring(index + attrLength, output.indexOf("\"", index + attrLength)) : null;
    }

    public static ResponsibleParty getResponsibleParty(MdObjectStore store, String identityName, String responsibility) throws MdException {
        int flags = 2056;
        return MetadataUtil.getResponsibleParty(store, identityName, responsibility, null, flags);
    }

    public static ResponsibleParty getResponsibleParty(MdObjectStore store, String identityName, String responsibility, String template, int flags) throws MdException {
        String respPartyID = MetadataUtil.getResponsiblePartyID(identityName, responsibility, false);
        if (respPartyID == null || respPartyID.length() == 0) {
            respPartyID = MetadataUtil.getResponsiblePartyID(identityName, responsibility, true);
        }
        if (respPartyID != null) {
            if (template == null) {
                template = "";
            }
            ResponsibleParty respParty = (ResponsibleParty)MetadataUtil.getMetadataAllDepths(store, "ResponsibleParty", respPartyID, null, null, template, flags);
            return respParty;
        }
        return null;
    }

    private static String getResponsiblePartyID(String identityName, String responsibility, boolean create) throws MdException {
        IOMI connectionHandle = MetadataWorkspace.getWorkspace().getCMRHandle();
        StringBuffer sb = new StringBuffer();
        if (create) {
            sb.append("<AddResponsibleParty>");
            sb.append("<ResponsibleParty IdentityName=\"");
            sb.append(identityName);
            sb.append("\" Responsibility=\"");
            sb.append(responsibility);
            sb.append("\"/></AddResponsibleParty>");
        } else {
            sb.append("<GetResponsibleParty>");
            sb.append("<ResponsibleParty IdentityName=\"");
            sb.append(identityName);
            sb.append("\" Responsibility=\"");
            sb.append(responsibility);
            sb.append("\"/></GetResponsibleParty>");
        }
        String inputXML = sb.toString();
        Util.printLoglnClient(inputXML);
        StringHolder outputXML = new StringHolder();
        try {
            connectionHandle.DoRequest(inputXML, outputXML);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String output = outputXML.value;
        Util.printLoglnServer(output);
        String idAttribute = "Id=\"";
        int index = output.indexOf(idAttribute);
        return index > -1 ? output.substring(index + 4, output.indexOf("\"", index + 4)) : null;
    }

    public static int doesObjectExist(String reposID, String objectType, String xmlSelect) throws MdException {
        return MetadataUtil.doesObjectExist(MetadataWorkspace.getWorkspace().getCMRHandle(), reposID, objectType, xmlSelect);
    }

    public static int doesObjectExist(IOMI connectionHandle, String reposID, String objectType, String xmlSelect) throws MdException {
        int flags = 256;
        if (xmlSelect == null) {
            xmlSelect = "";
        } else {
            flags |= 0x80;
        }
        String outXMLString = MetadataUtil.getMetadataObjectsFromServer(connectionHandle, reposID, objectType, flags, xmlSelect);
        if (outXMLString.length() <= 10) {
            return 0;
        }
        int count = 0;
        Pattern assocPattern = Pattern.compile("<" + objectType);
        Matcher m = assocPattern.matcher(outXMLString);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static List getMetadataObjectsSubset(MdStore inStore, String strReposID, String strType, int flags, String options) throws MdException {
        return MetadataUtil.getMetadataObjectsSubset(inStore, strReposID, strType, flags, options, false);
    }

    public static List getMetadataObjectsSubset(MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException {
        return MetadataUtil.getMetadataObjectsSubset(MetadataWorkspace.getWorkspace().getCMRHandle(), inStore, strReposID, strType, flags, options, doOverrideAssocs);
    }

    public static List getMetadataObjectsSubset(IOMI connectionHandle, MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataObjectsSubset(connectionHandle, inStore, strReposID, strType, flags, options, doOverrideAssocs);
        }
        Vector<CMetadata> outObjects = new Vector<CMetadata>(0);
        if (inStore != null && !inStore.isGoToServerForMetadata()) {
            Util.printOutputln("Debug Note: getMetadataObjectsSubset Not going to server...");
            return outObjects;
        }
        String outXMLString = MetadataUtil.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, options);
        Document doc = MetadataUtil.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            String tempStrType;
            CMetadata metaObject;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            boolean populateObject = true;
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            String strFQID = idNode.getNodeValue();
            String strName = "";
            Node nameNode = attributeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = MetadataUtil.createObjectInStore(inStore, strName, tempStrType = secondLevelList.item(k).getNodeName(), strFQID)) == null) continue;
            if (populateObject) {
                MetadataUtil.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doOverrideAssocs);
            }
            outObjects.add(metaObject);
            if (metaObject == null || metaObject.getObjectStore() == null || metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        outXMLString = null;
        firstNode = null;
        secondLevelList = null;
        doc = null;
        return outObjects;
    }

    public static List getMetadataObjectsSubsetList(MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException {
        return MetadataUtil.getMetadataObjectsSubsetList(MetadataWorkspace.getWorkspace().getCMRHandle(), inStore, strReposID, strType, flags, options, doOverrideAssocs);
    }

    public static List getMetadataObjectsSubsetList(IOMI connectionHandle, MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataObjectsSubsetList(connectionHandle, inStore, strReposID, strType, flags, options, doOverrideAssocs);
        }
        ArrayList outObjects = new ArrayList(100);
        if (inStore != null && !inStore.isGoToServerForMetadata()) {
            Util.printOutputln("Debug Note: getMetadataObjectsSubsetList() Not going to server...");
            return outObjects;
        }
        String outXMLString = MetadataUtil.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, options);
        Document doc = MetadataUtil.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            String tempStrType;
            CMetadata metaObject;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            boolean populateObject = true;
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            String strFQID = idNode.getNodeValue();
            String strName = "";
            Node nameNode = attributeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = MetadataUtil.createObjectInStore(inStore, strName, tempStrType = secondLevelList.item(k).getNodeName(), strFQID)) == null) continue;
            if (populateObject) {
                MetadataUtil.populateObjects(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doOverrideAssocs, outObjects);
            }
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        outXMLString = null;
        firstNode = null;
        secondLevelList = null;
        doc = null;
        return outObjects;
    }

    public static List getMetadataObjects(String strReposID, String strType, int iFlags) throws MdException {
        return MetadataUtil.getMetadataObjects(strReposID, strType, iFlags, "");
    }

    public static List getMetadataObjects(String strReposID, String strType) throws MdException {
        return MetadataUtil.getMetadataObjects(strReposID, strType, 0, "");
    }

    public static List getMetadataObjects(String strReposID, String strType, int flags, String strOptions) throws MdException {
        return MetadataUtil.getMetadataObjects(MetadataWorkspace.getWorkspace().getCMRHandle(), strReposID, strType, flags, strOptions);
    }

    public static List getMetadataObjects(IOMI connectionHandle, String strReposID, String strType, int flags, String strOptions) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataObjects(connectionHandle, strReposID, strType, flags, strOptions);
        }
        Vector<Root> outData = new Vector<Root>();
        String outXMLString = MetadataUtil.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, strOptions);
        Document doc = MetadataUtil.parseXML(outXMLString);
        Node firstNode = doc.getFirstChild();
        NodeList myNodeList = firstNode.getChildNodes();
        int length = myNodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String strId = "";
            String strName = "";
            NamedNodeMap nodeMap = myNodeList.item(i).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode == null) {
                idNode = nodeMap.getNamedItem("ObjRef");
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            strId = idNode.getNodeValue();
            Node nameNode = nodeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            String strLockedBy = null;
            Node thisNode = nodeMap.getNamedItem("LockedBy");
            if (thisNode != null) {
                strLockedBy = thisNode.getNodeValue();
            }
            MdObjectFactory cfr_ignored_0 = (MdObjectFactory)m_factory;
            Root cmobject = (Root)MdObjectFactory.createSimpleMetadataObject(strName, strType, strId, strLockedBy);
            thisNode = nodeMap.getNamedItem("ChangeState");
            if (thisNode != null) {
                cmobject.setChangeState(thisNode.getNodeValue());
            }
            outData.add(cmobject);
        }
        doc = null;
        return outData;
    }

    public static List getMetadataObjects(MdStore inStore, String inXML, String strTemplate, int iFlags) throws MdException {
        return MetadataUtil.getMetadataObjects(inStore, inXML, strTemplate, iFlags, false);
    }

    public static List getMetadataObjects(MdStore inStore, String inXML, String strTemplate, int iFlags, boolean doNotOverrideAssocs) throws MdException {
        return MetadataUtil.getMetadataObjects(MetadataWorkspace.getWorkspace().getCMRHandle(), inStore, inXML, strTemplate, iFlags, doNotOverrideAssocs);
    }

    public static List getMetadataObjects(IOMI connectionHandle, MdStore inStore, String inXML, String strTemplate, int iFlags, boolean doNotOverrideAssocs) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataObjects(connectionHandle, inStore, inXML, strTemplate, iFlags, doNotOverrideAssocs);
        }
        Vector<CMetadata> outObjects = new Vector<CMetadata>(0);
        if (inStore != null && !inStore.isGoToServerForMetadata()) {
            return outObjects;
        }
        String strFQID = null;
        String strName = null;
        String outXMLString = MetadataUtil.getMetadataFromServer(connectionHandle, inXML, iFlags, strTemplate);
        StringBuffer sb = new StringBuffer(outXMLString.length() + 21);
        sb.append("<Metadata>");
        sb.append(outXMLString);
        sb.append("</Metadata>");
        Document doc = MetadataUtil.parseXML(sb.toString());
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            boolean populateObject = true;
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            strFQID = idNode.getNodeValue();
            Node nameNode = attributeMap.getNamedItem("Name");
            strName = nameNode != null ? nameNode.getNodeValue() : "";
            String tempStrType = secondLevelList.item(k).getNodeName();
            CMetadata metaObject = MetadataUtil.createObjectInStore(inStore, strName, tempStrType, strFQID);
            if (metaObject == null) continue;
            if (populateObject) {
                MetadataUtil.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doNotOverrideAssocs);
            }
            outObjects.add(metaObject);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        doc = null;
        return outObjects;
    }

    public static List getMetadata(MdStore store, Map objectMap, String template, int flags) throws MdException {
        return MetadataUtil.getMetadata(store, objectMap, template, flags, false, true);
    }

    public static List getMetadata(MdStore store, Map objectMap, String template, int flags, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException {
        return MetadataUtil.getMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), store, objectMap, template, flags, doNotOverrideAssocs, doNotOverrideAttrs);
    }

    public static List getMetadata(IOMI connectionHandle, MdStore store, Map objectMap, String template, int flags, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadata(connectionHandle, store, objectMap, template, flags, doNotOverrideAssocs, doNotOverrideAttrs);
        }
        if (objectMap == null || objectMap.size() == 0 || !store.isGoToServerForMetadata()) {
            Util.printOutputln("Debug Note: getMetadata not going to server...");
            return new ArrayList();
        }
        ArrayList<CMetadata> outObjects = new ArrayList<CMetadata>();
        String inXML = MetadataUtil.createGetXMLString(objectMap);
        String outXMLString = MetadataUtil.getMetadataFromServer(connectionHandle, inXML, flags, template);
        StringBuffer sb = new StringBuffer(21 + outXMLString.length());
        sb.append("<Metadata>");
        sb.append(outXMLString);
        sb.append("</Metadata>");
        Document doc = MetadataUtil.parseXML(sb.toString());
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            String tempStrType;
            CMetadata metaObject;
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            boolean populateObject = true;
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
                populateObject = false;
            }
            if (idNode == null) {
                throw new MdException(MdObjectFactory.getBundle().getString("MetadataUtil.IdMustBeSpecInInputXML.txt"));
            }
            String id = idNode.getNodeValue();
            String strName = "";
            Node nameNode = attributeMap.getNamedItem("Name");
            if (nameNode != null) {
                strName = nameNode.getNodeValue();
            }
            if ((metaObject = MetadataUtil.createObjectInStore(store, strName, tempStrType = secondLevelList.item(k).getNodeName(), id)) == null) continue;
            if (populateObject) {
                MetadataUtil.populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), doNotOverrideAssocs, doNotOverrideAttrs, 2);
            }
            outObjects.add(metaObject);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        firstNode = null;
        secondLevelList = null;
        doc = null;
        return outObjects;
    }

    public static Document getMetadata(String inXML, int iFlags) throws MdException {
        return MetadataUtil.getMetadata(inXML, "", iFlags);
    }

    public static Document getMetadata(String inXML, String strTemplate, int iFlags) throws MdException {
        return MetadataUtil.getMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, strTemplate, iFlags);
    }

    public static Document getMetadata(IOMI connectionHandle, String inXML, String strTemplate, int iFlags) throws MdException {
        String outXMLString = MetadataUtil.getMetadataFromServer(connectionHandle, inXML.toString(), iFlags, strTemplate);
        Document doc = MetadataUtil.parseXML(outXMLString);
        return doc;
    }

    public static Document DoRequest(String inXML) throws MdException {
        return MetadataUtil.DoRequest(inXML, true);
    }

    public static Map getMetadataNoCache(String strType, String strFQID, String strOptions, int iFlags) throws MdException {
        return MetadataUtil.getMetadataNoCache(MetadataWorkspace.getWorkspace().getCMRHandle(), strType, strFQID, strOptions, iFlags);
    }

    public static Map getMetadataNoCache(IOMI connectionHandle, String strType, String strFQID, String strOptions, int iFlags) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataNoCache(connectionHandle, strType, strFQID, strOptions, iFlags);
        }
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(strType);
        inXML.append(" Id=\"");
        inXML.append(strFQID);
        inXML.append("\"/>");
        String outXMLString = MetadataUtil.getMetadataFromServer(connectionHandle, inXML.toString(), iFlags, strOptions);
        Document doc = MetadataUtil.parseXML(outXMLString);
        HashMap objectMap = new HashMap();
        Node firstNode = doc.getFirstChild();
        MetadataUtil.addObjectAttributesToMap(firstNode, objectMap);
        MetadataUtil.addObjectAssociationsToMap(firstNode, objectMap);
        doc = null;
        return objectMap;
    }

    public static List getMetadataNoCache(Map objectMap, String strOptions, int iFlags) throws MdException {
        return MetadataUtil.getMetadataNoCache(MetadataWorkspace.getWorkspace().getCMRHandle(), objectMap, strOptions, iFlags);
    }

    public static List getMetadataNoCache(IOMI connectionHandle, Map objectMap, String strOptions, int iFlags) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataNoCache(connectionHandle, objectMap, strOptions, iFlags);
        }
        String inXML = MetadataUtil.createGetXMLString(objectMap);
        String outXMLString = MetadataUtil.getMetadataFromServer(connectionHandle, inXML, iFlags, strOptions);
        StringBuffer sb = new StringBuffer(21 + outXMLString.length());
        sb.append("<Metadata>");
        sb.append(outXMLString);
        sb.append("</Metadata>");
        Document doc = MetadataUtil.parseXML(sb.toString());
        ArrayList objectList = new ArrayList();
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int i = 0; i < allObjects; ++i) {
            HashMap map = new HashMap();
            Node objectNode = secondLevelList.item(i);
            MetadataUtil.addObjectAttributesToMap(objectNode, map);
            MetadataUtil.addObjectAssociationsToMap(objectNode, map);
            objectList.add(map);
        }
        doc = null;
        return objectList;
    }

    public static List getMetadataObjectsNoCache(String strType, String strReposId, String strOptions, int iFlags) throws MdException {
        return MetadataUtil.getMetadataObjectsNoCache(MetadataWorkspace.getWorkspace().getCMRHandle(), strType, strReposId, strOptions, iFlags);
    }

    public static List getMetadataObjectsNoCache(IOMI connectionHandle, String strType, String strReposId, String strOptions, int iFlags) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getMetadataObjectsNoCache(connectionHandle, strType, strReposId, strOptions, iFlags);
        }
        String outXMLString = MetadataUtil.getMetadataObjectsFromServer(connectionHandle, strReposId, strType, iFlags, strOptions);
        Document doc = MetadataUtil.parseXML(outXMLString);
        ArrayList objectList = new ArrayList();
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int i = 0; i < allObjects; ++i) {
            HashMap objectMap = new HashMap();
            Node objectNode = secondLevelList.item(i);
            MetadataUtil.addObjectAttributesToMap(objectNode, objectMap);
            MetadataUtil.addObjectAssociationsToMap(objectNode, objectMap);
            objectList.add(objectMap);
        }
        doc = null;
        return objectList;
    }

    private static void addObjectAttributesToMap(Node objectNode, Map objectMap) {
        objectMap.put("MetadataObjectType", objectNode.getNodeName());
        NamedNodeMap nodeMap = objectNode.getAttributes();
        int attr_length = nodeMap.getLength();
        for (int i = 0; i < attr_length; ++i) {
            String attrName = nodeMap.item(i).getNodeName();
            String attrValue = nodeMap.item(i).getNodeValue();
            objectMap.put(attrName, attrValue);
        }
    }

    private static void addObjectAssociationsToMap(Node objectNode, Map objectMap) {
        NodeList nodeList = objectNode.getChildNodes();
        int child_length = nodeList.getLength();
        for (int i = 0; i < child_length; ++i) {
            Node assocNode = nodeList.item(i);
            if (assocNode.getChildNodes().getLength() <= 0) continue;
            String association_name = assocNode.getNodeName();
            ArrayList association_values = new ArrayList();
            NodeList assocList = assocNode.getChildNodes();
            int assoc_length = assocList.getLength();
            for (int j = 0; j < assoc_length; ++j) {
                HashMap map = new HashMap();
                MetadataUtil.addObjectAttributesToMap(assocList.item(j), map);
                MetadataUtil.addObjectAssociationsToMap(assocList.item(j), map);
                association_values.add(map);
            }
            objectMap.put(association_name, association_values);
        }
    }

    public static Document DoRequest(String inXML, boolean fUpdateIds) throws MdException {
        return MetadataUtil.DoRequest(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, fUpdateIds);
    }

    public static void DoRequestNoReturn(String inXML, boolean fUpdateIds) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            omi_wrapper.DoRequest(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, fUpdateIds);
        } else {
            MetadataUtil.DoRequest(inXML, fUpdateIds);
        }
    }

    public static Document DoRequest(IOMI connectionHandle, String inXML, boolean fUpdateIds) throws MdException {
        Util.printLoglnClient(inXML);
        StringHolder outXML = new StringHolder();
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.DoRequest(inXML, outXML);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",DoRequest," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        Document inDoc = MetadataUtil.parseXML(inXML);
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        Document outDoc = MetadataUtil.parseXML(outXMLString);
        MetadataUtil.processDeleteMetadataObjects(outDoc);
        if (fUpdateIds) {
            MetadataUtil.updateObjectId_Internal(inDoc, outDoc);
        }
        MetadataUtil.processDeletedObjects(outDoc);
        return outDoc;
    }

    private static void processDeleteMetadataObjects(Document outDoc) {
        NodeList nodeList = outDoc.getElementsByTagName("DeleteMetadata");
        if (nodeList.getLength() > 0) {
            Node metadataNode = nodeList.item(0).getFirstChild();
            NodeList nodes = metadataNode.getChildNodes();
            ArrayList<String> objectIDs = new ArrayList<String>();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node objectNode = nodes.item(i);
                NamedNodeMap attributes = objectNode.getAttributes();
                Node idNode = attributes.getNamedItem("Id");
                if (idNode == null) continue;
                objectIDs.add(idNode.getNodeValue());
            }
            if (objectIDs.size() > 0) {
                MdObjectFactory.deleteObjectsFromStores(objectIDs);
            }
        }
    }

    public static void processDeletedObjects(Document outDoc) {
        NodeList DeletedObjectsNodes = outDoc.getElementsByTagName("DeletedObjects");
        ArrayList<String> objectIds = new ArrayList<String>(10);
        for (int i = 0; i < DeletedObjectsNodes.getLength(); ++i) {
            Node DeletedObjectNode = DeletedObjectsNodes.item(i);
            NodeList DeletedChildrenNodes = DeletedObjectNode.getChildNodes();
            for (int j = 0; j < DeletedChildrenNodes.getLength(); ++j) {
                Node DeletedObject = DeletedChildrenNodes.item(j);
                NamedNodeMap attribMap = DeletedObject.getAttributes();
                Node IdNode = attribMap.getNamedItem("Id");
                if (IdNode == null) continue;
                String Id = IdNode.getNodeValue();
                objectIds.add(Id);
            }
        }
        Iterator newIter = objectIds.iterator();
        while (newIter.hasNext()) {
            MdObjectFactory.deleteDetailMetadataObject((String)newIter.next());
        }
    }

    private static void updateObjectId_Internal(Document inDoc, Document outDoc) throws MdException {
        NodeList clientList = inDoc.getElementsByTagName("UpdateMetadata");
        NodeList serverList = outDoc.getElementsByTagName("UpdateMetadata");
        if (clientList.getLength() > 0 && serverList.getLength() > 0) {
            Node oldNode = clientList.item(0).getFirstChild();
            Node newNode = serverList.item(0).getFirstChild();
            NodeList oldNodeList = oldNode.getChildNodes();
            NodeList newNodeList = newNode.getChildNodes();
            int oldLength = newNodeList.getLength();
            int newLength = oldNodeList.getLength();
            int length = oldLength;
            if (oldLength > newLength) {
                length = newLength;
            }
            for (int i = 0; i < length; ++i) {
                String strOldId;
                NamedNodeMap oldNodeMap = oldNodeList.item(i).getAttributes();
                NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
                if (oldNodeMap == null || newNodeMap == null) continue;
                Node oldIdNode = oldNodeMap.getNamedItem("Id");
                if (oldIdNode == null || (strOldId = oldIdNode.getNodeValue()) == null || strOldId.indexOf(".$") == -1) continue;
                Node newIdNode = newNodeMap.getNamedItem("Id");
                if (newIdNode == null) continue;
                String strNewId = newIdNode.getNodeValue();
                MdObjectFactory.changeHashKey(strOldId, strNewId);
            }
        }
    }

    public static void updateObjectId(Document inDoc, Document outDoc) throws MdException {
        Node oldNode = inDoc.getFirstChild().getFirstChild();
        Node newNode = outDoc.getFirstChild().getFirstChild();
        NodeList oldNodeList = oldNode.getChildNodes();
        NodeList newNodeList = newNode.getChildNodes();
        int oldLength = newNodeList.getLength();
        int newLength = oldNodeList.getLength();
        int length = oldLength;
        if (oldLength > newLength) {
            length = newLength;
        }
        for (int i = 0; i < length; ++i) {
            String strOldId;
            NamedNodeMap oldNodeMap = oldNodeList.item(i).getAttributes();
            NamedNodeMap newNodeMap = newNodeList.item(i).getAttributes();
            if (oldNodeMap == null || newNodeMap == null) continue;
            Node oldIdNode = oldNodeMap.getNamedItem("Id");
            if (oldIdNode == null || (strOldId = oldIdNode.getNodeValue()) == null || strOldId.indexOf(".$") == -1) continue;
            Node newIdNode = newNodeMap.getNamedItem("Id");
            if (newIdNode == null) continue;
            String strNewId = newIdNode.getNodeValue();
            MdObjectFactory cfr_ignored_0 = (MdObjectFactory)m_factory;
            MdObjectFactory.changeHashKey(strOldId, strNewId);
        }
    }

    public static String createGetXMLString(String strType, String strFQID, List simpleAttr, List complexAttr) {
        int i;
        int lengthAttr;
        StringBuffer strXML = new StringBuffer(60);
        strXML.append("<");
        strXML.append(strType);
        strXML.append(" ");
        if (strFQID != null && strFQID.length() > 0) {
            strXML.append("Id=\"");
            strXML.append(strFQID);
            strXML.append("\" ");
        }
        if (simpleAttr != null) {
            lengthAttr = simpleAttr.size();
            for (i = 0; i < lengthAttr; ++i) {
                strXML.append(simpleAttr.get(i));
                strXML.append("=\"\" ");
            }
        }
        strXML.append(">");
        if (complexAttr != null) {
            lengthAttr = complexAttr.size();
            for (i = 0; i < lengthAttr; ++i) {
                strXML.append("<");
                strXML.append(complexAttr.get(i));
                strXML.append("/>");
            }
        }
        strXML.append("</");
        strXML.append(strType);
        strXML.append(">");
        return strXML.toString();
    }

    public static String createGetXMLString(Map objectMap) {
        StringBuffer sb = new StringBuffer();
        for (String id : objectMap.keySet()) {
            String type = (String)objectMap.get(id);
            if (type == null) continue;
            sb.append("<");
            sb.append(type);
            sb.append(" Id=\"");
            sb.append(id);
            sb.append("\" />");
        }
        return sb.toString();
    }

    public static String createXMLSubString(List attributes, List values) {
        int iLength = Math.min(attributes.size(), values.size());
        if (iLength < 1) {
            return "";
        }
        StringBuffer inXML = new StringBuffer();
        for (int i = 0; i < iLength; ++i) {
            inXML.append(attributes.get(i));
            inXML.append("=\"");
            inXML.append(MetadataUtil.cleanStringForXML((String)values.get(i)));
            inXML.append("\" ");
        }
        return inXML.toString();
    }

    public static String createObjectAttributeString(Map attributes) {
        if (attributes == null || attributes.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String key : attributes.keySet()) {
            String value = (String)attributes.get(key);
            sb.append(key);
            sb.append("=\"");
            sb.append(MetadataUtil.cleanStringForXML(value));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public static String createRefreshXML(CMetadata meta, boolean refreshAssocsSetByServerOnly, boolean refreshAll) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(meta.getCMetadataType());
        sb.append(" Id=\"");
        sb.append(meta.getId());
        sb.append("\">");
        if (refreshAssocsSetByServerOnly || !refreshAll) {
            Map<String, AssociationList> associations = meta.getAssocs();
            for (Map.Entry<String, AssociationList> entry : associations.entrySet()) {
                int state;
                AssociationList assoc = entry.getValue();
                if (assoc == null || ((state = assoc.getState()) & 0x20) > 0 || (state & 0x40) > 0) continue;
                if (refreshAssocsSetByServerOnly && state == 1) {
                    sb.append("<");
                    sb.append(entry.getKey());
                    sb.append("/>");
                    continue;
                }
                if (refreshAssocsSetByServerOnly || refreshAll) continue;
                sb.append("<");
                sb.append(entry.getKey());
                sb.append("/>");
            }
            MapPool.instance();
            MapPool.returnMap(associations);
        }
        sb.append("</");
        sb.append(meta.getCMetadataType());
        sb.append(">");
        return sb.toString();
    }

    public static String cleanStringForXML(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer parsed = new StringBuffer(s.length());
        int len = s.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '<': 
                case '>': 
                case '\\': {
                    parsed.append("&#");
                    parsed.append(Converter.toString(c));
                    parsed.append(';');
                    continue block3;
                }
                default: {
                    parsed.append(c);
                }
            }
        }
        return parsed.toString();
    }

    public static String createUpdateXMLSimple(String strType, String strFQID, List attributes, List values) {
        int iLength = Math.min(attributes.size(), values.size());
        if (iLength < 1) {
            return null;
        }
        StringBuffer inXML = new StringBuffer();
        inXML.append("<");
        inXML.append(strType);
        inXML.append(" Id=\"");
        inXML.append(strFQID);
        inXML.append("\" ");
        for (int i = 0; i < iLength; ++i) {
            inXML.append(attributes.get(i));
            inXML.append("=\"");
            inXML.append(values.get(i));
            inXML.append("\" ");
        }
        inXML.append("></");
        inXML.append(strType);
        inXML.append(">");
        return inXML.toString();
    }

    public static void updateMetadataSimple(String strType, String strFQID, List attributes, List values) throws MdException {
        String inXML = MetadataUtil.createUpdateXMLSimple(strType, strFQID, attributes, values);
        StringHolder outXML = new StringHolder();
        MetadataUtil.updateMetadata(inXML, outXML, 0);
    }

    public static void updateMetadataSimple(String inXML) throws MdException {
        StringHolder outXML = new StringHolder();
        MetadataUtil.updateMetadata(inXML, outXML, 0);
    }

    public static void updateMetadata(String inXML) throws MdException {
        StringHolder outXML = new StringHolder();
        MetadataUtil.updateMetadata(inXML, outXML, 0);
    }

    public static int updateMetadata(String inXML, StringHolder outXML, int iFlags) throws MdException {
        return MetadataUtil.updateMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, outXML, iFlags);
    }

    public static int updateMetadata(IOMI connectionHandle, String inXML, StringHolder outXML, int iFlags) throws MdException {
        if ((iFlags & 0x10000000) == 0) {
            iFlags |= 0x10000000;
        }
        int rc = 0;
        Util.printLoglnClient(inXML);
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            rc = connectionHandle.UpdateMetadata(inXML, outXML, m_Namespace, iFlags, "");
            if (rc != 0) {
                Util.printOutputln("Bad Update! rc = " + rc);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",UpdateMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        Util.printLoglnServer(outXML.value);
        return rc;
    }

    public static int addMetadata(String inXML, String reposID, StringHolder outXML, int iFlags) throws MdException {
        return MetadataUtil.addMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, reposID, outXML, iFlags);
    }

    public static int addMetadata(IOMI connectionHandle, String inXML, String reposID, StringHolder outXML, int iFlags) throws MdException {
        if ((iFlags & 0x10000000) == 0) {
            iFlags |= 0x10000000;
        }
        String kludgeReposID = "A0000001." + reposID.substring(0, 8);
        int rc = 0;
        Util.printLoglnClient(inXML);
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            rc = connectionHandle.AddMetadata(inXML, kludgeReposID, outXML, m_Namespace, iFlags, "");
            if (rc != 0) {
                Util.printOutputln("Bad Add! rc = " + rc);
                Util.printLoglnServer(outXML.value);
            } else {
                Util.printLoglnServer(outXML.value);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",AddMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        return rc;
    }

    public static List copyMetadata(MdObjectStore instore, String inXML, String reposID, String template, int iFlags) throws MdException {
        return MetadataUtil.copyMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), instore, inXML, reposID, template, iFlags);
    }

    public static synchronized List copyMetadata(IOMI connectionHandle, MdObjectStore instore, String inXML, String reposID, String template, int iFlags) throws MdException {
        HashMap<String, String> objectMap = new HashMap<String, String>(10);
        ArrayList<CMetadata> idList = new ArrayList<CMetadata>(10);
        ArrayList<String> idOnlyList = new ArrayList<String>(10);
        String kludgeReposID = "A0000001." + reposID.substring(0, 8);
        int rc = 0;
        if (template != null && template.length() > 0) {
            template = "<LockTemplates>" + template + "</LockTemplates>";
            iFlags |= 0x10000;
        }
        StringBuffer inputXML = new StringBuffer("<CopyMetadata><Metadata>");
        inputXML.append(inXML);
        inputXML.append("</Metadata><ToReposid>");
        inputXML.append(kludgeReposID);
        inputXML.append("</ToReposid><Ns>");
        inputXML.append(m_Namespace);
        inputXML.append("</Ns><Flags>");
        inputXML.append(iFlags);
        inputXML.append("</Flags><Options>");
        inputXML.append(template);
        inputXML.append("</Options><CopyMetadata>");
        Util.printLoglnClient(inputXML.toString());
        StringHolder outXML = new StringHolder();
        try {
            long t0 = 0L;
            long t1 = 0L;
            if (MdObjectFactory.getInstance().getPerf()) {
                t0 = System.currentTimeMillis();
            }
            rc = connectionHandle.CopyMetadata(inXML, kludgeReposID, outXML, m_Namespace, iFlags, template);
            if (MdObjectFactory.getInstance().getPerf()) {
                t1 = System.currentTimeMillis();
                Util.printPerfln(Thread.currentThread().getName() + ",CopyMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            if (rc != 0) {
                Util.printOutputln("Bad Add! rc = " + rc);
                Util.printLoglnServer(outXML.value);
            } else {
                Util.printLoglnServer(outXML.value);
            }
            String outStrings = new String("<CopyMetadata>" + outXML.value + "</CopyMetadata>");
            Document doc = MetadataUtil.parseXML(outStrings);
            Node firstNode = doc.getFirstChild();
            NodeList typeNodeList = firstNode.getChildNodes();
            int length = typeNodeList.getLength();
            for (int index = 0; index < length; ++index) {
                CMetadata createdObject;
                Node nameNode;
                String type = null;
                String name = "";
                String id = null;
                Node objectNode = typeNodeList.item(index);
                type = objectNode.getNodeName();
                NamedNodeMap nodeMap = objectNode.getAttributes();
                Node idNode = nodeMap.getNamedItem("Id");
                if (idNode != null) {
                    id = idNode.getNodeValue();
                }
                if ((nameNode = nodeMap.getNamedItem("Name")) != null) {
                    name = nameNode.getNodeValue();
                }
                if ((createdObject = MdObjectFactory.createComplexMetadataObject(instore, null, name, type, id, null)) == null) continue;
                idList.add(createdObject);
                idOnlyList.add(createdObject.getId());
                objectMap.put(createdObject.getId(), createdObject.getCMetadataType());
            }
            firstNode = null;
            typeNodeList = null;
            doc = null;
            if (idList.size() > 0) {
                MdObjectFactory.fireMdObjectsCreated(new MdEvent(MdObjectFactory.getInstance(), instore), idOnlyList);
                MdObjectFactory.fireMdObjectsCreated(new MdFactoryEvent((MdFactory)MdObjectFactory.getInstance(), objectMap));
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        return idList;
    }

    public static void getTypes(List nameList, List descList) throws MdException {
        MetadataUtil.getTypes(MetadataWorkspace.getWorkspace().getCMRHandle(), nameList, descList);
    }

    public static void getTypes(IOMI connectionHandle, List nameList, List descList) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            omi_wrapper.getTypes(connectionHandle, nameList, descList);
            return;
        }
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(67);
        inputXML.append("<GetTypes><Types/><NS>");
        inputXML.append(m_Namespace);
        inputXML.append("</NS><Flags>0</Flags><Options/></GetTypes>");
        Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetTypes(outXML, m_Namespace, 0, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",GetTypes," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String strXML = outXML.value;
        Util.printLoglnServer(strXML);
        Document doc = MetadataUtil.parseXML(strXML);
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        int length = typeNodeList.getLength();
        for (int index = 0; index < length; ++index) {
            NamedNodeMap nodeMap = typeNodeList.item(index).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode != null) {
                nameList.add(index, idNode.getNodeValue());
            } else {
                idNode = nodeMap.getNamedItem("ObjRef");
                if (idNode != null) {
                    nameList.add(index, idNode.getNodeValue());
                }
            }
            Node descNode = nodeMap.getNamedItem("Desc");
            if (descNode == null) continue;
            descList.add(index, descNode.getNodeValue());
        }
        doc = null;
    }

    public static void getTypeProperties(String objectType, Map attributeMap, Map associationMap) throws MdException {
        MetadataUtil.getTypeProperties(MetadataWorkspace.getWorkspace().getCMRHandle(), objectType, attributeMap, associationMap);
    }

    public static void getTypeProperties(IOMI connectionHandle, String objectType, Map attributeMap, Map associationMap) throws MdException {
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(105);
        inputXML.append("<GetTypeProperties><Type>");
        inputXML.append(objectType);
        inputXML.append("</Type><NS>");
        inputXML.append(m_Namespace);
        inputXML.append("</NS><Flags>");
        inputXML.append(1);
        inputXML.append("</Flags><Options/></GetTypeProperties>");
        Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetTypeProperties(objectType, outXML, m_Namespace, 1, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",GetTypeProperties," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String strXML = outXML.value;
        Util.printLoglnServer(strXML);
        Document doc = MetadataUtil.parseXML(strXML);
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        for (int i = 0; i < typeNodeList.getLength(); ++i) {
            Node typeNode = typeNodeList.item(i);
            boolean isAttribute = false;
            boolean isAssociation = false;
            if (typeNode.getNodeName().equalsIgnoreCase("Attributes")) {
                isAttribute = true;
            } else if (typeNode.getNodeName().equalsIgnoreCase("Associations")) {
                isAssociation = true;
            }
            NodeList list = typeNode.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node node = list.item(j);
                NamedNodeMap nodeMap = node.getAttributes();
                if (nodeMap == null || nodeMap.getLength() <= 0) continue;
                int length = nodeMap.getLength();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(length);
                for (int k = 0; k < length; ++k) {
                    Node attr = nodeMap.item(k);
                    map.put(attr.getNodeName(), attr.getNodeValue());
                }
                if (isAttribute) {
                    attributeMap.put(node.getNodeName(), map);
                    continue;
                }
                if (!isAssociation) continue;
                associationMap.put(node.getNodeName(), map);
            }
        }
        doc = null;
    }

    public static List getSubTypes(String objectType, boolean includeDescendants) throws MdException {
        int flags = includeDescendants ? 64 : 0;
        IOMI connectionHandle = MetadataWorkspace.getWorkspace().getCMRHandle();
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(105);
        inputXML.append("<GetSubtypes><Supertype>");
        inputXML.append(objectType);
        inputXML.append("</Supertype><Subtypes/><NS>");
        inputXML.append(m_Namespace);
        inputXML.append("</NS><Flags>");
        inputXML.append(flags);
        inputXML.append("</Flags><Options/></GetSubtypes>");
        Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetSubtypes(objectType, outXML, m_Namespace, flags, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",GetSubtypes," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String strXML = outXML.value;
        Util.printLoglnServer(strXML);
        ArrayList<String> types = new ArrayList<String>();
        Document doc = MetadataUtil.parseXML(strXML);
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        for (int i = 0; i < typeNodeList.getLength(); ++i) {
            Node idNode;
            NamedNodeMap nodeMap;
            Node typeNode = typeNodeList.item(i);
            if (typeNode.getNodeType() != 1 || (nodeMap = typeNode.getAttributes()) == null || (idNode = nodeMap.getNamedItem("Id")) == null) continue;
            types.add(idNode.getNodeValue());
        }
        doc = null;
        return types;
    }

    public static CMetadata getAssociatedObject(CMetadata object, String strAssociation, String strTemplate) throws MdException {
        return MetadataUtil.getAssociatedObject(object, strAssociation, strTemplate, false);
    }

    public static CMetadata getAssociatedObject(CMetadata object, String strAssociation, String strTemplate, boolean doNotOverrideAssocs) throws MdException {
        CMetadata md = null;
        AssociationList objList = MetadataUtil.getAssociatedObjects(object, strAssociation, strTemplate, doNotOverrideAssocs);
        if (objList != null && objList.size() > 0) {
            md = (CMetadata)objList.get(0);
        }
        return md;
    }

    public static AssociationList getAssociatedObjects(CMetadata object, String strAssociation, String strTemplate) throws MdException {
        return MetadataUtil.getAssociatedObjects(object, strAssociation, strTemplate, false);
    }

    public static AssociationList getAssociatedObjects(CMetadata object, String strAssociation, String strTemplate, boolean doNotOverrideAssocs) throws MdException {
        Node firstNode;
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.getAssociatedObjects(object, strAssociation, strTemplate, doNotOverrideAssocs);
        }
        ArrayList<String> inXMLComplex = new ArrayList<String>(1);
        inXMLComplex.add(strAssociation);
        int options = 2056;
        if (strTemplate != null && strTemplate.length() > 0) {
            options |= 4;
        }
        List attributes = null;
        Util.printOutputln("DEBUG NOTE: GetAssociatedObjects to the server for association " + strAssociation);
        if (object == null || object.getFQID().indexOf(36) > -1 || !object.getObjectStore().isGoToServerForMetadata()) {
            Util.printOutputln(MdObjectFactory.getBundle().getString("MetadataUtil.getMetadataAllDepthsNotToServer.txt"));
            return object.getMdObjectAssociation(strAssociation);
        }
        String inXML = MetadataUtil.createGetXMLString(object.getCMetadataType(), object.getFQID(), attributes, inXMLComplex);
        Document doc = MetadataUtil.getMetadata(inXML, strTemplate, options);
        if (object.getObjectStore() == null) {
            object = MdObjectFactory.createComplexMetadataObjectServerStoreOnly(object.getName(), object.getCMetadataType(), object.getFQID());
        }
        if ((object = MetadataUtil.populateObject(object, (firstNode = doc.getFirstChild()).getAttributes(), firstNode.getChildNodes(), doNotOverrideAssocs)).getObjectStore().getStoreType() == 0) {
            object.resetObject();
        }
        AssociationList associatedObjectList = null;
        NodeList nl = doc.getElementsByTagName(strAssociation);
        if (nl.getLength() == 0) {
            associatedObjectList = new AssociationList(strAssociation);
            associatedObjectList.setState(1);
            object.setMdObjectAssociation(associatedObjectList);
        } else {
            associatedObjectList = object.getMdObjectAssociation(strAssociation);
            if (object.getObjectStore().isGoToServerForMetadata()) {
                associatedObjectList.setState(1);
            }
        }
        firstNode = null;
        doc = null;
        return associatedObjectList;
    }

    public static String getAttribute(String strAttribute, NamedNodeMap childNodeMap) {
        String returnValue = null;
        try {
            returnValue = childNodeMap.getNamedItem(strAttribute).getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return returnValue;
    }

    public static Document parseXML(String strXML) throws MdException {
        StringReader strReader = new StringReader(strXML);
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_docBuilder = null;
        try {
            m_docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        try {
            doc = m_docBuilder.parse(new InputSource(strReader));
        }
        catch (IOException ioe) {
            throw new MdException(ioe);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
        m_docBuilder = null;
        dbf = null;
        return doc;
    }

    public static Document parseXML(String strXML, boolean ignoreWhitespace) throws MdException {
        StringReader strReader = new StringReader(strXML);
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (ignoreWhitespace) {
            dbf.setValidating(true);
            dbf.setIgnoringElementContentWhitespace(true);
        }
        DocumentBuilder m_docBuilder = null;
        try {
            m_docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        try {
            doc = m_docBuilder.parse(new InputSource(strReader));
        }
        catch (IOException ioe) {
            throw new MdException(ioe);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
        m_docBuilder = null;
        dbf = null;
        return doc;
    }

    public static Document parseXML(URL xmlDocument) throws MdException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_docBuilder = null;
        try {
            m_docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MdException(e);
        }
        try {
            doc = m_docBuilder.parse(new InputSource(xmlDocument.openStream()));
        }
        catch (IOException ioe) {
            throw new MdException(ioe);
        }
        catch (SAXException e) {
            throw new MdException(e);
        }
        m_docBuilder = null;
        dbf = null;
        return doc;
    }

    public static String formatXML(String original) {
        boolean newLine = false;
        char[] chars = new char[original.length()];
        original.getChars(0, original.length(), chars, 0);
        int indent = 0;
        StringBuffer output = new StringBuffer(original.length());
        int length = chars.length;
        for (int index = 0; index < length; ++index) {
            if (chars[index] == '<') {
                int indentIndex;
                if (chars[index + 1] != '/') {
                    if (index > 0) {
                        newLine = true;
                        output.append('\n');
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            output.append('\t');
                        }
                    }
                    if (chars[index + 1] != '!' && chars[index + 1] != '?') {
                        ++indent;
                    }
                } else {
                    --indent;
                    if (newLine) {
                        output.append('\n');
                        newLine = false;
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            output.append('\t');
                        }
                    }
                }
            }
            if (chars[index] != '\t' && chars[index] != '\n') {
                output.append(chars[index]);
            }
            if (chars[index] != '>') continue;
            if (chars[index - 1] != '/') {
                if (newLine) {
                    newLine = false;
                    continue;
                }
                newLine = true;
                continue;
            }
            if (!newLine) {
                output.append('\n');
            }
            --indent;
        }
        return output.toString();
    }

    public static List deleteMetadataObject(CMetadata metadataObject, String template) throws MdException {
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(metadataObject.getCMetadataType());
        inXML.append(" Id=\"");
        inXML.append(metadataObject.getId());
        inXML.append("\"");
        if (template != null) {
            String nameAttr = "TemplateName";
            int index = template.indexOf("TemplateName");
            if (index < 0) {
                throw new IllegalArgumentException("Invalid template.  The TemplateName is required.");
            }
            int start = index + "TemplateName".length() + 2;
            String name = template.substring(start, template.indexOf("\"", start));
            inXML.append(" TemplateName=\"");
            inXML.append(name);
            inXML.append("\"");
        }
        inXML.append("/>");
        String templates = "<Templates>" + template + "</Templates>";
        return MetadataUtil.deleteObjectsFromServer(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML.toString(), templates);
    }

    public static List deleteMetadataObject(CMetadata inObject) throws MdException {
        return MetadataUtil.deleteMetadataObject(MetadataWorkspace.getWorkspace().getCMRHandle(), inObject);
    }

    public static synchronized List deleteMetadataObject(IOMI connectionHandle, CMetadata inObject) throws MdException {
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(inObject.getCMetadataType());
        inXML.append(" Id=\"");
        inXML.append(inObject.getFQID());
        inXML.append("\"/>");
        return MetadataUtil.deleteObjectsFromServer(connectionHandle, inXML.toString(), null);
    }

    public static synchronized List deleteMetadataObject(String objectType, String objectID) throws MdException {
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(objectType);
        inXML.append(" Id=\"");
        inXML.append(objectID);
        inXML.append("\"/>");
        return MetadataUtil.deleteObjectsFromServer(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML.toString(), null);
    }

    public static List deleteMetadataObjects(List inObjects) throws MdException {
        return MetadataUtil.deleteMetadataObjects(MetadataWorkspace.getWorkspace().getCMRHandle(), inObjects);
    }

    public static synchronized List deleteMetadataObjects(IOMI connectionHandle, List inObjects) throws MdException {
        if (inObjects.isEmpty()) {
            return new Vector(0);
        }
        StringBuffer inXML = new StringBuffer();
        for (int i = 0; i < inObjects.size(); ++i) {
            CMetadata inObject = (CMetadata)inObjects.get(i);
            inXML.append("<");
            inXML.append(inObject.getCMetadataType());
            inXML.append(" Id=\"");
            inXML.append(inObject.getFQID());
            inXML.append("\"/>");
        }
        return MetadataUtil.deleteObjectsFromServer(connectionHandle, inXML.toString(), null);
    }

    public static List deleteMetadataObjects(Map inObjects) throws MdException {
        return MetadataUtil.deleteMetadataObjects(MetadataWorkspace.getWorkspace().getCMRHandle(), inObjects);
    }

    public static synchronized List deleteMetadataObjects(IOMI connectionHandle, Map inObjects) throws MdException {
        if (inObjects.isEmpty()) {
            return new Vector(0);
        }
        StringBuffer inXML = new StringBuffer();
        for (String id : inObjects.keySet()) {
            String type = (String)inObjects.get(id);
            if (type == null) continue;
            inXML.append("<");
            inXML.append(type);
            inXML.append(" Id=\"");
            inXML.append(id);
            inXML.append("\"/>");
        }
        return MetadataUtil.deleteObjectsFromServer(connectionHandle, inXML.toString(), null);
    }

    private static synchronized List deleteObjectsFromServer(IOMI connectionHandle, String inXML, String templates) throws MdException {
        if (MdObjectFactory.getInstance().getParsingType() == 0) {
            return omi_wrapper.deleteObjectsFromServer(connectionHandle, inXML, templates);
        }
        Vector<String> idList = new Vector<String>(10);
        StringHolder outXML = new StringHolder();
        int flags = 0x10000000;
        flags ^= 0x400;
        flags ^= 0x8000000;
        if (templates != null) {
            flags |= 4;
        } else {
            templates = "";
        }
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(105 + inXML.length());
            inputXML.append("<DeleteMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(m_Namespace);
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags>");
            if (templates == null) {
                inputXML.append("<Options/>");
            } else {
                inputXML.append("<Options>");
                inputXML.append(templates);
                inputXML.append("</Options>");
            }
            inputXML.append("</DeleteMetadata>");
            Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.DeleteMetadata(inXML, outXML, m_Namespace, flags, templates);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",DeleteMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        StringBuffer outStrings = new StringBuffer(33 + outXML.value.length());
        outStrings.append("<DeleteMetadata>");
        outStrings.append(outXML.value);
        outStrings.append("</DeleteMetadata>");
        Util.printLoglnServer(outStrings.toString());
        Document doc = MetadataUtil.parseXML(outStrings.toString());
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        int length = typeNodeList.getLength();
        for (int index = 0; index < length; ++index) {
            NamedNodeMap nodeMap = typeNodeList.item(index).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode == null) continue;
            idList.add(index, idNode.getNodeValue());
        }
        doc = null;
        return idList;
    }

    public static synchronized List unlockMetadataObjects(List inObjects) throws MdException {
        return MetadataUtil.unlockMetadataObjects(MetadataWorkspace.getWorkspace().getCMRHandle(), inObjects);
    }

    public static synchronized List unlockMetadataObjects(IOMI connectionHandle, List inObjects) throws MdException {
        Vector<String> idList = new Vector<String>(10);
        StringBuffer inXML = new StringBuffer("");
        if (inObjects.size() > 0) {
            for (int i = 0; i < inObjects.size(); ++i) {
                CMetadata inObject = (CMetadata)inObjects.get(i);
                inXML.append("<");
                inXML.append(inObject.getCMetadataType());
                inXML.append(" Id=\"");
                inXML.append(inObject.getFQID());
                inXML.append("\"/>");
            }
        } else {
            return idList;
        }
        StringHolder outXML = new StringHolder();
        int flags = 0x10000000;
        flags ^= 0x400;
        flags ^= 0x8000000;
        flags ^= 0x40000;
        String options = new String("");
        StringBuffer inputXML = new StringBuffer("<UpdateMetadata><Metadata>");
        inputXML.append(inXML);
        inputXML.append("</Metadata><NS>");
        inputXML.append(m_Namespace);
        inputXML.append("</NS><Flags>");
        inputXML.append(flags);
        inputXML.append("</Flags><Options/>");
        inputXML.append("</UpdateMetadata>");
        Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.UpdateMetadata(inXML.toString(), outXML, m_Namespace, flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",UpdateMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        StringBuffer outStrings = new StringBuffer("<UpdateMetadata>");
        outStrings.append(outXML.value);
        outStrings.append("</UpdateMetadata>");
        Util.printLoglnServer(outStrings.toString());
        Document doc = MetadataUtil.parseXML(outStrings.toString());
        Node firstNode = doc.getFirstChild();
        NodeList typeNodeList = firstNode.getChildNodes();
        int length = typeNodeList.getLength();
        for (int index = 0; index < length; ++index) {
            NamedNodeMap nodeMap = typeNodeList.item(index).getAttributes();
            Node idNode = nodeMap.getNamedItem("Id");
            if (idNode == null) continue;
            idList.add(index, idNode.getNodeValue());
        }
        doc = null;
        return idList;
    }

    public static synchronized Document ApplyXML(String inXML, String reposID) throws MdException {
        return MetadataUtil.ApplyXML(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, reposID);
    }

    public static synchronized Document ApplyXML(IOMI connectionHandle, String inXML, String reposID) throws MdException {
        StringBuffer outputXML = new StringBuffer(130 + (inXML == null ? 0 : inXML.length()));
        outputXML.append("<AddMetadata><Metadata>");
        outputXML.append(inXML);
        outputXML.append("</Metadata><Reposid>");
        outputXML.append(reposID);
        outputXML.append("</Reposid><Ns>SAS</Ns>");
        outputXML.append("<Flags>268435456</Flags><Options/></AddMetadata>");
        Util.printLoglnClient(outputXML.toString());
        StringHolder outXML = new StringHolder();
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.DoRequest(outputXML.toString(), outXML);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",AddMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        return MetadataUtil.parseXML(outXMLString);
    }

    private static String getMetadataFromServer(IOMI connectionHandle, String inXML, int flags, String options) throws MdException {
        MdObjectFactory factory = MdObjectFactory.getInstance();
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(100 + inXML.length() + options.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(MetadataUtil.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadata>");
            Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetMetadata(inXML, outXML, MetadataUtil.getNamespace(), flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            Util.printPerfln(sb.toString());
        }
        Util.printLoglnServer(outXML.value);
        return outXML.value;
    }

    private static String getMetadataObjectsFromServer(IOMI connectionHandle, String reposID, String type, int flags, String options) throws MdException {
        MdObjectFactory factory = MdObjectFactory.getInstance();
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(155 + options.length());
            inputXML.append("<GetMetadataObjects><Reposid>");
            inputXML.append(reposID);
            inputXML.append("</Reposid><Type>");
            inputXML.append(type);
            inputXML.append("</Type><NS>");
            inputXML.append(MetadataUtil.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadataObjects>");
            Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetMetadataObjects(reposID, type, outXML, MetadataUtil.getNamespace(), flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadataObjects,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            Util.printPerfln(sb.toString());
        }
        Util.printLoglnServer(outXML.value);
        return outXML.value;
    }
}

