/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.MdException;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MdRepositoryUtil {
    private static final String REPOSITORY_TYPE = "RepositoryBase";
    public static final String FOUNDATION_REPOS = "FOUNDATION";
    public static final String CUSTOM_REPOS = "CUSTOM";
    public static final String PROJECT_REPOS = "PROJECT";

    public static String getRepositoryType(String repositoryID) throws MdException {
        return MdRepositoryUtil.getRepositoryType(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static String getRepositoryType(IOMI connectionHandle, String repositoryID) throws MdException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\" RepositoryType=\"\"/>");
        inXML.append(getXML);
        inXML.append("</Metadata><Ns>REPOS</Ns><Flags>");
        inXML.append(1);
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        Util.printLoglnClient(inXML.toString());
        try {
            connectionHandle.GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        String repositoryType = null;
        Pattern p = Pattern.compile("RepositoryType=\"([0-9a-zA-Z.]+)\"");
        Matcher m = p.matcher(outXMLString);
        if (m.find()) {
            repositoryType = m.group(1);
        }
        return repositoryType;
    }

    public static String getRepositoryName(String repositoryID) throws MdException {
        return MdRepositoryUtil.getRepositoryName(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static String getRepositoryName(IOMI connectionHandle, String repositoryID) throws MdException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\" Name=\"\"/>");
        inXML.append(getXML);
        inXML.append("</Metadata><Ns>REPOS</Ns><Flags>");
        inXML.append(1);
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        Util.printLoglnClient(inXML.toString());
        try {
            connectionHandle.GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        String repositoryName = null;
        Document doc = MetadataUtil.parseXML(outXMLString);
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            NamedNodeMap nodeMap = firstNode.getAttributes();
            repositoryName = MetadataUtil.getAttribute("Name", nodeMap);
        }
        doc = null;
        return repositoryName;
    }

    public static String getRepositoryIDFromName(String name) throws MdException {
        return MdRepositoryUtil.getRepositoryIDFromName(MetadataWorkspace.getWorkspace().getCMRHandle(), name);
    }

    public static String getRepositoryIDFromName(IOMI connectionHandle, String name) throws MdException {
        String repos_manager_id = "A0000001.A0000001";
        int flags = 384;
        String options = "<XMLSelect Search=\"@Name='" + name + "'\"/>";
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadataObjects><ReposId>");
        inXML.append("A0000001.A0000001");
        inXML.append("</ReposId><Type><RepositoryBase>");
        inXML.append("</Type><Ns>REPOS</Ns><Flags>");
        inXML.append(flags);
        inXML.append("</Flags><Options>");
        inXML.append(options);
        inXML.append("</Options></GetMetadataObjects>");
        StringHolder outXML = new StringHolder();
        Util.printLoglnClient(inXML.toString());
        try {
            connectionHandle.GetMetadataObjects("A0000001.A0000001", REPOSITORY_TYPE, outXML, "REPOS", flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        String id = null;
        Pattern p = Pattern.compile("Id=\"([0-9a-zA-Z.]+)\"");
        Matcher m = p.matcher(outXMLString);
        if (m.find()) {
            id = m.group(1);
        }
        return id;
    }

    public static List getDependentRepositories(String repositoryID) throws MdException {
        return MdRepositoryUtil.getDependentRepositories(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static List getDependentRepositories(IOMI connectionHandle, String repositoryID) throws MdException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\"><DependencyUsedBy/></RepositoryBase>");
        inXML.append(getXML.substring(0));
        inXML.append("</Metadata><NS>REPOS</NS><Flags>0");
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        Util.printLoglnClient(inXML.substring(0));
        try {
            connectionHandle.GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        ArrayList<String> returnObjects = new ArrayList<String>();
        Document doc = MetadataUtil.parseXML(outXMLString);
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                NodeList childList = currentNode.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node childNode = childList.item(j);
                    NamedNodeMap childNodeMap = childNode.getAttributes();
                    String id = MetadataUtil.getAttribute("Id", childNodeMap);
                    if (id == null) continue;
                    returnObjects.add(id);
                }
            }
        }
        doc = null;
        return returnObjects;
    }

    public static List getUsedByRepositories(String repositoryID) throws MdException {
        return MdRepositoryUtil.getUsedByRepositories(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static List getUsedByRepositories(IOMI connectionHandle, String repositoryID) throws MdException {
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\"><DependencyUses/></RepositoryBase>");
        inXML.append(getXML.substring(0));
        inXML.append("</Metadata><NS>REPOS</NS><Flags>0");
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        Util.printLoglnClient(inXML.substring(0));
        try {
            connectionHandle.GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        String outXMLString = outXML.value;
        Util.printLoglnServer(outXMLString);
        ArrayList<String> returnObjects = new ArrayList<String>();
        Document doc = MetadataUtil.parseXML(outXMLString);
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                NodeList childList = currentNode.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node childNode = childList.item(j);
                    NamedNodeMap childNodeMap = childNode.getAttributes();
                    String id = MetadataUtil.getAttribute("Id", childNodeMap);
                    if (id == null) continue;
                    returnObjects.add(id);
                }
            }
        }
        doc = null;
        return returnObjects;
    }

    public static boolean isDependentRepository(String repositoryID) throws MdException {
        return MdRepositoryUtil.isDependentRepository(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static boolean isDependentRepository(IOMI connectionHandle, String repositoryID) throws MdException {
        List reposList = MdRepositoryUtil.getUsedByRepositories(connectionHandle, repositoryID);
        return reposList.size() > 0;
    }

    public static boolean hasDependentRepositories(String repositoryID) throws MdException {
        return MdRepositoryUtil.hasDependentRepositories(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static boolean hasDependentRepositories(IOMI connectionHandle, String repositoryID) throws MdException {
        List reposList = MdRepositoryUtil.getDependentRepositories(connectionHandle, repositoryID);
        return reposList.size() > 0;
    }

    public static boolean isFoundationType(String repositoryID) throws MdException {
        return MdRepositoryUtil.isFoundationType(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static boolean isFoundationType(IOMI connectionHandle, String repositoryID) throws MdException {
        return MdRepositoryUtil.getRepositoryType(connectionHandle, repositoryID).equalsIgnoreCase(FOUNDATION_REPOS);
    }

    public static boolean isCustomType(String repositoryID) throws MdException {
        return MdRepositoryUtil.isCustomType(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static boolean isCustomType(IOMI connectionHandle, String repositoryID) throws MdException {
        return MdRepositoryUtil.getRepositoryType(connectionHandle, repositoryID).equalsIgnoreCase(CUSTOM_REPOS);
    }

    public static boolean isProjectType(String repositoryID) throws MdException {
        return MdRepositoryUtil.isProjectType(MetadataWorkspace.getWorkspace().getCMRHandle(), repositoryID);
    }

    public static boolean isProjectType(IOMI connectionHandle, String repositoryID) throws MdException {
        return MdRepositoryUtil.getRepositoryType(connectionHandle, repositoryID).equalsIgnoreCase(PROJECT_REPOS);
    }
}

