/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.CMetadata;
import com.sas.metadata.MapPool;
import com.sas.metadata.MdEvent;
import com.sas.metadata.MdException;
import com.sas.metadata.MdFactory;
import com.sas.metadata.MdFactoryEvent;
import com.sas.metadata.MdFactoryListener;
import com.sas.metadata.MdObjectBase;
import com.sas.metadata.MdObjectBaseUtil;
import com.sas.metadata.MdObjectFactoryListener;
import com.sas.metadata.MdObjectListener;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdServerStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MdStoreUtil;
import com.sas.metadata.MetadataResource;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.Root;
import com.sas.metadata.Util;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class MdObjectFactory
implements MdFactory {
    protected static MetadataResource bundle = new MetadataResource(MdObjectFactory.class);
    protected static int newID;
    protected static EventListenerList MdObjectFactoryListenerList;
    protected static EventListenerList MdFactoryListenerList;
    private static MdObjectFactory m_MdObjectFactoryInstance;
    protected static MdServerStore m_MdServerStore;
    protected static String m_impl_package;
    protected static String m_impl_extension;
    protected boolean m_changeManagementEnabled = false;
    protected boolean m_bInDebug = false;
    protected boolean m_bInPerf = false;
    protected boolean m_bLoggingEnabled = true;
    private static Map class_map;
    protected int m_ParsingType = 0;
    private boolean _removeDependentObjects = true;
    private boolean _formatDates = true;

    private MdObjectFactory() {
        newID = 0;
        m_MdObjectFactoryInstance = this;
        String retVal = System.getProperty("com.sas.metadata.parser");
        if (retVal != null) {
            if (retVal.equalsIgnoreCase("SAX")) {
                this.m_ParsingType = 0;
            } else if (retVal.equalsIgnoreCase("DOM")) {
                this.m_ParsingType = 1;
            }
        }
    }

    public static MapPool getMapPool() {
        return MapPool.instance();
    }

    public void makeConnection(String protocol, String host, String port, String username, String password) throws MdException {
        try {
            MetadataWorkspace workspace = MetadataWorkspace.getWorkspace();
            workspace.makeOMRConnection(host, port, username, password);
        }
        catch (RemoteException e) {
            throw new MdException(e);
        }
    }

    public void makeConnection2(String host, String port, String username, String password) throws MdException {
        try {
            MetadataWorkspace workspace = MetadataWorkspace.getWorkspace();
            workspace.makeOMRConnection(host, port, username, password);
        }
        catch (RemoteException e) {
            throw new MdException(e);
        }
    }

    public void makeOMRConnection(String host, String port, String username, String password) throws MdException {
        try {
            MetadataWorkspace workspace = MetadataWorkspace.getWorkspace();
            workspace.makeOMRConnection(host, port, username, password);
        }
        catch (RemoteException e) {
            throw new MdException(e);
        }
    }

    @Override
    public int getMdFactoryType() {
        return 0;
    }

    public static MetadataResource getBundle() {
        return bundle;
    }

    @Override
    public boolean getDebug() {
        return this.m_bInDebug;
    }

    @Override
    public void setDebug(boolean instate) {
        this.m_bInDebug = instate;
    }

    public boolean getPerf() {
        return this.m_bInPerf;
    }

    public void setPerf(boolean instate) {
        this.m_bInPerf = instate;
    }

    @Override
    public boolean getLoggingEnabled() {
        return this.m_bLoggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean instate) {
        this.m_bLoggingEnabled = instate;
    }

    public void setRemoveDependentObjects(boolean remove) {
        this._removeDependentObjects = remove;
    }

    public boolean getRemoveDependentObjects() {
        return this._removeDependentObjects;
    }

    public void setUseServerFormattedDates(boolean format) {
        this._formatDates = format;
    }

    public boolean getUseServerFormattedDates() {
        return this._formatDates;
    }

    public static MdObjectFactory getInstance() {
        return m_MdObjectFactoryInstance;
    }

    public int getParsingType() {
        return this.m_ParsingType;
    }

    public void setParsingType(int parsing) {
        this.m_ParsingType = parsing;
    }

    public static void dispose() {
        m_MdServerStore.disposeAllStoresAndExit();
        MetadataWorkspace.getWorkspace().dispose();
        m_impl_extension = null;
        m_impl_package = null;
        m_MdServerStore = null;
        MdObjectFactoryListenerList = null;
        m_MdObjectFactoryInstance = null;
        MapPool.instance();
        MapPool.returnMap(class_map);
        class_map = null;
    }

    @Override
    public boolean getChangeManagementEnabled() {
        return this.m_changeManagementEnabled;
    }

    @Override
    public void setChangeManagementEnabled(boolean enabled) {
        this.m_changeManagementEnabled = enabled;
    }

    public static Map getSimpleObjectMap() {
        return m_MdServerStore.getSimpleObjectMap();
    }

    public static Map getDetailObjectMap() {
        return m_MdServerStore.getDetailObjectMap();
    }

    public static MdServerStore getStore() {
        return m_MdServerStore;
    }

    protected static MdServerStore getServerStore() {
        return m_MdServerStore;
    }

    public static MdObjectStore createObjectStore() {
        return MdObjectFactory.createObjectStore(null);
    }

    public static MdObjectStore createObjectStore(MdStore parentStore) {
        return MdObjectFactory.createObjectStore(parentStore, null);
    }

    public static MdObjectStore createObjectStore(MdStore parentStore, String StoreName) {
        MdObjectStore returnObject = null;
        returnObject = parentStore == null ? new MdObjectStore(m_MdServerStore, m_MdObjectFactoryInstance, StoreName) : new MdObjectStore(parentStore, m_MdObjectFactoryInstance, StoreName);
        return returnObject;
    }

    public static CMetadata createSimpleMetadataObject(CMetadata inObject) {
        return MdObjectFactory.createSimpleMetadataObject(inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
    }

    public static CMetadata createSimpleMetadataObject(CMetadata inObject, String lockedBy) {
        Root returnObject = (Root)MdObjectFactory.createSimpleMetadataObject(inObject);
        if (returnObject != null) {
            returnObject.setLockedBy(lockedBy);
        }
        return returnObject;
    }

    public static CMetadata createSimpleMetadataObject(String strName, String strType, String strFQID, String lockedBy) {
        Root returnObject = (Root)MdObjectFactory.createSimpleMetadataObject(strName, strType, strFQID);
        if (returnObject != null) {
            returnObject.setLockedBy(lockedBy);
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMetadata createSimpleMetadataObject(String strName, String strType, String strFQID) {
        Map objectMap = m_MdServerStore.getSimpleObjectMap();
        CMetadata cMetaObject = null;
        Map map = objectMap;
        synchronized (map) {
            if (strFQID.length() < 9) {
                strFQID = MdObjectFactory.makeID(strFQID);
            }
            try {
                StringBuffer objectName = new StringBuffer(m_impl_package);
                objectName.append("Root");
                objectName.append(m_impl_extension);
                String classToLoad = objectName.toString();
                Class<?> LoadedClass = (Class<?>)class_map.get(classToLoad);
                if (LoadedClass == null) {
                    LoadedClass = Class.forName(classToLoad, true, MdObjectFactory.getInstance().getClass().getClassLoader());
                    class_map.put(classToLoad, LoadedClass);
                }
                cMetaObject = (CMetadata)LoadedClass.newInstance();
                cMetaObject.setCMetadataType(strType);
                cMetaObject.setFQID(strFQID);
                cMetaObject.setName(strName, 2);
            }
            catch (Exception e) {
                Util.printOutputln(e.toString());
                return cMetaObject;
            }
            Object tempHashObject = objectMap.get(strFQID);
            if (tempHashObject == null) {
                objectMap.put(strFQID, cMetaObject);
                ArrayList<String> items = new ArrayList<String>(1);
                items.add(strFQID);
            }
        }
        return cMetaObject;
    }

    public static CMetadata createComplexMetadataObject(MdObjectStore oStore, CMetadata oSimple) {
        return MdObjectFactory.createComplexMetadataObject(oStore, null, oSimple.getName(), oSimple.getCMetadataType(), oSimple.getFQID(), null);
    }

    public static CMetadata createComplexMetadataObject(MdObjectStore oStore, String strName, String strType, String strFQID) {
        return MdObjectFactory.createComplexMetadataObject(oStore, null, strName, strType, strFQID, null);
    }

    public static CMetadata createComplexMetadataObject(MdObjectStore inStore, MdStore parentStore, CMetadata oSimple) {
        return MdObjectFactory.createComplexMetadataObject(inStore, parentStore, oSimple.getName(), oSimple.getCMetadataType(), oSimple.getFQID(), null);
    }

    public static CMetadata createComplexMetadataObject(MdObjectStore inStore, MdStore parentStore, String strName, String strType, String strFQID) {
        return MdObjectFactory.createComplexMetadataObject(inStore, parentStore, strName, strType, strFQID, null);
    }

    public static CMetadata createComplexMetadataObject(MdStore inStore, MdStore parentStore, String strName, String strType, String strFQID, String strNewObjectExternalIdentityRealRepos) {
        if (inStore.getStoreType() == 1) {
            return MdObjectFactory.createComplexMetadataObject((MdObjectStore)inStore, parentStore, strName, strType, strFQID, null);
        }
        return MdObjectFactory.createComplexMetadataObjectServerStoreOnly(strName, strType, strFQID);
    }

    public static CMetadata createComplexMetadataObject(MdObjectStore inStore, MdStore parentStore, String strName, String strType, String strFQID, String strNewObjectExternalIdentityRealRepos) {
        MdStore pStore;
        boolean objectInParent = false;
        if (parentStore == null && inStore != null && (pStore = inStore.getOwningStore()) != null) {
            parentStore = pStore;
        }
        if (parentStore != null) {
            if (parentStore.getStoreType() == 0) {
                objectInParent = ((MdServerStore)parentStore).isObjectInServerStore(strFQID);
            } else {
                boolean bl = objectInParent = parentStore.getObject(strFQID) != null;
            }
        }
        if (strFQID.length() < 9) {
            strFQID = MdObjectFactory.makeID(strFQID);
        } else {
            MdObjectBase tempHashObject = null;
            if (inStore != null) {
                tempHashObject = inStore.getObject(strFQID, true);
                if (tempHashObject != null) {
                    return tempHashObject;
                }
                if (inStore.getDeletedObjects() != null && inStore.getDeletedObjects().containsKey(strFQID)) {
                    return null;
                }
                tempHashObject = inStore.getObject(strFQID);
                if (objectInParent && !parentStore.equals(inStore.getOwningStore())) {
                    MdStoreUtil.copyMetaObject(parentStore, (MdStore)inStore, strFQID);
                }
                if ((tempHashObject = inStore.getObject(strFQID, true)) != null) {
                    return tempHashObject;
                }
            }
            if (tempHashObject != null && tempHashObject.getFQID().compareTo(strFQID) == 0) {
                CMetadata returnObject;
                if (inStore == null) {
                    inStore = parentStore != null ? new MdObjectStore(parentStore, m_MdObjectFactoryInstance) : new MdObjectStore(m_MdServerStore, m_MdObjectFactoryInstance);
                }
                inStore.getObject(strFQID);
                if (objectInParent && !parentStore.equals(inStore.getOwningStore())) {
                    MdStoreUtil.copyMetaObject(parentStore, (MdStore)inStore, strFQID);
                }
                if ((returnObject = inStore.getObject(strFQID, true)).isNewObject()) {
                    returnObject.setNameState(1);
                }
                if (MdObjectFactory.getInstance().getChangeManagementEnabled()) {
                    if (strNewObjectExternalIdentityRealRepos != null) {
                        ((Root)returnObject).setChangeState(":" + strNewObjectExternalIdentityRealRepos);
                    } else {
                        ((Root)returnObject).setChangeState("");
                    }
                }
                return returnObject;
            }
        }
        if (inStore == null) {
            inStore = parentStore != null ? new MdObjectStore(parentStore, m_MdObjectFactoryInstance) : new MdObjectStore(m_MdServerStore, m_MdObjectFactoryInstance);
        }
        CMetadata returnObject = null;
        boolean exists = MdObjectFactory.objectExists(inStore, strFQID);
        returnObject = !exists ? MdObjectFactory.createObjectInParentObjectStores(inStore, strName, strType, strFQID) : inStore.getObject(strFQID);
        if (returnObject == null) {
            return returnObject;
        }
        if (objectInParent && !parentStore.equals(inStore.getOwningStore())) {
            MdStoreUtil.copyMetaObject(parentStore, (MdStore)inStore, strFQID);
        }
        if (returnObject.isNewObject()) {
            returnObject.setNameState(1);
            if (MdObjectFactory.getInstance().getChangeManagementEnabled()) {
                if (strNewObjectExternalIdentityRealRepos != null) {
                    ((Root)returnObject).setChangeState(":" + strNewObjectExternalIdentityRealRepos);
                } else {
                    ((Root)returnObject).setChangeState("");
                }
            }
        }
        return returnObject;
    }

    public static CMetadata createComplexMetadataObjectServerStoreOnly(String strName, String strType, String strFQID) {
        MdObjectBase cMetaObject = null;
        boolean createdNew = false;
        if (strFQID.length() < 9) {
            strFQID = MdObjectFactory.makeID(strFQID);
            createdNew = true;
        } else {
            CMetadata tempHashObject = (CMetadata)m_MdServerStore.getDetailObjectMap().get(strFQID);
            if (tempHashObject != null && tempHashObject.getFQID().compareTo(strFQID) == 0) {
                tempHashObject.setObjectStore(m_MdServerStore);
                return tempHashObject;
            }
        }
        try {
            StringBuffer objectName = new StringBuffer(m_impl_package);
            objectName.append(strType);
            objectName.append(m_impl_extension);
            String classToLoad = objectName.toString();
            Class<?> LoadedClass = (Class<?>)class_map.get(classToLoad);
            if (LoadedClass == null) {
                LoadedClass = Class.forName(classToLoad, true, MdObjectFactory.getInstance().getClass().getClassLoader());
                class_map.put(classToLoad, LoadedClass);
            }
            cMetaObject = (CMetadata)LoadedClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cMetaObject != null) {
            if (createdNew) {
                cMetaObject.setName(strName, 1);
                cMetaObject.setFQID(strFQID, 1);
            } else {
                cMetaObject.setName(strName, 2);
                cMetaObject.setFQID(strFQID, 1);
            }
            cMetaObject.setCMetadataType(strType);
            Map serverStoreMap = m_MdServerStore.getDetailObjectMap();
            serverStoreMap.put(strFQID, cMetaObject);
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            MdEvent addedEvent = new MdEvent(cMetaObject, m_MdServerStore);
            m_MdServerStore.fireMdObjectsAdded(addedEvent, items);
            addedEvent = null;
        }
        cMetaObject.setObjectStore(m_MdServerStore);
        cMetaObject.addMdObjectListener(m_MdServerStore);
        return cMetaObject;
    }

    public static CMetadata createComplexMetadataObjectStoreOnly(MdStore inStore, String strName, String strType, String strFQID) {
        if (strFQID == null || strFQID.length() == 0) {
            return null;
        }
        if (inStore == null) {
            return null;
        }
        if (inStore.getStoreType() == 0) {
            return null;
        }
        MdObjectBaseUtil cMetaObject = null;
        if (strFQID.length() < 9) {
            strFQID = MdObjectFactory.makeID(strFQID);
        } else {
            Map delObjectMap = ((MdObjectStore)inStore).getDeletedObjects();
            if (delObjectMap != null && delObjectMap.containsKey(strFQID)) {
                return null;
            }
            CMetadata tempHashObject = (CMetadata)inStore.getDetailObjectMap().get(strFQID);
            if (tempHashObject != null && tempHashObject.getFQID().compareTo(strFQID) == 0) {
                tempHashObject.setObjectStore(inStore);
                return tempHashObject;
            }
        }
        try {
            StringBuffer objectName = new StringBuffer(m_impl_package);
            objectName.append(strType);
            objectName.append(m_impl_extension);
            String classToLoad = objectName.toString();
            Class<?> LoadedClass = (Class<?>)class_map.get(classToLoad);
            if (LoadedClass == null) {
                LoadedClass = Class.forName(classToLoad, true, MdObjectFactory.getInstance().getClass().getClassLoader());
                class_map.put(classToLoad, LoadedClass);
            }
            cMetaObject = (CMetadata)LoadedClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cMetaObject != null) {
            if (strFQID.indexOf(36) > -1) {
                cMetaObject.setName(strName, 1);
                cMetaObject.setFQID(strFQID, 1);
            } else {
                cMetaObject.setName(strName, 2);
                cMetaObject.setFQID(strFQID, 2);
            }
            cMetaObject.setCMetadataType(strType);
            inStore.getDetailObjectMap().put(strFQID, cMetaObject);
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            MdEvent addedEvent = new MdEvent(cMetaObject, inStore);
            inStore.fireMdObjectsAdded(addedEvent, items);
            addedEvent = null;
        }
        cMetaObject.addMdObjectListener((MdObjectStore)inStore);
        cMetaObject.setObjectStore(inStore);
        return cMetaObject;
    }

    private static boolean objectExists(MdObjectStore inStore, String objectID) {
        boolean exists = false;
        CMetadata meta = inStore.getObject(objectID, true);
        if (meta != null) {
            exists = true;
        } else if (!exists && inStore.getOwningStore().getStoreType() != 0) {
            exists = MdObjectFactory.objectExists((MdObjectStore)inStore.getOwningStore(), objectID);
        }
        return exists;
    }

    private static CMetadata createObjectInParentObjectStores(MdObjectStore inStore, String strName, String strType, String strFQID) {
        CMetadata parentObject;
        CMetadata meta = MdObjectFactory.createComplexMetadataObjectStoreOnly(inStore, strName, strType, strFQID);
        if (inStore.getOwningStore() != null && inStore.getOwningStore().getStoreType() != 0 && (parentObject = MdObjectFactory.createObjectInParentObjectStores((MdObjectStore)inStore.getOwningStore(), strName, strType, strFQID)) == null) {
            return null;
        }
        return meta;
    }

    public static void deleteDetailMetadataObject(String strFQID) {
        CMetadata meta = m_MdServerStore.getObjectInChildStore(strFQID);
        if (meta != null) {
            if (MdObjectFactory.getInstance().getDebug()) {
                Util.printOutputln("Deleting object: " + meta.getName() + ", Id=\"" + meta.getId() + "\"");
            }
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            m_MdServerStore.deleteObjectFromStores(strFQID);
            MdEvent removedEvent = new MdEvent(meta, m_MdServerStore);
            m_MdServerStore.fireMdObjectsRemoved(removedEvent, items);
            Object var3_3 = null;
        }
    }

    private static void createDeleteEvent(List objectIDList) {
        int size;
        int n = size = objectIDList == null ? 0 : objectIDList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String objectID = (String)objectIDList.get(i);
                m_MdServerStore.deleteObjectFromStores(objectID);
                MdEvent deletedEvent = new MdEvent(m_MdObjectFactoryInstance, m_MdServerStore);
                MdObjectFactory.fireMdObjectDeleted(deletedEvent, objectID);
                deletedEvent = null;
            }
            MdFactoryEvent event = new MdFactoryEvent((MdFactory)m_MdObjectFactoryInstance, objectIDList.toArray(new String[objectIDList.size()]));
            MdObjectFactory.fireMdObjectsDeleted(event);
            Object var2_3 = null;
        }
    }

    protected static synchronized void deleteObjectsFromStores(List objectList) {
        MdObjectFactory.createDeleteEvent(objectList);
    }

    public static void deletePublicObject(CMetadata publicObject) throws MdException {
        MdObjectFactory.deleteMetadataObject(publicObject);
    }

    public static void deletePublicObject(CMetadata publicObject, String template) throws MdException {
        if (publicObject != null) {
            ArrayList<String> deleteList;
            if (publicObject.isNewObject()) {
                deleteList = new ArrayList<String>(1);
                deleteList.add(publicObject.getId());
            } else {
                deleteList = MetadataUtil.deleteMetadataObject(publicObject, template);
            }
            MdObjectFactory.createDeleteEvent(deleteList);
            m_MdServerStore.fireMdObjectsRemoved(new MdEvent(m_MdObjectFactoryInstance, m_MdServerStore), new ArrayList(deleteList));
        }
    }

    public static void deleteMetadataObject(CMetadata delobject) throws MdException {
        if (delobject != null) {
            Vector<String> deletedIds;
            if (delobject.isNewObject()) {
                deletedIds = new Vector<String>(1);
                deletedIds.add(delobject.getId());
            } else {
                deletedIds = MetadataUtil.deleteMetadataObject(delobject);
            }
            MdObjectFactory.createDeleteEvent(deletedIds);
            MdEvent removedEvent = new MdEvent(m_MdObjectFactoryInstance, m_MdServerStore);
            m_MdServerStore.fireMdObjectsRemoved(removedEvent, new ArrayList(deletedIds));
            Object var2_2 = null;
        }
    }

    public static void deleteMetadataObjects(CMetadata deleteObject, String template) throws MdException {
        MdObjectFactory.deleteMetadataObjects(deleteObject.getName(), deleteObject.getCMetadataType(), deleteObject.getFQID(), template);
    }

    public static void deleteMetadataObjects(String objectName, String objectType, String objectFQID, String template) throws MdException {
        MdObjectStore deleteStore = MdObjectFactory.createObjectStore(null, "MdObjectFactory::deleteMetadataObjects");
        CMetadata deleteObject = MdObjectFactory.createComplexMetadataObject(deleteStore, null, objectName, objectType, objectFQID, null);
        if (deleteObject == null) {
            return;
        }
        if (template == null) {
            template = "";
        }
        StringBuffer SELECT = new StringBuffer(objectFQID.length() + template.length() + 26);
        SELECT.append("<XMLSelect search=\"@Id='");
        SELECT.append(objectFQID);
        SELECT.append("'\"/>");
        SELECT.append(template);
        List toDeleteListServer = MetadataUtil.getMetadataObjectsSubsetList(deleteStore, "A0000001." + deleteObject.getRepositoryID(), objectType, 2436, SELECT.toString(), true);
        LinkedHashMap<String, String> deleteMap = new LinkedHashMap<String, String>(toDeleteListServer.size());
        for (CMetadata lDetailed : toDeleteListServer) {
            if (lDetailed == null) continue;
            deleteMap.put(lDetailed.getId(), lDetailed.getCMetadataType());
        }
        deleteStore.dispose();
        List deletedIds = MetadataUtil.deleteMetadataObjects(deleteMap);
        MdObjectFactory.createDeleteEvent(deletedIds);
        deleteMap = null;
    }

    public static synchronized void deleteMetadataObjects(List objectList) throws MdException {
        ArrayList<String> deleteFromClientList = new ArrayList<String>();
        ArrayList<CMetadata> deleteFromServerList = new ArrayList<CMetadata>();
        int size = objectList.size();
        for (int i = 0; i < size; ++i) {
            CMetadata meta = (CMetadata)objectList.get(i);
            if (meta.isNewObject()) {
                deleteFromClientList.add(meta.getId());
                continue;
            }
            deleteFromServerList.add(meta);
        }
        if (deleteFromServerList.size() > 0) {
            List deletedObjects = MetadataUtil.deleteMetadataObjects(deleteFromServerList);
            deleteFromClientList.addAll(deletedObjects);
        }
        MdObjectFactory.createDeleteEvent(deleteFromClientList);
    }

    public static void unlockMetadataObjects(CMetadata unlockObject, String template) throws MdException {
        MdObjectFactory.unlockMetadataObjects(unlockObject.getName(), unlockObject.getCMetadataType(), unlockObject.getFQID(), template);
    }

    public static void unlockMetadataObjects(String objectName, String objectType, String objectFQID, String template) throws MdException {
        MdObjectStore unlockStore = MdObjectFactory.createObjectStore(null, "MdObjectFactory::unlockMetadataObjects");
        CMetadata unlockObject = MdObjectFactory.createComplexMetadataObject(unlockStore, null, objectName, objectType, objectFQID, null);
        if (unlockObject == null) {
            return;
        }
        if (template == null) {
            template = "";
        }
        StringBuffer SELECT = new StringBuffer(objectFQID.length() + template.length() + 26);
        SELECT.append("<XMLSelect search=\"@Id='");
        SELECT.append(objectFQID);
        SELECT.append("'\"/>");
        SELECT.append(template);
        List toUnlockListServer = MetadataUtil.getMetadataObjectsSubsetList(unlockStore, "A0000001." + unlockObject.getRepositoryID(), objectType, 388, SELECT.toString(), true);
        Vector<CMetadata> toUnlockList = new Vector<CMetadata>(toUnlockListServer.size());
        for (CMetadata lDetailed : toUnlockListServer) {
            CMetadata lSimple = MdObjectFactory.createSimpleMetadataObject(lDetailed);
            toUnlockList.add(lSimple);
        }
        unlockStore.dispose();
        MetadataUtil.unlockMetadataObjects(toUnlockList);
    }

    public static String makeID(String shortID) {
        int zero = 48;
        StringBuffer id = new StringBuffer(String.valueOf(newID));
        int iLength = id.length();
        for (int i = 7; i > iLength; --i) {
            id.insert(0, '0');
        }
        id.insert(0, ".$");
        id.insert(0, shortID);
        if (++newID > 9999999) {
            newID = 0;
        }
        return id.toString();
    }

    public static void dumpDetailHashMap() {
        m_MdServerStore.dumpDetailAllHashMaps();
    }

    public static CMetadata getObject(String strFQID) {
        return m_MdServerStore.getObject(strFQID);
    }

    public static void changeHashKey(String strOldId, String strNewId) {
        m_MdServerStore.changeHashKey(strOldId, strNewId);
    }

    public void changeImplementationPackage(String newPackage) {
        m_impl_package = new String(newPackage);
    }

    public void changeImplementationExtension(String newExtension) {
        m_impl_extension = new String(newExtension);
    }

    public static void removeStore(MdStore childStore) {
        m_MdServerStore.removeStore(childStore);
    }

    public void addMdObjectListener(MdObjectListener l) {
        m_MdServerStore.addMdObjectListener(l);
    }

    public void removeMdObjectListener(MdObjectListener l) {
        m_MdServerStore.removeMdObjectListener(l);
    }

    public static void addMdObjectFactoryListener(MdObjectFactoryListener l) {
        MdObjectFactoryListenerList.add(MdObjectFactoryListener.class, l);
    }

    public static void removeMdObjectFactoryListener(MdObjectFactoryListener l) {
        MdObjectFactoryListenerList.remove(MdObjectFactoryListener.class, l);
    }

    public static void addMdFactoryListener(MdFactoryListener l) {
        MdFactoryListenerList.add(MdFactoryListener.class, l);
    }

    public static void removeMdFactoryListener(MdFactoryListener l) {
        MdFactoryListenerList.remove(MdFactoryListener.class, l);
    }

    public static void fireMdObjectCreated(MdEvent e, String id) {
        Object[] listeners = MdObjectFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectFactoryListener.class) continue;
            ((MdObjectFactoryListener)listeners[i + 1]).MdObjectCreated(e, id);
        }
    }

    public static void fireMdObjectsCreated(MdEvent e, List id) {
        m_MdServerStore.updateCreatedItemsList(id);
        Object[] listeners = MdObjectFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectFactoryListener.class) continue;
            ((MdObjectFactoryListener)listeners[i + 1]).MdObjectsCreated(e, id);
        }
    }

    public static void fireMdObjectDeleted(MdEvent e, String id) {
        Object[] listeners = MdObjectFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectFactoryListener.class) continue;
            ((MdObjectFactoryListener)listeners[i + 1]).MdObjectDeleted(e, id);
        }
    }

    protected static boolean hasFactoryListeners() {
        return MdFactoryListenerList.getListenerList().length > 0;
    }

    public static void fireMdObjectsCreated(MdFactoryEvent e) {
        Map map = e.getObjectMap();
        if (map != null) {
            ArrayList idList = new ArrayList(map.keySet());
            m_MdServerStore.updateCreatedItemsList(idList);
        }
        Object[] listeners = MdFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdFactoryListener.class) continue;
            ((MdFactoryListener)listeners[i + 1]).MdObjectsCreated(e);
        }
    }

    public static void fireMdObjectsModified(MdFactoryEvent e) {
        Object[] listeners = MdFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdFactoryListener.class) continue;
            ((MdFactoryListener)listeners[i + 1]).MdObjectsModified(e);
        }
    }

    public static void fireMdObjectsDeleted(MdFactoryEvent e) {
        Object[] listeners = MdFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdFactoryListener.class) continue;
            ((MdFactoryListener)listeners[i + 1]).MdObjectsDeleted(e);
        }
    }

    static {
        MdObjectFactoryListenerList = new EventListenerList();
        MdFactoryListenerList = new EventListenerList();
        m_MdObjectFactoryInstance = new MdObjectFactory();
        m_MdServerStore = MdServerStore.getServerStoreInstance();
        m_impl_package = "com.sas.metadata.impl.";
        m_impl_extension = "Impl";
        class_map = new HashMap(100);
    }
}

