/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.MdDeletedObjectsHandler;
import com.sas.metadata.MdException;
import com.sas.metadata.MdGetObjectHandler;
import com.sas.metadata.MdGetObjectNoCacheHandler;
import com.sas.metadata.MdGetTypesHandler;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdObjectStore;
import com.sas.metadata.MdServerStore;
import com.sas.metadata.MdStore;
import com.sas.metadata.MdUpdateHandler;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.Util;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.StringHolder;

public class MdOMIWrapper {
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    public static final Pattern m_idPattern = Pattern.compile("(?:Id)=\"([0-9a-zA-Z.$]+)\"");
    protected static final Pattern m_delObjectsPattern = Pattern.compile("<DeletedObjects/>");
    private static final String UPDATE_METADATA_TAG = "<UpdateMetadata>";

    public MdOMIWrapper() {
        this.parserFactory.setNamespaceAware(false);
        this.parserFactory.setValidating(false);
    }

    public void getTypes(IOMI connectionHandle, List nameList, List descList) throws MdException {
        MdGetTypesHandler myHandler = null;
        StringHolder outXML = new StringHolder();
        StringBuffer inputXML = new StringBuffer(67);
        inputXML.append("<GetTypes><Types/><NS>");
        inputXML.append(MetadataUtil.getNamespace());
        inputXML.append("</NS><Flags>0</Flags><Options/></GetTypes>");
        Util.printLoglnClient(inputXML.toString());
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetTypes(outXML, MetadataUtil.getNamespace(), 0, "");
            if (MdObjectFactory.getInstance().getPerf()) {
                t1 = System.currentTimeMillis();
                Util.printPerfln(Thread.currentThread().getName() + ",GetTypes," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            String strXML = outXML.value;
            Util.printLoglnServer(strXML);
            myHandler = new MdGetTypesHandler(nameList, descList, this.parserFactory);
            myHandler.parseXML(strXML);
            nameList = myHandler.getObjectTypes();
            descList = myHandler.getObjectDescriptions();
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    public int updateMetadata(String inXML, int iFlags) throws MdException {
        StringHolder outXML = new StringHolder();
        if ((iFlags & 0x10000000) == 0) {
            iFlags |= 0x10000000;
        }
        int rc = 0;
        Util.printLoglnClient(inXML);
        long t0 = System.currentTimeMillis();
        try {
            rc = MetadataWorkspace.getWorkspace().getCMRHandle().UpdateMetadata(inXML, outXML, MetadataUtil.getNamespace(), iFlags, "");
            if (rc != 0) {
                Util.printOutputln("Bad Update! rc = " + rc);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        long t1 = System.currentTimeMillis();
        Util.printPerfln(Thread.currentThread().getName() + ",UpdateMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        Util.printLoglnServer(outXML.value);
        return rc;
    }

    public AssociationList getAssociatedObjects(CMetadata object, String strAssociation, String strTemplate, boolean doNotOverrideAssocs) throws MdException {
        ArrayList<String> inXMLComplex = new ArrayList<String>(1);
        inXMLComplex.add(strAssociation);
        int options = 2056;
        if (strTemplate != null && strTemplate.length() > 0) {
            options |= 4;
        }
        List attributes = null;
        Util.printOutputln("DEBUG NOTE: GetAssociatedObjects to the server for association " + strAssociation);
        if (object == null || object.getFQID().indexOf(36) > -1 || !object.getObjectStore().isGoToServerForMetadata()) {
            Util.printOutputln(MdObjectFactory.getBundle().getString("MetadataUtil.getMetadataAllDepthsNotToServer.txt"));
            return object.getMdObjectAssociation(strAssociation);
        }
        String inXML = MetadataUtil.createGetXMLString(object.getCMetadataType(), object.getFQID(), attributes, inXMLComplex);
        String outXMLString = this.getMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, strTemplate, options);
        if (object.getObjectStore() == null) {
            object = MdObjectFactory.createComplexMetadataObjectServerStoreOnly(object.getName(), object.getCMetadataType(), object.getFQID());
        }
        MdGetObjectHandler myHandler = null;
        AssociationList associatedObjectList = null;
        try {
            myHandler = new MdGetObjectHandler(object.getObjectStore(), this.parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(outXMLString);
            if (object.getObjectStore().getStoreType() == 0) {
                object.resetObject();
            }
            object = (CMetadata)myHandler.getRootLevelCreatedObjects().get(0);
            Pattern assocPattern = Pattern.compile("<" + strAssociation + ">");
            Matcher m = assocPattern.matcher(outXMLString);
            if (m.find()) {
                associatedObjectList = object.getMdObjectAssociation(strAssociation);
                if (object.getObjectStore().isGoToServerForMetadata()) {
                    associatedObjectList.setState(1);
                }
            } else {
                associatedObjectList = new AssociationList(strAssociation);
                associatedObjectList.setState(1);
                object.setMdObjectAssociation(associatedObjectList);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return associatedObjectList;
    }

    public CMetadata getMetadataAllDepths(MdStore inStore, String strType, String strFQID, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException {
        return this.getMetadataAllDepths(MetadataWorkspace.getWorkspace().getCMRHandle(), inStore, strType, strFQID, inSimpleAttr, inComplexObject, strTemplate, iOptions, doNotOverrideAssocs, doNotOverrideAttrs);
    }

    public CMetadata getMetadataAllDepths(IOMI connectionHandle, MdStore inStore, String strType, String strFQID, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException {
        MdGetObjectHandler myHandler = null;
        CMetadata object = null;
        try {
            if (inStore == null) {
                inStore = MdObjectFactory.getServerStore();
            }
            String inXML = MetadataUtil.createGetXMLString(strType, strFQID, inSimpleAttr, inComplexObject);
            String returnXML = this.getMetadata(connectionHandle, inXML, strTemplate, iOptions);
            myHandler = new MdGetObjectHandler(inStore, this.parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            if (!doNotOverrideAttrs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            }
            myHandler.parseXML(returnXML);
            object = inStore.getStoreType() == 1 ? inStore.getObject(strFQID) : ((MdServerStore)inStore).getObjectFromServerStoreOnly(strFQID);
            if (inStore.getStoreType() == 0) {
                object.resetObject();
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return object;
    }

    public CMetadata getMetadataAllDepths(CMetadata object, List inSimpleAttr, List inComplexObject, String strTemplate, int iOptions, boolean doNotOverrideAssocs) throws MdException {
        MdGetObjectHandler myHandler = null;
        try {
            if (object == null || object.getFQID().indexOf(36) > -1 || !object.getObjectStore().isGoToServerForMetadata()) {
                MdObjectFactory.getInstance();
                Util.printOutputln(MdObjectFactory.getBundle().getString("MetadataUtil.getMetadataAllDepthsNotToServer.txt"));
                CMetadata cMetadata = object;
                return cMetadata;
            }
            String inXML = MetadataUtil.createGetXMLString(object.getCMetadataType(), object.getFQID(), inSimpleAttr, inComplexObject);
            String returnXML = this.getMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), inXML, strTemplate, iOptions);
            myHandler = new MdGetObjectHandler(object.getObjectStore(), this.parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(returnXML);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return object;
    }

    public List getMetadata(IOMI connectionHandle, MdStore store, Map objectMap, String template, int flags, boolean doNotOverrideAssocs, boolean doNotOverrideAttrs) throws MdException {
        MdGetObjectHandler myHandler = null;
        try {
            if (store == null) {
                store = MdObjectFactory.getServerStore();
            }
            if (objectMap == null || objectMap.size() == 0 || !store.isGoToServerForMetadata()) {
                Util.printOutputln("Debug Note: getMetadata not going to server...");
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            String inXML = MetadataUtil.createGetXMLString(objectMap);
            StringBuffer returnXML = new StringBuffer();
            returnXML.append("<Metadata>");
            returnXML.append(this.getMetadata(connectionHandle, inXML, template, flags));
            returnXML.append("</Metadata>");
            myHandler = new MdGetObjectHandler(store, this.parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            if (!doNotOverrideAttrs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            }
            myHandler.parseXML(returnXML.toString());
            ArrayList arrayList = new ArrayList(myHandler.getRootLevelCreatedObjects());
            return arrayList;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    public String getMetadata(IOMI connectionHandle, String inXML, String strTemplate, int iFlags) throws MdException {
        if (connectionHandle == null) {
            connectionHandle = MetadataWorkspace.getWorkspace().getCMRHandle();
        }
        return this.getMetadataFromServer(connectionHandle, inXML, iFlags, strTemplate);
    }

    public List getMetadataObjectsSubset(IOMI connectionHandle, MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException {
        MdStore store = inStore;
        if (store == null) {
            store = MdObjectFactory.getServerStore();
        }
        if (!store.isGoToServerForMetadata()) {
            Util.printOutputln("Debug Note: getMetadataObjectsSubset Not going to server...");
            return new ArrayList();
        }
        String outXMLString = this.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, options);
        Vector retList = null;
        MdGetObjectHandler myHandler = null;
        try {
            myHandler = new MdGetObjectHandler(store, this.parserFactory);
            if (!doOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(outXMLString);
            retList = new Vector(myHandler.getRootLevelCreatedObjects());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    public String DoRequest(IOMI connectionHandle, String inXML, boolean fUpdateIds) throws MdException {
        Util.printLoglnClient(inXML);
        StringHolder outXML = new StringHolder();
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        MdUpdateHandler myHandler = null;
        try {
            List deletedObjectsList;
            List updateList;
            connectionHandle.DoRequest(inXML, outXML);
            if (MdObjectFactory.getInstance().getPerf()) {
                t1 = System.currentTimeMillis();
                Util.printPerfln(Thread.currentThread().getName() + ",DoRequest," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            }
            String outXMLString = outXML.value;
            Util.printLoglnServer(outXMLString);
            myHandler = new MdUpdateHandler(this.parserFactory);
            myHandler.parseXML(outXMLString);
            List deleteList = myHandler.getDeleteMetadataList();
            if (deleteList != null) {
                MdObjectFactory.deleteObjectsFromStores(deleteList);
            }
            if ((updateList = myHandler.getUpdatedObjectsList()) != null && fUpdateIds) {
                this.updateObjectIds(inXML, updateList);
            }
            if ((deletedObjectsList = myHandler.getDeletedObjectsList()) != null) {
                this.processDeletedObjects(deletedObjectsList);
            }
            String string = outXMLString;
            return string;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    public void processDeletedObjects(String inXML) throws MdException {
        Matcher matcher = m_delObjectsPattern.matcher(inXML);
        if (matcher.find()) {
            return;
        }
        MdDeletedObjectsHandler myHandler = null;
        try {
            myHandler = new MdDeletedObjectsHandler(this.parserFactory);
            myHandler.parseXML(inXML);
            List deletedObjects = myHandler.getDeletedObjects();
            int size = deletedObjects.size();
            for (int i = 0; i < size; ++i) {
                String toDelete = (String)deletedObjects.get(i);
                MdObjectFactory.deleteDetailMetadataObject(toDelete);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    public Map getMetadataNoCache(IOMI connectionHandle, String strType, String strFQID, String strOptions, int iFlags) throws MdException {
        MdGetObjectHandler myHandler = null;
        Map objectMap = new HashMap();
        StringBuffer inXML = new StringBuffer(40);
        inXML.append("<");
        inXML.append(strType);
        inXML.append(" Id=\"");
        inXML.append(strFQID);
        inXML.append("\"/>");
        try {
            String outXMLString = this.getMetadataFromServer(connectionHandle, inXML.toString(), iFlags, strOptions);
            myHandler = new MdGetObjectNoCacheHandler(this.parserFactory);
            myHandler.parseXML(outXMLString);
            if (myHandler.getRootLevelCreatedObjects().size() > 0) {
                objectMap = (Map)myHandler.getRootLevelCreatedObjects().get(0);
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return objectMap;
    }

    public List getMetadataNoCache(IOMI connectionHandle, Map objectMap, String strOptions, int iFlags) throws MdException {
        MdGetObjectHandler myHandler = null;
        ArrayList objectList = null;
        String inXML = MetadataUtil.createGetXMLString(objectMap);
        try {
            String xml = this.getMetadataFromServer(connectionHandle, inXML, iFlags, strOptions);
            StringBuffer sb = new StringBuffer(21 + xml.length());
            sb.append("<Metadata>");
            sb.append(xml);
            sb.append("</Metadata>");
            myHandler = new MdGetObjectNoCacheHandler(this.parserFactory);
            myHandler.parseXML(sb.toString());
            objectList = new ArrayList(myHandler.getRootLevelCreatedObjects());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return objectList;
    }

    public List getMetadataObjectsNoCache(IOMI connectionHandle, String strType, String strReposId, String strOptions, int iFlags) throws MdException {
        MdGetObjectHandler myHandler = null;
        ArrayList objectList = null;
        try {
            String outXMLString = this.getMetadataObjectsFromServer(connectionHandle, strReposId, strType, iFlags, strOptions);
            myHandler = new MdGetObjectNoCacheHandler(this.parserFactory);
            myHandler.parseXML(outXMLString);
            objectList = new ArrayList(myHandler.getRootLevelCreatedObjects());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return objectList;
    }

    public List getMetadataObjects(IOMI connectionHandle, String strReposID, String strType, int flags, String strOptions) throws MdException {
        MdGetObjectHandler myHandler = null;
        Vector retList = null;
        try {
            String outXMLString = this.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, strOptions);
            myHandler = new MdGetObjectHandler(MdObjectFactory.getServerStore(), this.parserFactory);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.setFlag(MdGetObjectHandler.CREATE_SIMPLE_OBJECTS_ONLY);
            myHandler.parseXML(outXMLString);
            retList = new Vector(myHandler.getRootLevelCreatedObjects());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    public void populateStoreFromString(MdStore inStore, String inXML, int state, boolean useReposForNewObjects) throws MdException {
        MdStore store = inStore;
        if (inStore == null) {
            store = MdObjectFactory.getServerStore();
        }
        MdGetObjectHandler myHandler = null;
        try {
            myHandler = new MdGetObjectHandler(store, this.parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            if (state == 1) {
                myHandler.setFlag(MdGetObjectHandler.LOCAL_STATE_ON);
            }
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(inXML);
            List createdObjects = myHandler.getObjectCreatedList();
            if (useReposForNewObjects) {
                for (CMetadata listObject : createdObjects) {
                    if (!listObject.isNewObject()) continue;
                    String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                    MdObjectFactory.changeHashKey(listObject.getId(), newId);
                }
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    public void populateStoreFromInputStream(MdStore inStore, InputStream stream, int state, boolean useReposForNewObjects) throws MdException {
        MdStore store = inStore;
        if (inStore == null) {
            store = MdObjectFactory.getServerStore();
        }
        MdGetObjectHandler myHandler = null;
        try {
            myHandler = new MdGetObjectHandler(store, this.parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            if (state == 1) {
                myHandler.setFlag(MdGetObjectHandler.LOCAL_STATE_ON);
            }
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(stream);
            List createdObjects = myHandler.getObjectCreatedList();
            if (useReposForNewObjects) {
                for (CMetadata listObject : createdObjects) {
                    if (!listObject.isNewObject()) continue;
                    String newId = listObject.getObjectStore().makeID(listObject.getFQID().substring(0, 8));
                    MdObjectFactory.changeHashKey(listObject.getId(), newId);
                }
            }
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    public List getMetadataObjectsSubsetList(IOMI connectionHandle, MdStore inStore, String strReposID, String strType, int flags, String options, boolean doOverrideAssocs) throws MdException {
        MdStore store = inStore;
        if (store == null) {
            store = MdObjectFactory.getServerStore();
        }
        if (store != null && !store.isDisposed() && !store.isGoToServerForMetadata()) {
            Util.printOutputln("Debug Note: getMetadataObjectsSubsetList() Not going to server...");
            return new ArrayList();
        }
        String outXMLString = this.getMetadataObjectsFromServer(connectionHandle, strReposID, strType, flags, options);
        MdGetObjectHandler myHandler = null;
        ArrayList retList = null;
        try {
            myHandler = new MdGetObjectHandler(store, this.parserFactory);
            if (!doOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(outXMLString);
            retList = new ArrayList(myHandler.getObjectCreatedList());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    public List getMetadataObjects(IOMI connectionHandle, MdStore inStore, String inXML, String strTemplate, int iFlags, boolean doNotOverrideAssocs) throws MdException {
        MdStore store = inStore;
        if (store == null) {
            store = MdObjectFactory.getServerStore();
        }
        if (store != null && !store.isDisposed() && !store.isGoToServerForMetadata()) {
            Util.printOutputln("Debug Note: getMetadataObjects Not going to server...");
            return new Vector(0);
        }
        String xml = this.getMetadataFromServer(connectionHandle, inXML, iFlags, strTemplate);
        StringBuffer outXMLString = new StringBuffer(21 + xml.length());
        outXMLString.append("<Metadata>");
        outXMLString.append(xml);
        outXMLString.append("</Metadata>");
        MdGetObjectHandler myHandler = null;
        Vector retList = null;
        try {
            myHandler = new MdGetObjectHandler(store, this.parserFactory);
            if (!doNotOverrideAssocs) {
                myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS);
            }
            myHandler.parseXML(outXMLString.toString());
            retList = new Vector(myHandler.getRootLevelCreatedObjects());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
        return retList;
    }

    public void refreshStoreFromServer(MdObjectStore inStore, boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws MdException {
        String updateXML = inStore.createRefreshXMLforStore(includeLocallyChangedItems, getFullObjectUpdate);
        int flags = 2304;
        if (getFullObjectUpdate) {
            flags |= 1;
        }
        String retXML = this.getMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), updateXML, "", flags);
        StringBuffer outXMLBuffer = new StringBuffer(retXML.length() + 19);
        outXMLBuffer.append("<Objects>");
        outXMLBuffer.append(retXML);
        outXMLBuffer.append("</Objects>");
        MdGetObjectHandler myHandler = null;
        try {
            myHandler = new MdGetObjectHandler(inStore, this.parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(outXMLBuffer.toString());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    public void refreshObjectFromServer(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate, boolean refreshAssocsSetByServerOnly) throws MdException {
        MdStore inStore = inObject.getObjectStore();
        int flags = 264;
        if (getFullObjectUpdate && !refreshAssocsSetByServerOnly) {
            flags |= 1;
        }
        String refreshXML = MetadataUtil.createRefreshXML(inObject, refreshAssocsSetByServerOnly, getFullObjectUpdate);
        String retXML = this.getMetadata(MetadataWorkspace.getWorkspace().getCMRHandle(), refreshXML, "", flags);
        StringBuffer outXMLBuffer = new StringBuffer(retXML.length() + 19);
        outXMLBuffer.append("<Objects>");
        outXMLBuffer.append(retXML);
        outXMLBuffer.append("</Objects>");
        MdGetObjectHandler myHandler = null;
        try {
            myHandler = new MdGetObjectHandler(inStore, this.parserFactory);
            myHandler.setFlag(MdGetObjectHandler.MDSTORE_XML);
            myHandler.setFlag(MdGetObjectHandler.OVERRIDE_LOCALLYSET_ASSOCIATIONS | MdGetObjectHandler.OVERRIDE_LOCALLYSET_ATTRIBUTES);
            myHandler.parseXML(outXMLBuffer.toString());
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }

    private void updateObjectIds(String clientXML, List serverIDList) {
        int index = clientXML.indexOf(UPDATE_METADATA_TAG);
        List clientIDList = this.getListOfIdMatchesInString(clientXML = clientXML.substring(index, clientXML.length()));
        int clientSize = clientIDList.size();
        if (clientSize > serverIDList.size()) {
            clientSize = serverIDList.size();
        }
        ArrayList<String> idsFound = new ArrayList<String>();
        for (int i = 0; i < clientSize; ++i) {
            String serverID;
            String clientID = (String)clientIDList.get(i);
            if (idsFound.contains(clientID) || clientID.equals(serverID = (String)serverIDList.get(i))) continue;
            idsFound.add(clientID);
            MdObjectFactory.changeHashKey(clientID, serverID);
        }
    }

    public void updateObjectIds(String clientXML, String serverXML) {
        ArrayList<String> idsFound = new ArrayList<String>();
        List oldids = this.getListOfIdMatchesInString(clientXML);
        List newids = this.getListOfIdMatchesInString(serverXML);
        int oldsize = oldids.size();
        if (oldsize > newids.size()) {
            oldsize = newids.size();
        }
        for (int i = 0; i < oldsize; ++i) {
            String newID;
            String oldID = (String)oldids.get(i);
            if (idsFound.contains(oldID) || oldID.equals(newID = (String)newids.get(i))) continue;
            idsFound.add(oldID);
            MdObjectFactory.changeHashKey(oldID, newID);
        }
    }

    private void processDeletedObjects(List deletedObjects) throws MdException {
        int size = deletedObjects.size();
        for (int i = 0; i < size; ++i) {
            String toDelete = (String)deletedObjects.get(i);
            MdObjectFactory.deleteDetailMetadataObject(toDelete);
        }
    }

    private List getListOfIdMatchesInString(String inString) {
        Matcher matcher = m_idPattern.matcher(inString);
        ArrayList<String> ids = new ArrayList<String>();
        while (matcher.find()) {
            String matchvalue;
            if (matcher.groupCount() != 1 || (matchvalue = matcher.group(1)) == null) continue;
            ids.add(matchvalue);
        }
        return ids;
    }

    private String getMetadataFromServer(IOMI connectionHandle, String inXML, int flags, String options) throws MdException {
        MdObjectFactory factory = MdObjectFactory.getInstance();
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(100 + inXML.length() + options.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(MetadataUtil.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadata>");
            Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetMetadata(inXML, outXML, MetadataUtil.getNamespace(), flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadata,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            Util.printPerfln(sb.toString());
        }
        Util.printLoglnServer(outXML.value);
        return outXML.value;
    }

    private String getMetadataObjectsFromServer(IOMI connectionHandle, String reposID, String type, int flags, String options) throws MdException {
        MdObjectFactory factory = MdObjectFactory.getInstance();
        StringHolder outXML = new StringHolder();
        if (options == null) {
            options = "";
        }
        if (!factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        if (factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(155 + options.length());
            inputXML.append("<GetMetadataObjects><Reposid>");
            inputXML.append(reposID);
            inputXML.append("</Reposid><Type>");
            inputXML.append(type);
            inputXML.append("</Type><NS>");
            inputXML.append(MetadataUtil.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadataObjects>");
            Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (factory.getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.GetMetadataObjects(reposID, type, outXML, MetadataUtil.getNamespace(), flags, options);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (factory.getPerf()) {
            t1 = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(Thread.currentThread().getName());
            sb.append(",GetMetadataObjects,");
            sb.append(DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
            Util.printPerfln(sb.toString());
        }
        Util.printLoglnServer(outXML.value);
        return outXML.value;
    }

    protected List deleteObjectsFromServer(IOMI connectionHandle, String inXML, String templates) throws MdException {
        StringHolder outXML = new StringHolder();
        int flags = 402654208;
        if (templates != null) {
            flags |= 4;
        } else {
            templates = "";
        }
        if (MdObjectFactory.getInstance().getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(105 + inXML.length());
            inputXML.append("<DeleteMetadata><Metadata>");
            inputXML.append(inXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(MetadataUtil.getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags>");
            if (templates == null) {
                inputXML.append("<Options/>");
            } else {
                inputXML.append("<Options>");
                inputXML.append(templates);
                inputXML.append("</Options>");
            }
            inputXML.append("</DeleteMetadata>");
            Util.printLoglnClient(inputXML.toString());
        }
        long t0 = 0L;
        long t1 = 0L;
        if (MdObjectFactory.getInstance().getPerf()) {
            t0 = System.currentTimeMillis();
        }
        try {
            connectionHandle.DeleteMetadata(inXML, outXML, MetadataUtil.getNamespace(), flags, templates);
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        if (MdObjectFactory.getInstance().getPerf()) {
            t1 = System.currentTimeMillis();
            Util.printPerfln(Thread.currentThread().getName() + ",DeleteMetadata," + DecimalFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
        StringBuffer outStrings = new StringBuffer(33 + outXML.value.length());
        outStrings.append("<DeleteMetadata>");
        outStrings.append(outXML.value);
        outStrings.append("</DeleteMetadata>");
        String xml = outStrings.toString();
        Util.printLoglnServer(xml);
        MdUpdateHandler myHandler = null;
        try {
            myHandler = new MdUpdateHandler(this.parserFactory);
            myHandler.parseXML(xml);
            ArrayList arrayList = new ArrayList(myHandler.getDeleteMetadataList());
            return arrayList;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        finally {
            if (myHandler != null) {
                myHandler.dispose();
            }
        }
    }
}

