/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.MetadataUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MdException
extends Exception {
    private String SASMessage;
    private String SASMessageSeverity;
    private Throwable cause;

    public MdException() {
    }

    public MdException(String s) {
        super(s);
    }

    public MdException(Throwable t) {
        this.cause = t;
        if (t.getCause() != null) {
            this.cause = t.getCause();
        }
        String Message = this.cause.getLocalizedMessage();
        Document errorDoc = null;
        if (Message != null && Message.length() > 0 && Message.charAt(0) == '<') {
            try {
                errorDoc = MetadataUtil.parseXML(Message);
            }
            catch (Exception exp) {
                return;
            }
            NodeList errorList = errorDoc.getElementsByTagName("SASMessage");
            for (int i = 0; i < errorList.getLength(); ++i) {
                Node error = errorList.item(i);
                NamedNodeMap attributes = error.getAttributes();
                NodeList children = error.getChildNodes();
                this.SASMessageSeverity = attributes.item(0).getNodeValue();
                this.SASMessage = "[OMS Message] " + children.item(0).getNodeValue();
            }
        } else {
            Message = "[OMS Message] " + Message;
        }
    }

    public MdException(String s, String SAS_Message, String SAS_MessageSeverity) {
        super(s);
        this.SASMessage = SAS_Message;
        super.printStackTrace();
        this.SASMessageSeverity = SAS_MessageSeverity;
    }

    public String getSASMessage() {
        return this.SASMessage;
    }

    public String getSASMessageSeverity() {
        return this.SASMessageSeverity;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getLocalizedMessage() {
        if (this.cause == null) {
            return super.getLocalizedMessage();
        }
        if (this.SASMessage != null) {
            return this.SASMessage;
        }
        return this.cause.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        if (this.cause == null) {
            return super.getMessage();
        }
        if (this.SASMessage != null) {
            return this.SASMessage;
        }
        return this.cause.getMessage();
    }

    @Override
    public void printStackTrace() {
        if (this.cause == null) {
            super.printStackTrace();
        } else {
            this.cause.printStackTrace();
        }
    }
}

