/*
 * Decompiled with CFR 0.152.
 */
package com.sas.antlr.debug;

import com.sas.antlr.CharStreamException;
import com.sas.antlr.InputBuffer;
import com.sas.antlr.debug.InputBufferEventSupport;
import com.sas.antlr.debug.InputBufferListener;
import java.util.Vector;

public class DebuggingInputBuffer
extends InputBuffer {
    private InputBuffer buffer;
    private InputBufferEventSupport inputBufferEventSupport;
    private boolean debugMode = true;

    public DebuggingInputBuffer(InputBuffer buffer) {
        this.buffer = buffer;
        this.inputBufferEventSupport = new InputBufferEventSupport(this);
    }

    public void addInputBufferListener(InputBufferListener l) {
        this.inputBufferEventSupport.addInputBufferListener(l);
    }

    @Override
    public void consume() {
        char la = ' ';
        try {
            la = this.buffer.LA(1);
        }
        catch (CharStreamException charStreamException) {
            // empty catch block
        }
        this.buffer.consume();
        if (this.debugMode) {
            this.inputBufferEventSupport.fireConsume(la);
        }
    }

    @Override
    public void fill(int a) throws CharStreamException {
        this.buffer.fill(a);
    }

    public Vector getInputBufferListeners() {
        return this.inputBufferEventSupport.getInputBufferListeners();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public boolean isMarked() {
        return this.buffer.isMarked();
    }

    @Override
    public char LA(int i) throws CharStreamException {
        char la = this.buffer.LA(i);
        if (this.debugMode) {
            this.inputBufferEventSupport.fireLA(la, i);
        }
        return la;
    }

    @Override
    public int mark() {
        int m = this.buffer.mark();
        this.inputBufferEventSupport.fireMark(m);
        return m;
    }

    public void removeInputBufferListener(InputBufferListener l) {
        if (this.inputBufferEventSupport != null) {
            this.inputBufferEventSupport.removeInputBufferListener(l);
        }
    }

    @Override
    public void rewind(int mark) {
        this.buffer.rewind(mark);
        this.inputBufferEventSupport.fireRewind(mark);
    }

    public void setDebugMode(boolean value) {
        this.debugMode = value;
    }
}

