/*
 * Decompiled with CFR 0.152.
 */
package com.sas.antlr;

import com.sas.antlr.CharScanner;
import com.sas.antlr.RecognitionException;

public class NoViableAltForCharException
extends RecognitionException {
    public char foundChar;

    public NoViableAltForCharException(char c, CharScanner scanner) {
        super("NoViableAlt", scanner.getFilename(), scanner.getLine(), scanner.getColumn());
        this.foundChar = c;
    }

    public NoViableAltForCharException(char c, String fileName, int line) {
        this(c, fileName, line, -1);
    }

    public NoViableAltForCharException(char c, String fileName, int line, int column) {
        super("NoViableAlt", fileName, line, column);
        this.foundChar = c;
    }

    @Override
    public String getMessage() {
        String mesg = "unexpected char: ";
        if (this.foundChar >= ' ' && this.foundChar <= '~') {
            mesg = mesg + '\'';
            mesg = mesg + this.foundChar;
            mesg = mesg + '\'';
        } else {
            mesg = mesg + "0x";
            int t = this.foundChar >> 4;
            mesg = t < 10 ? mesg + (char)(t | 0x30) : mesg + (char)(t + 55);
            t = this.foundChar & 0xF;
            mesg = t < 10 ? mesg + (char)(t | 0x30) : mesg + (char)(t + 55);
        }
        return mesg;
    }
}

