/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import com.rsa.cryptoj.f.el;
import com.rsa.cryptoj.f.fa;
import com.rsa.cryptoj.f.gu;
import com.rsa.cryptoj.f.hi;
import com.rsa.cryptoj.f.is;
import com.rsa.cryptoj.f.jS;
import com.rsa.cryptoj.f.mN;
import com.rsa.cryptoj.f.nd;
import com.rsa.cryptoj.f.ny;
import com.rsa.cryptoj.f.qF;
import com.rsa.cryptoj.f.qI;
import com.rsa.cryptoj.f.sN;
import com.rsa.jcp.FIPS140Mode;
import com.rsa.jcp.OCSPException;
import com.rsa.jcp.OCSPResponderConfig;
import com.rsa.jcp.OCSPStatusType;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCSP {
    private OCSP() {
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        nd.c();
        return OCSP.sendRequest(string, x509Certificate, publicKey, OCSP.createRequestExtensions(new ArrayList<byte[]>()));
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey, byte[] byArray) throws OCSPException {
        gu gu2;
        nd.c();
        fa fa2 = mN.a();
        try {
            gu2 = new gu(fa2, x509Certificate, publicKey, new OCSPResponderConfig(string), byArray);
        }
        catch (ny ny2) {
            throw new OCSPException("Invalid DER-encoded extensions.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException.getMessage());
        }
        jS jS2 = new jS(fa2);
        byte[] byArray2 = jS2.a(gu2, string, null);
        if (byArray2 == null) {
            throw new OCSPException("OCSP request was unsuccessful: " + jS2.a());
        }
        return byArray2;
    }

    public static OCSPStatusType checkRevocationStatus(byte[] byArray, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        qI.a a2;
        nd.c();
        nd.c();
        fa fa2 = mN.a();
        qI qI2 = new qI(fa2, byArray);
        if (!qI2.c()) {
            throw new OCSPException(qI2.d());
        }
        try {
            a2 = qI2.a(x509Certificate, publicKey);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException);
        }
        if (a2 == null) {
            throw new OCSPException("Response did not contain status for specified certificate.");
        }
        return OCSPStatusType.a(a2.f());
    }

    public static byte[] createNonceExtension(byte[] byArray) {
        nd.c();
        is is2 = el.a(byArray);
        return qF.c(is2);
    }

    public static byte[] createRequestExtensions(List<byte[]> list) {
        nd.c();
        boolean bl2 = false;
        ArrayList<is> arrayList = new ArrayList<is>();
        for (byte[] byArray : list) {
            try {
                is is2 = qF.a("Extension", byArray, 0, false);
                if (is2.a("extnID").equals(hi.co.c())) {
                    bl2 = true;
                }
                arrayList.add(is2);
            }
            catch (ny ny2) {
                throw new InvalidParameterException("Input contained invalid extension encoding.");
            }
        }
        if (!bl2) {
            arrayList.add(el.a());
        }
        return qF.c(qF.a("Extensions", arrayList));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2, FIPS140Mode fIPS140Mode) {
        nd.c();
        if (!sN.a()) {
            throw new SecurityException("Cannot use this API with non-FIPS 140 toolkit");
        }
        return OCSP.a(x509Certificate, bl2, fa.a(fIPS140Mode.getValue(), 11));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2, FIPS140Context fIPS140Context) {
        nd.c();
        if (!sN.a()) {
            throw new SecurityException("Cannot use this API with non-FIPS 140 toolkit");
        }
        return OCSP.a(x509Certificate, bl2, fa.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2) {
        nd.c();
        return OCSP.a(x509Certificate, bl2, mN.a());
    }

    private static byte[] a(X509Certificate x509Certificate, boolean bl2, fa fa2) {
        if (bl2) {
            is is2 = qF.a("Name", x509Certificate.getSubjectX500Principal().getEncoded(), 0, true);
            return qF.c(is2.c(qF.c(1)));
        }
        return el.a(x509Certificate.getPublicKey(), fa2);
    }
}

