/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.lifecycle.impl;

import com.sas.midtier.components.container.ContainerCompositionException;
import com.sas.midtier.components.container.ContainerManager;
import com.sas.midtier.components.container.LifecycleException;
import com.sas.midtier.components.container.StorageContext;
import com.sas.midtier.components.container.impl.ContainerManagerLocator;
import com.sas.midtier.components.container.impl.DefaultContainerManager;
import com.sas.midtier.components.container.impl.StandAloneStorageContextImpl;
import com.sas.midtier.components.container.impl.XMLComposer;
import com.sas.midtier.components.lifecycle.ContainerDestroyer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.picocontainer.PicoContainer;

public class StandAloneContainerInitializer {
    private StorageContext _storageContext;

    public void init() {
        this._storageContext = new StandAloneStorageContextImpl(new HashMap());
        ContainerManagerLocator locator = new ContainerManagerLocator(this._storageContext);
        DefaultContainerManager containerManager = new DefaultContainerManager(this._storageContext, new XMLComposer());
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("containers.xml");
        if (stream == null) {
            System.out.println("Container configuration file \"containers.xml\" not found");
            return;
        }
        try {
            ArrayList compNames = new ArrayList();
            containerManager.initializeContainers(stream, compNames);
            this.guaranteeComponentLoad(containerManager.getContainer(), compNames);
        }
        catch (ContainerCompositionException e) {
            Throwable rootCause = e.getUltimateCause();
            System.out.println(rootCause.getLocalizedMessage());
            rootCause.printStackTrace();
            return;
        }
        catch (LifecycleException e) {
            Throwable rootCause = e.getUltimateCause();
            System.out.println(rootCause.getLocalizedMessage());
            rootCause.printStackTrace();
            return;
        }
        locator.store(containerManager);
    }

    public StorageContext getStorageContext() {
        return this._storageContext;
    }

    public void destroy() {
        ContainerDestroyer cd;
        ContainerManager manager = (ContainerManager)this._storageContext.getAttribute("sas.webapp.component.container.manager");
        if (manager == null) {
            StandAloneStorageContextImpl context = new StandAloneStorageContextImpl(new HashMap());
            ContainerManagerLocator locator = new ContainerManagerLocator(context);
            manager = locator.locate();
        }
        if (manager != null && (cd = new ContainerDestroyer(manager)) != null) {
            try {
                cd.destroy();
            }
            catch (LifecycleException e) {
                Throwable uc = e.getUltimateCause();
                uc.printStackTrace();
            }
        }
    }

    private void guaranteeComponentLoad(PicoContainer container, List compNames) {
        for (String name : compNames) {
            try {
                container.getComponentInstanceOfType(Class.forName(name));
            }
            catch (Throwable t) {
                System.out.println(t.getLocalizedMessage());
                t.printStackTrace();
            }
        }
    }
}

