/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.container.util.impl;

import com.sas.midtier.components.container.ContainerManager;
import com.sas.midtier.components.container.impl.ContainerManagerLocator;
import com.sas.midtier.components.container.util.MulticastInvocationHandler;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public class ContainerHelper {
    public static PicoContainer getContainer(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        return ContainerHelper.getContainer(session);
    }

    public static PicoContainer getContainer(HttpSession session) {
        ServletContext context = session.getServletContext();
        return ContainerHelper.getContainer(context);
    }

    public static PicoContainer getContainer(ServletContext context) {
        ContainerManagerLocator locator = new ContainerManagerLocator(context);
        ContainerManager containerManager = locator.locate();
        return containerManager.getContainer();
    }

    public static Object getMulticastReference(PicoContainer container, Class klass) {
        return ContainerHelper.getMulticastReference(container, klass, true, true);
    }

    public static Object getMulticastReference(PicoContainer container, Class klass, boolean childFirst, boolean useOrderOfInstantiation) {
        List components = ContainerHelper.getComponentsOfType(container, klass, useOrderOfInstantiation);
        if (childFirst) {
            Collections.reverse(components);
        }
        ArrayList flattenedCompList = new ArrayList();
        ContainerHelper.flattenList(flattenedCompList, components);
        Class[] proxiedType = new Class[]{klass};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return Proxy.newProxyInstance(cl, proxiedType, (InvocationHandler)new MulticastInvocationHandler(flattenedCompList));
    }

    private static List getComponentsOfType(PicoContainer container, Class klass, boolean useOrderOfInstantiation) {
        ArrayList<List> retval = new ArrayList<List>();
        if (container.getParent() != null) {
            retval.add(ContainerHelper.getComponentsOfType(container.getParent(), klass, useOrderOfInstantiation));
        }
        List comps = ContainerHelper.unbundleAdapters(container.getComponentAdaptersOfType(klass));
        if (useOrderOfInstantiation) {
            Collections.reverse(comps);
        }
        retval.addAll(comps);
        return retval;
    }

    private static void flattenList(List accumList, List nestedList) {
        int count = nestedList.size();
        for (int x = 0; x < count; ++x) {
            Object o = nestedList.get(x);
            if (o instanceof List) {
                ContainerHelper.flattenList(accumList, (List)o);
                continue;
            }
            if (accumList.contains(o)) continue;
            accumList.add(o);
        }
    }

    private static List unbundleAdapters(List adapters) {
        ArrayList<Object> retval = new ArrayList<Object>();
        if (adapters == null || adapters.size() == 0) {
            return retval;
        }
        for (ComponentAdapter adapter : adapters) {
            retval.add(adapter.getComponentInstance());
        }
        return retval;
    }
}

