/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.container.impl;

import com.sas.midtier.components.container.ContainerComposer;
import com.sas.midtier.components.container.ContainerCompositionException;
import com.sas.midtier.components.container.Decorator;
import com.sas.midtier.components.container.StorageContext;
import com.sas.midtier.components.container.impl.ComponentEntityResolver;
import com.sas.midtier.components.container.impl.DecoratedComponentAdapterFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLComposer
implements ContainerComposer {
    private DecoratedComponentAdapterFactory _adapterFactory = new DecoratedComponentAdapterFactory();
    private static final String CONTAINER_NODE = "container";
    private static final String COMPONENT_NODE = "component";
    private static final String DECORATOR_NODE = "decorator";
    private static final String PARAMETER_NODE = "parameter";
    private static final String DEPENDENCY_NODE = "dependency";
    private static final String CONFIG_PARAM_NODE = "config-param";
    private static final String VERSION_ATTR = "version";
    private static final String TYPE_ATTR = "type";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";

    public MutablePicoContainer compose(StorageContext context, Reader script, ClassLoader classLoader, List keyCollector) throws ContainerCompositionException {
        MutablePicoContainer retval = null;
        InputSource inputSource = new InputSource(script);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setEntityResolver(new ComponentEntityResolver());
            Element rootElement = builder.parse(inputSource).getDocumentElement();
            String version = rootElement.getAttribute(VERSION_ATTR);
            if (version == null || !version.equals("1.0")) {
                throw new ContainerCompositionException("Incorrect pico-container.dtd version");
            }
            NodeList children = rootElement.getChildNodes();
            MutablePicoContainer currentContainer = null;
            MutablePicoContainer prevContainer = null;
            for (int x = 0; x < children.getLength(); ++x) {
                Node current = children.item(x);
                if (!CONTAINER_NODE.equals(current.getNodeName())) continue;
                currentContainer = this.configureContainer(current, classLoader, keyCollector, prevContainer);
                currentContainer.registerComponentInstance((Object)StorageContext.class.getName(), (Object)context);
                this.makeServletAware(currentContainer, context);
                prevContainer = currentContainer;
                currentContainer = null;
                retval = prevContainer;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ContainerCompositionException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ContainerCompositionException((Throwable)e);
        }
        catch (IOException e) {
            throw new ContainerCompositionException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ContainerCompositionException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new ContainerCompositionException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ContainerCompositionException((Throwable)e);
        }
        return retval;
    }

    void makeServletAware(MutablePicoContainer container, StorageContext context) {
        if (container == null || context != null) {
            // empty if block
        }
    }

    private MutablePicoContainer configureContainer(Node containerNode, ClassLoader classLoader, List keyCollector, MutablePicoContainer parent) throws IllegalArgumentException, ClassNotFoundException {
        DefaultPicoContainer retval = new DefaultPicoContainer((PicoContainer)parent);
        NodeList children = containerNode.getChildNodes();
        int count = children.getLength();
        String decorator = null;
        Map decoratorConfig = null;
        for (int x = 0; x < count; ++x) {
            if (children.item(x).getNodeType() != 1) continue;
            Node child = children.item(x);
            if (DECORATOR_NODE.equals(child.getNodeName())) {
                decorator = ((Element)child).getAttribute(TYPE_ATTR);
                if (decorator != null && (decorator = decorator.trim()).length() == 0) {
                    decorator = null;
                }
                if (decorator == null) continue;
                decoratorConfig = this.buildDecoratorConfig(child);
                continue;
            }
            if (!COMPONENT_NODE.equals(child.getNodeName())) continue;
            String key = ((Element)child).getAttribute("key");
            String type = ((Element)child).getAttribute("class");
            if (type.equals("default")) {
                type = this.buildDefaultTypeName(key);
            }
            this.registerComponent((MutablePicoContainer)retval, key, type, child.getChildNodes(), classLoader, decorator, decoratorConfig);
            if (keyCollector == null) continue;
            keyCollector.add(key);
        }
        return retval;
    }

    private String buildDefaultTypeName(String key) {
        int breakpos = key.lastIndexOf(".");
        String pkgName = key.substring(0, breakpos);
        String className = key.substring(breakpos + 1);
        StringBuffer buf = new StringBuffer();
        buf.append(pkgName);
        buf.append(".impl.");
        buf.append(className).append("Impl");
        return buf.toString();
    }

    private void registerComponent(MutablePicoContainer container, String key, String type, NodeList params, ClassLoader classLoader, String decorator, Map decoratorConfig) throws IllegalArgumentException, ClassNotFoundException {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        int count = params.getLength();
        String activeDecorator = decorator;
        Map activeDecoratorConfig = decoratorConfig;
        for (int x = 0; x < count; ++x) {
            String dependencyKey;
            Parameter param = null;
            if (params.item(x).getNodeType() != 1) continue;
            Node child = params.item(x);
            if (DECORATOR_NODE.equals(child.getNodeName())) {
                activeDecorator = ((Element)child).getAttribute(TYPE_ATTR);
                if (activeDecorator == null) {
                    activeDecorator = decorator;
                    continue;
                }
                if ((activeDecorator = activeDecorator.trim()).length() == 0) {
                    activeDecorator = decorator;
                }
                if (activeDecorator == null || activeDecorator.equals(decorator) || (activeDecoratorConfig = this.buildDecoratorConfig(child)) != null) continue;
                activeDecoratorConfig = decoratorConfig;
                continue;
            }
            if (PARAMETER_NODE.equals(child.getNodeName())) {
                String paramValue;
                String paramType = ((Element)child).getAttribute(TYPE_ATTR);
                param = this.constructConstantParameter(paramType, paramValue = child.getChildNodes().item(0).getNodeValue());
                if (param == null) continue;
                paramList.add(param);
                continue;
            }
            if (!DEPENDENCY_NODE.equals(child.getNodeName()) || (param = this.constructDependencyParameter(dependencyKey = ((Element)child).getAttribute("key"))) == null) continue;
            paramList.add(param);
        }
        Class<?> componentClass = null;
        componentClass = classLoader.loadClass(type);
        Parameter[] finalParams = null;
        if (paramList.size() > 0) {
            finalParams = new Parameter[paramList.size()];
            paramList.toArray(finalParams);
        }
        if (activeDecorator == null) {
            container.registerComponent(this._adapterFactory.createComponentAdapter(key, componentClass, finalParams));
        } else {
            container.registerComponent(this.createComponentAdapter(key, componentClass, finalParams, activeDecorator, activeDecoratorConfig, classLoader));
        }
    }

    private Parameter constructDependencyParameter(String key) throws ClassNotFoundException {
        ComponentParameter retval = new ComponentParameter((Object)key);
        return retval;
    }

    private Parameter constructConstantParameter(String type, String value) {
        ConstantParameter retval = null;
        retval = type.equals("int") ? new ConstantParameter((Object)Integer.valueOf(value)) : (type.equals("long") ? new ConstantParameter((Object)Long.valueOf(value)) : (type.equals("boolean") ? new ConstantParameter((Object)Boolean.valueOf(value)) : new ConstantParameter((Object)value)));
        return retval;
    }

    private ComponentAdapter createComponentAdapter(Object key, Class componentClass, Parameter[] params, String factoryClassName, Map config, ClassLoader classLoader) {
        Decorator decorator = null;
        try {
            Class<?> decoratorClass = classLoader.loadClass(factoryClassName);
            decorator = (Decorator)decoratorClass.newInstance();
            return this._adapterFactory.createComponentAdapter(key, componentClass, params, decorator, config);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.err.println("Ignoring decorator-factory: " + factoryClassName);
            return this._adapterFactory.createComponentAdapter(key, componentClass, params);
        }
    }

    private Map buildDecoratorConfig(Node decorator) {
        HashMap<String, String> retval = null;
        NodeList children = decorator.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return retval;
        }
        int count = children.getLength();
        for (int x = 0; x < count; ++x) {
            Node current;
            if (children.item(x).getNodeType() != 1 || !CONFIG_PARAM_NODE.equals((current = children.item(x)).getNodeName())) continue;
            if (retval == null) {
                retval = new HashMap<String, String>();
            }
            String name = ((Element)current).getAttribute(NAME_ATTR);
            String value = ((Element)current).getAttribute(VALUE_ATTR);
            if (name == null || value == null) continue;
            retval.put(name, value);
        }
        if (retval != null && retval.size() == 0) {
            retval = null;
        }
        return retval;
    }
}

