/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.container.impl;

import com.sas.midtier.components.container.StorageContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class StorageContextImpl
implements StorageContext {
    private static final String GET_ATTRIBUTE_METHOD_NAME_PRIMARY = "getAttribute";
    private static final String GET_ATTRIBUTE_METHOD_NAME_SECONDARY = "get";
    private static final Class[] GET_ATTRIBUTE_PARAM_LIST_PRIMARY = new Class[]{String.class};
    private static final Class[] GET_ATTRIBUTE_PARAM_LIST_SECONDARY = new Class[]{Object.class};
    private static final String SET_ATTRIBUTE_METHOD_NAME_PRIMARY = "setAttribute";
    private static final String SET_ATTRIBUTE_METHOD_NAME_SECONDARY = "put";
    private static final Class[] SET_ATTRIBUTE_PARAM_LIST_PRIMARY = new Class[]{String.class, Object.class};
    private static final Class[] SET_ATTRIBUTE_PARAM_LIST_SECONDARY = new Class[]{Object.class, Object.class};
    private static final String REMOVE_ATTRIBUTE_METHOD_NAME_PRIMARY = "removeAttribute";
    private static final String REMOVE_ATTRIBUTE_METHOD_NAME_SECONDARY = "remove";
    private static final Class[] REMOVE_ATTRIBUTE_PARAM_LIST_PRIMARY = new Class[]{String.class};
    private static final Class[] REMOVE_ATTRIBUTE_PARAM_LIST_SECONDARY = new Class[]{Object.class};
    private static final String RESOURCE_AS_STREAM_METHOD_NAME = "getResourceAsStream";
    private static final Class[] RESOURCE_AS_STREAM_PARAM_LIST = new Class[]{String.class};
    private static final String GET_NAME_METHOD_NAME_PRIMARY = "getServletContextName";
    private static final String GET_NAME_METHOD_NAME_SECONDARY = "getName";
    private static final String RESOURCE_PATHS_METHOD_NAME = "getResourcePaths";
    private static final Class[] RESOURCE_PATHS_PARAM_LIST = new Class[]{String.class};
    private static final String TEST_ATTRIBUTE_NAME = "/StorageContextTest";
    private Object _target;
    private Method _getMethod;
    private Method _setMethod;
    private Method _removeMethod;
    private Method _getResourceAsStream;
    private Method _getResourcePaths;
    private Method _getName;

    public StorageContextImpl(Object target) throws IllegalArgumentException {
        this._getMethod = this.locateGetMethod(target);
        this._setMethod = this.locateSetMethod(target);
        this._removeMethod = this.locateRemoveMethod(target);
        this._getResourceAsStream = this.locateResourceAsStreamMethod(target);
        this._getResourcePaths = this.locateResourcePathsMethod(target);
        this._getName = this.locateGetNameMethod(target);
        this.validateMethods(target);
        this._target = target;
    }

    public String getName() {
        String retval = null;
        if (this._getName == null) {
            return retval;
        }
        try {
            Object[] params = null;
            retval = (String)this._getName.invoke(this._target, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    public void setAttribute(String key, Object value) {
        try {
            Object[] params = new Object[]{key, value};
            this._setMethod.invoke(this._target, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getAttribute(String key) {
        Object retval = null;
        try {
            Object[] params = new Object[]{key};
            retval = this._getMethod.invoke(this._target, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    public InputStream getResourceAsStream(String resourceName) {
        File f;
        InputStream retval = null;
        if (this._getResourceAsStream == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            retval = cl.getResourceAsStream(resourceName);
        } else {
            try {
                Object[] params = new Object[]{resourceName};
                retval = (InputStream)this._getResourceAsStream.invoke(this._target, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (retval == null && (f = new File(resourceName)).exists()) {
            try {
                retval = new FileInputStream(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retval;
    }

    public Set getResourcePaths(String basePath) {
        Set retval = null;
        if (this._getResourcePaths != null) {
            try {
                Object[] params = new Object[]{basePath};
                retval = (Set)this._getResourcePaths.invoke(this._target, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return retval;
    }

    public void removeAttribute(String key) {
        try {
            Object[] params = new Object[]{key};
            this._removeMethod.invoke(this._target, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getTarget() {
        return this._target;
    }

    private void validateMethods(Object target) {
        if (this._getMethod == null || this._setMethod == null || this._removeMethod == null || this._getResourceAsStream == null || this._getResourcePaths == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.testSetMethod(target);
            this.testGetMethod(target);
            this.testGetNameMethod(target);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        if (this._removeMethod != null) {
            try {
                this.testRemoveMethod(target);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
        try {
            this.testResourceAsStreamMethod(target);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        try {
            this.testResourcePathsMethod(target);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    private void testResourcePathsMethod(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this._getResourcePaths == null) {
            return;
        }
        Object[] params = new Object[]{TEST_ATTRIBUTE_NAME};
        this._getResourcePaths.invoke(target, params);
    }

    private void testSetMethod(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] params = new Object[]{TEST_ATTRIBUTE_NAME, TEST_ATTRIBUTE_NAME};
        this._setMethod.invoke(target, params);
    }

    private void testGetMethod(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] params = new Object[]{TEST_ATTRIBUTE_NAME};
        this._getMethod.invoke(target, params);
    }

    private void testRemoveMethod(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] params = new Object[]{TEST_ATTRIBUTE_NAME};
        this._removeMethod.invoke(target, params);
    }

    private void testGetNameMethod(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] params = null;
        if (this._getName != null) {
            this._getName.invoke(target, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testResourceAsStreamMethod(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this._getResourceAsStream == null) {
            return;
        }
        Object[] params = new Object[]{TEST_ATTRIBUTE_NAME};
        InputStream in = null;
        try {
            in = (InputStream)this._getResourceAsStream.invoke(target, params);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Method locateGetMethod(Object target) {
        Method retval = this.locateMethod(GET_ATTRIBUTE_METHOD_NAME_PRIMARY, GET_ATTRIBUTE_PARAM_LIST_PRIMARY, target);
        if (retval == null) {
            retval = this.locateMethod(GET_ATTRIBUTE_METHOD_NAME_SECONDARY, GET_ATTRIBUTE_PARAM_LIST_SECONDARY, target);
        }
        return retval;
    }

    private Method locateSetMethod(Object target) {
        Method retval = this.locateMethod(SET_ATTRIBUTE_METHOD_NAME_PRIMARY, SET_ATTRIBUTE_PARAM_LIST_PRIMARY, target);
        if (retval == null) {
            retval = this.locateMethod(SET_ATTRIBUTE_METHOD_NAME_SECONDARY, SET_ATTRIBUTE_PARAM_LIST_SECONDARY, target);
        }
        return retval;
    }

    private Method locateRemoveMethod(Object target) {
        Method retval = this.locateMethod(REMOVE_ATTRIBUTE_METHOD_NAME_PRIMARY, REMOVE_ATTRIBUTE_PARAM_LIST_PRIMARY, target);
        if (retval == null) {
            retval = this.locateMethod(REMOVE_ATTRIBUTE_METHOD_NAME_SECONDARY, REMOVE_ATTRIBUTE_PARAM_LIST_SECONDARY, target);
        }
        return retval;
    }

    private Method locateResourceAsStreamMethod(Object target) {
        Method retval = this.locateMethod(RESOURCE_AS_STREAM_METHOD_NAME, RESOURCE_AS_STREAM_PARAM_LIST, target);
        return retval;
    }

    private Method locateGetNameMethod(Object target) {
        Method retval = this.locateMethod(GET_NAME_METHOD_NAME_PRIMARY, null, target);
        if (retval == null) {
            retval = this.locateMethod(GET_NAME_METHOD_NAME_SECONDARY, null, target);
        }
        return retval;
    }

    private Method locateResourcePathsMethod(Object target) {
        Method retval = this.locateMethod(RESOURCE_PATHS_METHOD_NAME, RESOURCE_PATHS_PARAM_LIST, target);
        return retval;
    }

    private Method locateMethod(String name, Class[] paramList, Object target) {
        Method retval = null;
        try {
            retval = target.getClass().getMethod(name, paramList);
        }
        catch (NoSuchMethodException e) {
            retval = null;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return retval;
    }
}

